/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply
 * ProjectDemandServiceSupply}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.field.ProjectDemandServiceSupplyField
 * ProjectDemandServiceSupplyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.link.ProjectDemandServiceSupplyLink
 * ProjectDemandServiceSupplyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#PROJECT_DEMAND_SERVICE_SUPPLY_UUID
 * PROJECT_DEMAND_SERVICE_SUPPLY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#PROJECT_DEMAND_SERVICE_UUID
 * PROJECT_DEMAND_SERVICE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#PROJECT_DEMAND_UUID
 * PROJECT_DEMAND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#TO_SERVICE
 * TO_SERVICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.projectdemand.ProjectDemandServiceSupply#TO_ROOT
 * TO_ROOT}</li>
 * </ul>
 *
 */
public interface ProjectDemandServiceSupplySelectable extends EntitySelectable<ProjectDemandServiceSupply>
{

}
