/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.field.PurContrItemConditionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable.PurContrItemConditionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Condition
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurContrItemConditionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurContrItemCondition extends VdmEntity<PurContrItemCondition>
{

    /**
     * Selector for all available fields of PurContrItemCondition.
     *
     */
    public final static PurContrItemConditionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> PURCHASE_CONTRACT =
        new PurContrItemConditionField<String>("PurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> PURCHASE_CONTRACT_ITEM =
        new PurContrItemConditionField<String>("PurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return The conditionValidityEndDate contained in this entity.
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new PurContrItemConditionField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @Key
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_TYPE =
        new PurContrItemConditionField<String>("ConditionType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_RECORD =
        new PurContrItemConditionField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_SEQUENTIAL_NUMBER =
        new PurContrItemConditionField<String>("ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return The conditionValidityStartDate contained in this entity.
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new PurContrItemConditionField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTextID</b>
     * </p>
     *
     * @return Number of texts
     */
    @SerializedName( "ConditionTextID" )
    @JsonProperty( "ConditionTextID" )
    @Nullable
    @ODataField( odataName = "ConditionTextID" )
    private String conditionTextID;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTextID</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_TEXT_ID =
        new PurContrItemConditionField<String>("ConditionTextID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> PRICING_SCALE_TYPE =
        new PurContrItemConditionField<String>("PricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @return Scale Base Type
     */
    @SerializedName( "PricingScaleBasis" )
    @JsonProperty( "PricingScaleBasis" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasis" )
    private String pricingScaleBasis;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasis</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> PRICING_SCALE_BASIS =
        new PurContrItemConditionField<String>("PricingScaleBasis");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new PurContrItemConditionField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new PurContrItemConditionField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new PurContrItemConditionField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new PurContrItemConditionField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_CALCULATION_TYPE =
        new PurContrItemConditionField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition amount or percentage where no scale exists
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_RATE_VALUE =
        new PurContrItemConditionField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_RATE_VALUE_UNIT =
        new PurContrItemConditionField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_QUANTITY =
        new PurContrItemConditionField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_QUANTITY_UNIT =
        new PurContrItemConditionField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for converting condition units to base units
     */
    @SerializedName( "ConditionToBaseQtyNmrtr" )
    @JsonProperty( "ConditionToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyNmrtr" )
    private BigDecimal conditionToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_TO_BASE_QTY_NMRTR =
        new PurContrItemConditionField<BigDecimal>("ConditionToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for converting condition units to base units
     */
    @SerializedName( "ConditionToBaseQtyDnmntr" )
    @JsonProperty( "ConditionToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyDnmntr" )
    private BigDecimal conditionToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_TO_BASE_QTY_DNMNTR =
        new PurContrItemConditionField<BigDecimal>("ConditionToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> BASE_UNIT =
        new PurContrItemConditionField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimit</b>
     * </p>
     *
     * @return Lower limit of the condition rate/amount
     */
    @SerializedName( "ConditionLowerLimit" )
    @JsonProperty( "ConditionLowerLimit" )
    @Nullable
    @ODataField( odataName = "ConditionLowerLimit" )
    private BigDecimal conditionLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionLowerLimit</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_LOWER_LIMIT =
        new PurContrItemConditionField<BigDecimal>("ConditionLowerLimit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimit</b>
     * </p>
     *
     * @return Upper limit for the condition rate
     */
    @SerializedName( "ConditionUpperLimit" )
    @JsonProperty( "ConditionUpperLimit" )
    @Nullable
    @ODataField( odataName = "ConditionUpperLimit" )
    private BigDecimal conditionUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUpperLimit</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> CONDITION_UPPER_LIMIT =
        new PurContrItemConditionField<BigDecimal>("ConditionUpperLimit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @return Condition Currency (for Cumulation Fields)
     */
    @SerializedName( "ConditionAlternativeCurrency" )
    @JsonProperty( "ConditionAlternativeCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionAlternativeCurrency" )
    private String conditionAlternativeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAlternativeCurrency</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_ALTERNATIVE_CURRENCY =
        new PurContrItemConditionField<String>("ConditionAlternativeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @return Condition exclusion indicator
     */
    @SerializedName( "ConditionExclusion" )
    @JsonProperty( "ConditionExclusion" )
    @Nullable
    @ODataField( odataName = "ConditionExclusion" )
    private String conditionExclusion;
    /**
     * Use with available fluent helpers to apply the <b>ConditionExclusion</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_EXCLUSION =
        new PurContrItemConditionField<String>("ConditionExclusion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionIsDeleted" )
    @JsonProperty( "ConditionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsDeleted" )
    private Boolean conditionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsDeleted</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<Boolean> CONDITION_IS_DELETED =
        new PurContrItemConditionField<Boolean>("ConditionIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @return Additional Value Days
     */
    @SerializedName( "AdditionalValueDays" )
    @JsonProperty( "AdditionalValueDays" )
    @Nullable
    @ODataField( odataName = "AdditionalValueDays" )
    private String additionalValueDays;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueDays</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> ADDITIONAL_VALUE_DAYS =
        new PurContrItemConditionField<String>("AdditionalValueDays");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @return Fixed Value Date
     */
    @SerializedName( "FixedValueDate" )
    @JsonProperty( "FixedValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FixedValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime fixedValueDate;
    /**
     * Use with available fluent helpers to apply the <b>FixedValueDate</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<LocalDateTime> FIXED_VALUE_DATE =
        new PurContrItemConditionField<LocalDateTime>("FixedValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> PAYMENT_TERMS =
        new PurContrItemConditionField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnMaxNumberOfSalesOrders</b>
     * </p>
     *
     * @return Maximum number of sales orders per condition record
     */
    @SerializedName( "CndnMaxNumberOfSalesOrders" )
    @JsonProperty( "CndnMaxNumberOfSalesOrders" )
    @Nullable
    @ODataField( odataName = "CndnMaxNumberOfSalesOrders" )
    private String cndnMaxNumberOfSalesOrders;
    /**
     * Use with available fluent helpers to apply the <b>CndnMaxNumberOfSalesOrders</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CNDN_MAX_NUMBER_OF_SALES_ORDERS =
        new PurContrItemConditionField<String>("CndnMaxNumberOfSalesOrders");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumConditionBasisValue</b>
     * </p>
     *
     * @return Minimum condition base value
     */
    @SerializedName( "MinimumConditionBasisValue" )
    @JsonProperty( "MinimumConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "MinimumConditionBasisValue" )
    private BigDecimal minimumConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>MinimumConditionBasisValue</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> MINIMUM_CONDITION_BASIS_VALUE =
        new PurContrItemConditionField<BigDecimal>("MinimumConditionBasisValue");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionBasisValue</b>
     * </p>
     *
     * @return Maximum condition base value
     */
    @SerializedName( "MaximumConditionBasisValue" )
    @JsonProperty( "MaximumConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "MaximumConditionBasisValue" )
    private BigDecimal maximumConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>MaximumConditionBasisValue</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> MAXIMUM_CONDITION_BASIS_VALUE =
        new PurContrItemConditionField<BigDecimal>("MaximumConditionBasisValue");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionAmount</b>
     * </p>
     *
     * @return Maximum condition value
     */
    @SerializedName( "MaximumConditionAmount" )
    @JsonProperty( "MaximumConditionAmount" )
    @Nullable
    @ODataField( odataName = "MaximumConditionAmount" )
    private BigDecimal maximumConditionAmount;
    /**
     * Use with available fluent helpers to apply the <b>MaximumConditionAmount</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<BigDecimal> MAXIMUM_CONDITION_AMOUNT =
        new PurContrItemConditionField<BigDecimal>("MaximumConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncrementalScale</b>
     * </p>
     *
     * @return Number of incremental scale
     */
    @SerializedName( "IncrementalScale" )
    @JsonProperty( "IncrementalScale" )
    @Nullable
    @ODataField( odataName = "IncrementalScale" )
    private String incrementalScale;
    /**
     * Use with available fluent helpers to apply the <b>IncrementalScale</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> INCREMENTAL_SCALE =
        new PurContrItemConditionField<String>("IncrementalScale");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleLine</b>
     * </p>
     *
     * @return Scale number for pricing
     */
    @SerializedName( "PricingScaleLine" )
    @JsonProperty( "PricingScaleLine" )
    @Nullable
    @ODataField( odataName = "PricingScaleLine" )
    private String pricingScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleLine</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> PRICING_SCALE_LINE =
        new PurContrItemConditionField<String>("PricingScaleLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ConditionReleaseStatus" )
    @JsonProperty( "ConditionReleaseStatus" )
    @Nullable
    @ODataField( odataName = "ConditionReleaseStatus" )
    private String conditionReleaseStatus;
    /**
     * Use with available fluent helpers to apply the <b>ConditionReleaseStatus</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_RELEASE_STATUS =
        new PurContrItemConditionField<String>("ConditionReleaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClassification</b>
     * </p>
     *
     * @return The conditionClassification contained in this entity.
     */
    @SerializedName( "ConditionClassification" )
    @JsonProperty( "ConditionClassification" )
    @Nullable
    @ODataField( odataName = "ConditionClassification" )
    private String conditionClassification;
    /**
     * Use with available fluent helpers to apply the <b>ConditionClassification</b> field to query operations.
     *
     */
    public final static PurContrItemConditionField<String> CONDITION_CLASSIFICATION =
        new PurContrItemConditionField<String>("ConditionClassification");

    @Nonnull
    @Override
    public Class<PurContrItemCondition> getType()
    {
        return PurContrItemCondition.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            The conditionValidityEndDate to set.
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            The conditionValidityStartDate to set.
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTextID</b>
     * </p>
     *
     * @param conditionTextID
     *            Number of texts
     */
    public void setConditionTextID( @Nullable final String conditionTextID )
    {
        rememberChangedField("ConditionTextID", this.conditionTextID);
        this.conditionTextID = conditionTextID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @param pricingScaleBasis
     *            Scale Base Type
     */
    public void setPricingScaleBasis( @Nullable final String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition amount or percentage where no scale exists
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @param conditionToBaseQtyNmrtr
     *            Numerator for converting condition units to base units
     */
    public void setConditionToBaseQtyNmrtr( @Nullable final BigDecimal conditionToBaseQtyNmrtr )
    {
        rememberChangedField("ConditionToBaseQtyNmrtr", this.conditionToBaseQtyNmrtr);
        this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @param conditionToBaseQtyDnmntr
     *            Denominator for converting condition units to base units
     */
    public void setConditionToBaseQtyDnmntr( @Nullable final BigDecimal conditionToBaseQtyDnmntr )
    {
        rememberChangedField("ConditionToBaseQtyDnmntr", this.conditionToBaseQtyDnmntr);
        this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionLowerLimit</b>
     * </p>
     *
     * @param conditionLowerLimit
     *            Lower limit of the condition rate/amount
     */
    public void setConditionLowerLimit( @Nullable final BigDecimal conditionLowerLimit )
    {
        rememberChangedField("ConditionLowerLimit", this.conditionLowerLimit);
        this.conditionLowerLimit = conditionLowerLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUpperLimit</b>
     * </p>
     *
     * @param conditionUpperLimit
     *            Upper limit for the condition rate
     */
    public void setConditionUpperLimit( @Nullable final BigDecimal conditionUpperLimit )
    {
        rememberChangedField("ConditionUpperLimit", this.conditionUpperLimit);
        this.conditionUpperLimit = conditionUpperLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAlternativeCurrency</b>
     * </p>
     *
     * @param conditionAlternativeCurrency
     *            Condition Currency (for Cumulation Fields)
     */
    public void setConditionAlternativeCurrency( @Nullable final String conditionAlternativeCurrency )
    {
        rememberChangedField("ConditionAlternativeCurrency", this.conditionAlternativeCurrency);
        this.conditionAlternativeCurrency = conditionAlternativeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionExclusion</b>
     * </p>
     *
     * @param conditionExclusion
     *            Condition exclusion indicator
     */
    public void setConditionExclusion( @Nullable final String conditionExclusion )
    {
        rememberChangedField("ConditionExclusion", this.conditionExclusion);
        this.conditionExclusion = conditionExclusion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @param additionalValueDays
     *            Additional Value Days
     */
    public void setAdditionalValueDays( @Nullable final String additionalValueDays )
    {
        rememberChangedField("AdditionalValueDays", this.additionalValueDays);
        this.additionalValueDays = additionalValueDays;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @param fixedValueDate
     *            Fixed Value Date
     */
    public void setFixedValueDate( @Nullable final LocalDateTime fixedValueDate )
    {
        rememberChangedField("FixedValueDate", this.fixedValueDate);
        this.fixedValueDate = fixedValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnMaxNumberOfSalesOrders</b>
     * </p>
     *
     * @param cndnMaxNumberOfSalesOrders
     *            Maximum number of sales orders per condition record
     */
    public void setCndnMaxNumberOfSalesOrders( @Nullable final String cndnMaxNumberOfSalesOrders )
    {
        rememberChangedField("CndnMaxNumberOfSalesOrders", this.cndnMaxNumberOfSalesOrders);
        this.cndnMaxNumberOfSalesOrders = cndnMaxNumberOfSalesOrders;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumConditionBasisValue</b>
     * </p>
     *
     * @param minimumConditionBasisValue
     *            Minimum condition base value
     */
    public void setMinimumConditionBasisValue( @Nullable final BigDecimal minimumConditionBasisValue )
    {
        rememberChangedField("MinimumConditionBasisValue", this.minimumConditionBasisValue);
        this.minimumConditionBasisValue = minimumConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionBasisValue</b>
     * </p>
     *
     * @param maximumConditionBasisValue
     *            Maximum condition base value
     */
    public void setMaximumConditionBasisValue( @Nullable final BigDecimal maximumConditionBasisValue )
    {
        rememberChangedField("MaximumConditionBasisValue", this.maximumConditionBasisValue);
        this.maximumConditionBasisValue = maximumConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumConditionAmount</b>
     * </p>
     *
     * @param maximumConditionAmount
     *            Maximum condition value
     */
    public void setMaximumConditionAmount( @Nullable final BigDecimal maximumConditionAmount )
    {
        rememberChangedField("MaximumConditionAmount", this.maximumConditionAmount);
        this.maximumConditionAmount = maximumConditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncrementalScale</b>
     * </p>
     *
     * @param incrementalScale
     *            Number of incremental scale
     */
    public void setIncrementalScale( @Nullable final String incrementalScale )
    {
        rememberChangedField("IncrementalScale", this.incrementalScale);
        this.incrementalScale = incrementalScale;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleLine</b>
     * </p>
     *
     * @param pricingScaleLine
     *            Scale number for pricing
     */
    public void setPricingScaleLine( @Nullable final String pricingScaleLine )
    {
        rememberChangedField("PricingScaleLine", this.pricingScaleLine);
        this.pricingScaleLine = pricingScaleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @param conditionReleaseStatus
     *            Release Status
     */
    public void setConditionReleaseStatus( @Nullable final String conditionReleaseStatus )
    {
        rememberChangedField("ConditionReleaseStatus", this.conditionReleaseStatus);
        this.conditionReleaseStatus = conditionReleaseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClassification</b>
     * </p>
     *
     * @param conditionClassification
     *            The conditionClassification to set.
     */
    public void setConditionClassification( @Nullable final String conditionClassification )
    {
        rememberChangedField("ConditionClassification", this.conditionClassification);
        this.conditionClassification = conditionClassification;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurContrItemCondition";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseContract", getPurchaseContract());
        result.put("PurchaseContractItem", getPurchaseContractItem());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        result.put("ConditionType", getConditionType());
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionType", getConditionType());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionTextID", getConditionTextID());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionToBaseQtyNmrtr", getConditionToBaseQtyNmrtr());
        values.put("ConditionToBaseQtyDnmntr", getConditionToBaseQtyDnmntr());
        values.put("BaseUnit", getBaseUnit());
        values.put("ConditionLowerLimit", getConditionLowerLimit());
        values.put("ConditionUpperLimit", getConditionUpperLimit());
        values.put("ConditionAlternativeCurrency", getConditionAlternativeCurrency());
        values.put("ConditionExclusion", getConditionExclusion());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        values.put("AdditionalValueDays", getAdditionalValueDays());
        values.put("FixedValueDate", getFixedValueDate());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CndnMaxNumberOfSalesOrders", getCndnMaxNumberOfSalesOrders());
        values.put("MinimumConditionBasisValue", getMinimumConditionBasisValue());
        values.put("MaximumConditionBasisValue", getMaximumConditionBasisValue());
        values.put("MaximumConditionAmount", getMaximumConditionAmount());
        values.put("IncrementalScale", getIncrementalScale());
        values.put("PricingScaleLine", getPricingScaleLine());
        values.put("ConditionReleaseStatus", getConditionReleaseStatus());
        values.put("ConditionClassification", getConditionClassification());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionTextID") ) {
                final Object value = values.remove("ConditionTextID");
                if( (value == null) || (!value.equals(getConditionTextID())) ) {
                    setConditionTextID(((String) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyNmrtr") ) {
                final Object value = values.remove("ConditionToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyNmrtr())) ) {
                    setConditionToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyDnmntr") ) {
                final Object value = values.remove("ConditionToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyDnmntr())) ) {
                    setConditionToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionLowerLimit") ) {
                final Object value = values.remove("ConditionLowerLimit");
                if( (value == null) || (!value.equals(getConditionLowerLimit())) ) {
                    setConditionLowerLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionUpperLimit") ) {
                final Object value = values.remove("ConditionUpperLimit");
                if( (value == null) || (!value.equals(getConditionUpperLimit())) ) {
                    setConditionUpperLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAlternativeCurrency") ) {
                final Object value = values.remove("ConditionAlternativeCurrency");
                if( (value == null) || (!value.equals(getConditionAlternativeCurrency())) ) {
                    setConditionAlternativeCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionExclusion") ) {
                final Object value = values.remove("ConditionExclusion");
                if( (value == null) || (!value.equals(getConditionExclusion())) ) {
                    setConditionExclusion(((String) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("AdditionalValueDays") ) {
                final Object value = values.remove("AdditionalValueDays");
                if( (value == null) || (!value.equals(getAdditionalValueDays())) ) {
                    setAdditionalValueDays(((String) value));
                }
            }
            if( values.containsKey("FixedValueDate") ) {
                final Object value = values.remove("FixedValueDate");
                if( (value == null) || (!value.equals(getFixedValueDate())) ) {
                    setFixedValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CndnMaxNumberOfSalesOrders") ) {
                final Object value = values.remove("CndnMaxNumberOfSalesOrders");
                if( (value == null) || (!value.equals(getCndnMaxNumberOfSalesOrders())) ) {
                    setCndnMaxNumberOfSalesOrders(((String) value));
                }
            }
            if( values.containsKey("MinimumConditionBasisValue") ) {
                final Object value = values.remove("MinimumConditionBasisValue");
                if( (value == null) || (!value.equals(getMinimumConditionBasisValue())) ) {
                    setMinimumConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumConditionBasisValue") ) {
                final Object value = values.remove("MaximumConditionBasisValue");
                if( (value == null) || (!value.equals(getMaximumConditionBasisValue())) ) {
                    setMaximumConditionBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaximumConditionAmount") ) {
                final Object value = values.remove("MaximumConditionAmount");
                if( (value == null) || (!value.equals(getMaximumConditionAmount())) ) {
                    setMaximumConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("IncrementalScale") ) {
                final Object value = values.remove("IncrementalScale");
                if( (value == null) || (!value.equals(getIncrementalScale())) ) {
                    setIncrementalScale(((String) value));
                }
            }
            if( values.containsKey("PricingScaleLine") ) {
                final Object value = values.remove("PricingScaleLine");
                if( (value == null) || (!value.equals(getPricingScaleLine())) ) {
                    setPricingScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionReleaseStatus") ) {
                final Object value = values.remove("ConditionReleaseStatus");
                if( (value == null) || (!value.equals(getConditionReleaseStatus())) ) {
                    setConditionReleaseStatus(((String) value));
                }
            }
            if( values.containsKey("ConditionClassification") ) {
                final Object value = values.remove("ConditionClassification");
                if( (value == null) || (!value.equals(getConditionClassification())) ) {
                    setConditionClassification(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurContrItemConditionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurContrItemConditionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurContrItemConditionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurContrItemConditionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
