/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable.PurContrItemConditionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
 * PurContrItemCondition} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PurContrItemConditionByKeyFluentHelper
    extends
    FluentHelperByKey<PurContrItemConditionByKeyFluentHelper, PurContrItemCondition, PurContrItemConditionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
     * PurContrItemCondition} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurContrItemCondition}
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurContrItemCondition}
     * @param conditionType
     *            Condition Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PurContrItemConditionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseContract,
        final String purchaseContractItem,
        final LocalDateTime conditionValidityEndDate,
        final String conditionType,
        final String conditionRecord,
        final String conditionSequentialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseContract", purchaseContract);
        this.key.put("PurchaseContractItem", purchaseContractItem);
        this.key.put("ConditionValidityEndDate", conditionValidityEndDate);
        this.key.put("ConditionType", conditionType);
        this.key.put("ConditionRecord", conditionRecord);
        this.key.put("ConditionSequentialNumber", conditionSequentialNumber);
    }

    @Override
    @Nonnull
    protected Class<PurContrItemCondition> getEntityClass()
    {
        return PurContrItemCondition.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
