/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.field.PurCtrAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable.PurCtrAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Account Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurCtrAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurCtrAccount extends VdmEntity<PurCtrAccount>
{

    /**
     * Selector for all available fields of PurCtrAccount.
     *
     */
    public final static PurCtrAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @return Sequential Number of Account Assignment
     */
    @Key
    @SerializedName( "AccountAssignment" )
    @JsonProperty( "AccountAssignment" )
    @Nullable
    @ODataField( odataName = "AccountAssignment" )
    private String accountAssignment;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignment</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> ACCOUNT_ASSIGNMENT =
        new PurCtrAccountField<String>("AccountAssignment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> PURCHASE_CONTRACT_ITEM =
        new PurCtrAccountField<String>("PurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> PURCHASE_CONTRACT =
        new PurCtrAccountField<String>("PurchaseContract");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator: Purchasing Document Account Assignment
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<Boolean> IS_DELETED = new PurCtrAccountField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<BigDecimal> QUANTITY = new PurCtrAccountField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> ORDER_QUANTITY_UNIT =
        new PurCtrAccountField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistrPercent</b>
     * </p>
     *
     * @return Distribution percentage in the case of multiple acct assgt
     */
    @SerializedName( "MultipleAcctAssgmtDistrPercent" )
    @JsonProperty( "MultipleAcctAssgmtDistrPercent" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistrPercent" )
    private BigDecimal multipleAcctAssgmtDistrPercent;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistrPercent</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<BigDecimal> MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT =
        new PurCtrAccountField<BigDecimal>("MultipleAcctAssgmtDistrPercent");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocNetAmount</b>
     * </p>
     *
     * @return Net Order Value in PO Currency
     */
    @SerializedName( "PurgDocNetAmount" )
    @JsonProperty( "PurgDocNetAmount" )
    @Nullable
    @ODataField( odataName = "PurgDocNetAmount" )
    private BigDecimal purgDocNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocNetAmount</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<BigDecimal> PURG_DOC_NET_AMOUNT =
        new PurCtrAccountField<BigDecimal>("PurgDocNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> DOCUMENT_CURRENCY =
        new PurCtrAccountField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> GL_ACCOUNT = new PurCtrAccountField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> BUSINESS_AREA = new PurCtrAccountField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> COST_CENTER = new PurCtrAccountField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> SALES_ORDER = new PurCtrAccountField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> SALES_ORDER_ITEM = new PurCtrAccountField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @SerializedName( "SalesOrderScheduleLine" )
    @JsonProperty( "SalesOrderScheduleLine" )
    @Nullable
    @ODataField( odataName = "SalesOrderScheduleLine" )
    private String salesOrderScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderScheduleLine</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> SALES_ORDER_SCHEDULE_LINE =
        new PurCtrAccountField<String>("SalesOrderScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> MASTER_FIXED_ASSET =
        new PurCtrAccountField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> FIXED_ASSET = new PurCtrAccountField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> ORDER_ID = new PurCtrAccountField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> GOODS_RECIPIENT_NAME =
        new PurCtrAccountField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> UNLOADING_POINT_NAME =
        new PurCtrAccountField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> CONTROLLING_AREA = new PurCtrAccountField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> COST_OBJECT = new PurCtrAccountField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> PROFIT_CENTER = new PurCtrAccountField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> PROJECT_NETWORK = new PurCtrAccountField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @return Internal Key for Real Estate Object
     */
    @SerializedName( "RealEstateObject" )
    @JsonProperty( "RealEstateObject" )
    @Nullable
    @ODataField( odataName = "RealEstateObject" )
    private String realEstateObject;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateObject</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> REAL_ESTATE_OBJECT =
        new PurCtrAccountField<String>("RealEstateObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountNumber</b>
     * </p>
     *
     * @return Partner account number
     */
    @SerializedName( "PartnerAccountNumber" )
    @JsonProperty( "PartnerAccountNumber" )
    @Nullable
    @ODataField( odataName = "PartnerAccountNumber" )
    private String partnerAccountNumber;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountNumber</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> PARTNER_ACCOUNT_NUMBER =
        new PurCtrAccountField<String>("PartnerAccountNumber");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> COMMITMENT_ITEM = new PurCtrAccountField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureRecoveryCode</b>
     * </p>
     *
     * @return Recovery Indicator
     */
    @SerializedName( "JointVentureRecoveryCode" )
    @JsonProperty( "JointVentureRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureRecoveryCode" )
    private String jointVentureRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureRecoveryCode</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> JOINT_VENTURE_RECOVERY_CODE =
        new PurCtrAccountField<String>("JointVentureRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> FUNDS_CENTER = new PurCtrAccountField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> FUNCTIONAL_AREA = new PurCtrAccountField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @return Reference date for settlement
     */
    @SerializedName( "SettlementReferenceDate" )
    @JsonProperty( "SettlementReferenceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementReferenceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime settlementReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<LocalDateTime> SETTLEMENT_REFERENCE_DATE =
        new PurCtrAccountField<LocalDateTime>("SettlementReferenceDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> TAX_CODE = new PurCtrAccountField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> TAX_JURISDICTION = new PurCtrAccountField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NonDeductibleInputTaxAmount</b>
     * </p>
     *
     * @return Non-deductible input tax
     */
    @SerializedName( "NonDeductibleInputTaxAmount" )
    @JsonProperty( "NonDeductibleInputTaxAmount" )
    @Nullable
    @ODataField( odataName = "NonDeductibleInputTaxAmount" )
    private BigDecimal nonDeductibleInputTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>NonDeductibleInputTaxAmount</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<BigDecimal> NON_DEDUCTIBLE_INPUT_TAX_AMOUNT =
        new PurCtrAccountField<BigDecimal>("NonDeductibleInputTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> COST_CTR_ACTIVITY_TYPE =
        new PurCtrAccountField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> BUSINESS_PROCESS = new PurCtrAccountField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> EARMARKED_FUNDS_DOCUMENT =
        new PurCtrAccountField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> GRANT_ID = new PurCtrAccountField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> BUDGET_PERIOD = new PurCtrAccountField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static PurCtrAccountField<String> WBS_ELEMENT = new PurCtrAccountField<String>("WBSElement");

    @Nonnull
    @Override
    public Class<PurCtrAccount> getType()
    {
        return PurCtrAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignment</b>
     * </p>
     *
     * @param accountAssignment
     *            Sequential Number of Account Assignment
     */
    public void setAccountAssignment( @Nullable final String accountAssignment )
    {
        rememberChangedField("AccountAssignment", this.accountAssignment);
        this.accountAssignment = accountAssignment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator: Purchasing Document Account Assignment
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistrPercent</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistrPercent
     *            Distribution percentage in the case of multiple acct assgt
     */
    public void setMultipleAcctAssgmtDistrPercent( @Nullable final BigDecimal multipleAcctAssgmtDistrPercent )
    {
        rememberChangedField("MultipleAcctAssgmtDistrPercent", this.multipleAcctAssgmtDistrPercent);
        this.multipleAcctAssgmtDistrPercent = multipleAcctAssgmtDistrPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocNetAmount</b>
     * </p>
     *
     * @param purgDocNetAmount
     *            Net Order Value in PO Currency
     */
    public void setPurgDocNetAmount( @Nullable final BigDecimal purgDocNetAmount )
    {
        rememberChangedField("PurgDocNetAmount", this.purgDocNetAmount);
        this.purgDocNetAmount = purgDocNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales and Distribution Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Document Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @param salesOrderScheduleLine
     *            Schedule Line Number
     */
    public void setSalesOrderScheduleLine( @Nullable final String salesOrderScheduleLine )
    {
        rememberChangedField("SalesOrderScheduleLine", this.salesOrderScheduleLine);
        this.salesOrderScheduleLine = salesOrderScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @param realEstateObject
     *            Internal Key for Real Estate Object
     */
    public void setRealEstateObject( @Nullable final String realEstateObject )
    {
        rememberChangedField("RealEstateObject", this.realEstateObject);
        this.realEstateObject = realEstateObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountNumber</b>
     * </p>
     *
     * @param partnerAccountNumber
     *            Partner account number
     */
    public void setPartnerAccountNumber( @Nullable final String partnerAccountNumber )
    {
        rememberChangedField("PartnerAccountNumber", this.partnerAccountNumber);
        this.partnerAccountNumber = partnerAccountNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureRecoveryCode</b>
     * </p>
     *
     * @param jointVentureRecoveryCode
     *            Recovery Indicator
     */
    public void setJointVentureRecoveryCode( @Nullable final String jointVentureRecoveryCode )
    {
        rememberChangedField("JointVentureRecoveryCode", this.jointVentureRecoveryCode);
        this.jointVentureRecoveryCode = jointVentureRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @param settlementReferenceDate
     *            Reference date for settlement
     */
    public void setSettlementReferenceDate( @Nullable final LocalDateTime settlementReferenceDate )
    {
        rememberChangedField("SettlementReferenceDate", this.settlementReferenceDate);
        this.settlementReferenceDate = settlementReferenceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NonDeductibleInputTaxAmount</b>
     * </p>
     *
     * @param nonDeductibleInputTaxAmount
     *            Non-deductible input tax
     */
    public void setNonDeductibleInputTaxAmount( @Nullable final BigDecimal nonDeductibleInputTaxAmount )
    {
        rememberChangedField("NonDeductibleInputTaxAmount", this.nonDeductibleInputTaxAmount);
        this.nonDeductibleInputTaxAmount = nonDeductibleInputTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurCtrAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AccountAssignment", getAccountAssignment());
        result.put("PurchaseContractItem", getPurchaseContractItem());
        result.put("PurchaseContract", getPurchaseContract());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AccountAssignment", getAccountAssignment());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("IsDeleted", getIsDeleted());
        values.put("Quantity", getQuantity());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("MultipleAcctAssgmtDistrPercent", getMultipleAcctAssgmtDistrPercent());
        values.put("PurgDocNetAmount", getPurgDocNetAmount());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("GLAccount", getGLAccount());
        values.put("BusinessArea", getBusinessArea());
        values.put("CostCenter", getCostCenter());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("SalesOrderScheduleLine", getSalesOrderScheduleLine());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("OrderID", getOrderID());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("ControllingArea", getControllingArea());
        values.put("CostObject", getCostObject());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("RealEstateObject", getRealEstateObject());
        values.put("PartnerAccountNumber", getPartnerAccountNumber());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("JointVentureRecoveryCode", getJointVentureRecoveryCode());
        values.put("FundsCenter", getFundsCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("SettlementReferenceDate", getSettlementReferenceDate());
        values.put("TaxCode", getTaxCode());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("NonDeductibleInputTaxAmount", getNonDeductibleInputTaxAmount());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("GrantID", getGrantID());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("WBSElement", getWBSElement());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AccountAssignment") ) {
                final Object value = values.remove("AccountAssignment");
                if( (value == null) || (!value.equals(getAccountAssignment())) ) {
                    setAccountAssignment(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistrPercent") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistrPercent");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistrPercent())) ) {
                    setMultipleAcctAssgmtDistrPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurgDocNetAmount") ) {
                final Object value = values.remove("PurgDocNetAmount");
                if( (value == null) || (!value.equals(getPurgDocNetAmount())) ) {
                    setPurgDocNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrderScheduleLine") ) {
                final Object value = values.remove("SalesOrderScheduleLine");
                if( (value == null) || (!value.equals(getSalesOrderScheduleLine())) ) {
                    setSalesOrderScheduleLine(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("RealEstateObject") ) {
                final Object value = values.remove("RealEstateObject");
                if( (value == null) || (!value.equals(getRealEstateObject())) ) {
                    setRealEstateObject(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountNumber") ) {
                final Object value = values.remove("PartnerAccountNumber");
                if( (value == null) || (!value.equals(getPartnerAccountNumber())) ) {
                    setPartnerAccountNumber(((String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("JointVentureRecoveryCode") ) {
                final Object value = values.remove("JointVentureRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureRecoveryCode())) ) {
                    setJointVentureRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate") ) {
                final Object value = values.remove("SettlementReferenceDate");
                if( (value == null) || (!value.equals(getSettlementReferenceDate())) ) {
                    setSettlementReferenceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("NonDeductibleInputTaxAmount") ) {
                final Object value = values.remove("NonDeductibleInputTaxAmount");
                if( (value == null) || (!value.equals(getNonDeductibleInputTaxAmount())) ) {
                    setNonDeductibleInputTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PurCtrAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurCtrAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurCtrAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurCtrAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
