/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable.PurCtrAccountSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount PurCtrAccount} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class PurCtrAccountByKeyFluentHelper
    extends
    FluentHelperByKey<PurCtrAccountByKeyFluentHelper, PurCtrAccount, PurCtrAccountSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount PurCtrAccount} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurCtrAccount}
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param accountAssignment
     *            Sequential Number of Account Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurCtrAccount}
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public PurCtrAccountByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String accountAssignment,
        final String purchaseContractItem,
        final String purchaseContract )
    {
        super(servicePath, entityCollection);
        this.key.put("AccountAssignment", accountAssignment);
        this.key.put("PurchaseContractItem", purchaseContractItem);
        this.key.put("PurchaseContract", purchaseContract);
    }

    @Override
    @Nonnull
    protected Class<PurCtrAccount> getEntityClass()
    {
        return PurCtrAccount.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
