/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem;

/**
 * Implementation of the {@link PurchaseContractServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractService PurchaseContractService}.
 *
 */
public class DefaultPurchaseContractServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchaseContractServiceBatch, PurchaseContractServiceBatchChangeSet>
    implements
    PurchaseContractServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchaseContractServiceBatchChangeSet(
        @Nonnull final DefaultPurchaseContractServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseContractServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet createPurchaseContract(
        @Nonnull final PurchaseContract purchaseContract )
    {
        return addRequestCreate(service::createPurchaseContract, purchaseContract);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet updatePurchaseContract(
        @Nonnull final PurchaseContract purchaseContract )
    {
        return addRequestUpdate(service::updatePurchaseContract, purchaseContract);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet createPurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return addRequestCreate(service::createPurchaseContractItem, purchaseContractItem);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet updatePurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return addRequestUpdate(service::updatePurchaseContractItem, purchaseContractItem);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return addRequestCreate(service::createPurCtrAccount, purCtrAccount);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return addRequestUpdate(service::updatePurCtrAccount, purCtrAccount);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return addRequestCreate(service::createPurCtrAddress, purCtrAddress);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return addRequestUpdate(service::updatePurCtrAddress, purCtrAddress);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return addRequestCreate(service::createPurCtrPartners, purCtrPartners);
    }

    @Nonnull
    @Override
    public PurchaseContractServiceBatchChangeSet updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return addRequestUpdate(service::updatePurCtrPartners, purCtrPartners);
    }

}
