/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractService PurchaseContractService}.
 *
 */
public interface PurchaseContractServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchaseContractServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchaseContractServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     * PurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param purchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *            PurchaseContract} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet createPurchaseContract( @Nonnull final PurchaseContract purchaseContract );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     * PurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param purchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContract
     *            PurchaseContract} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet updatePurchaseContract( @Nonnull final PurchaseContract purchaseContract );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     * PurchaseContractItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *            PurchaseContractItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet
        createPurchaseContractItem( @Nonnull final PurchaseContractItem purchaseContractItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     * PurchaseContractItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
     *            PurchaseContractItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet
        updatePurchaseContractItem( @Nonnull final PurchaseContractItem purchaseContractItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     * PurCtrAccount} entity and save it to the S/4HANA system.
     *
     * @param purCtrAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     *            PurCtrAccount} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     * PurCtrAccount} entity and save it to the S/4HANA system.
     *
     * @param purCtrAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAccount
     *            PurCtrAccount} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     * PurCtrAddress} entity and save it to the S/4HANA system.
     *
     * @param purCtrAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     *            PurCtrAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     * PurCtrAddress} entity and save it to the S/4HANA system.
     *
     * @param purCtrAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress
     *            PurCtrAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     * PurCtrPartners} entity and save it to the S/4HANA system.
     *
     * @param purCtrPartners
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *            PurCtrPartners} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     * PurCtrPartners} entity and save it to the S/4HANA system.
     *
     * @param purCtrPartners
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners
     *            PurCtrPartners} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractServiceBatchChangeSet updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners );

}
