/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition
 * PurContrItemCondition}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.field.PurContrItemConditionField
 * PurContrItemConditionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.link.PurContrItemConditionLink
 * PurContrItemConditionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_VALIDITY_END_DATE
 * CONDITION_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_VALIDITY_START_DATE
 * CONDITION_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_TEXT_ID
 * CONDITION_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_SCALE_QUANTITY
 * CONDITION_SCALE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_SCALE_QUANTITY_UNIT
 * CONDITION_SCALE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_SCALE_AMOUNT
 * CONDITION_SCALE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_SCALE_AMOUNT_CURRENCY
 * CONDITION_SCALE_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_RATE_VALUE_UNIT
 * CONDITION_RATE_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_TO_BASE_QTY_NMRTR
 * CONDITION_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_TO_BASE_QTY_DNMNTR
 * CONDITION_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_LOWER_LIMIT
 * CONDITION_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_UPPER_LIMIT
 * CONDITION_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_ALTERNATIVE_CURRENCY
 * CONDITION_ALTERNATIVE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_EXCLUSION
 * CONDITION_EXCLUSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_IS_DELETED
 * CONDITION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#ADDITIONAL_VALUE_DAYS
 * ADDITIONAL_VALUE_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#FIXED_VALUE_DATE
 * FIXED_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CNDN_MAX_NUMBER_OF_SALES_ORDERS
 * CNDN_MAX_NUMBER_OF_SALES_ORDERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#MINIMUM_CONDITION_BASIS_VALUE
 * MINIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#MAXIMUM_CONDITION_BASIS_VALUE
 * MAXIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#MAXIMUM_CONDITION_AMOUNT
 * MAXIMUM_CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#INCREMENTAL_SCALE
 * INCREMENTAL_SCALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#PRICING_SCALE_LINE
 * PRICING_SCALE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_RELEASE_STATUS
 * CONDITION_RELEASE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurContrItemCondition#CONDITION_CLASSIFICATION
 * CONDITION_CLASSIFICATION}</li>
 * </ul>
 *
 */
public interface PurContrItemConditionSelectable extends EntitySelectable<PurContrItemCondition>
{

}
