/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress PurCtrAddress}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.field.PurCtrAddressField
 * PurCtrAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.link.PurCtrAddressLink
 * PurCtrAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#FULL_NAME
 * FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#CONSIGNEE_NAME3
 * CONSIGNEE_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#CONSIGNEE_NAME4
 * CONSIGNEE_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#CARE_OF_NAME
 * CARE_OF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#DISTRICT DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#CITY_CODE
 * CITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#COMPANY_POSTAL_CODE
 * COMPANY_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PO_BOX PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PO_BOX_DEVIATING_CITY_NAME
 * PO_BOX_DEVIATING_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#STREET_PREFIX_NAME
 * STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#ADDITIONAL_STREET_PREFIX_NAME
 * ADDITIONAL_STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#ADDITIONAL_STREET_SUFFIX_NAME
 * ADDITIONAL_STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#BUILDING BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#FLOOR FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#ROOM_NUMBER
 * ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#ADDRESS_TIME_ZONE
 * ADDRESS_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PRFRD_COMM_MEDIUM_TYPE
 * PRFRD_COMM_MEDIUM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrAddress#STREET_SUFFIX_NAME
 * STREET_SUFFIX_NAME}</li>
 * </ul>
 *
 */
public interface PurCtrAddressSelectable extends EntitySelectable<PurCtrAddress>
{

}
