/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners PurCtrPartners}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.field.PurCtrPartnersField
 * PurCtrPartnersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.link.PurCtrPartnersLink
 * PurCtrPartnersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#SUPPLIER_SUBRANGE
 * SUPPLIER_SUBRANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#PARTNER_COUNTER
 * PARTNER_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurCtrPartners#DEFAULT_PARTNER
 * DEFAULT_PARTNER}</li>
 * </ul>
 *
 */
public interface PurCtrPartnersSelectable extends EntitySelectable<PurCtrPartners>
{

}
