/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem
 * PurchaseContractItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.field.PurchaseContractItemField
 * PurchaseContractItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.link.PurchaseContractItemLink
 * PurchaseContractItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURCHASING_CONTRACT_DELETION_CODE
 * PURCHASING_CONTRACT_DELETION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURCHASE_CONTRACT_ITEM_TEXT
 * PURCHASE_CONTRACT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#REQUIREMENT_TRACKING
 * REQUIREMENT_TRACKING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#SUPPLIER_MATERIAL_NUMBER
 * SUPPLIER_MATERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TARGET_QUANTITY
 * TARGET_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURG_DOC_RELEASE_ORDER_QUANTITY
 * PURG_DOC_RELEASE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#ORDER_PRICE_UNIT
 * ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR
 * ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR
 * ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#CONTRACT_NET_PRICE_AMOUNT
 * CONTRACT_NET_PRICE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#NET_PRICE_QUANTITY
 * NET_PRICE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TAX_COUNTRY
 * TAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TAX_DETERMINATION_DATE
 * TAX_DETERMINATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#STOCK_TYPE
 * STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#IS_INFO_RECORD_UPDATED
 * IS_INFO_RECORD_UPDATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PRICE_IS_TO_BE_PRINTED
 * PRICE_IS_TO_BE_PRINTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURG_DOC_ESTIMATED_PRICE
 * PURG_DOC_ESTIMATED_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#NO_DAYS_REMINDER1
 * NO_DAYS_REMINDER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#NO_DAYS_REMINDER2
 * NO_DAYS_REMINDER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#NO_DAYS_REMINDER3
 * NO_DAYS_REMINDER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PLANNED_DELIVERY_DURATION_IN_DAYS
 * PLANNED_DELIVERY_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#UNLIMITED_OVERDELIVERY_IS_ALLOWED
 * UNLIMITED_OVERDELIVERY_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURCHASING_DOCUMENT_ITEM_CATEGORY
 * PURCHASING_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#ACCOUNT_ASSIGNMENT_CATEGORY
 * ACCOUNT_ASSIGNMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#MULTIPLE_ACCT_ASSGMT_DISTRIBUTION
 * MULTIPLE_ACCT_ASSGMT_DISTRIBUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#GOODS_RECEIPT_IS_EXPECTED
 * GOODS_RECEIPT_IS_EXPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#GOODS_RECEIPT_IS_NON_VALUATED
 * GOODS_RECEIPT_IS_NON_VALUATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#INVOICE_IS_EXPECTED
 * INVOICE_IS_EXPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#INVOICE_IS_GOODS_RECEIPT_BASED
 * INVOICE_IS_GOODS_RECEIPT_BASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#IS_ORDER_ACKN_RQD
 * IS_ORDER_ACKN_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURG_DOC_ORDER_ACKN_NUMBER
 * PURG_DOC_ORDER_ACKN_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#SHIPPING_INSTRUCTION
 * SHIPPING_INSTRUCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#MANUAL_DELIVERY_ADDRESS_ID
 * MANUAL_DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#SUBCONTRACTOR
 * SUBCONTRACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#EVALD_RCPT_SETTLMT_IS_ALLOWED
 * EVALD_RCPT_SETTLMT_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#SERVICE_PERFORMER
 * SERVICE_PERFORMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PRODUCT_TYPE
 * PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#MATERIAL_TYPE
 * MATERIAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PUR_CONTRACT_ITM_REPLNMT_ELMNT_TYPE
 * PUR_CONTRACT_ITM_REPLNMT_ELMNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#FORMATTED_PURCHASE_CONTRACT_ITEM
 * FORMATTED_PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#PURCHASING_PARENT_ITEM
 * PURCHASING_PARENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TO_PURCHASE_CONTRACT
 * TO_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TO_PUR_CONTR_ITEM_CONDITION
 * TO_PUR_CONTR_ITEM_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TO_PUR_CTR_ACCOUNT
 * TO_PUR_CTR_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontract.PurchaseContractItem#TO_PUR_CTR_ADDRESS
 * TO_PUR_CTR_ADDRESS}</li>
 * </ul>
 *
 */
public interface PurchaseContractItemSelectable extends EntitySelectable<PurchaseContractItem>
{

}
