/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurContrHdrCndnScaleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurContrHdrCndnScaleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurContrHdrCndnScaleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchase Contract Header Conditions Scales
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurContrHdrCndnScaleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurContrHdrCndnScale extends VdmEntity<PurContrHdrCndnScale>
{

    /**
     * Selector for all available fields of PurContrHdrCndnScale.
     *
     */
    public final static PurContrHdrCndnScaleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> PURCHASE_CONTRACT =
        new PurContrHdrCndnScaleField<String>("PurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_RECORD =
        new PurContrHdrCndnScaleField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_SEQUENTIAL_NUMBER =
        new PurContrHdrCndnScaleField<String>("ConditionSequentialNumber");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new PurContrHdrCndnScaleField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @return Current number of the line scale
     */
    @Key
    @SerializedName( "ConditionScaleLine" )
    @JsonProperty( "ConditionScaleLine" )
    @Nullable
    @ODataField( odataName = "ConditionScaleLine" )
    private String conditionScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleLine</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_SCALE_LINE =
        new PurContrHdrCndnScaleField<String>("ConditionScaleLine");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new PurContrHdrCndnScaleField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new PurContrHdrCndnScaleField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new PurContrHdrCndnScaleField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new PurContrHdrCndnScaleField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<BigDecimal> CONDITION_RATE_VALUE =
        new PurContrHdrCndnScaleField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_RATE_VALUE_UNIT =
        new PurContrHdrCndnScaleField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionRateRatio" )
    @JsonProperty( "ConditionRateRatio" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatio" )
    private BigDecimal conditionRateRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatio</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<BigDecimal> CONDITION_RATE_RATIO =
        new PurContrHdrCndnScaleField<BigDecimal>("ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "ConditionRateRatioUnit" )
    @JsonProperty( "ConditionRateRatioUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatioUnit" )
    private String conditionRateRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatioUnit</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_RATE_RATIO_UNIT =
        new PurContrHdrCndnScaleField<String>("ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateAmount" )
    @JsonProperty( "ConditionRateAmount" )
    @Nullable
    @ODataField( odataName = "ConditionRateAmount" )
    private BigDecimal conditionRateAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateAmount</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<BigDecimal> CONDITION_RATE_AMOUNT =
        new PurContrHdrCndnScaleField<BigDecimal>("ConditionRateAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_CURRENCY =
        new PurContrHdrCndnScaleField<String>("ConditionCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionScaleIsDeleted" )
    @JsonProperty( "ConditionScaleIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionScaleIsDeleted" )
    private Boolean conditionScaleIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleIsDeleted</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<Boolean> CONDITION_SCALE_IS_DELETED =
        new PurContrHdrCndnScaleField<Boolean>("ConditionScaleIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> PRICING_SCALE_TYPE =
        new PurContrHdrCndnScaleField<String>("PricingScaleType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<BigDecimal> CONDITION_QUANTITY =
        new PurContrHdrCndnScaleField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static PurContrHdrCndnScaleField<String> CONDITION_QUANTITY_UNIT =
        new PurContrHdrCndnScaleField<String>("ConditionQuantityUnit");
    /**
     * Navigation property <b>to_PurchaseContract</b> for <b>PurContrHdrCndnScale</b> to single <b>PurchaseContract</b>.
     *
     */
    @SerializedName( "to_PurchaseContract" )
    @JsonProperty( "to_PurchaseContract" )
    @ODataField( odataName = "to_PurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchaseContract toPurchaseContract;
    /**
     * Navigation property <b>to_PurContrHdrCndnAmount</b> for <b>PurContrHdrCndnScale</b> to single
     * <b>PurContrHdrCndnAmount</b>.
     *
     */
    @SerializedName( "to_PurContrHdrCndnAmount" )
    @JsonProperty( "to_PurContrHdrCndnAmount" )
    @ODataField( odataName = "to_PurContrHdrCndnAmount" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurContrHdrCndnAmount toPurContrHdrCndnAmount;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static PurContrHdrCndnScaleOneToOneLink<PurchaseContract> TO_PURCHASE_CONTRACT =
        new PurContrHdrCndnScaleOneToOneLink<PurchaseContract>("to_PurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_PurContrHdrCndnAmount</b> navigation property to query
     * operations.
     *
     */
    public final static PurContrHdrCndnScaleOneToOneLink<PurContrHdrCndnAmount> TO_PUR_CONTR_HDR_CNDN_AMOUNT =
        new PurContrHdrCndnScaleOneToOneLink<PurContrHdrCndnAmount>("to_PurContrHdrCndnAmount");

    @Nonnull
    @Override
    public Class<PurContrHdrCndnScale> getType()
    {
        return PurContrHdrCndnScale.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @param conditionScaleLine
     *            Current number of the line scale
     */
    public void setConditionScaleLine( @Nullable final String conditionScaleLine )
    {
        rememberChangedField("ConditionScaleLine", this.conditionScaleLine);
        this.conditionScaleLine = conditionScaleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @param conditionRateRatioUnit
     *            Unit of Measure
     */
    public void setConditionRateRatioUnit( @Nullable final String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @param conditionRateAmount
     *            Condition Amount or Percentage
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleIsDeleted</b>
     * </p>
     *
     * @param conditionScaleIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionScaleIsDeleted( @Nullable final Boolean conditionScaleIsDeleted )
    {
        rememberChangedField("ConditionScaleIsDeleted", this.conditionScaleIsDeleted);
        this.conditionScaleIsDeleted = conditionScaleIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurContrHdrCndnScale";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseContract", getPurchaseContract());
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        result.put("ConditionScaleLine", getConditionScaleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseContract", getPurchaseContract());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionScaleLine", getConditionScaleLine());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionScaleIsDeleted", getConditionScaleIsDeleted());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionScaleLine") ) {
                final Object value = values.remove("ConditionScaleLine");
                if( (value == null) || (!value.equals(getConditionScaleLine())) ) {
                    setConditionScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleIsDeleted") ) {
                final Object value = values.remove("ConditionScaleIsDeleted");
                if( (value == null) || (!value.equals(getConditionScaleIsDeleted())) ) {
                    setConditionScaleIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchaseContract") ) {
                final Object value = (values).remove("to_PurchaseContract");
                if( value instanceof Map ) {
                    if( toPurchaseContract == null ) {
                        toPurchaseContract = new PurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurContrHdrCndnAmount") ) {
                final Object value = (values).remove("to_PurContrHdrCndnAmount");
                if( value instanceof Map ) {
                    if( toPurContrHdrCndnAmount == null ) {
                        toPurContrHdrCndnAmount = new PurContrHdrCndnAmount();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurContrHdrCndnAmount.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurContrHdrCndnScaleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurContrHdrCndnScaleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurContrHdrCndnScaleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurContrHdrCndnScaleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchaseContract != null ) {
            (values).put("to_PurchaseContract", toPurchaseContract);
        }
        if( toPurContrHdrCndnAmount != null ) {
            (values).put("to_PurContrHdrCndnAmount", toPurContrHdrCndnAmount);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchaseContract</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchaseContract</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContract fetchPurchaseContract()
    {
        return fetchFieldAsSingle("to_PurchaseContract", PurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>PurchaseContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_PurchaseContract</b> of a queried <b>PurContrHdrCndnScale</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContract getPurchaseContractOrFetch()
    {
        if( toPurchaseContract == null ) {
            toPurchaseContract = fetchPurchaseContract();
        }
        return toPurchaseContract;
    }

    /**
     * Retrieval of associated <b>PurchaseContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>PurContrHdrCndnScale</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseContract</b> is already loaded, the result will
     *         contain the <b>PurchaseContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchaseContract> getPurchaseContractIfPresent()
    {
        return Option.of(toPurchaseContract);
    }

    /**
     * Overwrites the associated <b>PurchaseContract</b> entity for the loaded navigation property
     * <b>to_PurchaseContract</b>.
     *
     * @param value
     *            New <b>PurchaseContract</b> entity.
     */
    public void setPurchaseContract( final PurchaseContract value )
    {
        toPurchaseContract = value;
    }

    /**
     * Fetches the <b>PurContrHdrCndnAmount</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurContrHdrCndnAmount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurContrHdrCndnAmount</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurContrHdrCndnAmount fetchPurContrHdrCndnAmount()
    {
        return fetchFieldAsSingle("to_PurContrHdrCndnAmount", PurContrHdrCndnAmount.class);
    }

    /**
     * Retrieval of associated <b>PurContrHdrCndnAmount</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurContrHdrCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_PurContrHdrCndnAmount</b> of a queried <b>PurContrHdrCndnScale</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurContrHdrCndnAmount</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurContrHdrCndnAmount getPurContrHdrCndnAmountOrFetch()
    {
        if( toPurContrHdrCndnAmount == null ) {
            toPurContrHdrCndnAmount = fetchPurContrHdrCndnAmount();
        }
        return toPurContrHdrCndnAmount;
    }

    /**
     * Retrieval of associated <b>PurContrHdrCndnAmount</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurContrHdrCndnAmount</b>.
     * <p>
     * If the navigation property for an entity <b>PurContrHdrCndnScale</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurContrHdrCndnAmount</b> is already loaded, the result
     *         will contain the <b>PurContrHdrCndnAmount</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurContrHdrCndnAmount> getPurContrHdrCndnAmountIfPresent()
    {
        return Option.of(toPurContrHdrCndnAmount);
    }

    /**
     * Overwrites the associated <b>PurContrHdrCndnAmount</b> entity for the loaded navigation property
     * <b>to_PurContrHdrCndnAmount</b>.
     *
     * @param value
     *            New <b>PurContrHdrCndnAmount</b> entity.
     */
    public void setPurContrHdrCndnAmount( final PurContrHdrCndnAmount value )
    {
        toPurContrHdrCndnAmount = value;
    }

    /**
     * Helper class to allow for fluent creation of PurContrHdrCndnScale instances.
     *
     */
    public final static class PurContrHdrCndnScaleBuilder
    {

        private PurchaseContract toPurchaseContract;
        private String purchaseContract = null;
        private PurContrHdrCndnAmount toPurContrHdrCndnAmount;

        private PurContrHdrCndnScale.PurContrHdrCndnScaleBuilder toPurchaseContract( final PurchaseContract value )
        {
            toPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseContract</b> for <b>PurContrHdrCndnScale</b> to single
         * <b>PurchaseContract</b>.
         *
         * @param value
         *            The PurchaseContract to build this PurContrHdrCndnScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrHdrCndnScale.PurContrHdrCndnScaleBuilder purchaseContract( final PurchaseContract value )
        {
            return toPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>PurchaseContract</b>
         * </p>
         *
         * @param value
         *            The purchaseContract to build this PurContrHdrCndnScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrHdrCndnScale.PurContrHdrCndnScaleBuilder purchaseContract( final String value )
        {
            purchaseContract = value;
            return this;
        }

        private PurContrHdrCndnScale.PurContrHdrCndnScaleBuilder toPurContrHdrCndnAmount(
            final PurContrHdrCndnAmount value )
        {
            toPurContrHdrCndnAmount = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurContrHdrCndnAmount</b> for <b>PurContrHdrCndnScale</b> to single
         * <b>PurContrHdrCndnAmount</b>.
         *
         * @param value
         *            The PurContrHdrCndnAmount to build this PurContrHdrCndnScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrHdrCndnScale.PurContrHdrCndnScaleBuilder purContrHdrCndnAmount(
            final PurContrHdrCndnAmount value )
        {
            return toPurContrHdrCndnAmount(value);
        }

    }

}
