/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurContrHdrCndnScaleSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnScale
 * PurContrHdrCndnScale} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class PurContrHdrCndnScaleByKeyFluentHelper
    extends
    FluentHelperByKey<PurContrHdrCndnScaleByKeyFluentHelper, PurContrHdrCndnScale, PurContrHdrCndnScaleSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnScale
     * PurContrHdrCndnScale} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurContrHdrCndnScale}
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurContrHdrCndnScale}
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionScaleLine
     *            Current number of the line scale
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public PurContrHdrCndnScaleByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseContract,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseContract", purchaseContract);
        this.key.put("ConditionRecord", conditionRecord);
        this.key.put("ConditionSequentialNumber", conditionSequentialNumber);
        this.key.put("ConditionValidityEndDate", conditionValidityEndDate);
        this.key.put("ConditionScaleLine", conditionScaleLine);
    }

    @Override
    @Nonnull
    protected Class<PurContrHdrCndnScale> getEntityClass()
    {
        return PurContrHdrCndnScale.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
