/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurContrHdrCndnValdtySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnValdty
 * PurContrHdrCndnValdty} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PurContrHdrCndnValdtyByKeyFluentHelper
    extends
    FluentHelperByKey<PurContrHdrCndnValdtyByKeyFluentHelper, PurContrHdrCndnValdty, PurContrHdrCndnValdtySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrHdrCndnValdty
     * PurContrHdrCndnValdty} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurContrHdrCndnValdty}
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurContrHdrCndnValdty}
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PurContrHdrCndnValdtyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseContract", purchaseContract);
        this.key.put("ConditionRecord", conditionRecord);
        this.key.put("ConditionValidityEndDate", conditionValidityEndDate);
    }

    @Override
    @Nonnull
    protected Class<PurContrHdrCndnValdty> getEntityClass()
    {
        return PurContrHdrCndnValdty.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
