/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurContrItmCndnValdtyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurContrItmCndnValdtyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurContrItmCndnValdtyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurContrItmCndnValdtySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchase Contract Item Condition Validity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurContrItmCndnValdtyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurContrItmCndnValdty extends VdmEntity<PurContrItmCndnValdty>
{

    /**
     * Selector for all available fields of PurContrItmCndnValdty.
     *
     */
    public final static PurContrItmCndnValdtySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<String> PURCHASE_CONTRACT =
        new PurContrItmCndnValdtyField<String>("PurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<String> PURCHASE_CONTRACT_ITEM =
        new PurContrItmCndnValdtyField<String>("PurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<String> CONDITION_RECORD =
        new PurContrItmCndnValdtyField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new PurContrItmCndnValdtyField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<String> CONDITION_APPLICATION =
        new PurContrItmCndnValdtyField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<String> CONDITION_TYPE =
        new PurContrItmCndnValdtyField<String>("ConditionType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionIsDeleted" )
    @JsonProperty( "ConditionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsDeleted" )
    private Boolean conditionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsDeleted</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<Boolean> CONDITION_IS_DELETED =
        new PurContrItmCndnValdtyField<Boolean>("ConditionIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<String> PLANT = new PurContrItmCndnValdtyField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static PurContrItmCndnValdtyField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new PurContrItmCndnValdtyField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Navigation property <b>to_PurchaseContractItem</b> for <b>PurContrItmCndnValdty</b> to single
     * <b>PurchaseContractItem</b>.
     *
     */
    @SerializedName( "to_PurchaseContractItem" )
    @JsonProperty( "to_PurchaseContractItem" )
    @ODataField( odataName = "to_PurchaseContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchaseContractItem toPurchaseContractItem;
    /**
     * Navigation property <b>to_PurchaseContract</b> for <b>PurContrItmCndnValdty</b> to single
     * <b>PurchaseContract</b>.
     *
     */
    @SerializedName( "to_PurchaseContract" )
    @JsonProperty( "to_PurchaseContract" )
    @ODataField( odataName = "to_PurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchaseContract toPurchaseContract;
    /**
     * Navigation property <b>to_PurContrItmCndnAmount</b> for <b>PurContrItmCndnValdty</b> to multiple
     * <b>PurContrItmCndnAmount</b>.
     *
     */
    @SerializedName( "to_PurContrItmCndnAmount" )
    @JsonProperty( "to_PurContrItmCndnAmount" )
    @ODataField( odataName = "to_PurContrItmCndnAmount" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurContrItmCndnAmount> toPurContrItmCndnAmount;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static PurContrItmCndnValdtyOneToOneLink<PurchaseContractItem> TO_PURCHASE_CONTRACT_ITEM =
        new PurContrItmCndnValdtyOneToOneLink<PurchaseContractItem>("to_PurchaseContractItem");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static PurContrItmCndnValdtyOneToOneLink<PurchaseContract> TO_PURCHASE_CONTRACT =
        new PurContrItmCndnValdtyOneToOneLink<PurchaseContract>("to_PurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_PurContrItmCndnAmount</b> navigation property to query
     * operations.
     *
     */
    public final static PurContrItmCndnValdtyLink<PurContrItmCndnAmount> TO_PUR_CONTR_ITM_CNDN_AMOUNT =
        new PurContrItmCndnValdtyLink<PurContrItmCndnAmount>("to_PurContrItmCndnAmount");

    @Nonnull
    @Override
    public Class<PurContrItmCndnValdty> getType()
    {
        return PurContrItmCndnValdty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurContrItmCndnValdty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseContract", getPurchaseContract());
        result.put("PurchaseContractItem", getPurchaseContractItem());
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        values.put("Plant", getPlant());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchaseContractItem") ) {
                final Object value = (values).remove("to_PurchaseContractItem");
                if( value instanceof Map ) {
                    if( toPurchaseContractItem == null ) {
                        toPurchaseContractItem = new PurchaseContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseContractItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurchaseContract") ) {
                final Object value = (values).remove("to_PurchaseContract");
                if( value instanceof Map ) {
                    if( toPurchaseContract == null ) {
                        toPurchaseContract = new PurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurContrItmCndnAmount") ) {
                final Object value = (values).remove("to_PurContrItmCndnAmount");
                if( value instanceof Iterable ) {
                    if( toPurContrItmCndnAmount == null ) {
                        toPurContrItmCndnAmount = Lists.newArrayList();
                    } else {
                        toPurContrItmCndnAmount = Lists.newArrayList(toPurContrItmCndnAmount);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurContrItmCndnAmount entity;
                        if( toPurContrItmCndnAmount.size() > i ) {
                            entity = toPurContrItmCndnAmount.get(i);
                        } else {
                            entity = new PurContrItmCndnAmount();
                            toPurContrItmCndnAmount.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurContrItmCndnValdtyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurContrItmCndnValdtyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurContrItmCndnValdtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurContrItmCndnValdtyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchaseContractItem != null ) {
            (values).put("to_PurchaseContractItem", toPurchaseContractItem);
        }
        if( toPurchaseContract != null ) {
            (values).put("to_PurchaseContract", toPurchaseContract);
        }
        if( toPurContrItmCndnAmount != null ) {
            (values).put("to_PurContrItmCndnAmount", toPurContrItmCndnAmount);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchaseContractItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchaseContractItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContractItem fetchPurchaseContractItem()
    {
        return fetchFieldAsSingle("to_PurchaseContractItem", PurchaseContractItem.class);
    }

    /**
     * Retrieval of associated <b>PurchaseContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseContractItem</b> of a queried <b>PurContrItmCndnValdty</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContractItem getPurchaseContractItemOrFetch()
    {
        if( toPurchaseContractItem == null ) {
            toPurchaseContractItem = fetchPurchaseContractItem();
        }
        return toPurchaseContractItem;
    }

    /**
     * Retrieval of associated <b>PurchaseContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>PurContrItmCndnValdty</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseContractItem</b> is already loaded, the result
     *         will contain the <b>PurchaseContractItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchaseContractItem> getPurchaseContractItemIfPresent()
    {
        return Option.of(toPurchaseContractItem);
    }

    /**
     * Overwrites the associated <b>PurchaseContractItem</b> entity for the loaded navigation property
     * <b>to_PurchaseContractItem</b>.
     *
     * @param value
     *            New <b>PurchaseContractItem</b> entity.
     */
    public void setPurchaseContractItem( final PurchaseContractItem value )
    {
        toPurchaseContractItem = value;
    }

    /**
     * Fetches the <b>PurchaseContract</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchaseContract</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContract fetchPurchaseContract()
    {
        return fetchFieldAsSingle("to_PurchaseContract", PurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>PurchaseContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_PurchaseContract</b> of a queried <b>PurContrItmCndnValdty</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContract getPurchaseContractOrFetch()
    {
        if( toPurchaseContract == null ) {
            toPurchaseContract = fetchPurchaseContract();
        }
        return toPurchaseContract;
    }

    /**
     * Retrieval of associated <b>PurchaseContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>PurContrItmCndnValdty</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseContract</b> is already loaded, the result will
     *         contain the <b>PurchaseContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchaseContract> getPurchaseContractIfPresent()
    {
        return Option.of(toPurchaseContract);
    }

    /**
     * Overwrites the associated <b>PurchaseContract</b> entity for the loaded navigation property
     * <b>to_PurchaseContract</b>.
     *
     * @param value
     *            New <b>PurchaseContract</b> entity.
     */
    public void setPurchaseContract( final PurchaseContract value )
    {
        toPurchaseContract = value;
    }

    /**
     * Fetches the <b>PurContrItmCndnAmount</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurContrItmCndnAmount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurContrItmCndnAmount</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurContrItmCndnAmount> fetchPurContrItmCndnAmount()
    {
        return fetchFieldAsList("to_PurContrItmCndnAmount", PurContrItmCndnAmount.class);
    }

    /**
     * Retrieval of associated <b>PurContrItmCndnAmount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_PurContrItmCndnAmount</b> of a queried <b>PurContrItmCndnValdty</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurContrItmCndnAmount</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurContrItmCndnAmount> getPurContrItmCndnAmountOrFetch()
    {
        if( toPurContrItmCndnAmount == null ) {
            toPurContrItmCndnAmount = fetchPurContrItmCndnAmount();
        }
        return toPurContrItmCndnAmount;
    }

    /**
     * Retrieval of associated <b>PurContrItmCndnAmount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property for an entity <b>PurContrItmCndnValdty</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurContrItmCndnAmount</b> is already loaded, the result
     *         will contain the <b>PurContrItmCndnAmount</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurContrItmCndnAmount>> getPurContrItmCndnAmountIfPresent()
    {
        return Option.of(toPurContrItmCndnAmount);
    }

    /**
     * Overwrites the list of associated <b>PurContrItmCndnAmount</b> entities for the loaded navigation property
     * <b>to_PurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_PurContrItmCndnAmount</b> of a queried <b>PurContrItmCndnValdty</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurContrItmCndnAmount</b> entities.
     */
    public void setPurContrItmCndnAmount( @Nonnull final List<PurContrItmCndnAmount> value )
    {
        if( toPurContrItmCndnAmount == null ) {
            toPurContrItmCndnAmount = Lists.newArrayList();
        }
        toPurContrItmCndnAmount.clear();
        toPurContrItmCndnAmount.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurContrItmCndnAmount</b> entities. This corresponds to the OData
     * navigation property <b>to_PurContrItmCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_PurContrItmCndnAmount</b> of a queried <b>PurContrItmCndnValdty</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurContrItmCndnAmount</b> entities.
     */
    public void addPurContrItmCndnAmount( PurContrItmCndnAmount... entity )
    {
        if( toPurContrItmCndnAmount == null ) {
            toPurContrItmCndnAmount = Lists.newArrayList();
        }
        toPurContrItmCndnAmount.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurContrItmCndnValdty instances.
     *
     */
    public final static class PurContrItmCndnValdtyBuilder
    {

        private PurchaseContractItem toPurchaseContractItem;
        private String purchaseContractItem = null;
        private PurchaseContract toPurchaseContract;
        private String purchaseContract = null;
        private List<PurContrItmCndnAmount> toPurContrItmCndnAmount = Lists.newArrayList();

        private PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder toPurchaseContractItem(
            final PurchaseContractItem value )
        {
            toPurchaseContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseContractItem</b> for <b>PurContrItmCndnValdty</b> to single
         * <b>PurchaseContractItem</b>.
         *
         * @param value
         *            The PurchaseContractItem to build this PurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder purchaseContractItem(
            final PurchaseContractItem value )
        {
            return toPurchaseContractItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 5
         * <p>
         * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
         * </p>
         *
         * @param value
         *            The purchaseContractItem to build this PurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder purchaseContractItem( final String value )
        {
            purchaseContractItem = value;
            return this;
        }

        private PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder toPurchaseContract( final PurchaseContract value )
        {
            toPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseContract</b> for <b>PurContrItmCndnValdty</b> to single
         * <b>PurchaseContract</b>.
         *
         * @param value
         *            The PurchaseContract to build this PurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder purchaseContract( final PurchaseContract value )
        {
            return toPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>PurchaseContract</b>
         * </p>
         *
         * @param value
         *            The purchaseContract to build this PurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder purchaseContract( final String value )
        {
            purchaseContract = value;
            return this;
        }

        private PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder toPurContrItmCndnAmount(
            final List<PurContrItmCndnAmount> value )
        {
            toPurContrItmCndnAmount.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurContrItmCndnAmount</b> for <b>PurContrItmCndnValdty</b> to multiple
         * <b>PurContrItmCndnAmount</b>.
         *
         * @param value
         *            The PurContrItmCndnAmounts to build this PurContrItmCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurContrItmCndnValdty.PurContrItmCndnValdtyBuilder purContrItmCndnAmount(
            PurContrItmCndnAmount... value )
        {
            return toPurContrItmCndnAmount(Lists.newArrayList(value));
        }

    }

}
