/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurCtrAddressField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurCtrAddressSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Delivery Address
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurCtrAddressType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurCtrAddress extends VdmEntity<PurCtrAddress>
{

    /**
     * Selector for all available fields of PurCtrAddress.
     *
     */
    public final static PurCtrAddressSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Contract Header
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PURCHASE_CONTRACT =
        new PurCtrAddressField<String>("PurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @Key
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> ADDRESS_ID = new PurCtrAddressField<String>("AddressID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Contract
     */
    @Key
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PURCHASE_CONTRACT_ITEM =
        new PurCtrAddressField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Form-of-Address Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> FORM_OF_ADDRESS = new PurCtrAddressField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FullName</b>
     * </p>
     *
     * @return Full Name of Person
     */
    @SerializedName( "FullName" )
    @JsonProperty( "FullName" )
    @Nullable
    @ODataField( odataName = "FullName" )
    private String fullName;
    /**
     * Use with available fluent helpers to apply the <b>FullName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> FULL_NAME = new PurCtrAddressField<String>("FullName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsigneeName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "ConsigneeName3" )
    @JsonProperty( "ConsigneeName3" )
    @Nullable
    @ODataField( odataName = "ConsigneeName3" )
    private String consigneeName3;
    /**
     * Use with available fluent helpers to apply the <b>ConsigneeName3</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> CONSIGNEE_NAME3 = new PurCtrAddressField<String>("ConsigneeName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsigneeName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "ConsigneeName4" )
    @JsonProperty( "ConsigneeName4" )
    @Nullable
    @ODataField( odataName = "ConsigneeName4" )
    private String consigneeName4;
    /**
     * Use with available fluent helpers to apply the <b>ConsigneeName4</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> CONSIGNEE_NAME4 = new PurCtrAddressField<String>("ConsigneeName4");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CareOfName</b>
     * </p>
     *
     * @return c/o name
     */
    @SerializedName( "CareOfName" )
    @JsonProperty( "CareOfName" )
    @Nullable
    @ODataField( odataName = "CareOfName" )
    private String careOfName;
    /**
     * Use with available fluent helpers to apply the <b>CareOfName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> CARE_OF_NAME = new PurCtrAddressField<String>("CareOfName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> CITY_NAME = new PurCtrAddressField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "District" )
    @JsonProperty( "District" )
    @Nullable
    @ODataField( odataName = "District" )
    private String district;
    /**
     * Use with available fluent helpers to apply the <b>District</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> DISTRICT = new PurCtrAddressField<String>("District");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @return City Code
     */
    @SerializedName( "CityCode" )
    @JsonProperty( "CityCode" )
    @Nullable
    @ODataField( odataName = "CityCode" )
    private String cityCode;
    /**
     * Use with available fluent helpers to apply the <b>CityCode</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> CITY_CODE = new PurCtrAddressField<String>("CityCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> POSTAL_CODE = new PurCtrAddressField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @return PO Box Postal Code
     */
    @SerializedName( "POBoxPostalCode" )
    @JsonProperty( "POBoxPostalCode" )
    @Nullable
    @ODataField( odataName = "POBoxPostalCode" )
    private String pOBoxPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>POBoxPostalCode</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PO_BOX_POSTAL_CODE =
        new PurCtrAddressField<String>("POBoxPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompanyPostalCode</b>
     * </p>
     *
     * @return Company Postal Code (for Large Customers)
     */
    @SerializedName( "CompanyPostalCode" )
    @JsonProperty( "CompanyPostalCode" )
    @Nullable
    @ODataField( odataName = "CompanyPostalCode" )
    private String companyPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyPostalCode</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> COMPANY_POSTAL_CODE =
        new PurCtrAddressField<String>("CompanyPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Use with available fluent helpers to apply the <b>POBox</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PO_BOX = new PurCtrAddressField<String>("POBox");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCityName</b>
     * </p>
     *
     * @return PO Box city
     */
    @SerializedName( "POBoxDeviatingCityName" )
    @JsonProperty( "POBoxDeviatingCityName" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingCityName" )
    private String pOBoxDeviatingCityName;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingCityName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PO_BOX_DEVIATING_CITY_NAME =
        new PurCtrAddressField<String>("POBoxDeviatingCityName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> STREET_NAME = new PurCtrAddressField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> HOUSE_NUMBER = new PurCtrAddressField<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @return Street 2
     */
    @SerializedName( "StreetPrefixName" )
    @JsonProperty( "StreetPrefixName" )
    @Nullable
    @ODataField( odataName = "StreetPrefixName" )
    private String streetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetPrefixName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> STREET_PREFIX_NAME =
        new PurCtrAddressField<String>("StreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @return Street 3
     */
    @SerializedName( "AdditionalStreetPrefixName" )
    @JsonProperty( "AdditionalStreetPrefixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetPrefixName" )
    private String additionalStreetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetPrefixName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> ADDITIONAL_STREET_PREFIX_NAME =
        new PurCtrAddressField<String>("AdditionalStreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @return Street 5
     */
    @SerializedName( "AdditionalStreetSuffixName" )
    @JsonProperty( "AdditionalStreetSuffixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetSuffixName" )
    private String additionalStreetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetSuffixName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> ADDITIONAL_STREET_SUFFIX_NAME =
        new PurCtrAddressField<String>("AdditionalStreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @return Building (Number or Code)
     */
    @SerializedName( "Building" )
    @JsonProperty( "Building" )
    @Nullable
    @ODataField( odataName = "Building" )
    private String building;
    /**
     * Use with available fluent helpers to apply the <b>Building</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> BUILDING = new PurCtrAddressField<String>("Building");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @return Floor in building
     */
    @SerializedName( "Floor" )
    @JsonProperty( "Floor" )
    @Nullable
    @ODataField( odataName = "Floor" )
    private String floor;
    /**
     * Use with available fluent helpers to apply the <b>Floor</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> FLOOR = new PurCtrAddressField<String>("Floor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @return Room or Apartment Number
     */
    @SerializedName( "RoomNumber" )
    @JsonProperty( "RoomNumber" )
    @Nullable
    @ODataField( odataName = "RoomNumber" )
    private String roomNumber;
    /**
     * Use with available fluent helpers to apply the <b>RoomNumber</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> ROOM_NUMBER = new PurCtrAddressField<String>("RoomNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> COUNTRY = new PurCtrAddressField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "CorrespondenceLanguage" )
    @JsonProperty( "CorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "CorrespondenceLanguage" )
    private String correspondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>CorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> CORRESPONDENCE_LANGUAGE =
        new PurCtrAddressField<String>("CorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> REGION = new PurCtrAddressField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AddressTimeZone</b>
     * </p>
     *
     * @return Address Time Zone
     */
    @SerializedName( "AddressTimeZone" )
    @JsonProperty( "AddressTimeZone" )
    @Nullable
    @ODataField( odataName = "AddressTimeZone" )
    private String addressTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>AddressTimeZone</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> ADDRESS_TIME_ZONE =
        new PurCtrAddressField<String>("AddressTimeZone");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> TAX_JURISDICTION = new PurCtrAddressField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrfrdCommMediumType</b>
     * </p>
     *
     * @return Communication Method (Key) (Business Address Services)
     */
    @SerializedName( "PrfrdCommMediumType" )
    @JsonProperty( "PrfrdCommMediumType" )
    @Nullable
    @ODataField( odataName = "PrfrdCommMediumType" )
    private String prfrdCommMediumType;
    /**
     * Use with available fluent helpers to apply the <b>PrfrdCommMediumType</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PRFRD_COMM_MEDIUM_TYPE =
        new PurCtrAddressField<String>("PrfrdCommMediumType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Telephone No.: Dialing Code + Number
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> PHONE_NUMBER = new PurCtrAddressField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 31
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return Fax Number
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> FAX_NUMBER = new PurCtrAddressField<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @return Transportation zone to or from which the goods are delivered
     */
    @SerializedName( "TransportZone" )
    @JsonProperty( "TransportZone" )
    @Nullable
    @ODataField( odataName = "TransportZone" )
    private String transportZone;
    /**
     * Use with available fluent helpers to apply the <b>TransportZone</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> TRANSPORT_ZONE = new PurCtrAddressField<String>("TransportZone");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @return House number supplement
     */
    @SerializedName( "HouseNumberSupplementText" )
    @JsonProperty( "HouseNumberSupplementText" )
    @Nullable
    @ODataField( odataName = "HouseNumberSupplementText" )
    private String houseNumberSupplementText;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumberSupplementText</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> HOUSE_NUMBER_SUPPLEMENT_TEXT =
        new PurCtrAddressField<String>("HouseNumberSupplementText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @return Street 4
     */
    @SerializedName( "StreetSuffixName" )
    @JsonProperty( "StreetSuffixName" )
    @Nullable
    @ODataField( odataName = "StreetSuffixName" )
    private String streetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetSuffixName</b> field to query operations.
     *
     */
    public final static PurCtrAddressField<String> STREET_SUFFIX_NAME =
        new PurCtrAddressField<String>("StreetSuffixName");

    @Nonnull
    @Override
    public Class<PurCtrAddress> getType()
    {
        return PurCtrAddress.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Contract Header
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Contract
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Form-of-Address Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FullName</b>
     * </p>
     *
     * @param fullName
     *            Full Name of Person
     */
    public void setFullName( @Nullable final String fullName )
    {
        rememberChangedField("FullName", this.fullName);
        this.fullName = fullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsigneeName3</b>
     * </p>
     *
     * @param consigneeName3
     *            Name 3
     */
    public void setConsigneeName3( @Nullable final String consigneeName3 )
    {
        rememberChangedField("ConsigneeName3", this.consigneeName3);
        this.consigneeName3 = consigneeName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsigneeName4</b>
     * </p>
     *
     * @param consigneeName4
     *            Name 4
     */
    public void setConsigneeName4( @Nullable final String consigneeName4 )
    {
        rememberChangedField("ConsigneeName4", this.consigneeName4);
        this.consigneeName4 = consigneeName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CareOfName</b>
     * </p>
     *
     * @param careOfName
     *            c/o name
     */
    public void setCareOfName( @Nullable final String careOfName )
    {
        rememberChangedField("CareOfName", this.careOfName);
        this.careOfName = careOfName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @param district
     *            District
     */
    public void setDistrict( @Nullable final String district )
    {
        rememberChangedField("District", this.district);
        this.district = district;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @param cityCode
     *            City Code
     */
    public void setCityCode( @Nullable final String cityCode )
    {
        rememberChangedField("CityCode", this.cityCode);
        this.cityCode = cityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @param pOBoxPostalCode
     *            PO Box Postal Code
     */
    public void setPOBoxPostalCode( @Nullable final String pOBoxPostalCode )
    {
        rememberChangedField("POBoxPostalCode", this.pOBoxPostalCode);
        this.pOBoxPostalCode = pOBoxPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompanyPostalCode</b>
     * </p>
     *
     * @param companyPostalCode
     *            Company Postal Code (for Large Customers)
     */
    public void setCompanyPostalCode( @Nullable final String companyPostalCode )
    {
        rememberChangedField("CompanyPostalCode", this.companyPostalCode);
        this.companyPostalCode = companyPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCityName</b>
     * </p>
     *
     * @param pOBoxDeviatingCityName
     *            PO Box city
     */
    public void setPOBoxDeviatingCityName( @Nullable final String pOBoxDeviatingCityName )
    {
        rememberChangedField("POBoxDeviatingCityName", this.pOBoxDeviatingCityName);
        this.pOBoxDeviatingCityName = pOBoxDeviatingCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @param streetPrefixName
     *            Street 2
     */
    public void setStreetPrefixName( @Nullable final String streetPrefixName )
    {
        rememberChangedField("StreetPrefixName", this.streetPrefixName);
        this.streetPrefixName = streetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @param additionalStreetPrefixName
     *            Street 3
     */
    public void setAdditionalStreetPrefixName( @Nullable final String additionalStreetPrefixName )
    {
        rememberChangedField("AdditionalStreetPrefixName", this.additionalStreetPrefixName);
        this.additionalStreetPrefixName = additionalStreetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @param additionalStreetSuffixName
     *            Street 5
     */
    public void setAdditionalStreetSuffixName( @Nullable final String additionalStreetSuffixName )
    {
        rememberChangedField("AdditionalStreetSuffixName", this.additionalStreetSuffixName);
        this.additionalStreetSuffixName = additionalStreetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @param building
     *            Building (Number or Code)
     */
    public void setBuilding( @Nullable final String building )
    {
        rememberChangedField("Building", this.building);
        this.building = building;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @param floor
     *            Floor in building
     */
    public void setFloor( @Nullable final String floor )
    {
        rememberChangedField("Floor", this.floor);
        this.floor = floor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @param roomNumber
     *            Room or Apartment Number
     */
    public void setRoomNumber( @Nullable final String roomNumber )
    {
        rememberChangedField("RoomNumber", this.roomNumber);
        this.roomNumber = roomNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @param correspondenceLanguage
     *            Language Key
     */
    public void setCorrespondenceLanguage( @Nullable final String correspondenceLanguage )
    {
        rememberChangedField("CorrespondenceLanguage", this.correspondenceLanguage);
        this.correspondenceLanguage = correspondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AddressTimeZone</b>
     * </p>
     *
     * @param addressTimeZone
     *            Address Time Zone
     */
    public void setAddressTimeZone( @Nullable final String addressTimeZone )
    {
        rememberChangedField("AddressTimeZone", this.addressTimeZone);
        this.addressTimeZone = addressTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrfrdCommMediumType</b>
     * </p>
     *
     * @param prfrdCommMediumType
     *            Communication Method (Key) (Business Address Services)
     */
    public void setPrfrdCommMediumType( @Nullable final String prfrdCommMediumType )
    {
        rememberChangedField("PrfrdCommMediumType", this.prfrdCommMediumType);
        this.prfrdCommMediumType = prfrdCommMediumType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Telephone No.: Dialing Code + Number
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 31
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            Fax Number
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @param transportZone
     *            Transportation zone to or from which the goods are delivered
     */
    public void setTransportZone( @Nullable final String transportZone )
    {
        rememberChangedField("TransportZone", this.transportZone);
        this.transportZone = transportZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @param houseNumberSupplementText
     *            House number supplement
     */
    public void setHouseNumberSupplementText( @Nullable final String houseNumberSupplementText )
    {
        rememberChangedField("HouseNumberSupplementText", this.houseNumberSupplementText);
        this.houseNumberSupplementText = houseNumberSupplementText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @param streetSuffixName
     *            Street 4
     */
    public void setStreetSuffixName( @Nullable final String streetSuffixName )
    {
        rememberChangedField("StreetSuffixName", this.streetSuffixName);
        this.streetSuffixName = streetSuffixName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurCtrAddress";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseContract", getPurchaseContract());
        result.put("AddressID", getAddressID());
        result.put("PurchaseContractItem", getPurchaseContractItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseContract", getPurchaseContract());
        values.put("AddressID", getAddressID());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("FullName", getFullName());
        values.put("ConsigneeName3", getConsigneeName3());
        values.put("ConsigneeName4", getConsigneeName4());
        values.put("CareOfName", getCareOfName());
        values.put("CityName", getCityName());
        values.put("District", getDistrict());
        values.put("CityCode", getCityCode());
        values.put("PostalCode", getPostalCode());
        values.put("POBoxPostalCode", getPOBoxPostalCode());
        values.put("CompanyPostalCode", getCompanyPostalCode());
        values.put("POBox", getPOBox());
        values.put("POBoxDeviatingCityName", getPOBoxDeviatingCityName());
        values.put("StreetName", getStreetName());
        values.put("HouseNumber", getHouseNumber());
        values.put("StreetPrefixName", getStreetPrefixName());
        values.put("AdditionalStreetPrefixName", getAdditionalStreetPrefixName());
        values.put("AdditionalStreetSuffixName", getAdditionalStreetSuffixName());
        values.put("Building", getBuilding());
        values.put("Floor", getFloor());
        values.put("RoomNumber", getRoomNumber());
        values.put("Country", getCountry());
        values.put("CorrespondenceLanguage", getCorrespondenceLanguage());
        values.put("Region", getRegion());
        values.put("AddressTimeZone", getAddressTimeZone());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("PrfrdCommMediumType", getPrfrdCommMediumType());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("FaxNumber", getFaxNumber());
        values.put("TransportZone", getTransportZone());
        values.put("HouseNumberSupplementText", getHouseNumberSupplementText());
        values.put("StreetSuffixName", getStreetSuffixName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("FullName") ) {
                final Object value = values.remove("FullName");
                if( (value == null) || (!value.equals(getFullName())) ) {
                    setFullName(((String) value));
                }
            }
            if( values.containsKey("ConsigneeName3") ) {
                final Object value = values.remove("ConsigneeName3");
                if( (value == null) || (!value.equals(getConsigneeName3())) ) {
                    setConsigneeName3(((String) value));
                }
            }
            if( values.containsKey("ConsigneeName4") ) {
                final Object value = values.remove("ConsigneeName4");
                if( (value == null) || (!value.equals(getConsigneeName4())) ) {
                    setConsigneeName4(((String) value));
                }
            }
            if( values.containsKey("CareOfName") ) {
                final Object value = values.remove("CareOfName");
                if( (value == null) || (!value.equals(getCareOfName())) ) {
                    setCareOfName(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("District") ) {
                final Object value = values.remove("District");
                if( (value == null) || (!value.equals(getDistrict())) ) {
                    setDistrict(((String) value));
                }
            }
            if( values.containsKey("CityCode") ) {
                final Object value = values.remove("CityCode");
                if( (value == null) || (!value.equals(getCityCode())) ) {
                    setCityCode(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("POBoxPostalCode") ) {
                final Object value = values.remove("POBoxPostalCode");
                if( (value == null) || (!value.equals(getPOBoxPostalCode())) ) {
                    setPOBoxPostalCode(((String) value));
                }
            }
            if( values.containsKey("CompanyPostalCode") ) {
                final Object value = values.remove("CompanyPostalCode");
                if( (value == null) || (!value.equals(getCompanyPostalCode())) ) {
                    setCompanyPostalCode(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingCityName") ) {
                final Object value = values.remove("POBoxDeviatingCityName");
                if( (value == null) || (!value.equals(getPOBoxDeviatingCityName())) ) {
                    setPOBoxDeviatingCityName(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("StreetPrefixName") ) {
                final Object value = values.remove("StreetPrefixName");
                if( (value == null) || (!value.equals(getStreetPrefixName())) ) {
                    setStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetPrefixName") ) {
                final Object value = values.remove("AdditionalStreetPrefixName");
                if( (value == null) || (!value.equals(getAdditionalStreetPrefixName())) ) {
                    setAdditionalStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetSuffixName") ) {
                final Object value = values.remove("AdditionalStreetSuffixName");
                if( (value == null) || (!value.equals(getAdditionalStreetSuffixName())) ) {
                    setAdditionalStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("Building") ) {
                final Object value = values.remove("Building");
                if( (value == null) || (!value.equals(getBuilding())) ) {
                    setBuilding(((String) value));
                }
            }
            if( values.containsKey("Floor") ) {
                final Object value = values.remove("Floor");
                if( (value == null) || (!value.equals(getFloor())) ) {
                    setFloor(((String) value));
                }
            }
            if( values.containsKey("RoomNumber") ) {
                final Object value = values.remove("RoomNumber");
                if( (value == null) || (!value.equals(getRoomNumber())) ) {
                    setRoomNumber(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("CorrespondenceLanguage") ) {
                final Object value = values.remove("CorrespondenceLanguage");
                if( (value == null) || (!value.equals(getCorrespondenceLanguage())) ) {
                    setCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("AddressTimeZone") ) {
                final Object value = values.remove("AddressTimeZone");
                if( (value == null) || (!value.equals(getAddressTimeZone())) ) {
                    setAddressTimeZone(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("PrfrdCommMediumType") ) {
                final Object value = values.remove("PrfrdCommMediumType");
                if( (value == null) || (!value.equals(getPrfrdCommMediumType())) ) {
                    setPrfrdCommMediumType(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("TransportZone") ) {
                final Object value = values.remove("TransportZone");
                if( (value == null) || (!value.equals(getTransportZone())) ) {
                    setTransportZone(((String) value));
                }
            }
            if( values.containsKey("HouseNumberSupplementText") ) {
                final Object value = values.remove("HouseNumberSupplementText");
                if( (value == null) || (!value.equals(getHouseNumberSupplementText())) ) {
                    setHouseNumberSupplementText(((String) value));
                }
            }
            if( values.containsKey("StreetSuffixName") ) {
                final Object value = values.remove("StreetSuffixName");
                if( (value == null) || (!value.equals(getStreetSuffixName())) ) {
                    setStreetSuffixName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PurCtrAddressField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurCtrAddressField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurCtrAddressField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurCtrAddressField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service.DEFAULT_SERVICE_PATH);
    }

}
