/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurchaseContractItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurchaseContractItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurchaseContractItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurchaseContractItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchase Contract Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseContractItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseContractItem extends VdmEntity<PurchaseContractItem>
{

    /**
     * Selector for all available fields of PurchaseContractItem.
     *
     */
    public final static PurchaseContractItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Purchasing Contract Header
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASE_CONTRACT =
        new PurchaseContractItemField<String>("PurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Contract
     */
    @Key
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASE_CONTRACT_ITEM =
        new PurchaseContractItemField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingContractDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingContractDeletionCode" )
    @JsonProperty( "PurchasingContractDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingContractDeletionCode" )
    private String purchasingContractDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingContractDeletionCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASING_CONTRACT_DELETION_CODE =
        new PurchaseContractItemField<String>("PurchasingContractDeletionCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "PurchaseContractItemText" )
    @JsonProperty( "PurchaseContractItemText" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItemText" )
    private String purchaseContractItemText;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItemText</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASE_CONTRACT_ITEM_TEXT =
        new PurchaseContractItemField<String>("PurchaseContractItemText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> COMPANY_CODE =
        new PurchaseContractItemField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PLANT = new PurchaseContractItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> STORAGE_LOCATION =
        new PurchaseContractItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @return Requirement Tracking Number
     */
    @SerializedName( "RequirementTracking" )
    @JsonProperty( "RequirementTracking" )
    @Nullable
    @ODataField( odataName = "RequirementTracking" )
    private String requirementTracking;
    /**
     * Use with available fluent helpers to apply the <b>RequirementTracking</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> REQUIREMENT_TRACKING =
        new PurchaseContractItemField<String>("RequirementTracking");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> MATERIAL_GROUP =
        new PurchaseContractItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> SUPPLIER_MATERIAL_NUMBER =
        new PurchaseContractItemField<String>("SupplierMaterialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> ORDER_QUANTITY_UNIT =
        new PurchaseContractItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "OrderQuantityUnitISOCode" )
    @JsonProperty( "OrderQuantityUnitISOCode" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnitISOCode" )
    private String orderQuantityUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnitISOCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> ORDER_QUANTITY_UNIT_ISO_CODE =
        new PurchaseContractItemField<String>("OrderQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @return Target Quantity
     */
    @SerializedName( "TargetQuantity" )
    @JsonProperty( "TargetQuantity" )
    @Nullable
    @ODataField( odataName = "TargetQuantity" )
    private BigDecimal targetQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantity</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> TARGET_QUANTITY =
        new PurchaseContractItemField<BigDecimal>("TargetQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocReleaseOrderQuantity</b>
     * </p>
     *
     * @return Standard release order quantity
     */
    @SerializedName( "PurgDocReleaseOrderQuantity" )
    @JsonProperty( "PurgDocReleaseOrderQuantity" )
    @Nullable
    @ODataField( odataName = "PurgDocReleaseOrderQuantity" )
    private BigDecimal purgDocReleaseOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocReleaseOrderQuantity</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> PURG_DOC_RELEASE_ORDER_QUANTITY =
        new PurchaseContractItemField<BigDecimal>("PurgDocReleaseOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "OrderPriceUnit" )
    @JsonProperty( "OrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnit" )
    private String orderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnit</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> ORDER_PRICE_UNIT =
        new PurchaseContractItemField<String>("OrderPriceUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "OrderPriceUnitISOCode" )
    @JsonProperty( "OrderPriceUnitISOCode" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnitISOCode" )
    private String orderPriceUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnitISOCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> ORDER_PRICE_UNIT_ISO_CODE =
        new PurchaseContractItemField<String>("OrderPriceUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Price Unit into Order Unit
     */
    @SerializedName( "OrderPriceUnitToOrderUnitNmrtr" )
    @JsonProperty( "OrderPriceUnitToOrderUnitNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnitToOrderUnitNmrtr" )
    private BigDecimal orderPriceUnitToOrderUnitNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnitToOrderUnitNmrtr</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR =
        new PurchaseContractItemField<BigDecimal>("OrderPriceUnitToOrderUnitNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @return Denominator for Conv. of Order Price Unit into Order Unit
     */
    @SerializedName( "OrdPriceUnitToOrderUnitDnmntr" )
    @JsonProperty( "OrdPriceUnitToOrderUnitDnmntr" )
    @Nullable
    @ODataField( odataName = "OrdPriceUnitToOrderUnitDnmntr" )
    private BigDecimal ordPriceUnitToOrderUnitDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrdPriceUnitToOrderUnitDnmntr</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR =
        new PurchaseContractItemField<BigDecimal>("OrdPriceUnitToOrderUnitDnmntr");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContractNetPriceAmount</b>
     * </p>
     *
     * @return Net Price in Purchasing Document (in Document Currency)
     */
    @SerializedName( "ContractNetPriceAmount" )
    @JsonProperty( "ContractNetPriceAmount" )
    @Nullable
    @ODataField( odataName = "ContractNetPriceAmount" )
    private BigDecimal contractNetPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>ContractNetPriceAmount</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> CONTRACT_NET_PRICE_AMOUNT =
        new PurchaseContractItemField<BigDecimal>("ContractNetPriceAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> DOCUMENT_CURRENCY =
        new PurchaseContractItemField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @return Price Unit
     */
    @SerializedName( "NetPriceQuantity" )
    @JsonProperty( "NetPriceQuantity" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantity" )
    private BigDecimal netPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantity</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> NET_PRICE_QUANTITY =
        new PurchaseContractItemField<BigDecimal>("NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> TAX_CODE = new PurchaseContractItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> TAX_COUNTRY =
        new PurchaseContractItemField<String>("TaxCountry");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determining Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<LocalDateTime> TAX_DETERMINATION_DATE =
        new PurchaseContractItemField<LocalDateTime>("TaxDeterminationDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> STOCK_TYPE =
        new PurchaseContractItemField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordUpdateCode</b>
     * </p>
     *
     * @return Indicator: Update Info Record
     */
    @SerializedName( "PurchasingInfoRecordUpdateCode" )
    @JsonProperty( "PurchasingInfoRecordUpdateCode" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordUpdateCode" )
    private String purchasingInfoRecordUpdateCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordUpdateCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASING_INFO_RECORD_UPDATE_CODE =
        new PurchaseContractItemField<String>("PurchasingInfoRecordUpdateCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @return Price Printout
     */
    @SerializedName( "PriceIsToBePrinted" )
    @JsonProperty( "PriceIsToBePrinted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PriceIsToBePrinted" )
    private Boolean priceIsToBePrinted;
    /**
     * Use with available fluent helpers to apply the <b>PriceIsToBePrinted</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> PRICE_IS_TO_BE_PRINTED =
        new PurchaseContractItemField<Boolean>("PriceIsToBePrinted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingPriceIsEstimated</b>
     * </p>
     *
     * @return Indicator: Estimated Price
     */
    @SerializedName( "PurchasingPriceIsEstimated" )
    @JsonProperty( "PurchasingPriceIsEstimated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurchasingPriceIsEstimated" )
    private Boolean purchasingPriceIsEstimated;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingPriceIsEstimated</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> PURCHASING_PRICE_IS_ESTIMATED =
        new PurchaseContractItemField<Boolean>("PurchasingPriceIsEstimated");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @return Number of Days for First Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder1" )
    @JsonProperty( "NoDaysReminder1" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder1" )
    private BigDecimal noDaysReminder1;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder1</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> NO_DAYS_REMINDER1 =
        new PurchaseContractItemField<BigDecimal>("NoDaysReminder1");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @return Number of Days for Second Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder2" )
    @JsonProperty( "NoDaysReminder2" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder2" )
    private BigDecimal noDaysReminder2;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder2</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> NO_DAYS_REMINDER2 =
        new PurchaseContractItemField<BigDecimal>("NoDaysReminder2");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @return Number of Days for Third Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder3" )
    @JsonProperty( "NoDaysReminder3" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder3" )
    private BigDecimal noDaysReminder3;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder3</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> NO_DAYS_REMINDER3 =
        new PurchaseContractItemField<BigDecimal>("NoDaysReminder3");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "PlannedDeliveryDurationInDays" )
    @JsonProperty( "PlannedDeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "PlannedDeliveryDurationInDays" )
    private BigDecimal plannedDeliveryDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryDurationInDays</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> PLANNED_DELIVERY_DURATION_IN_DAYS =
        new PurchaseContractItemField<BigDecimal>("PlannedDeliveryDurationInDays");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdelivery Tolerance
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new PurchaseContractItemField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new PurchaseContractItemField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdelivery Tolerance
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new PurchaseContractItemField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchasingDocumentItemCategory" )
    @JsonProperty( "PurchasingDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemCategory" )
    private String purchasingDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemCategory</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASING_DOCUMENT_ITEM_CATEGORY =
        new PurchaseContractItemField<String>("PurchasingDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new PurchaseContractItemField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @return Distribution Indicator for Multiple Account Assignment
     */
    @SerializedName( "MultipleAcctAssgmtDistribution" )
    @JsonProperty( "MultipleAcctAssgmtDistribution" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistribution" )
    private String multipleAcctAssgmtDistribution;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistribution</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> MULTIPLE_ACCT_ASSGMT_DISTRIBUTION =
        new PurchaseContractItemField<String>("MultipleAcctAssgmtDistribution");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @return Goods Receipt Indicator
     */
    @SerializedName( "GoodsReceiptIsExpected" )
    @JsonProperty( "GoodsReceiptIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsExpected" )
    private Boolean goodsReceiptIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsExpected</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> GOODS_RECEIPT_IS_EXPECTED =
        new PurchaseContractItemField<Boolean>("GoodsReceiptIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @return Goods Receipt, Non-Valuated
     */
    @SerializedName( "GoodsReceiptIsNonValuated" )
    @JsonProperty( "GoodsReceiptIsNonValuated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsNonValuated" )
    private Boolean goodsReceiptIsNonValuated;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsNonValuated</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> GOODS_RECEIPT_IS_NON_VALUATED =
        new PurchaseContractItemField<Boolean>("GoodsReceiptIsNonValuated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @return Invoice Receipt Indicator
     */
    @SerializedName( "InvoiceIsExpected" )
    @JsonProperty( "InvoiceIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsExpected" )
    private Boolean invoiceIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsExpected</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> INVOICE_IS_EXPECTED =
        new PurchaseContractItemField<Boolean>("InvoiceIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @return Indicator: GR-Based Invoice Verification
     */
    @SerializedName( "InvoiceIsGoodsReceiptBased" )
    @JsonProperty( "InvoiceIsGoodsReceiptBased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsGoodsReceiptBased" )
    private Boolean invoiceIsGoodsReceiptBased;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsGoodsReceiptBased</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> INVOICE_IS_GOODS_RECEIPT_BASED =
        new PurchaseContractItemField<Boolean>("InvoiceIsGoodsReceiptBased");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @return Order Acknowledgment Requirement
     */
    @SerializedName( "IsOrderAcknRqd" )
    @JsonProperty( "IsOrderAcknRqd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsOrderAcknRqd" )
    private Boolean isOrderAcknRqd;
    /**
     * Use with available fluent helpers to apply the <b>IsOrderAcknRqd</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> IS_ORDER_ACKN_RQD =
        new PurchaseContractItemField<Boolean>("IsOrderAcknRqd");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderAcknNumber</b>
     * </p>
     *
     * @return Order Acknowledgment Number
     */
    @SerializedName( "PurgDocOrderAcknNumber" )
    @JsonProperty( "PurgDocOrderAcknNumber" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderAcknNumber" )
    private String purgDocOrderAcknNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderAcknNumber</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURG_DOC_ORDER_ACKN_NUMBER =
        new PurchaseContractItemField<String>("PurgDocOrderAcknNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @return Shipping Instructions
     */
    @SerializedName( "ShippingInstruction" )
    @JsonProperty( "ShippingInstruction" )
    @Nullable
    @ODataField( odataName = "ShippingInstruction" )
    private String shippingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>ShippingInstruction</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> SHIPPING_INSTRUCTION =
        new PurchaseContractItemField<String>("ShippingInstruction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "ManualDeliveryAddressID" )
    @JsonProperty( "ManualDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ManualDeliveryAddressID" )
    private String manualDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ManualDeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> MANUAL_DELIVERY_ADDRESS_ID =
        new PurchaseContractItemField<String>("ManualDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> VOLUME_UNIT =
        new PurchaseContractItemField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> INCOTERMS_CLASSIFICATION =
        new PurchaseContractItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Subcontractor</b>
     * </p>
     *
     * @return Supplier to be Supplied/Who is to Receive Delivery
     */
    @SerializedName( "Subcontractor" )
    @JsonProperty( "Subcontractor" )
    @Nullable
    @ODataField( odataName = "Subcontractor" )
    private String subcontractor;
    /**
     * Use with available fluent helpers to apply the <b>Subcontractor</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> SUBCONTRACTOR =
        new PurchaseContractItemField<String>("Subcontractor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @return Evaluated Receipt Settlement (ERS)
     */
    @SerializedName( "EvaldRcptSettlmtIsAllowed" )
    @JsonProperty( "EvaldRcptSettlmtIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EvaldRcptSettlmtIsAllowed" )
    private Boolean evaldRcptSettlmtIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>EvaldRcptSettlmtIsAllowed</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<Boolean> EVALD_RCPT_SETTLMT_IS_ALLOWED =
        new PurchaseContractItemField<Boolean>("EvaldRcptSettlmtIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> INCOTERMS_LOCATION1 =
        new PurchaseContractItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> INCOTERMS_LOCATION2 =
        new PurchaseContractItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1Identifier</b>
     * </p>
     *
     * @return Identifier for Incoterm Location 1
     */
    @SerializedName( "IncotermsLocation1Identifier" )
    @JsonProperty( "IncotermsLocation1Identifier" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1Identifier" )
    private String incotermsLocation1Identifier;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1Identifier</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> INCOTERMS_LOCATION1_IDENTIFIER =
        new PurchaseContractItemField<String>("IncotermsLocation1Identifier");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2Identifier</b>
     * </p>
     *
     * @return Identifier for Incoterm Location 2
     */
    @SerializedName( "IncotermsLocation2Identifier" )
    @JsonProperty( "IncotermsLocation2Identifier" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2Identifier" )
    private String incotermsLocation2Identifier;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2Identifier</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> INCOTERMS_LOCATION2_IDENTIFIER =
        new PurchaseContractItemField<String>("IncotermsLocation2Identifier");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> MATERIAL = new PurchaseContractItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Service Performer
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> SERVICE_PERFORMER =
        new PurchaseContractItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeCode</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductTypeCode" )
    @JsonProperty( "ProductTypeCode" )
    @Nullable
    @ODataField( odataName = "ProductTypeCode" )
    private String productTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>ProductTypeCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PRODUCT_TYPE_CODE =
        new PurchaseContractItemField<String>("ProductTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @return Material Type
     */
    @SerializedName( "MaterialType" )
    @JsonProperty( "MaterialType" )
    @Nullable
    @ODataField( odataName = "MaterialType" )
    private String materialType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialType</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> MATERIAL_TYPE =
        new PurchaseContractItemField<String>("MaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurContractItmReplnmtElmntType</b>
     * </p>
     *
     * @return Kanban Indicator
     */
    @SerializedName( "PurContractItmReplnmtElmntType" )
    @JsonProperty( "PurContractItmReplnmtElmntType" )
    @Nullable
    @ODataField( odataName = "PurContractItmReplnmtElmntType" )
    private String purContractItmReplnmtElmntType;
    /**
     * Use with available fluent helpers to apply the <b>PurContractItmReplnmtElmntType</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PUR_CONTRACT_ITM_REPLNMT_ELMNT_TYPE =
        new PurchaseContractItemField<String>("PurContractItmReplnmtElmntType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurContrAcceptedAtOriginCode</b>
     * </p>
     *
     * @return The purContrAcceptedAtOriginCode contained in this entity.
     */
    @SerializedName( "PurContrAcceptedAtOriginCode" )
    @JsonProperty( "PurContrAcceptedAtOriginCode" )
    @Nullable
    @ODataField( odataName = "PurContrAcceptedAtOriginCode" )
    private String purContrAcceptedAtOriginCode;
    /**
     * Use with available fluent helpers to apply the <b>PurContrAcceptedAtOriginCode</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PUR_CONTR_ACCEPTED_AT_ORIGIN_CODE =
        new PurchaseContractItemField<String>("PurContrAcceptedAtOriginCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncSupplierStatus</b>
     * </p>
     *
     * @return Product Compliance Supplier Check Status (Item)
     */
    @SerializedName( "PurgProdCmplncSupplierStatus" )
    @JsonProperty( "PurgProdCmplncSupplierStatus" )
    @Nullable
    @ODataField( odataName = "PurgProdCmplncSupplierStatus" )
    private String purgProdCmplncSupplierStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgProdCmplncSupplierStatus</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURG_PROD_CMPLNC_SUPPLIER_STATUS =
        new PurchaseContractItemField<String>("PurgProdCmplncSupplierStatus");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItemFormatted</b>
     * </p>
     *
     * @return Char 15
     */
    @SerializedName( "PurchaseContractItemFormatted" )
    @JsonProperty( "PurchaseContractItemFormatted" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItemFormatted" )
    private String purchaseContractItemFormatted;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItemFormatted</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASE_CONTRACT_ITEM_FORMATTED =
        new PurchaseContractItemField<String>("PurchaseContractItemFormatted");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentItem</b>
     * </p>
     *
     * @return Higher-Level Item in Purchasing Documents
     */
    @SerializedName( "PurchasingParentItem" )
    @JsonProperty( "PurchasingParentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingParentItem" )
    private String purchasingParentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingParentItem</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURCHASING_PARENT_ITEM =
        new PurchaseContractItemField<String>("PurchasingParentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemCatalogRelevance</b>
     * </p>
     *
     * @return The purgDocItemCatalogRelevance contained in this entity.
     */
    @SerializedName( "PurgDocItemCatalogRelevance" )
    @JsonProperty( "PurgDocItemCatalogRelevance" )
    @Nullable
    @ODataField( odataName = "PurgDocItemCatalogRelevance" )
    private String purgDocItemCatalogRelevance;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocItemCatalogRelevance</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<String> PURG_DOC_ITEM_CATALOG_RELEVANCE =
        new PurchaseContractItemField<String>("PurgDocItemCatalogRelevance");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContractConsumptionInPct</b>
     * </p>
     *
     * @return The contractConsumptionInPct contained in this entity.
     */
    @SerializedName( "ContractConsumptionInPct" )
    @JsonProperty( "ContractConsumptionInPct" )
    @Nullable
    @ODataField( odataName = "ContractConsumptionInPct" )
    private BigDecimal contractConsumptionInPct;
    /**
     * Use with available fluent helpers to apply the <b>ContractConsumptionInPct</b> field to query operations.
     *
     */
    public final static PurchaseContractItemField<BigDecimal> CONTRACT_CONSUMPTION_IN_PCT =
        new PurchaseContractItemField<BigDecimal>("ContractConsumptionInPct");
    /**
     * Navigation property <b>to_PurContrItemCndnValdty</b> for <b>PurchaseContractItem</b> to multiple
     * <b>PurContrItmCndnValdty</b>.
     *
     */
    @SerializedName( "to_PurContrItemCndnValdty" )
    @JsonProperty( "to_PurContrItemCndnValdty" )
    @ODataField( odataName = "to_PurContrItemCndnValdty" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurContrItmCndnValdty> toPurContrItemCndnValdty;
    /**
     * Navigation property <b>to_PurCtrAccount</b> for <b>PurchaseContractItem</b> to multiple <b>PurCtrAccount</b>.
     *
     */
    @SerializedName( "to_PurCtrAccount" )
    @JsonProperty( "to_PurCtrAccount" )
    @ODataField( odataName = "to_PurCtrAccount" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurCtrAccount> toPurCtrAccount;
    /**
     * Navigation property <b>to_PurCtrAddress</b> for <b>PurchaseContractItem</b> to multiple <b>PurCtrAddress</b>.
     *
     */
    @SerializedName( "to_PurCtrAddress" )
    @JsonProperty( "to_PurCtrAddress" )
    @ODataField( odataName = "to_PurCtrAddress" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurCtrAddress> toPurCtrAddress;
    /**
     * Navigation property <b>to_PurCtrItemNotes</b> for <b>PurchaseContractItem</b> to multiple
     * <b>PurchaseContractItemNotes</b>.
     *
     */
    @SerializedName( "to_PurCtrItemNotes" )
    @JsonProperty( "to_PurCtrItemNotes" )
    @ODataField( odataName = "to_PurCtrItemNotes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseContractItemNotes> toPurCtrItemNotes;
    /**
     * Navigation property <b>to_PurchaseContract</b> for <b>PurchaseContractItem</b> to single <b>PurchaseContract</b>.
     *
     */
    @SerializedName( "to_PurchaseContract" )
    @JsonProperty( "to_PurchaseContract" )
    @ODataField( odataName = "to_PurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchaseContract toPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>to_PurContrItemCndnValdty</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseContractItemLink<PurContrItmCndnValdty> TO_PUR_CONTR_ITEM_CNDN_VALDTY =
        new PurchaseContractItemLink<PurContrItmCndnValdty>("to_PurContrItemCndnValdty");
    /**
     * Use with available fluent helpers to apply the <b>to_PurCtrAccount</b> navigation property to query operations.
     *
     */
    public final static PurchaseContractItemLink<PurCtrAccount> TO_PUR_CTR_ACCOUNT =
        new PurchaseContractItemLink<PurCtrAccount>("to_PurCtrAccount");
    /**
     * Use with available fluent helpers to apply the <b>to_PurCtrAddress</b> navigation property to query operations.
     *
     */
    public final static PurchaseContractItemLink<PurCtrAddress> TO_PUR_CTR_ADDRESS =
        new PurchaseContractItemLink<PurCtrAddress>("to_PurCtrAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_PurCtrItemNotes</b> navigation property to query operations.
     *
     */
    public final static PurchaseContractItemLink<PurchaseContractItemNotes> TO_PUR_CTR_ITEM_NOTES =
        new PurchaseContractItemLink<PurchaseContractItemNotes>("to_PurCtrItemNotes");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseContractItemOneToOneLink<PurchaseContract> TO_PURCHASE_CONTRACT =
        new PurchaseContractItemOneToOneLink<PurchaseContract>("to_PurchaseContract");

    @Nonnull
    @Override
    public Class<PurchaseContractItem> getType()
    {
        return PurchaseContractItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Purchasing Contract Header
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Contract
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingContractDeletionCode</b>
     * </p>
     *
     * @param purchasingContractDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingContractDeletionCode( @Nullable final String purchasingContractDeletionCode )
    {
        rememberChangedField("PurchasingContractDeletionCode", this.purchasingContractDeletionCode);
        this.purchasingContractDeletionCode = purchasingContractDeletionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItemText</b>
     * </p>
     *
     * @param purchaseContractItemText
     *            Short Text
     */
    public void setPurchaseContractItemText( @Nullable final String purchaseContractItemText )
    {
        rememberChangedField("PurchaseContractItemText", this.purchaseContractItemText);
        this.purchaseContractItemText = purchaseContractItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @param requirementTracking
     *            Requirement Tracking Number
     */
    public void setRequirementTracking( @Nullable final String requirementTracking )
    {
        rememberChangedField("RequirementTracking", this.requirementTracking);
        this.requirementTracking = requirementTracking;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnitISOCode</b>
     * </p>
     *
     * @param orderQuantityUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setOrderQuantityUnitISOCode( @Nullable final String orderQuantityUnitISOCode )
    {
        rememberChangedField("OrderQuantityUnitISOCode", this.orderQuantityUnitISOCode);
        this.orderQuantityUnitISOCode = orderQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantity</b>
     * </p>
     *
     * @param targetQuantity
     *            Target Quantity
     */
    public void setTargetQuantity( @Nullable final BigDecimal targetQuantity )
    {
        rememberChangedField("TargetQuantity", this.targetQuantity);
        this.targetQuantity = targetQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocReleaseOrderQuantity</b>
     * </p>
     *
     * @param purgDocReleaseOrderQuantity
     *            Standard release order quantity
     */
    public void setPurgDocReleaseOrderQuantity( @Nullable final BigDecimal purgDocReleaseOrderQuantity )
    {
        rememberChangedField("PurgDocReleaseOrderQuantity", this.purgDocReleaseOrderQuantity);
        this.purgDocReleaseOrderQuantity = purgDocReleaseOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @param orderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setOrderPriceUnit( @Nullable final String orderPriceUnit )
    {
        rememberChangedField("OrderPriceUnit", this.orderPriceUnit);
        this.orderPriceUnit = orderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitISOCode</b>
     * </p>
     *
     * @param orderPriceUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setOrderPriceUnitISOCode( @Nullable final String orderPriceUnitISOCode )
    {
        rememberChangedField("OrderPriceUnitISOCode", this.orderPriceUnitISOCode);
        this.orderPriceUnitISOCode = orderPriceUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @param orderPriceUnitToOrderUnitNmrtr
     *            Numerator for Conversion of Order Price Unit into Order Unit
     */
    public void setOrderPriceUnitToOrderUnitNmrtr( @Nullable final BigDecimal orderPriceUnitToOrderUnitNmrtr )
    {
        rememberChangedField("OrderPriceUnitToOrderUnitNmrtr", this.orderPriceUnitToOrderUnitNmrtr);
        this.orderPriceUnitToOrderUnitNmrtr = orderPriceUnitToOrderUnitNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @param ordPriceUnitToOrderUnitDnmntr
     *            Denominator for Conv. of Order Price Unit into Order Unit
     */
    public void setOrdPriceUnitToOrderUnitDnmntr( @Nullable final BigDecimal ordPriceUnitToOrderUnitDnmntr )
    {
        rememberChangedField("OrdPriceUnitToOrderUnitDnmntr", this.ordPriceUnitToOrderUnitDnmntr);
        this.ordPriceUnitToOrderUnitDnmntr = ordPriceUnitToOrderUnitDnmntr;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContractNetPriceAmount</b>
     * </p>
     *
     * @param contractNetPriceAmount
     *            Net Price in Purchasing Document (in Document Currency)
     */
    public void setContractNetPriceAmount( @Nullable final BigDecimal contractNetPriceAmount )
    {
        rememberChangedField("ContractNetPriceAmount", this.contractNetPriceAmount);
        this.contractNetPriceAmount = contractNetPriceAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @param netPriceQuantity
     *            Price Unit
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determining Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordUpdateCode</b>
     * </p>
     *
     * @param purchasingInfoRecordUpdateCode
     *            Indicator: Update Info Record
     */
    public void setPurchasingInfoRecordUpdateCode( @Nullable final String purchasingInfoRecordUpdateCode )
    {
        rememberChangedField("PurchasingInfoRecordUpdateCode", this.purchasingInfoRecordUpdateCode);
        this.purchasingInfoRecordUpdateCode = purchasingInfoRecordUpdateCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @param priceIsToBePrinted
     *            Price Printout
     */
    public void setPriceIsToBePrinted( @Nullable final Boolean priceIsToBePrinted )
    {
        rememberChangedField("PriceIsToBePrinted", this.priceIsToBePrinted);
        this.priceIsToBePrinted = priceIsToBePrinted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingPriceIsEstimated</b>
     * </p>
     *
     * @param purchasingPriceIsEstimated
     *            Indicator: Estimated Price
     */
    public void setPurchasingPriceIsEstimated( @Nullable final Boolean purchasingPriceIsEstimated )
    {
        rememberChangedField("PurchasingPriceIsEstimated", this.purchasingPriceIsEstimated);
        this.purchasingPriceIsEstimated = purchasingPriceIsEstimated;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @param noDaysReminder1
     *            Number of Days for First Reminder/Expediter
     */
    public void setNoDaysReminder1( @Nullable final BigDecimal noDaysReminder1 )
    {
        rememberChangedField("NoDaysReminder1", this.noDaysReminder1);
        this.noDaysReminder1 = noDaysReminder1;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @param noDaysReminder2
     *            Number of Days for Second Reminder/Expediter
     */
    public void setNoDaysReminder2( @Nullable final BigDecimal noDaysReminder2 )
    {
        rememberChangedField("NoDaysReminder2", this.noDaysReminder2);
        this.noDaysReminder2 = noDaysReminder2;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @param noDaysReminder3
     *            Number of Days for Third Reminder/Expediter
     */
    public void setNoDaysReminder3( @Nullable final BigDecimal noDaysReminder3 )
    {
        rememberChangedField("NoDaysReminder3", this.noDaysReminder3);
        this.noDaysReminder3 = noDaysReminder3;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @param plannedDeliveryDurationInDays
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDurationInDays( @Nullable final BigDecimal plannedDeliveryDurationInDays )
    {
        rememberChangedField("PlannedDeliveryDurationInDays", this.plannedDeliveryDurationInDays);
        this.plannedDeliveryDurationInDays = plannedDeliveryDurationInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdelivery Tolerance
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdelivery Tolerance
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @param purchasingDocumentItemCategory
     *            Item category in purchasing document
     */
    public void setPurchasingDocumentItemCategory( @Nullable final String purchasingDocumentItemCategory )
    {
        rememberChangedField("PurchasingDocumentItemCategory", this.purchasingDocumentItemCategory);
        this.purchasingDocumentItemCategory = purchasingDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistribution
     *            Distribution Indicator for Multiple Account Assignment
     */
    public void setMultipleAcctAssgmtDistribution( @Nullable final String multipleAcctAssgmtDistribution )
    {
        rememberChangedField("MultipleAcctAssgmtDistribution", this.multipleAcctAssgmtDistribution);
        this.multipleAcctAssgmtDistribution = multipleAcctAssgmtDistribution;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @param goodsReceiptIsExpected
     *            Goods Receipt Indicator
     */
    public void setGoodsReceiptIsExpected( @Nullable final Boolean goodsReceiptIsExpected )
    {
        rememberChangedField("GoodsReceiptIsExpected", this.goodsReceiptIsExpected);
        this.goodsReceiptIsExpected = goodsReceiptIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @param goodsReceiptIsNonValuated
     *            Goods Receipt, Non-Valuated
     */
    public void setGoodsReceiptIsNonValuated( @Nullable final Boolean goodsReceiptIsNonValuated )
    {
        rememberChangedField("GoodsReceiptIsNonValuated", this.goodsReceiptIsNonValuated);
        this.goodsReceiptIsNonValuated = goodsReceiptIsNonValuated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @param invoiceIsExpected
     *            Invoice Receipt Indicator
     */
    public void setInvoiceIsExpected( @Nullable final Boolean invoiceIsExpected )
    {
        rememberChangedField("InvoiceIsExpected", this.invoiceIsExpected);
        this.invoiceIsExpected = invoiceIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @param invoiceIsGoodsReceiptBased
     *            Indicator: GR-Based Invoice Verification
     */
    public void setInvoiceIsGoodsReceiptBased( @Nullable final Boolean invoiceIsGoodsReceiptBased )
    {
        rememberChangedField("InvoiceIsGoodsReceiptBased", this.invoiceIsGoodsReceiptBased);
        this.invoiceIsGoodsReceiptBased = invoiceIsGoodsReceiptBased;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @param isOrderAcknRqd
     *            Order Acknowledgment Requirement
     */
    public void setIsOrderAcknRqd( @Nullable final Boolean isOrderAcknRqd )
    {
        rememberChangedField("IsOrderAcknRqd", this.isOrderAcknRqd);
        this.isOrderAcknRqd = isOrderAcknRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderAcknNumber</b>
     * </p>
     *
     * @param purgDocOrderAcknNumber
     *            Order Acknowledgment Number
     */
    public void setPurgDocOrderAcknNumber( @Nullable final String purgDocOrderAcknNumber )
    {
        rememberChangedField("PurgDocOrderAcknNumber", this.purgDocOrderAcknNumber);
        this.purgDocOrderAcknNumber = purgDocOrderAcknNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @param shippingInstruction
     *            Shipping Instructions
     */
    public void setShippingInstruction( @Nullable final String shippingInstruction )
    {
        rememberChangedField("ShippingInstruction", this.shippingInstruction);
        this.shippingInstruction = shippingInstruction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @param manualDeliveryAddressID
     *            Manual address number in purchasing document item
     */
    public void setManualDeliveryAddressID( @Nullable final String manualDeliveryAddressID )
    {
        rememberChangedField("ManualDeliveryAddressID", this.manualDeliveryAddressID);
        this.manualDeliveryAddressID = manualDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Subcontractor</b>
     * </p>
     *
     * @param subcontractor
     *            Supplier to be Supplied/Who is to Receive Delivery
     */
    public void setSubcontractor( @Nullable final String subcontractor )
    {
        rememberChangedField("Subcontractor", this.subcontractor);
        this.subcontractor = subcontractor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @param evaldRcptSettlmtIsAllowed
     *            Evaluated Receipt Settlement (ERS)
     */
    public void setEvaldRcptSettlmtIsAllowed( @Nullable final Boolean evaldRcptSettlmtIsAllowed )
    {
        rememberChangedField("EvaldRcptSettlmtIsAllowed", this.evaldRcptSettlmtIsAllowed);
        this.evaldRcptSettlmtIsAllowed = evaldRcptSettlmtIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1Identifier</b>
     * </p>
     *
     * @param incotermsLocation1Identifier
     *            Identifier for Incoterm Location 1
     */
    public void setIncotermsLocation1Identifier( @Nullable final String incotermsLocation1Identifier )
    {
        rememberChangedField("IncotermsLocation1Identifier", this.incotermsLocation1Identifier);
        this.incotermsLocation1Identifier = incotermsLocation1Identifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2Identifier</b>
     * </p>
     *
     * @param incotermsLocation2Identifier
     *            Identifier for Incoterm Location 2
     */
    public void setIncotermsLocation2Identifier( @Nullable final String incotermsLocation2Identifier )
    {
        rememberChangedField("IncotermsLocation2Identifier", this.incotermsLocation2Identifier);
        this.incotermsLocation2Identifier = incotermsLocation2Identifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Service Performer
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeCode</b>
     * </p>
     *
     * @param productTypeCode
     *            Product Type Group
     */
    public void setProductTypeCode( @Nullable final String productTypeCode )
    {
        rememberChangedField("ProductTypeCode", this.productTypeCode);
        this.productTypeCode = productTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @param materialType
     *            Material Type
     */
    public void setMaterialType( @Nullable final String materialType )
    {
        rememberChangedField("MaterialType", this.materialType);
        this.materialType = materialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurContractItmReplnmtElmntType</b>
     * </p>
     *
     * @param purContractItmReplnmtElmntType
     *            Kanban Indicator
     */
    public void setPurContractItmReplnmtElmntType( @Nullable final String purContractItmReplnmtElmntType )
    {
        rememberChangedField("PurContractItmReplnmtElmntType", this.purContractItmReplnmtElmntType);
        this.purContractItmReplnmtElmntType = purContractItmReplnmtElmntType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurContrAcceptedAtOriginCode</b>
     * </p>
     *
     * @param purContrAcceptedAtOriginCode
     *            The purContrAcceptedAtOriginCode to set.
     */
    public void setPurContrAcceptedAtOriginCode( @Nullable final String purContrAcceptedAtOriginCode )
    {
        rememberChangedField("PurContrAcceptedAtOriginCode", this.purContrAcceptedAtOriginCode);
        this.purContrAcceptedAtOriginCode = purContrAcceptedAtOriginCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncSupplierStatus</b>
     * </p>
     *
     * @param purgProdCmplncSupplierStatus
     *            Product Compliance Supplier Check Status (Item)
     */
    public void setPurgProdCmplncSupplierStatus( @Nullable final String purgProdCmplncSupplierStatus )
    {
        rememberChangedField("PurgProdCmplncSupplierStatus", this.purgProdCmplncSupplierStatus);
        this.purgProdCmplncSupplierStatus = purgProdCmplncSupplierStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItemFormatted</b>
     * </p>
     *
     * @param purchaseContractItemFormatted
     *            Char 15
     */
    public void setPurchaseContractItemFormatted( @Nullable final String purchaseContractItemFormatted )
    {
        rememberChangedField("PurchaseContractItemFormatted", this.purchaseContractItemFormatted);
        this.purchaseContractItemFormatted = purchaseContractItemFormatted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentItem</b>
     * </p>
     *
     * @param purchasingParentItem
     *            Higher-Level Item in Purchasing Documents
     */
    public void setPurchasingParentItem( @Nullable final String purchasingParentItem )
    {
        rememberChangedField("PurchasingParentItem", this.purchasingParentItem);
        this.purchasingParentItem = purchasingParentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemCatalogRelevance</b>
     * </p>
     *
     * @param purgDocItemCatalogRelevance
     *            The purgDocItemCatalogRelevance to set.
     */
    public void setPurgDocItemCatalogRelevance( @Nullable final String purgDocItemCatalogRelevance )
    {
        rememberChangedField("PurgDocItemCatalogRelevance", this.purgDocItemCatalogRelevance);
        this.purgDocItemCatalogRelevance = purgDocItemCatalogRelevance;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContractConsumptionInPct</b>
     * </p>
     *
     * @param contractConsumptionInPct
     *            The contractConsumptionInPct to set.
     */
    public void setContractConsumptionInPct( @Nullable final BigDecimal contractConsumptionInPct )
    {
        rememberChangedField("ContractConsumptionInPct", this.contractConsumptionInPct);
        this.contractConsumptionInPct = contractConsumptionInPct;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseContractItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseContract", getPurchaseContract());
        result.put("PurchaseContractItem", getPurchaseContractItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("PurchasingContractDeletionCode", getPurchasingContractDeletionCode());
        values.put("PurchaseContractItemText", getPurchaseContractItemText());
        values.put("CompanyCode", getCompanyCode());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("RequirementTracking", getRequirementTracking());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantityUnitISOCode", getOrderQuantityUnitISOCode());
        values.put("TargetQuantity", getTargetQuantity());
        values.put("PurgDocReleaseOrderQuantity", getPurgDocReleaseOrderQuantity());
        values.put("OrderPriceUnit", getOrderPriceUnit());
        values.put("OrderPriceUnitISOCode", getOrderPriceUnitISOCode());
        values.put("OrderPriceUnitToOrderUnitNmrtr", getOrderPriceUnitToOrderUnitNmrtr());
        values.put("OrdPriceUnitToOrderUnitDnmntr", getOrdPriceUnitToOrderUnitDnmntr());
        values.put("ContractNetPriceAmount", getContractNetPriceAmount());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("TaxCode", getTaxCode());
        values.put("TaxCountry", getTaxCountry());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        values.put("StockType", getStockType());
        values.put("PurchasingInfoRecordUpdateCode", getPurchasingInfoRecordUpdateCode());
        values.put("PriceIsToBePrinted", getPriceIsToBePrinted());
        values.put("PurchasingPriceIsEstimated", getPurchasingPriceIsEstimated());
        values.put("NoDaysReminder1", getNoDaysReminder1());
        values.put("NoDaysReminder2", getNoDaysReminder2());
        values.put("NoDaysReminder3", getNoDaysReminder3());
        values.put("PlannedDeliveryDurationInDays", getPlannedDeliveryDurationInDays());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("PurchasingDocumentItemCategory", getPurchasingDocumentItemCategory());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("MultipleAcctAssgmtDistribution", getMultipleAcctAssgmtDistribution());
        values.put("GoodsReceiptIsExpected", getGoodsReceiptIsExpected());
        values.put("GoodsReceiptIsNonValuated", getGoodsReceiptIsNonValuated());
        values.put("InvoiceIsExpected", getInvoiceIsExpected());
        values.put("InvoiceIsGoodsReceiptBased", getInvoiceIsGoodsReceiptBased());
        values.put("IsOrderAcknRqd", getIsOrderAcknRqd());
        values.put("PurgDocOrderAcknNumber", getPurgDocOrderAcknNumber());
        values.put("ShippingInstruction", getShippingInstruction());
        values.put("ManualDeliveryAddressID", getManualDeliveryAddressID());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("Subcontractor", getSubcontractor());
        values.put("EvaldRcptSettlmtIsAllowed", getEvaldRcptSettlmtIsAllowed());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsLocation1Identifier", getIncotermsLocation1Identifier());
        values.put("IncotermsLocation2Identifier", getIncotermsLocation2Identifier());
        values.put("Material", getMaterial());
        values.put("ServicePerformer", getServicePerformer());
        values.put("ProductTypeCode", getProductTypeCode());
        values.put("MaterialType", getMaterialType());
        values.put("PurContractItmReplnmtElmntType", getPurContractItmReplnmtElmntType());
        values.put("PurContrAcceptedAtOriginCode", getPurContrAcceptedAtOriginCode());
        values.put("PurgProdCmplncSupplierStatus", getPurgProdCmplncSupplierStatus());
        values.put("PurchaseContractItemFormatted", getPurchaseContractItemFormatted());
        values.put("PurchasingParentItem", getPurchasingParentItem());
        values.put("PurgDocItemCatalogRelevance", getPurgDocItemCatalogRelevance());
        values.put("ContractConsumptionInPct", getContractConsumptionInPct());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingContractDeletionCode") ) {
                final Object value = values.remove("PurchasingContractDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingContractDeletionCode())) ) {
                    setPurchasingContractDeletionCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItemText") ) {
                final Object value = values.remove("PurchaseContractItemText");
                if( (value == null) || (!value.equals(getPurchaseContractItemText())) ) {
                    setPurchaseContractItemText(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("RequirementTracking") ) {
                final Object value = values.remove("RequirementTracking");
                if( (value == null) || (!value.equals(getRequirementTracking())) ) {
                    setRequirementTracking(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnitISOCode") ) {
                final Object value = values.remove("OrderQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getOrderQuantityUnitISOCode())) ) {
                    setOrderQuantityUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("TargetQuantity") ) {
                final Object value = values.remove("TargetQuantity");
                if( (value == null) || (!value.equals(getTargetQuantity())) ) {
                    setTargetQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurgDocReleaseOrderQuantity") ) {
                final Object value = values.remove("PurgDocReleaseOrderQuantity");
                if( (value == null) || (!value.equals(getPurgDocReleaseOrderQuantity())) ) {
                    setPurgDocReleaseOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderPriceUnit") ) {
                final Object value = values.remove("OrderPriceUnit");
                if( (value == null) || (!value.equals(getOrderPriceUnit())) ) {
                    setOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("OrderPriceUnitISOCode") ) {
                final Object value = values.remove("OrderPriceUnitISOCode");
                if( (value == null) || (!value.equals(getOrderPriceUnitISOCode())) ) {
                    setOrderPriceUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("OrderPriceUnitToOrderUnitNmrtr") ) {
                final Object value = values.remove("OrderPriceUnitToOrderUnitNmrtr");
                if( (value == null) || (!value.equals(getOrderPriceUnitToOrderUnitNmrtr())) ) {
                    setOrderPriceUnitToOrderUnitNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrdPriceUnitToOrderUnitDnmntr") ) {
                final Object value = values.remove("OrdPriceUnitToOrderUnitDnmntr");
                if( (value == null) || (!value.equals(getOrdPriceUnitToOrderUnitDnmntr())) ) {
                    setOrdPriceUnitToOrderUnitDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ContractNetPriceAmount") ) {
                final Object value = values.remove("ContractNetPriceAmount");
                if( (value == null) || (!value.equals(getContractNetPriceAmount())) ) {
                    setContractNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordUpdateCode") ) {
                final Object value = values.remove("PurchasingInfoRecordUpdateCode");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordUpdateCode())) ) {
                    setPurchasingInfoRecordUpdateCode(((String) value));
                }
            }
            if( values.containsKey("PriceIsToBePrinted") ) {
                final Object value = values.remove("PriceIsToBePrinted");
                if( (value == null) || (!value.equals(getPriceIsToBePrinted())) ) {
                    setPriceIsToBePrinted(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingPriceIsEstimated") ) {
                final Object value = values.remove("PurchasingPriceIsEstimated");
                if( (value == null) || (!value.equals(getPurchasingPriceIsEstimated())) ) {
                    setPurchasingPriceIsEstimated(((Boolean) value));
                }
            }
            if( values.containsKey("NoDaysReminder1") ) {
                final Object value = values.remove("NoDaysReminder1");
                if( (value == null) || (!value.equals(getNoDaysReminder1())) ) {
                    setNoDaysReminder1(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder2") ) {
                final Object value = values.remove("NoDaysReminder2");
                if( (value == null) || (!value.equals(getNoDaysReminder2())) ) {
                    setNoDaysReminder2(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder3") ) {
                final Object value = values.remove("NoDaysReminder3");
                if( (value == null) || (!value.equals(getNoDaysReminder3())) ) {
                    setNoDaysReminder3(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDurationInDays") ) {
                final Object value = values.remove("PlannedDeliveryDurationInDays");
                if( (value == null) || (!value.equals(getPlannedDeliveryDurationInDays())) ) {
                    setPlannedDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemCategory") ) {
                final Object value = values.remove("PurchasingDocumentItemCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemCategory())) ) {
                    setPurchasingDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistribution") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistribution");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistribution())) ) {
                    setMultipleAcctAssgmtDistribution(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsExpected") ) {
                final Object value = values.remove("GoodsReceiptIsExpected");
                if( (value == null) || (!value.equals(getGoodsReceiptIsExpected())) ) {
                    setGoodsReceiptIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsNonValuated") ) {
                final Object value = values.remove("GoodsReceiptIsNonValuated");
                if( (value == null) || (!value.equals(getGoodsReceiptIsNonValuated())) ) {
                    setGoodsReceiptIsNonValuated(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsExpected") ) {
                final Object value = values.remove("InvoiceIsExpected");
                if( (value == null) || (!value.equals(getInvoiceIsExpected())) ) {
                    setInvoiceIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsGoodsReceiptBased") ) {
                final Object value = values.remove("InvoiceIsGoodsReceiptBased");
                if( (value == null) || (!value.equals(getInvoiceIsGoodsReceiptBased())) ) {
                    setInvoiceIsGoodsReceiptBased(((Boolean) value));
                }
            }
            if( values.containsKey("IsOrderAcknRqd") ) {
                final Object value = values.remove("IsOrderAcknRqd");
                if( (value == null) || (!value.equals(getIsOrderAcknRqd())) ) {
                    setIsOrderAcknRqd(((Boolean) value));
                }
            }
            if( values.containsKey("PurgDocOrderAcknNumber") ) {
                final Object value = values.remove("PurgDocOrderAcknNumber");
                if( (value == null) || (!value.equals(getPurgDocOrderAcknNumber())) ) {
                    setPurgDocOrderAcknNumber(((String) value));
                }
            }
            if( values.containsKey("ShippingInstruction") ) {
                final Object value = values.remove("ShippingInstruction");
                if( (value == null) || (!value.equals(getShippingInstruction())) ) {
                    setShippingInstruction(((String) value));
                }
            }
            if( values.containsKey("ManualDeliveryAddressID") ) {
                final Object value = values.remove("ManualDeliveryAddressID");
                if( (value == null) || (!value.equals(getManualDeliveryAddressID())) ) {
                    setManualDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("Subcontractor") ) {
                final Object value = values.remove("Subcontractor");
                if( (value == null) || (!value.equals(getSubcontractor())) ) {
                    setSubcontractor(((String) value));
                }
            }
            if( values.containsKey("EvaldRcptSettlmtIsAllowed") ) {
                final Object value = values.remove("EvaldRcptSettlmtIsAllowed");
                if( (value == null) || (!value.equals(getEvaldRcptSettlmtIsAllowed())) ) {
                    setEvaldRcptSettlmtIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1Identifier") ) {
                final Object value = values.remove("IncotermsLocation1Identifier");
                if( (value == null) || (!value.equals(getIncotermsLocation1Identifier())) ) {
                    setIncotermsLocation1Identifier(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2Identifier") ) {
                final Object value = values.remove("IncotermsLocation2Identifier");
                if( (value == null) || (!value.equals(getIncotermsLocation2Identifier())) ) {
                    setIncotermsLocation2Identifier(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("ProductTypeCode") ) {
                final Object value = values.remove("ProductTypeCode");
                if( (value == null) || (!value.equals(getProductTypeCode())) ) {
                    setProductTypeCode(((String) value));
                }
            }
            if( values.containsKey("MaterialType") ) {
                final Object value = values.remove("MaterialType");
                if( (value == null) || (!value.equals(getMaterialType())) ) {
                    setMaterialType(((String) value));
                }
            }
            if( values.containsKey("PurContractItmReplnmtElmntType") ) {
                final Object value = values.remove("PurContractItmReplnmtElmntType");
                if( (value == null) || (!value.equals(getPurContractItmReplnmtElmntType())) ) {
                    setPurContractItmReplnmtElmntType(((String) value));
                }
            }
            if( values.containsKey("PurContrAcceptedAtOriginCode") ) {
                final Object value = values.remove("PurContrAcceptedAtOriginCode");
                if( (value == null) || (!value.equals(getPurContrAcceptedAtOriginCode())) ) {
                    setPurContrAcceptedAtOriginCode(((String) value));
                }
            }
            if( values.containsKey("PurgProdCmplncSupplierStatus") ) {
                final Object value = values.remove("PurgProdCmplncSupplierStatus");
                if( (value == null) || (!value.equals(getPurgProdCmplncSupplierStatus())) ) {
                    setPurgProdCmplncSupplierStatus(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItemFormatted") ) {
                final Object value = values.remove("PurchaseContractItemFormatted");
                if( (value == null) || (!value.equals(getPurchaseContractItemFormatted())) ) {
                    setPurchaseContractItemFormatted(((String) value));
                }
            }
            if( values.containsKey("PurchasingParentItem") ) {
                final Object value = values.remove("PurchasingParentItem");
                if( (value == null) || (!value.equals(getPurchasingParentItem())) ) {
                    setPurchasingParentItem(((String) value));
                }
            }
            if( values.containsKey("PurgDocItemCatalogRelevance") ) {
                final Object value = values.remove("PurgDocItemCatalogRelevance");
                if( (value == null) || (!value.equals(getPurgDocItemCatalogRelevance())) ) {
                    setPurgDocItemCatalogRelevance(((String) value));
                }
            }
            if( values.containsKey("ContractConsumptionInPct") ) {
                final Object value = values.remove("ContractConsumptionInPct");
                if( (value == null) || (!value.equals(getContractConsumptionInPct())) ) {
                    setContractConsumptionInPct(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurContrItemCndnValdty") ) {
                final Object value = (values).remove("to_PurContrItemCndnValdty");
                if( value instanceof Iterable ) {
                    if( toPurContrItemCndnValdty == null ) {
                        toPurContrItemCndnValdty = Lists.newArrayList();
                    } else {
                        toPurContrItemCndnValdty = Lists.newArrayList(toPurContrItemCndnValdty);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurContrItmCndnValdty entity;
                        if( toPurContrItemCndnValdty.size() > i ) {
                            entity = toPurContrItemCndnValdty.get(i);
                        } else {
                            entity = new PurContrItmCndnValdty();
                            toPurContrItemCndnValdty.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurCtrAccount") ) {
                final Object value = (values).remove("to_PurCtrAccount");
                if( value instanceof Iterable ) {
                    if( toPurCtrAccount == null ) {
                        toPurCtrAccount = Lists.newArrayList();
                    } else {
                        toPurCtrAccount = Lists.newArrayList(toPurCtrAccount);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurCtrAccount entity;
                        if( toPurCtrAccount.size() > i ) {
                            entity = toPurCtrAccount.get(i);
                        } else {
                            entity = new PurCtrAccount();
                            toPurCtrAccount.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurCtrAddress") ) {
                final Object value = (values).remove("to_PurCtrAddress");
                if( value instanceof Iterable ) {
                    if( toPurCtrAddress == null ) {
                        toPurCtrAddress = Lists.newArrayList();
                    } else {
                        toPurCtrAddress = Lists.newArrayList(toPurCtrAddress);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurCtrAddress entity;
                        if( toPurCtrAddress.size() > i ) {
                            entity = toPurCtrAddress.get(i);
                        } else {
                            entity = new PurCtrAddress();
                            toPurCtrAddress.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurCtrItemNotes") ) {
                final Object value = (values).remove("to_PurCtrItemNotes");
                if( value instanceof Iterable ) {
                    if( toPurCtrItemNotes == null ) {
                        toPurCtrItemNotes = Lists.newArrayList();
                    } else {
                        toPurCtrItemNotes = Lists.newArrayList(toPurCtrItemNotes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseContractItemNotes entity;
                        if( toPurCtrItemNotes.size() > i ) {
                            entity = toPurCtrItemNotes.get(i);
                        } else {
                            entity = new PurchaseContractItemNotes();
                            toPurCtrItemNotes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurchaseContract") ) {
                final Object value = (values).remove("to_PurchaseContract");
                if( value instanceof Map ) {
                    if( toPurchaseContract == null ) {
                        toPurchaseContract = new PurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseContractItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseContractItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseContractItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseContractItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurContrItemCndnValdty != null ) {
            (values).put("to_PurContrItemCndnValdty", toPurContrItemCndnValdty);
        }
        if( toPurCtrAccount != null ) {
            (values).put("to_PurCtrAccount", toPurCtrAccount);
        }
        if( toPurCtrAddress != null ) {
            (values).put("to_PurCtrAddress", toPurCtrAddress);
        }
        if( toPurCtrItemNotes != null ) {
            (values).put("to_PurCtrItemNotes", toPurCtrItemNotes);
        }
        if( toPurchaseContract != null ) {
            (values).put("to_PurchaseContract", toPurchaseContract);
        }
        return values;
    }

    /**
     * Fetches the <b>PurContrItmCndnValdty</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurContrItemCndnValdty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurContrItmCndnValdty</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurContrItmCndnValdty> fetchPurContrItemCndnValdty()
    {
        return fetchFieldAsList("to_PurContrItemCndnValdty", PurContrItmCndnValdty.class);
    }

    /**
     * Retrieval of associated <b>PurContrItmCndnValdty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurContrItemCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_PurContrItemCndnValdty</b> of a queried <b>PurchaseContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurContrItmCndnValdty</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurContrItmCndnValdty> getPurContrItemCndnValdtyOrFetch()
    {
        if( toPurContrItemCndnValdty == null ) {
            toPurContrItemCndnValdty = fetchPurContrItemCndnValdty();
        }
        return toPurContrItemCndnValdty;
    }

    /**
     * Retrieval of associated <b>PurContrItmCndnValdty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurContrItemCndnValdty</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurContrItemCndnValdty</b> is already loaded, the result
     *         will contain the <b>PurContrItmCndnValdty</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurContrItmCndnValdty>> getPurContrItemCndnValdtyIfPresent()
    {
        return Option.of(toPurContrItemCndnValdty);
    }

    /**
     * Overwrites the list of associated <b>PurContrItmCndnValdty</b> entities for the loaded navigation property
     * <b>to_PurContrItemCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_PurContrItemCndnValdty</b> of a queried <b>PurchaseContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurContrItmCndnValdty</b> entities.
     */
    public void setPurContrItemCndnValdty( @Nonnull final List<PurContrItmCndnValdty> value )
    {
        if( toPurContrItemCndnValdty == null ) {
            toPurContrItemCndnValdty = Lists.newArrayList();
        }
        toPurContrItemCndnValdty.clear();
        toPurContrItemCndnValdty.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurContrItmCndnValdty</b> entities. This corresponds to the OData
     * navigation property <b>to_PurContrItemCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_PurContrItemCndnValdty</b> of a queried <b>PurchaseContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurContrItmCndnValdty</b> entities.
     */
    public void addPurContrItemCndnValdty( PurContrItmCndnValdty... entity )
    {
        if( toPurContrItemCndnValdty == null ) {
            toPurContrItemCndnValdty = Lists.newArrayList();
        }
        toPurContrItemCndnValdty.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurCtrAccount</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurCtrAccount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurCtrAccount</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurCtrAccount> fetchPurCtrAccount()
    {
        return fetchFieldAsList("to_PurCtrAccount", PurCtrAccount.class);
    }

    /**
     * Retrieval of associated <b>PurCtrAccount</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurCtrAccount</b>.
     * <p>
     * If the navigation property <b>to_PurCtrAccount</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurCtrAccount</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurCtrAccount> getPurCtrAccountOrFetch()
    {
        if( toPurCtrAccount == null ) {
            toPurCtrAccount = fetchPurCtrAccount();
        }
        return toPurCtrAccount;
    }

    /**
     * Retrieval of associated <b>PurCtrAccount</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurCtrAccount</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurCtrAccount</b> is already loaded, the result will
     *         contain the <b>PurCtrAccount</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurCtrAccount>> getPurCtrAccountIfPresent()
    {
        return Option.of(toPurCtrAccount);
    }

    /**
     * Overwrites the list of associated <b>PurCtrAccount</b> entities for the loaded navigation property
     * <b>to_PurCtrAccount</b>.
     * <p>
     * If the navigation property <b>to_PurCtrAccount</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurCtrAccount</b> entities.
     */
    public void setPurCtrAccount( @Nonnull final List<PurCtrAccount> value )
    {
        if( toPurCtrAccount == null ) {
            toPurCtrAccount = Lists.newArrayList();
        }
        toPurCtrAccount.clear();
        toPurCtrAccount.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurCtrAccount</b> entities. This corresponds to the OData navigation
     * property <b>to_PurCtrAccount</b>.
     * <p>
     * If the navigation property <b>to_PurCtrAccount</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurCtrAccount</b> entities.
     */
    public void addPurCtrAccount( PurCtrAccount... entity )
    {
        if( toPurCtrAccount == null ) {
            toPurCtrAccount = Lists.newArrayList();
        }
        toPurCtrAccount.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurCtrAddress</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurCtrAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurCtrAddress</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurCtrAddress> fetchPurCtrAddress()
    {
        return fetchFieldAsList("to_PurCtrAddress", PurCtrAddress.class);
    }

    /**
     * Retrieval of associated <b>PurCtrAddress</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurCtrAddress</b>.
     * <p>
     * If the navigation property <b>to_PurCtrAddress</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurCtrAddress</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurCtrAddress> getPurCtrAddressOrFetch()
    {
        if( toPurCtrAddress == null ) {
            toPurCtrAddress = fetchPurCtrAddress();
        }
        return toPurCtrAddress;
    }

    /**
     * Retrieval of associated <b>PurCtrAddress</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurCtrAddress</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurCtrAddress</b> is already loaded, the result will
     *         contain the <b>PurCtrAddress</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurCtrAddress>> getPurCtrAddressIfPresent()
    {
        return Option.of(toPurCtrAddress);
    }

    /**
     * Overwrites the list of associated <b>PurCtrAddress</b> entities for the loaded navigation property
     * <b>to_PurCtrAddress</b>.
     * <p>
     * If the navigation property <b>to_PurCtrAddress</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurCtrAddress</b> entities.
     */
    public void setPurCtrAddress( @Nonnull final List<PurCtrAddress> value )
    {
        if( toPurCtrAddress == null ) {
            toPurCtrAddress = Lists.newArrayList();
        }
        toPurCtrAddress.clear();
        toPurCtrAddress.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurCtrAddress</b> entities. This corresponds to the OData navigation
     * property <b>to_PurCtrAddress</b>.
     * <p>
     * If the navigation property <b>to_PurCtrAddress</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurCtrAddress</b> entities.
     */
    public void addPurCtrAddress( PurCtrAddress... entity )
    {
        if( toPurCtrAddress == null ) {
            toPurCtrAddress = Lists.newArrayList();
        }
        toPurCtrAddress.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurchaseContractItemNotes</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurCtrItemNotes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseContractItemNotes</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseContractItemNotes> fetchPurCtrItemNotes()
    {
        return fetchFieldAsList("to_PurCtrItemNotes", PurchaseContractItemNotes.class);
    }

    /**
     * Retrieval of associated <b>PurchaseContractItemNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurCtrItemNotes</b>.
     * <p>
     * If the navigation property <b>to_PurCtrItemNotes</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseContractItemNotes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseContractItemNotes> getPurCtrItemNotesOrFetch()
    {
        if( toPurCtrItemNotes == null ) {
            toPurCtrItemNotes = fetchPurCtrItemNotes();
        }
        return toPurCtrItemNotes;
    }

    /**
     * Retrieval of associated <b>PurchaseContractItemNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurCtrItemNotes</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurCtrItemNotes</b> is already loaded, the result will
     *         contain the <b>PurchaseContractItemNotes</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseContractItemNotes>> getPurCtrItemNotesIfPresent()
    {
        return Option.of(toPurCtrItemNotes);
    }

    /**
     * Overwrites the list of associated <b>PurchaseContractItemNotes</b> entities for the loaded navigation property
     * <b>to_PurCtrItemNotes</b>.
     * <p>
     * If the navigation property <b>to_PurCtrItemNotes</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseContractItemNotes</b> entities.
     */
    public void setPurCtrItemNotes( @Nonnull final List<PurchaseContractItemNotes> value )
    {
        if( toPurCtrItemNotes == null ) {
            toPurCtrItemNotes = Lists.newArrayList();
        }
        toPurCtrItemNotes.clear();
        toPurCtrItemNotes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseContractItemNotes</b> entities. This corresponds to the OData
     * navigation property <b>to_PurCtrItemNotes</b>.
     * <p>
     * If the navigation property <b>to_PurCtrItemNotes</b> of a queried <b>PurchaseContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseContractItemNotes</b> entities.
     */
    public void addPurCtrItemNotes( PurchaseContractItemNotes... entity )
    {
        if( toPurCtrItemNotes == null ) {
            toPurCtrItemNotes = Lists.newArrayList();
        }
        toPurCtrItemNotes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurchaseContract</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchaseContract</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContract fetchPurchaseContract()
    {
        return fetchFieldAsSingle("to_PurchaseContract", PurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>PurchaseContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_PurchaseContract</b> of a queried <b>PurchaseContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseContract getPurchaseContractOrFetch()
    {
        if( toPurchaseContract == null ) {
            toPurchaseContract = fetchPurchaseContract();
        }
        return toPurchaseContract;
    }

    /**
     * Retrieval of associated <b>PurchaseContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseContract</b> is already loaded, the result will
     *         contain the <b>PurchaseContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchaseContract> getPurchaseContractIfPresent()
    {
        return Option.of(toPurchaseContract);
    }

    /**
     * Overwrites the associated <b>PurchaseContract</b> entity for the loaded navigation property
     * <b>to_PurchaseContract</b>.
     *
     * @param value
     *            New <b>PurchaseContract</b> entity.
     */
    public void setPurchaseContract( final PurchaseContract value )
    {
        toPurchaseContract = value;
    }

    /**
     * Helper class to allow for fluent creation of PurchaseContractItem instances.
     *
     */
    public final static class PurchaseContractItemBuilder
    {

        private List<PurContrItmCndnValdty> toPurContrItemCndnValdty = Lists.newArrayList();
        private List<PurCtrAccount> toPurCtrAccount = Lists.newArrayList();
        private List<PurCtrAddress> toPurCtrAddress = Lists.newArrayList();
        private List<PurchaseContractItemNotes> toPurCtrItemNotes = Lists.newArrayList();
        private PurchaseContract toPurchaseContract;
        private String purchaseContract = null;

        private PurchaseContractItem.PurchaseContractItemBuilder toPurContrItemCndnValdty(
            final List<PurContrItmCndnValdty> value )
        {
            toPurContrItemCndnValdty.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurContrItemCndnValdty</b> for <b>PurchaseContractItem</b> to multiple
         * <b>PurContrItmCndnValdty</b>.
         *
         * @param value
         *            The PurContrItmCndnValdtys to build this PurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseContractItem.PurchaseContractItemBuilder purContrItemCndnValdty( PurContrItmCndnValdty... value )
        {
            return toPurContrItemCndnValdty(Lists.newArrayList(value));
        }

        private PurchaseContractItem.PurchaseContractItemBuilder toPurCtrAccount( final List<PurCtrAccount> value )
        {
            toPurCtrAccount.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurCtrAccount</b> for <b>PurchaseContractItem</b> to multiple <b>PurCtrAccount</b>.
         *
         * @param value
         *            The PurCtrAccounts to build this PurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseContractItem.PurchaseContractItemBuilder purCtrAccount( PurCtrAccount... value )
        {
            return toPurCtrAccount(Lists.newArrayList(value));
        }

        private PurchaseContractItem.PurchaseContractItemBuilder toPurCtrAddress( final List<PurCtrAddress> value )
        {
            toPurCtrAddress.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurCtrAddress</b> for <b>PurchaseContractItem</b> to multiple <b>PurCtrAddress</b>.
         *
         * @param value
         *            The PurCtrAddresss to build this PurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseContractItem.PurchaseContractItemBuilder purCtrAddress( PurCtrAddress... value )
        {
            return toPurCtrAddress(Lists.newArrayList(value));
        }

        private PurchaseContractItem.PurchaseContractItemBuilder toPurCtrItemNotes(
            final List<PurchaseContractItemNotes> value )
        {
            toPurCtrItemNotes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurCtrItemNotes</b> for <b>PurchaseContractItem</b> to multiple
         * <b>PurchaseContractItemNotes</b>.
         *
         * @param value
         *            The PurchaseContractItemNotess to build this PurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseContractItem.PurchaseContractItemBuilder purCtrItemNotes( PurchaseContractItemNotes... value )
        {
            return toPurCtrItemNotes(Lists.newArrayList(value));
        }

        private PurchaseContractItem.PurchaseContractItemBuilder toPurchaseContract( final PurchaseContract value )
        {
            toPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseContract</b> for <b>PurchaseContractItem</b> to single
         * <b>PurchaseContract</b>.
         *
         * @param value
         *            The PurchaseContract to build this PurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseContractItem.PurchaseContractItemBuilder purchaseContract( final PurchaseContract value )
        {
            return toPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>PurchaseContract</b>
         * </p>
         *
         * @param value
         *            The purchaseContract to build this PurchaseContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseContractItem.PurchaseContractItemBuilder purchaseContract( final String value )
        {
            purchaseContract = value;
            return this;
        }

    }

}
