/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurchaseContractItemNotesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurchaseContractItemNotesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Notes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseContractItemNotesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseContractItemNotes extends VdmEntity<PurchaseContractItemNotes>
{

    /**
     * Selector for all available fields of PurchaseContractItemNotes.
     *
     */
    public final static PurchaseContractItemNotesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> LANGUAGE =
        new PurchaseContractItemNotesField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "TextObjectType" )
    @JsonProperty( "TextObjectType" )
    @Nullable
    @ODataField( odataName = "TextObjectType" )
    private String textObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TextObjectType</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> TEXT_OBJECT_TYPE =
        new PurchaseContractItemNotesField<String>("TextObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>ArchitecturalObjectNumber</b>
     * </p>
     *
     * @return Name
     */
    @Key
    @SerializedName( "ArchitecturalObjectNumber" )
    @JsonProperty( "ArchitecturalObjectNumber" )
    @Nullable
    @ODataField( odataName = "ArchitecturalObjectNumber" )
    private String architecturalObjectNumber;
    /**
     * Use with available fluent helpers to apply the <b>ArchitecturalObjectNumber</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> ARCHITECTURAL_OBJECT_NUMBER =
        new PurchaseContractItemNotesField<String>("ArchitecturalObjectNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @return Texts: application object
     */
    @Key
    @SerializedName( "TechnicalObjectType" )
    @JsonProperty( "TechnicalObjectType" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectType" )
    private String technicalObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectType</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> TECHNICAL_OBJECT_TYPE =
        new PurchaseContractItemNotesField<String>("TechnicalObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> PURCHASE_CONTRACT_ITEM =
        new PurchaseContractItemNotesField<String>("PurchaseContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return The purchaseContract contained in this entity.
     */
    @Key
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> PURCHASE_CONTRACT =
        new PurchaseContractItemNotesField<String>("PurchaseContract");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoteDescription</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "NoteDescription" )
    @JsonProperty( "NoteDescription" )
    @Nullable
    @ODataField( odataName = "NoteDescription" )
    private String noteDescription;
    /**
     * Use with available fluent helpers to apply the <b>NoteDescription</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> NOTE_DESCRIPTION =
        new PurchaseContractItemNotesField<String>("NoteDescription");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedIndicator</b>
     * </p>
     *
     * @return "Fixed" Indicator for Texts
     */
    @SerializedName( "FixedIndicator" )
    @JsonProperty( "FixedIndicator" )
    @Nullable
    @ODataField( odataName = "FixedIndicator" )
    private String fixedIndicator;
    /**
     * Use with available fluent helpers to apply the <b>FixedIndicator</b> field to query operations.
     *
     */
    public final static PurchaseContractItemNotesField<String> FIXED_INDICATOR =
        new PurchaseContractItemNotesField<String>("FixedIndicator");

    @Nonnull
    @Override
    public Class<PurchaseContractItemNotes> getType()
    {
        return PurchaseContractItemNotes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @param textObjectType
     *            Text ID
     */
    public void setTextObjectType( @Nullable final String textObjectType )
    {
        rememberChangedField("TextObjectType", this.textObjectType);
        this.textObjectType = textObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>ArchitecturalObjectNumber</b>
     * </p>
     *
     * @param architecturalObjectNumber
     *            Name
     */
    public void setArchitecturalObjectNumber( @Nullable final String architecturalObjectNumber )
    {
        rememberChangedField("ArchitecturalObjectNumber", this.architecturalObjectNumber);
        this.architecturalObjectNumber = architecturalObjectNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @param technicalObjectType
     *            Texts: application object
     */
    public void setTechnicalObjectType( @Nullable final String technicalObjectType )
    {
        rememberChangedField("TechnicalObjectType", this.technicalObjectType);
        this.technicalObjectType = technicalObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            The purchaseContract to set.
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoteDescription</b>
     * </p>
     *
     * @param noteDescription
     *            Long Text
     */
    public void setNoteDescription( @Nullable final String noteDescription )
    {
        rememberChangedField("NoteDescription", this.noteDescription);
        this.noteDescription = noteDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedIndicator</b>
     * </p>
     *
     * @param fixedIndicator
     *            "Fixed" Indicator for Texts
     */
    public void setFixedIndicator( @Nullable final String fixedIndicator )
    {
        rememberChangedField("FixedIndicator", this.fixedIndicator);
        this.fixedIndicator = fixedIndicator;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseContractItemNotes";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("TextObjectType", getTextObjectType());
        result.put("ArchitecturalObjectNumber", getArchitecturalObjectNumber());
        result.put("TechnicalObjectType", getTechnicalObjectType());
        result.put("PurchaseContractItem", getPurchaseContractItem());
        result.put("PurchaseContract", getPurchaseContract());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("TextObjectType", getTextObjectType());
        values.put("ArchitecturalObjectNumber", getArchitecturalObjectNumber());
        values.put("TechnicalObjectType", getTechnicalObjectType());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("NoteDescription", getNoteDescription());
        values.put("FixedIndicator", getFixedIndicator());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("TextObjectType") ) {
                final Object value = values.remove("TextObjectType");
                if( (value == null) || (!value.equals(getTextObjectType())) ) {
                    setTextObjectType(((String) value));
                }
            }
            if( values.containsKey("ArchitecturalObjectNumber") ) {
                final Object value = values.remove("ArchitecturalObjectNumber");
                if( (value == null) || (!value.equals(getArchitecturalObjectNumber())) ) {
                    setArchitecturalObjectNumber(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectType") ) {
                final Object value = values.remove("TechnicalObjectType");
                if( (value == null) || (!value.equals(getTechnicalObjectType())) ) {
                    setTechnicalObjectType(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("NoteDescription") ) {
                final Object value = values.remove("NoteDescription");
                if( (value == null) || (!value.equals(getNoteDescription())) ) {
                    setNoteDescription(((String) value));
                }
            }
            if( values.containsKey("FixedIndicator") ) {
                final Object value = values.remove("FixedIndicator");
                if( (value == null) || (!value.equals(getFixedIndicator())) ) {
                    setFixedIndicator(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseContractItemNotesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseContractItemNotesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseContractItemNotesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseContractItemNotesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service.DEFAULT_SERVICE_PATH);
    }

}
