/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurchaseContractItemNotesSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes
 * PurchaseContractItemNotes} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PurchaseContractItemNotesByKeyFluentHelper
    extends
    FluentHelperByKey<PurchaseContractItemNotesByKeyFluentHelper, PurchaseContractItemNotes, PurchaseContractItemNotesSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes
     * PurchaseContractItemNotes} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurchaseContractItemNotes}
     * @param technicalObjectType
     *            Texts: application object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseContract
     *
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurchaseContractItemNotes}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param architecturalObjectNumber
     *            Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     */
    public PurchaseContractItemNotesByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String textObjectType,
        final String architecturalObjectNumber,
        final String technicalObjectType,
        final String purchaseContractItem,
        final String purchaseContract )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("TextObjectType", textObjectType);
        this.key.put("ArchitecturalObjectNumber", architecturalObjectNumber);
        this.key.put("TechnicalObjectType", technicalObjectType);
        this.key.put("PurchaseContractItem", purchaseContractItem);
        this.key.put("PurchaseContract", purchaseContract);
    }

    @Override
    @Nonnull
    protected Class<PurchaseContractItemNotes> getEntityClass()
    {
        return PurchaseContractItemNotes.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
