/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
 * PurchaseContractItem} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class PurchaseContractItemUpdateFluentHelper
    extends
    FluentHelperUpdate<PurchaseContractItemUpdateFluentHelper, PurchaseContractItem>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
     * PurchaseContractItem} entity object that will be updated in the S/4HANA system.
     *
     */
    private final PurchaseContractItem entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
     * PurchaseContractItem} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The PurchaseContractItem to take the updated values from.
     */
    public PurchaseContractItemUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final PurchaseContractItem entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected PurchaseContractItem getEntity()
    {
        return entity;
    }

}
