/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable.PurchaseContractNotesSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
 * PurchaseContractNotes} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PurchaseContractNotesByKeyFluentHelper
    extends
    FluentHelperByKey<PurchaseContractNotesByKeyFluentHelper, PurchaseContractNotes, PurchaseContractNotesSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
     * PurchaseContractNotes} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurchaseContractNotes}
     * @param technicalObjectType
     *            Texts: application object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurchaseContractNotes}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param architecturalObjectNumber
     *            Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     */
    public PurchaseContractNotesByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String textObjectType,
        final String technicalObjectType,
        final String architecturalObjectNumber,
        final String purchaseContract )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("TextObjectType", textObjectType);
        this.key.put("TechnicalObjectType", technicalObjectType);
        this.key.put("ArchitecturalObjectNumber", architecturalObjectNumber);
        this.key.put("PurchaseContract", purchaseContract);
    }

    @Override
    @Nonnull
    protected Class<PurchaseContractNotes> getEntityClass()
    {
        return PurchaseContractNotes.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
