/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchaseContractV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service PurchaseContractV2Service},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchaseContractV2ServiceBatch
    extends
    BatchFluentHelperBasic<PurchaseContractV2ServiceBatch, PurchaseContractV2ServiceBatchChangeSet>
    implements
    PurchaseContractV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchaseContractV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchaseContractV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchaseContractV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchaseContractV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseContractV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchaseContractV2ServiceBatchChangeSet(this, service);
    }

}
