/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes;

/**
 * Implementation of the {@link PurchaseContractV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service PurchaseContractV2Service}.
 *
 */
public class DefaultPurchaseContractV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchaseContractV2ServiceBatch, PurchaseContractV2ServiceBatchChangeSet>
    implements
    PurchaseContractV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchaseContractV2ServiceBatchChangeSet(
        @Nonnull final DefaultPurchaseContractV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseContractV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return addRequestCreate(service::createPurCtrAccount, purCtrAccount);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount )
    {
        return addRequestUpdate(service::updatePurCtrAccount, purCtrAccount);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return addRequestCreate(service::createPurCtrAddress, purCtrAddress);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress )
    {
        return addRequestUpdate(service::updatePurCtrAddress, purCtrAddress);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurchaseContractItemNotes(
        @Nonnull final PurchaseContractItemNotes purchaseContractItemNotes )
    {
        return addRequestCreate(service::createPurchaseContractItemNotes, purchaseContractItemNotes);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurchaseContractItemNotes(
        @Nonnull final PurchaseContractItemNotes purchaseContractItemNotes )
    {
        return addRequestUpdate(service::updatePurchaseContractItemNotes, purchaseContractItemNotes);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return addRequestCreate(service::createPurchaseContractItem, purchaseContractItem);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurchaseContractItem(
        @Nonnull final PurchaseContractItem purchaseContractItem )
    {
        return addRequestUpdate(service::updatePurchaseContractItem, purchaseContractItem);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurchaseContractNotes(
        @Nonnull final PurchaseContractNotes purchaseContractNotes )
    {
        return addRequestCreate(service::createPurchaseContractNotes, purchaseContractNotes);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurchaseContractNotes(
        @Nonnull final PurchaseContractNotes purchaseContractNotes )
    {
        return addRequestUpdate(service::updatePurchaseContractNotes, purchaseContractNotes);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return addRequestCreate(service::createPurCtrPartners, purCtrPartners);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners )
    {
        return addRequestUpdate(service::updatePurCtrPartners, purCtrPartners);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet createPurchaseContract(
        @Nonnull final PurchaseContract purchaseContract )
    {
        return addRequestCreate(service::createPurchaseContract, purchaseContract);
    }

    @Nonnull
    @Override
    public PurchaseContractV2ServiceBatchChangeSet updatePurchaseContract(
        @Nonnull final PurchaseContract purchaseContract )
    {
        return addRequestUpdate(service::updatePurchaseContract, purchaseContract);
    }

}
