/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseContractV2Service
 * PurchaseContractV2Service}.
 *
 */
public interface PurchaseContractV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchaseContractV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchaseContractV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount
     * PurCtrAccount} entity and save it to the S/4HANA system.
     *
     * @param purCtrAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount
     *            PurCtrAccount} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet createPurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount
     * PurCtrAccount} entity and save it to the S/4HANA system.
     *
     * @param purCtrAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAccount
     *            PurCtrAccount} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet updatePurCtrAccount( @Nonnull final PurCtrAccount purCtrAccount );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress
     * PurCtrAddress} entity and save it to the S/4HANA system.
     *
     * @param purCtrAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress
     *            PurCtrAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet createPurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress
     * PurCtrAddress} entity and save it to the S/4HANA system.
     *
     * @param purCtrAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrAddress
     *            PurCtrAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet updatePurCtrAddress( @Nonnull final PurCtrAddress purCtrAddress );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes
     * PurchaseContractItemNotes} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItemNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes
     *            PurchaseContractItemNotes} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet
        createPurchaseContractItemNotes( @Nonnull final PurchaseContractItemNotes purchaseContractItemNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes
     * PurchaseContractItemNotes} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItemNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItemNotes
     *            PurchaseContractItemNotes} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet
        updatePurchaseContractItemNotes( @Nonnull final PurchaseContractItemNotes purchaseContractItemNotes );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
     * PurchaseContractItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
     *            PurchaseContractItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet
        createPurchaseContractItem( @Nonnull final PurchaseContractItem purchaseContractItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
     * PurchaseContractItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
     *            PurchaseContractItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet
        updatePurchaseContractItem( @Nonnull final PurchaseContractItem purchaseContractItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
     * PurchaseContractNotes} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
     *            PurchaseContractNotes} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet
        createPurchaseContractNotes( @Nonnull final PurchaseContractNotes purchaseContractNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
     * PurchaseContractNotes} entity and save it to the S/4HANA system.
     *
     * @param purchaseContractNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
     *            PurchaseContractNotes} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet
        updatePurchaseContractNotes( @Nonnull final PurchaseContractNotes purchaseContractNotes );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners
     * PurCtrPartners} entity and save it to the S/4HANA system.
     *
     * @param purCtrPartners
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners
     *            PurCtrPartners} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet createPurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners
     * PurCtrPartners} entity and save it to the S/4HANA system.
     *
     * @param purCtrPartners
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurCtrPartners
     *            PurCtrPartners} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet updatePurCtrPartners( @Nonnull final PurCtrPartners purCtrPartners );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract
     * PurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param purchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract
     *            PurchaseContract} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet createPurchaseContract( @Nonnull final PurchaseContract purchaseContract );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract
     * PurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param purchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContract
     *            PurchaseContract} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseContractV2ServiceBatchChangeSet updatePurchaseContract( @Nonnull final PurchaseContract purchaseContract );

}
