/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount
 * PurContrItmCndnAmount}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurContrItmCndnAmountField
 * PurContrItmCndnAmountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurContrItmCndnAmountLink
 * PurContrItmCndnAmountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_VALIDITY_END_DATE
 * CONDITION_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_VALIDITY_START_DATE
 * CONDITION_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_TEXT_ID
 * CONDITION_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RATE_RATIO_UNIT
 * CONDITION_RATE_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RATE_RATIO
 * CONDITION_RATE_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RATE_AMOUNT
 * CONDITION_RATE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RATE_VALUE_UNIT
 * CONDITION_RATE_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_TO_BASE_QTY_NMRTR
 * CONDITION_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_TO_BASE_QTY_DNMNTR
 * CONDITION_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_LOWER_LIMIT_AMOUNT
 * CONDITION_LOWER_LIMIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_LOWER_LIMIT_RATIO
 * CONDITION_LOWER_LIMIT_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_UPPER_LIMIT_AMOUNT
 * CONDITION_UPPER_LIMIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_UPPER_LIMIT_RATIO
 * CONDITION_UPPER_LIMIT_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_ALTERNATIVE_CURRENCY
 * CONDITION_ALTERNATIVE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_EXCLUSION
 * CONDITION_EXCLUSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_IS_DELETED
 * CONDITION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#ADDITIONAL_VALUE_DAYS
 * ADDITIONAL_VALUE_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#FIXED_VALUE_DATE
 * FIXED_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CNDN_MAX_NUMBER_OF_SALES_ORDERS
 * CNDN_MAX_NUMBER_OF_SALES_ORDERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#MINIMUM_CONDITION_BASIS_VALUE
 * MINIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#MAXIMUM_CONDITION_BASIS_VALUE
 * MAXIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#MAXIMUM_CONDITION_AMOUNT
 * MAXIMUM_CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_RELEASE_STATUS
 * CONDITION_RELEASE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_CHANGE_REASON
 * CONDITION_CHANGE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PRICING_SCALE_LINE
 * PRICING_SCALE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#CONDITION_HAS_SCALES
 * CONDITION_HAS_SCALES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#PRICING_SCALE_CHECKING_RULE
 * PRICING_SCALE_CHECKING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#TO_PURCHASE_CONTRACT
 * TO_PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#TO_PUR_CONTR_ITM_CNDN_SCALES
 * TO_PUR_CONTR_ITM_CNDN_SCALES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurContrItmCndnAmount#TO_PUR_CONTR_ITM_CNDN_VALDTY
 * TO_PUR_CONTR_ITM_CNDN_VALDTY}</li>
 * </ul>
 *
 */
public interface PurContrItmCndnAmountSelectable extends EntitySelectable<PurContrItmCndnAmount>
{

}
