/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem
 * PurchaseContractItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurchaseContractItemField
 * PurchaseContractItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurchaseContractItemLink
 * PurchaseContractItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASE_CONTRACT_ITEM
 * PURCHASE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASING_CONTRACT_DELETION_CODE
 * PURCHASING_CONTRACT_DELETION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASE_CONTRACT_ITEM_TEXT
 * PURCHASE_CONTRACT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#REQUIREMENT_TRACKING
 * REQUIREMENT_TRACKING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#SUPPLIER_MATERIAL_NUMBER
 * SUPPLIER_MATERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ORDER_QUANTITY_UNIT_ISO_CODE
 * ORDER_QUANTITY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TARGET_QUANTITY
 * TARGET_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURG_DOC_RELEASE_ORDER_QUANTITY
 * PURG_DOC_RELEASE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ORDER_PRICE_UNIT
 * ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ORDER_PRICE_UNIT_ISO_CODE
 * ORDER_PRICE_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR
 * ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR
 * ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#CONTRACT_NET_PRICE_AMOUNT
 * CONTRACT_NET_PRICE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#NET_PRICE_QUANTITY
 * NET_PRICE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TAX_COUNTRY
 * TAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TAX_DETERMINATION_DATE
 * TAX_DETERMINATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#STOCK_TYPE
 * STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASING_INFO_RECORD_UPDATE_CODE
 * PURCHASING_INFO_RECORD_UPDATE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PRICE_IS_TO_BE_PRINTED
 * PRICE_IS_TO_BE_PRINTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASING_PRICE_IS_ESTIMATED
 * PURCHASING_PRICE_IS_ESTIMATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#NO_DAYS_REMINDER1
 * NO_DAYS_REMINDER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#NO_DAYS_REMINDER2
 * NO_DAYS_REMINDER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#NO_DAYS_REMINDER3
 * NO_DAYS_REMINDER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PLANNED_DELIVERY_DURATION_IN_DAYS
 * PLANNED_DELIVERY_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#UNLIMITED_OVERDELIVERY_IS_ALLOWED
 * UNLIMITED_OVERDELIVERY_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASING_DOCUMENT_ITEM_CATEGORY
 * PURCHASING_DOCUMENT_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#ACCOUNT_ASSIGNMENT_CATEGORY
 * ACCOUNT_ASSIGNMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#MULTIPLE_ACCT_ASSGMT_DISTRIBUTION
 * MULTIPLE_ACCT_ASSGMT_DISTRIBUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#GOODS_RECEIPT_IS_EXPECTED
 * GOODS_RECEIPT_IS_EXPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#GOODS_RECEIPT_IS_NON_VALUATED
 * GOODS_RECEIPT_IS_NON_VALUATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INVOICE_IS_EXPECTED
 * INVOICE_IS_EXPECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INVOICE_IS_GOODS_RECEIPT_BASED
 * INVOICE_IS_GOODS_RECEIPT_BASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#IS_ORDER_ACKN_RQD
 * IS_ORDER_ACKN_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURG_DOC_ORDER_ACKN_NUMBER
 * PURG_DOC_ORDER_ACKN_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#SHIPPING_INSTRUCTION
 * SHIPPING_INSTRUCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#MANUAL_DELIVERY_ADDRESS_ID
 * MANUAL_DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#SUBCONTRACTOR
 * SUBCONTRACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#EVALD_RCPT_SETTLMT_IS_ALLOWED
 * EVALD_RCPT_SETTLMT_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INCOTERMS_LOCATION1_IDENTIFIER
 * INCOTERMS_LOCATION1_IDENTIFIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#INCOTERMS_LOCATION2_IDENTIFIER
 * INCOTERMS_LOCATION2_IDENTIFIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#SERVICE_PERFORMER
 * SERVICE_PERFORMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PRODUCT_TYPE_CODE
 * PRODUCT_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#MATERIAL_TYPE
 * MATERIAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PUR_CONTRACT_ITM_REPLNMT_ELMNT_TYPE
 * PUR_CONTRACT_ITM_REPLNMT_ELMNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PUR_CONTR_ACCEPTED_AT_ORIGIN_CODE
 * PUR_CONTR_ACCEPTED_AT_ORIGIN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURG_PROD_CMPLNC_SUPPLIER_STATUS
 * PURG_PROD_CMPLNC_SUPPLIER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASE_CONTRACT_ITEM_FORMATTED
 * PURCHASE_CONTRACT_ITEM_FORMATTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURCHASING_PARENT_ITEM
 * PURCHASING_PARENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#PURG_DOC_ITEM_CATALOG_RELEVANCE
 * PURG_DOC_ITEM_CATALOG_RELEVANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#CONTRACT_CONSUMPTION_IN_PCT
 * CONTRACT_CONSUMPTION_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TO_PUR_CONTR_ITEM_CNDN_VALDTY
 * TO_PUR_CONTR_ITEM_CNDN_VALDTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TO_PUR_CTR_ACCOUNT
 * TO_PUR_CTR_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TO_PUR_CTR_ADDRESS
 * TO_PUR_CTR_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TO_PUR_CTR_ITEM_NOTES
 * TO_PUR_CTR_ITEM_NOTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractItem#TO_PURCHASE_CONTRACT
 * TO_PURCHASE_CONTRACT}</li>
 * </ul>
 *
 */
public interface PurchaseContractItemSelectable extends EntitySelectable<PurchaseContractItem>
{

}
