/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes
 * PurchaseContractNotes}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.field.PurchaseContractNotesField
 * PurchaseContractNotesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.link.PurchaseContractNotesLink
 * PurchaseContractNotesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes#TEXT_OBJECT_TYPE
 * TEXT_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes#TECHNICAL_OBJECT_TYPE
 * TECHNICAL_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes#ARCHITECTURAL_OBJECT_NUMBER
 * ARCHITECTURAL_OBJECT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes#PURCHASE_CONTRACT
 * PURCHASE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasecontractv2.PurchaseContractNotes#NOTE_DESCRIPTION
 * NOTE_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface PurchaseContractNotesSelectable extends EntitySelectable<PurchaseContractNotes>
{

}
