/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>GetPDFResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class GetPDFResult extends VdmComplex<GetPDFResult>
{

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>PurchaseOrderBinary</b>
     * </p>
     *
     * @param purchaseOrderBinary
     *
     */
    @SerializedName( "PurchaseOrderBinary" )
    @JsonProperty( "PurchaseOrderBinary" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderBinary" )
    private String purchaseOrderBinary;

    @Nonnull
    @Override
    public Class<GetPDFResult> getType()
    {
        return GetPDFResult.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseOrderBinary", getPurchaseOrderBinary());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseOrderBinary") ) {
                final Object value = values.remove("PurchaseOrderBinary");
                if( (value == null) || (!value.equals(getPurchaseOrderBinary())) ) {
                    setPurchaseOrderBinary(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>PurchaseOrderBinary</b>
     * </p>
     *
     * @param purchaseOrderBinary
     *            The purchaseOrderBinary to set.
     */
    public void setPurchaseOrderBinary( @Nullable final String purchaseOrderBinary )
    {
        rememberChangedField("PurchaseOrderBinary", this.purchaseOrderBinary);
        this.purchaseOrderBinary = purchaseOrderBinary;
    }

}
