/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.POSubcontractingComponentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.POSubcontractingComponentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Subcontracting Components
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_POSubcontractingComponentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class POSubcontractingComponent extends VdmEntity<POSubcontractingComponent>
{

    /**
     * Selector for all available fields of POSubcontractingComponent.
     *
     */
    public final static POSubcontractingComponentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> PURCHASE_ORDER =
        new POSubcontractingComponentField<String>("PurchaseOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @Key
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> PURCHASE_ORDER_ITEM =
        new POSubcontractingComponentField<String>("PurchaseOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Delivery Schedule Line Counter
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> SCHEDULE_LINE =
        new POSubcontractingComponentField<String>("ScheduleLine");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> RESERVATION_ITEM =
        new POSubcontractingComponentField<String>("ReservationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecordType</b>
     * </p>
     *
     * @return Reservation Record Type
     */
    @Key
    @SerializedName( "RecordType" )
    @JsonProperty( "RecordType" )
    @Nullable
    @ODataField( odataName = "RecordType" )
    private String recordType;
    /**
     * Use with available fluent helpers to apply the <b>RecordType</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> RECORD_TYPE =
        new POSubcontractingComponentField<String>("RecordType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> MATERIAL =
        new POSubcontractingComponentField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> BOM_ITEM_DESCRIPTION =
        new POSubcontractingComponentField<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "RequiredQuantity" )
    @JsonProperty( "RequiredQuantity" )
    @Nullable
    @ODataField( odataName = "RequiredQuantity" )
    private BigDecimal requiredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequiredQuantity</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<BigDecimal> REQUIRED_QUANTITY =
        new POSubcontractingComponentField<BigDecimal>("RequiredQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> BASE_UNIT =
        new POSubcontractingComponentField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDate</b>
     * </p>
     *
     * @return Material Component Requirement Date
     */
    @SerializedName( "RequirementDate" )
    @JsonProperty( "RequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requirementDate;
    /**
     * Use with available fluent helpers to apply the <b>RequirementDate</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<LocalDateTime> REQUIREMENT_DATE =
        new POSubcontractingComponentField<LocalDateTime>("RequirementDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @return Quantity in Unit of Entry
     */
    @SerializedName( "QuantityInEntryUnit" )
    @JsonProperty( "QuantityInEntryUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInEntryUnit" )
    private BigDecimal quantityInEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInEntryUnit</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<BigDecimal> QUANTITY_IN_ENTRY_UNIT =
        new POSubcontractingComponentField<BigDecimal>("QuantityInEntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> ENTRY_UNIT =
        new POSubcontractingComponentField<String>("EntryUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @return Withdrawn Quantity
     */
    @SerializedName( "WithdrawnQuantity" )
    @JsonProperty( "WithdrawnQuantity" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantity" )
    private BigDecimal withdrawnQuantity;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantity</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<BigDecimal> WITHDRAWN_QUANTITY =
        new POSubcontractingComponentField<BigDecimal>("WithdrawnQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> PLANT =
        new POSubcontractingComponentField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static POSubcontractingComponentField<String> BATCH =
        new POSubcontractingComponentField<String>("Batch");

    @Nonnull
    @Override
    public Class<POSubcontractingComponent> getType()
    {
        return POSubcontractingComponent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Purchasing Document Item
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecordType</b>
     * </p>
     *
     * @param recordType
     *            Reservation Record Type
     */
    public void setRecordType( @Nullable final String recordType )
    {
        rememberChangedField("RecordType", this.recordType);
        this.recordType = recordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @param requiredQuantity
     *            Requirement Quantity
     */
    public void setRequiredQuantity( @Nullable final BigDecimal requiredQuantity )
    {
        rememberChangedField("RequiredQuantity", this.requiredQuantity);
        this.requiredQuantity = requiredQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDate</b>
     * </p>
     *
     * @param requirementDate
     *            Material Component Requirement Date
     */
    public void setRequirementDate( @Nullable final LocalDateTime requirementDate )
    {
        rememberChangedField("RequirementDate", this.requirementDate);
        this.requirementDate = requirementDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *            Quantity in Unit of Entry
     */
    public void setQuantityInEntryUnit( @Nullable final BigDecimal quantityInEntryUnit )
    {
        rememberChangedField("QuantityInEntryUnit", this.quantityInEntryUnit);
        this.quantityInEntryUnit = quantityInEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @param withdrawnQuantity
     *            Withdrawn Quantity
     */
    public void setWithdrawnQuantity( @Nullable final BigDecimal withdrawnQuantity )
    {
        rememberChangedField("WithdrawnQuantity", this.withdrawnQuantity);
        this.withdrawnQuantity = withdrawnQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_POSubcontractingComponent";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseOrder", getPurchaseOrder());
        result.put("PurchaseOrderItem", getPurchaseOrderItem());
        result.put("ScheduleLine", getScheduleLine());
        result.put("ReservationItem", getReservationItem());
        result.put("RecordType", getRecordType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("ReservationItem", getReservationItem());
        values.put("RecordType", getRecordType());
        values.put("Material", getMaterial());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("RequiredQuantity", getRequiredQuantity());
        values.put("BaseUnit", getBaseUnit());
        values.put("RequirementDate", getRequirementDate());
        values.put("QuantityInEntryUnit", getQuantityInEntryUnit());
        values.put("EntryUnit", getEntryUnit());
        values.put("WithdrawnQuantity", getWithdrawnQuantity());
        values.put("Plant", getPlant());
        values.put("Batch", getBatch());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("RecordType") ) {
                final Object value = values.remove("RecordType");
                if( (value == null) || (!value.equals(getRecordType())) ) {
                    setRecordType(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("RequiredQuantity") ) {
                final Object value = values.remove("RequiredQuantity");
                if( (value == null) || (!value.equals(getRequiredQuantity())) ) {
                    setRequiredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("RequirementDate") ) {
                final Object value = values.remove("RequirementDate");
                if( (value == null) || (!value.equals(getRequirementDate())) ) {
                    setRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("QuantityInEntryUnit") ) {
                final Object value = values.remove("QuantityInEntryUnit");
                if( (value == null) || (!value.equals(getQuantityInEntryUnit())) ) {
                    setQuantityInEntryUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("WithdrawnQuantity") ) {
                final Object value = values.remove("WithdrawnQuantity");
                if( (value == null) || (!value.equals(getWithdrawnQuantity())) ) {
                    setWithdrawnQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> POSubcontractingComponentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new POSubcontractingComponentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> POSubcontractingComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new POSubcontractingComponentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

}
