/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.POSubcontractingComponentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
 * POSubcontractingComponent} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class POSubcontractingComponentByKeyFluentHelper
    extends
    FluentHelperByKey<POSubcontractingComponentByKeyFluentHelper, POSubcontractingComponent, POSubcontractingComponentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code POSubcontractingComponent}
     * @param reservationItem
     *            Reservation Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param recordType
     *            Reservation Record Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code POSubcontractingComponent}
     * @param purchaseOrder
     *            Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchaseOrderItem
     *            Purchasing Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public POSubcontractingComponentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseOrder,
        final String purchaseOrderItem,
        final String scheduleLine,
        final String reservationItem,
        final String recordType )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseOrder", purchaseOrder);
        this.key.put("PurchaseOrderItem", purchaseOrderItem);
        this.key.put("ScheduleLine", scheduleLine);
        this.key.put("ReservationItem", reservationItem);
        this.key.put("RecordType", recordType);
    }

    @Override
    @Nonnull
    protected Class<POSubcontractingComponent> getEntityClass()
    {
        return POSubcontractingComponent.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
