/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
 * PurOrdAccountAssignment} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class PurOrdAccountAssignmentCreateFluentHelper
    extends
    FluentHelperCreate<PurOrdAccountAssignmentCreateFluentHelper, PurOrdAccountAssignment>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity object that will be created in the S/4HANA system.
     *
     */
    private final PurOrdAccountAssignment entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The PurOrdAccountAssignment to create.
     */
    public PurOrdAccountAssignmentCreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final PurOrdAccountAssignment entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected PurOrdAccountAssignment getEntity()
    {
        return entity;
    }

}
