/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
 * PurOrdAccountAssignment} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class PurOrdAccountAssignmentUpdateFluentHelper
    extends
    FluentHelperUpdate<PurOrdAccountAssignmentUpdateFluentHelper, PurOrdAccountAssignment>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity object that will be updated in the S/4HANA system.
     *
     */
    private final PurOrdAccountAssignment entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The PurOrdAccountAssignment to take the updated values from.
     */
    public PurOrdAccountAssignmentUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final PurOrdAccountAssignment entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected PurOrdAccountAssignment getEntity()
    {
        return entity;
    }

}
