/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurOrdPricingElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.PurOrdPricingElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Pricing Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurOrdPricingElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurOrdPricingElement extends VdmEntity<PurOrdPricingElement>
{

    /**
     * Selector for all available fields of PurOrdPricingElement.
     *
     */
    public final static PurOrdPricingElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PURCHASE_ORDER =
        new PurOrdPricingElementField<String>("PurchaseOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PURCHASE_ORDER_ITEM =
        new PurOrdPricingElementField<String>("PurchaseOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PricingDocument</b>
     * </p>
     *
     * @return Number of the Document Condition
     */
    @Key
    @SerializedName( "PricingDocument" )
    @JsonProperty( "PricingDocument" )
    @Nullable
    @ODataField( odataName = "PricingDocument" )
    private String pricingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PricingDocument</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_DOCUMENT =
        new PurOrdPricingElementField<String>("PricingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingDocumentItem</b>
     * </p>
     *
     * @return Condition item number
     */
    @Key
    @SerializedName( "PricingDocumentItem" )
    @JsonProperty( "PricingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PricingDocumentItem" )
    private String pricingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PricingDocumentItem</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_DOCUMENT_ITEM =
        new PurOrdPricingElementField<String>("PricingDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_PROCEDURE_STEP =
        new PurOrdPricingElementField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_PROCEDURE_COUNTER =
        new PurOrdPricingElementField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_TYPE =
        new PurOrdPricingElementField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_RATE_VALUE =
        new PurOrdPricingElementField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_CURRENCY =
        new PurOrdPricingElementField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchangeRate</b>
     * </p>
     *
     * @return The priceDetnExchangeRate contained in this entity.
     */
    @SerializedName( "PriceDetnExchangeRate" )
    @JsonProperty( "PriceDetnExchangeRate" )
    @Nullable
    @ODataField( odataName = "PriceDetnExchangeRate" )
    private String priceDetnExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>PriceDetnExchangeRate</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICE_DETN_EXCHANGE_RATE =
        new PurOrdPricingElementField<String>("PriceDetnExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> TRANSACTION_CURRENCY =
        new PurOrdPricingElementField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     *
     * @return Condition Value
     */
    @SerializedName( "ConditionAmount" )
    @JsonProperty( "ConditionAmount" )
    @Nullable
    @ODataField( odataName = "ConditionAmount" )
    private BigDecimal conditionAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionAmount</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_AMOUNT =
        new PurOrdPricingElementField<BigDecimal>("ConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit in the Document
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_QUANTITY_UNIT =
        new PurOrdPricingElementField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_QUANTITY =
        new PurOrdPricingElementField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_APPLICATION =
        new PurOrdPricingElementField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateTime</b>
     * </p>
     *
     * @return Timestamp for Pricing
     */
    @SerializedName( "PricingDateTime" )
    @JsonProperty( "PricingDateTime" )
    @Nullable
    @ODataField( odataName = "PricingDateTime" )
    private String pricingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PricingDateTime</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_DATE_TIME =
        new PurOrdPricingElementField<String>("PricingDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "ConditionCalculationType" )
    @JsonProperty( "ConditionCalculationType" )
    @Nullable
    @ODataField( odataName = "ConditionCalculationType" )
    private String conditionCalculationType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCalculationType</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_CALCULATION_TYPE =
        new PurOrdPricingElementField<String>("ConditionCalculationType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseValue</b>
     * </p>
     *
     * @return Condition Basis
     */
    @SerializedName( "ConditionBaseValue" )
    @JsonProperty( "ConditionBaseValue" )
    @Nullable
    @ODataField( odataName = "ConditionBaseValue" )
    private BigDecimal conditionBaseValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionBaseValue</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_BASE_VALUE =
        new PurOrdPricingElementField<BigDecimal>("ConditionBaseValue");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Converting to Base UoM
     */
    @SerializedName( "ConditionToBaseQtyNmrtr" )
    @JsonProperty( "ConditionToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyNmrtr" )
    private BigDecimal conditionToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_TO_BASE_QTY_NMRTR =
        new PurOrdPricingElementField<BigDecimal>("ConditionToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Converting to Base UoM
     */
    @SerializedName( "ConditionToBaseQtyDnmntr" )
    @JsonProperty( "ConditionToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "ConditionToBaseQtyDnmntr" )
    private BigDecimal conditionToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>ConditionToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_TO_BASE_QTY_DNMNTR =
        new PurOrdPricingElementField<BigDecimal>("ConditionToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @return Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    @SerializedName( "ConditionCategory" )
    @JsonProperty( "ConditionCategory" )
    @Nullable
    @ODataField( odataName = "ConditionCategory" )
    private String conditionCategory;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCategory</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_CATEGORY =
        new PurOrdPricingElementField<String>("ConditionCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @return Condition is used for statistics
     */
    @SerializedName( "ConditionIsForStatistics" )
    @JsonProperty( "ConditionIsForStatistics" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForStatistics" )
    private Boolean conditionIsForStatistics;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForStatistics</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Boolean> CONDITION_IS_FOR_STATISTICS =
        new PurOrdPricingElementField<Boolean>("ConditionIsForStatistics");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @return Scale Type
     */
    @SerializedName( "PricingScaleType" )
    @JsonProperty( "PricingScaleType" )
    @Nullable
    @ODataField( odataName = "PricingScaleType" )
    private String pricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleType</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_SCALE_TYPE =
        new PurOrdPricingElementField<String>("PricingScaleType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @return Condition is Relevant for Accrual (e.g. Freight)
     */
    @SerializedName( "IsRelevantForAccrual" )
    @JsonProperty( "IsRelevantForAccrual" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRelevantForAccrual" )
    private Boolean isRelevantForAccrual;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForAccrual</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Boolean> IS_RELEVANT_FOR_ACCRUAL =
        new PurOrdPricingElementField<Boolean>("IsRelevantForAccrual");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForInvoiceList</b>
     * </p>
     *
     * @return Condition for Invoice List
     */
    @SerializedName( "CndnIsRelevantForInvoiceList" )
    @JsonProperty( "CndnIsRelevantForInvoiceList" )
    @Nullable
    @ODataField( odataName = "CndnIsRelevantForInvoiceList" )
    private String cndnIsRelevantForInvoiceList;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForInvoiceList</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CNDN_IS_RELEVANT_FOR_INVOICE_LIST =
        new PurOrdPricingElementField<String>("CndnIsRelevantForInvoiceList");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     *
     * @return Origin of the Condition
     */
    @SerializedName( "ConditionOrigin" )
    @JsonProperty( "ConditionOrigin" )
    @Nullable
    @ODataField( odataName = "ConditionOrigin" )
    private String conditionOrigin;
    /**
     * Use with available fluent helpers to apply the <b>ConditionOrigin</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_ORIGIN =
        new PurOrdPricingElementField<String>("ConditionOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @return Group Condition
     */
    @SerializedName( "IsGroupCondition" )
    @JsonProperty( "IsGroupCondition" )
    @Nullable
    @ODataField( odataName = "IsGroupCondition" )
    private String isGroupCondition;
    /**
     * Use with available fluent helpers to apply the <b>IsGroupCondition</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> IS_GROUP_CONDITION =
        new PurOrdPricingElementField<String>("IsGroupCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForLimitValue</b>
     * </p>
     *
     * @return Condition Update
     */
    @SerializedName( "CndnIsRelevantForLimitValue" )
    @JsonProperty( "CndnIsRelevantForLimitValue" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsRelevantForLimitValue" )
    private Boolean cndnIsRelevantForLimitValue;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForLimitValue</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Boolean> CNDN_IS_RELEVANT_FOR_LIMIT_VALUE =
        new PurOrdPricingElementField<Boolean>("CndnIsRelevantForLimitValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential Number of the Condition
     */
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_SEQUENTIAL_NUMBER =
        new PurOrdPricingElementField<String>("ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     *
     * @return Condition Control
     */
    @SerializedName( "ConditionControl" )
    @JsonProperty( "ConditionControl" )
    @Nullable
    @ODataField( odataName = "ConditionControl" )
    private String conditionControl;
    /**
     * Use with available fluent helpers to apply the <b>ConditionControl</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_CONTROL =
        new PurOrdPricingElementField<String>("ConditionControl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @return Condition is Inactive
     */
    @SerializedName( "ConditionInactiveReason" )
    @JsonProperty( "ConditionInactiveReason" )
    @Nullable
    @ODataField( odataName = "ConditionInactiveReason" )
    private String conditionInactiveReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionInactiveReason</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_INACTIVE_REASON =
        new PurOrdPricingElementField<String>("ConditionInactiveReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @return Condition Class
     */
    @SerializedName( "ConditionClass" )
    @JsonProperty( "ConditionClass" )
    @Nullable
    @ODataField( odataName = "ConditionClass" )
    private String conditionClass;
    /**
     * Use with available fluent helpers to apply the <b>ConditionClass</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_CLASS =
        new PurOrdPricingElementField<String>("ConditionClass");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     *
     * @return Factor for Condition Base Value
     */
    @SerializedName( "FactorForConditionBasisValue" )
    @JsonProperty( "FactorForConditionBasisValue" )
    @Nullable
    @ODataField( odataName = "FactorForConditionBasisValue" )
    private Double factorForConditionBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>FactorForConditionBasisValue</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Double> FACTOR_FOR_CONDITION_BASIS_VALUE =
        new PurOrdPricingElementField<Double>("FactorForConditionBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @return Scale Basis Indicator
     */
    @SerializedName( "PricingScaleBasis" )
    @JsonProperty( "PricingScaleBasis" )
    @Nullable
    @ODataField( odataName = "PricingScaleBasis" )
    private String pricingScaleBasis;
    /**
     * Use with available fluent helpers to apply the <b>PricingScaleBasis</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> PRICING_SCALE_BASIS =
        new PurOrdPricingElementField<String>("PricingScaleBasis");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @return Scale Base Value
     */
    @SerializedName( "ConditionScaleBasisValue" )
    @JsonProperty( "ConditionScaleBasisValue" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisValue" )
    private BigDecimal conditionScaleBasisValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisValue</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<BigDecimal> CONDITION_SCALE_BASIS_VALUE =
        new PurOrdPricingElementField<BigDecimal>("ConditionScaleBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleBasisCurrency" )
    @JsonProperty( "ConditionScaleBasisCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisCurrency" )
    private String conditionScaleBasisCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisCurrency</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_SCALE_BASIS_CURRENCY =
        new PurOrdPricingElementField<String>("ConditionScaleBasisCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleBasisUnit" )
    @JsonProperty( "ConditionScaleBasisUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleBasisUnit" )
    private String conditionScaleBasisUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleBasisUnit</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_SCALE_BASIS_UNIT =
        new PurOrdPricingElementField<String>("ConditionScaleBasisUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @return Condition for Intercompany Billing
     */
    @SerializedName( "CndnIsRelevantForIntcoBilling" )
    @JsonProperty( "CndnIsRelevantForIntcoBilling" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsRelevantForIntcoBilling" )
    private Boolean cndnIsRelevantForIntcoBilling;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsRelevantForIntcoBilling</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Boolean> CNDN_IS_RELEVANT_FOR_INTCO_BILLING =
        new PurOrdPricingElementField<Boolean>("CndnIsRelevantForIntcoBilling");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     *
     * @return Condition Used for Variant Configuration
     */
    @SerializedName( "ConditionIsForConfiguration" )
    @JsonProperty( "ConditionIsForConfiguration" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForConfiguration" )
    private Boolean conditionIsForConfiguration;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForConfiguration</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Boolean> CONDITION_IS_FOR_CONFIGURATION =
        new PurOrdPricingElementField<Boolean>("ConditionIsForConfiguration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     *
     * @return Condition Changed Manually
     */
    @SerializedName( "ConditionIsManuallyChanged" )
    @JsonProperty( "ConditionIsManuallyChanged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsManuallyChanged" )
    private Boolean conditionIsManuallyChanged;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsManuallyChanged</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<Boolean> CONDITION_IS_MANUALLY_CHANGED =
        new PurOrdPricingElementField<Boolean>("ConditionIsManuallyChanged");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> CONDITION_RECORD =
        new PurOrdPricingElementField<String>("ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     *
     * @return Access sequence - Access number
     */
    @SerializedName( "AccessNumberOfAccessSequence" )
    @JsonProperty( "AccessNumberOfAccessSequence" )
    @Nullable
    @ODataField( odataName = "AccessNumberOfAccessSequence" )
    private String accessNumberOfAccessSequence;
    /**
     * Use with available fluent helpers to apply the <b>AccessNumberOfAccessSequence</b> field to query operations.
     *
     */
    public final static PurOrdPricingElementField<String> ACCESS_NUMBER_OF_ACCESS_SEQUENCE =
        new PurOrdPricingElementField<String>("AccessNumberOfAccessSequence");

    @Nonnull
    @Override
    public Class<PurOrdPricingElement> getType()
    {
        return PurOrdPricingElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PricingDocument</b>
     * </p>
     *
     * @param pricingDocument
     *            Number of the Document Condition
     */
    public void setPricingDocument( @Nullable final String pricingDocument )
    {
        rememberChangedField("PricingDocument", this.pricingDocument);
        this.pricingDocument = pricingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingDocumentItem</b>
     * </p>
     *
     * @param pricingDocumentItem
     *            Condition item number
     */
    public void setPricingDocumentItem( @Nullable final String pricingDocumentItem )
    {
        rememberChangedField("PricingDocumentItem", this.pricingDocumentItem);
        this.pricingDocumentItem = pricingDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Currency Key
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchangeRate</b>
     * </p>
     *
     * @param priceDetnExchangeRate
     *            The priceDetnExchangeRate to set.
     */
    public void setPriceDetnExchangeRate( @Nullable final String priceDetnExchangeRate )
    {
        rememberChangedField("PriceDetnExchangeRate", this.priceDetnExchangeRate);
        this.priceDetnExchangeRate = priceDetnExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     *
     * @param conditionAmount
     *            Condition Value
     */
    public void setConditionAmount( @Nullable final BigDecimal conditionAmount )
    {
        rememberChangedField("ConditionAmount", this.conditionAmount);
        this.conditionAmount = conditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit in the Document
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateTime</b>
     * </p>
     *
     * @param pricingDateTime
     *            Timestamp for Pricing
     */
    public void setPricingDateTime( @Nullable final String pricingDateTime )
    {
        rememberChangedField("PricingDateTime", this.pricingDateTime);
        this.pricingDateTime = pricingDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     *
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseValue</b>
     * </p>
     *
     * @param conditionBaseValue
     *            Condition Basis
     */
    public void setConditionBaseValue( @Nullable final BigDecimal conditionBaseValue )
    {
        rememberChangedField("ConditionBaseValue", this.conditionBaseValue);
        this.conditionBaseValue = conditionBaseValue;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyNmrtr</b>
     * </p>
     *
     * @param conditionToBaseQtyNmrtr
     *            Numerator for Converting to Base UoM
     */
    public void setConditionToBaseQtyNmrtr( @Nullable final BigDecimal conditionToBaseQtyNmrtr )
    {
        rememberChangedField("ConditionToBaseQtyNmrtr", this.conditionToBaseQtyNmrtr);
        this.conditionToBaseQtyNmrtr = conditionToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionToBaseQtyDnmntr</b>
     * </p>
     *
     * @param conditionToBaseQtyDnmntr
     *            Denominator for Converting to Base UoM
     */
    public void setConditionToBaseQtyDnmntr( @Nullable final BigDecimal conditionToBaseQtyDnmntr )
    {
        rememberChangedField("ConditionToBaseQtyDnmntr", this.conditionToBaseQtyDnmntr);
        this.conditionToBaseQtyDnmntr = conditionToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     *
     * @param conditionCategory
     *            Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    public void setConditionCategory( @Nullable final String conditionCategory )
    {
        rememberChangedField("ConditionCategory", this.conditionCategory);
        this.conditionCategory = conditionCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @param conditionIsForStatistics
     *            Condition is used for statistics
     */
    public void setConditionIsForStatistics( @Nullable final Boolean conditionIsForStatistics )
    {
        rememberChangedField("ConditionIsForStatistics", this.conditionIsForStatistics);
        this.conditionIsForStatistics = conditionIsForStatistics;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     *
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     *
     * @param isRelevantForAccrual
     *            Condition is Relevant for Accrual (e.g. Freight)
     */
    public void setIsRelevantForAccrual( @Nullable final Boolean isRelevantForAccrual )
    {
        rememberChangedField("IsRelevantForAccrual", this.isRelevantForAccrual);
        this.isRelevantForAccrual = isRelevantForAccrual;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForInvoiceList</b>
     * </p>
     *
     * @param cndnIsRelevantForInvoiceList
     *            Condition for Invoice List
     */
    public void setCndnIsRelevantForInvoiceList( @Nullable final String cndnIsRelevantForInvoiceList )
    {
        rememberChangedField("CndnIsRelevantForInvoiceList", this.cndnIsRelevantForInvoiceList);
        this.cndnIsRelevantForInvoiceList = cndnIsRelevantForInvoiceList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     *
     * @param conditionOrigin
     *            Origin of the Condition
     */
    public void setConditionOrigin( @Nullable final String conditionOrigin )
    {
        rememberChangedField("ConditionOrigin", this.conditionOrigin);
        this.conditionOrigin = conditionOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     *
     * @param isGroupCondition
     *            Group Condition
     */
    public void setIsGroupCondition( @Nullable final String isGroupCondition )
    {
        rememberChangedField("IsGroupCondition", this.isGroupCondition);
        this.isGroupCondition = isGroupCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForLimitValue</b>
     * </p>
     *
     * @param cndnIsRelevantForLimitValue
     *            Condition Update
     */
    public void setCndnIsRelevantForLimitValue( @Nullable final Boolean cndnIsRelevantForLimitValue )
    {
        rememberChangedField("CndnIsRelevantForLimitValue", this.cndnIsRelevantForLimitValue);
        this.cndnIsRelevantForLimitValue = cndnIsRelevantForLimitValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential Number of the Condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     *
     * @param conditionControl
     *            Condition Control
     */
    public void setConditionControl( @Nullable final String conditionControl )
    {
        rememberChangedField("ConditionControl", this.conditionControl);
        this.conditionControl = conditionControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @param conditionInactiveReason
     *            Condition is Inactive
     */
    public void setConditionInactiveReason( @Nullable final String conditionInactiveReason )
    {
        rememberChangedField("ConditionInactiveReason", this.conditionInactiveReason);
        this.conditionInactiveReason = conditionInactiveReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     *
     * @param conditionClass
     *            Condition Class
     */
    public void setConditionClass( @Nullable final String conditionClass )
    {
        rememberChangedField("ConditionClass", this.conditionClass);
        this.conditionClass = conditionClass;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     *
     * @param factorForConditionBasisValue
     *            Factor for Condition Base Value
     */
    public void setFactorForConditionBasisValue( @Nullable final Double factorForConditionBasisValue )
    {
        rememberChangedField("FactorForConditionBasisValue", this.factorForConditionBasisValue);
        this.factorForConditionBasisValue = factorForConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     *
     * @param pricingScaleBasis
     *            Scale Basis Indicator
     */
    public void setPricingScaleBasis( @Nullable final String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisValue</b>
     * </p>
     *
     * @param conditionScaleBasisValue
     *            Scale Base Value
     */
    public void setConditionScaleBasisValue( @Nullable final BigDecimal conditionScaleBasisValue )
    {
        rememberChangedField("ConditionScaleBasisValue", this.conditionScaleBasisValue);
        this.conditionScaleBasisValue = conditionScaleBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     *
     * @param conditionScaleBasisCurrency
     *            Scale Currency
     */
    public void setConditionScaleBasisCurrency( @Nullable final String conditionScaleBasisCurrency )
    {
        rememberChangedField("ConditionScaleBasisCurrency", this.conditionScaleBasisCurrency);
        this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     *
     * @param conditionScaleBasisUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleBasisUnit( @Nullable final String conditionScaleBasisUnit )
    {
        rememberChangedField("ConditionScaleBasisUnit", this.conditionScaleBasisUnit);
        this.conditionScaleBasisUnit = conditionScaleBasisUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForIntcoBilling</b>
     * </p>
     *
     * @param cndnIsRelevantForIntcoBilling
     *            Condition for Intercompany Billing
     */
    public void setCndnIsRelevantForIntcoBilling( @Nullable final Boolean cndnIsRelevantForIntcoBilling )
    {
        rememberChangedField("CndnIsRelevantForIntcoBilling", this.cndnIsRelevantForIntcoBilling);
        this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     *
     * @param conditionIsForConfiguration
     *            Condition Used for Variant Configuration
     */
    public void setConditionIsForConfiguration( @Nullable final Boolean conditionIsForConfiguration )
    {
        rememberChangedField("ConditionIsForConfiguration", this.conditionIsForConfiguration);
        this.conditionIsForConfiguration = conditionIsForConfiguration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     *
     * @param conditionIsManuallyChanged
     *            Condition Changed Manually
     */
    public void setConditionIsManuallyChanged( @Nullable final Boolean conditionIsManuallyChanged )
    {
        rememberChangedField("ConditionIsManuallyChanged", this.conditionIsManuallyChanged);
        this.conditionIsManuallyChanged = conditionIsManuallyChanged;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     *
     * @param accessNumberOfAccessSequence
     *            Access sequence - Access number
     */
    public void setAccessNumberOfAccessSequence( @Nullable final String accessNumberOfAccessSequence )
    {
        rememberChangedField("AccessNumberOfAccessSequence", this.accessNumberOfAccessSequence);
        this.accessNumberOfAccessSequence = accessNumberOfAccessSequence;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurOrdPricingElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseOrder", getPurchaseOrder());
        result.put("PurchaseOrderItem", getPurchaseOrderItem());
        result.put("PricingDocument", getPricingDocument());
        result.put("PricingDocumentItem", getPricingDocumentItem());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("PricingDocument", getPricingDocument());
        values.put("PricingDocumentItem", getPricingDocumentItem());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionType", getConditionType());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("PriceDetnExchangeRate", getPriceDetnExchangeRate());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ConditionAmount", getConditionAmount());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingDateTime", getPricingDateTime());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionBaseValue", getConditionBaseValue());
        values.put("ConditionToBaseQtyNmrtr", getConditionToBaseQtyNmrtr());
        values.put("ConditionToBaseQtyDnmntr", getConditionToBaseQtyDnmntr());
        values.put("ConditionCategory", getConditionCategory());
        values.put("ConditionIsForStatistics", getConditionIsForStatistics());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("IsRelevantForAccrual", getIsRelevantForAccrual());
        values.put("CndnIsRelevantForInvoiceList", getCndnIsRelevantForInvoiceList());
        values.put("ConditionOrigin", getConditionOrigin());
        values.put("IsGroupCondition", getIsGroupCondition());
        values.put("CndnIsRelevantForLimitValue", getCndnIsRelevantForLimitValue());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionControl", getConditionControl());
        values.put("ConditionInactiveReason", getConditionInactiveReason());
        values.put("ConditionClass", getConditionClass());
        values.put("FactorForConditionBasisValue", getFactorForConditionBasisValue());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionScaleBasisValue", getConditionScaleBasisValue());
        values.put("ConditionScaleBasisCurrency", getConditionScaleBasisCurrency());
        values.put("ConditionScaleBasisUnit", getConditionScaleBasisUnit());
        values.put("CndnIsRelevantForIntcoBilling", getCndnIsRelevantForIntcoBilling());
        values.put("ConditionIsForConfiguration", getConditionIsForConfiguration());
        values.put("ConditionIsManuallyChanged", getConditionIsManuallyChanged());
        values.put("ConditionRecord", getConditionRecord());
        values.put("AccessNumberOfAccessSequence", getAccessNumberOfAccessSequence());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("PricingDocument") ) {
                final Object value = values.remove("PricingDocument");
                if( (value == null) || (!value.equals(getPricingDocument())) ) {
                    setPricingDocument(((String) value));
                }
            }
            if( values.containsKey("PricingDocumentItem") ) {
                final Object value = values.remove("PricingDocumentItem");
                if( (value == null) || (!value.equals(getPricingDocumentItem())) ) {
                    setPricingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("PriceDetnExchangeRate") ) {
                final Object value = values.remove("PriceDetnExchangeRate");
                if( (value == null) || (!value.equals(getPriceDetnExchangeRate())) ) {
                    setPriceDetnExchangeRate(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionAmount") ) {
                final Object value = values.remove("ConditionAmount");
                if( (value == null) || (!value.equals(getConditionAmount())) ) {
                    setConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("PricingDateTime") ) {
                final Object value = values.remove("PricingDateTime");
                if( (value == null) || (!value.equals(getPricingDateTime())) ) {
                    setPricingDateTime(((String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((String) value));
                }
            }
            if( values.containsKey("ConditionBaseValue") ) {
                final Object value = values.remove("ConditionBaseValue");
                if( (value == null) || (!value.equals(getConditionBaseValue())) ) {
                    setConditionBaseValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyNmrtr") ) {
                final Object value = values.remove("ConditionToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyNmrtr())) ) {
                    setConditionToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionToBaseQtyDnmntr") ) {
                final Object value = values.remove("ConditionToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getConditionToBaseQtyDnmntr())) ) {
                    setConditionToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCategory") ) {
                final Object value = values.remove("ConditionCategory");
                if( (value == null) || (!value.equals(getConditionCategory())) ) {
                    setConditionCategory(((String) value));
                }
            }
            if( values.containsKey("ConditionIsForStatistics") ) {
                final Object value = values.remove("ConditionIsForStatistics");
                if( (value == null) || (!value.equals(getConditionIsForStatistics())) ) {
                    setConditionIsForStatistics(((Boolean) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("IsRelevantForAccrual") ) {
                final Object value = values.remove("IsRelevantForAccrual");
                if( (value == null) || (!value.equals(getIsRelevantForAccrual())) ) {
                    setIsRelevantForAccrual(((Boolean) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForInvoiceList") ) {
                final Object value = values.remove("CndnIsRelevantForInvoiceList");
                if( (value == null) || (!value.equals(getCndnIsRelevantForInvoiceList())) ) {
                    setCndnIsRelevantForInvoiceList(((String) value));
                }
            }
            if( values.containsKey("ConditionOrigin") ) {
                final Object value = values.remove("ConditionOrigin");
                if( (value == null) || (!value.equals(getConditionOrigin())) ) {
                    setConditionOrigin(((String) value));
                }
            }
            if( values.containsKey("IsGroupCondition") ) {
                final Object value = values.remove("IsGroupCondition");
                if( (value == null) || (!value.equals(getIsGroupCondition())) ) {
                    setIsGroupCondition(((String) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForLimitValue") ) {
                final Object value = values.remove("CndnIsRelevantForLimitValue");
                if( (value == null) || (!value.equals(getCndnIsRelevantForLimitValue())) ) {
                    setCndnIsRelevantForLimitValue(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionControl") ) {
                final Object value = values.remove("ConditionControl");
                if( (value == null) || (!value.equals(getConditionControl())) ) {
                    setConditionControl(((String) value));
                }
            }
            if( values.containsKey("ConditionInactiveReason") ) {
                final Object value = values.remove("ConditionInactiveReason");
                if( (value == null) || (!value.equals(getConditionInactiveReason())) ) {
                    setConditionInactiveReason(((String) value));
                }
            }
            if( values.containsKey("ConditionClass") ) {
                final Object value = values.remove("ConditionClass");
                if( (value == null) || (!value.equals(getConditionClass())) ) {
                    setConditionClass(((String) value));
                }
            }
            if( values.containsKey("FactorForConditionBasisValue") ) {
                final Object value = values.remove("FactorForConditionBasisValue");
                if( (value == null) || (!value.equals(getFactorForConditionBasisValue())) ) {
                    setFactorForConditionBasisValue(((Double) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisValue") ) {
                final Object value = values.remove("ConditionScaleBasisValue");
                if( (value == null) || (!value.equals(getConditionScaleBasisValue())) ) {
                    setConditionScaleBasisValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisCurrency") ) {
                final Object value = values.remove("ConditionScaleBasisCurrency");
                if( (value == null) || (!value.equals(getConditionScaleBasisCurrency())) ) {
                    setConditionScaleBasisCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisUnit") ) {
                final Object value = values.remove("ConditionScaleBasisUnit");
                if( (value == null) || (!value.equals(getConditionScaleBasisUnit())) ) {
                    setConditionScaleBasisUnit(((String) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForIntcoBilling") ) {
                final Object value = values.remove("CndnIsRelevantForIntcoBilling");
                if( (value == null) || (!value.equals(getCndnIsRelevantForIntcoBilling())) ) {
                    setCndnIsRelevantForIntcoBilling(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionIsForConfiguration") ) {
                final Object value = values.remove("ConditionIsForConfiguration");
                if( (value == null) || (!value.equals(getConditionIsForConfiguration())) ) {
                    setConditionIsForConfiguration(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionIsManuallyChanged") ) {
                final Object value = values.remove("ConditionIsManuallyChanged");
                if( (value == null) || (!value.equals(getConditionIsManuallyChanged())) ) {
                    setConditionIsManuallyChanged(((Boolean) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("AccessNumberOfAccessSequence") ) {
                final Object value = values.remove("AccessNumberOfAccessSequence");
                if( (value == null) || (!value.equals(getAccessNumberOfAccessSequence())) ) {
                    setAccessNumberOfAccessSequence(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurOrdPricingElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurOrdPricingElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurOrdPricingElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurOrdPricingElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

}
