/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurchaseOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.PurchaseOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.PurchaseOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchase Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseOrder extends VdmEntity<PurchaseOrder>
{

    /**
     * Selector for all available fields of PurchaseOrder.
     *
     */
    public final static PurchaseOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchase Order Number
     */
    @Key
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASE_ORDER = new PurchaseOrderField<String>("PurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> COMPANY_CODE = new PurchaseOrderField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchaseOrderType" )
    @JsonProperty( "PurchaseOrderType" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderType" )
    private String purchaseOrderType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderType</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASE_ORDER_TYPE =
        new PurchaseOrderField<String>("PurchaseOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @return Purchase Order Deletion Code
     */
    @SerializedName( "PurchasingDocumentDeletionCode" )
    @JsonProperty( "PurchasingDocumentDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentDeletionCode" )
    private String purchasingDocumentDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDeletionCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASING_DOCUMENT_DELETION_CODE =
        new PurchaseOrderField<String>("PurchasingDocumentDeletionCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingProcessingStatus</b>
     * </p>
     *
     * @return Purchasing Document Processing State
     */
    @SerializedName( "PurchasingProcessingStatus" )
    @JsonProperty( "PurchasingProcessingStatus" )
    @Nullable
    @ODataField( odataName = "PurchasingProcessingStatus" )
    private String purchasingProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingProcessingStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASING_PROCESSING_STATUS =
        new PurchaseOrderField<String>("PurchasingProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User of person who created a purchasing document
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> CREATED_BY_USER = new PurchaseOrderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date of Purchasing Document
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<LocalDateTime> CREATION_DATE =
        new PurchaseOrderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Change Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PurchaseOrderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> SUPPLIER = new PurchaseOrderField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderSubtype</b>
     * </p>
     *
     * @return Control indicator for purchasing document type
     */
    @SerializedName( "PurchaseOrderSubtype" )
    @JsonProperty( "PurchaseOrderSubtype" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderSubtype" )
    private String purchaseOrderSubtype;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderSubtype</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASE_ORDER_SUBTYPE =
        new PurchaseOrderField<String>("PurchaseOrderSubtype");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> LANGUAGE = new PurchaseOrderField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PAYMENT_TERMS = new PurchaseOrderField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new PurchaseOrderField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new PurchaseOrderField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<BigDecimal> NET_PAYMENT_DAYS =
        new PurchaseOrderField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new PurchaseOrderField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new PurchaseOrderField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASING_ORGANIZATION =
        new PurchaseOrderField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrigin</b>
     * </p>
     *
     * @return Status of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentOrigin" )
    @JsonProperty( "PurchasingDocumentOrigin" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentOrigin" )
    private String purchasingDocumentOrigin;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentOrigin</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASING_DOCUMENT_ORIGIN =
        new PurchaseOrderField<String>("PurchasingDocumentOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASING_GROUP = new PurchaseOrderField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderDate</b>
     * </p>
     *
     * @return Purchase Order Date
     */
    @SerializedName( "PurchaseOrderDate" )
    @JsonProperty( "PurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<LocalDateTime> PURCHASE_ORDER_DATE =
        new PurchaseOrderField<LocalDateTime>("PurchaseOrderDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> DOCUMENT_CURRENCY =
        new PurchaseOrderField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @return The exchangeRate contained in this entity.
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private String exchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRate</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> EXCHANGE_RATE = new PurchaseOrderField<String>("ExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @return Indicator for Fixed Exchange Rate
     */
    @SerializedName( "ExchangeRateIsFixed" )
    @JsonProperty( "ExchangeRateIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchangeRateIsFixed" )
    private Boolean exchangeRateIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateIsFixed</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<Boolean> EXCHANGE_RATE_IS_FIXED =
        new PurchaseOrderField<Boolean>("ExchangeRateIsFixed");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start of Validity Period
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<LocalDateTime> VALIDITY_START_DATE =
        new PurchaseOrderField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End of Validity Period
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<LocalDateTime> VALIDITY_END_DATE =
        new PurchaseOrderField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @return Quotation Number
     */
    @SerializedName( "SupplierQuotationExternalID" )
    @JsonProperty( "SupplierQuotationExternalID" )
    @Nullable
    @ODataField( odataName = "SupplierQuotationExternalID" )
    private String supplierQuotationExternalID;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotationExternalID</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> SUPPLIER_QUOTATION_EXTERNAL_ID =
        new PurchaseOrderField<String>("SupplierQuotationExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCollectiveNumber</b>
     * </p>
     *
     * @return Collective Number
     */
    @SerializedName( "PurchasingCollectiveNumber" )
    @JsonProperty( "PurchasingCollectiveNumber" )
    @Nullable
    @ODataField( odataName = "PurchasingCollectiveNumber" )
    private String purchasingCollectiveNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingCollectiveNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURCHASING_COLLECTIVE_NUMBER =
        new PurchaseOrderField<String>("PurchasingCollectiveNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @return Responsible Salesperson at Supplier's Office
     */
    @SerializedName( "SupplierRespSalesPersonName" )
    @JsonProperty( "SupplierRespSalesPersonName" )
    @Nullable
    @ODataField( odataName = "SupplierRespSalesPersonName" )
    private String supplierRespSalesPersonName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierRespSalesPersonName</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> SUPPLIER_RESP_SALES_PERSON_NAME =
        new PurchaseOrderField<String>("SupplierRespSalesPersonName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @return Supplier's Phone Number
     */
    @SerializedName( "SupplierPhoneNumber" )
    @JsonProperty( "SupplierPhoneNumber" )
    @Nullable
    @ODataField( odataName = "SupplierPhoneNumber" )
    private String supplierPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPhoneNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> SUPPLIER_PHONE_NUMBER =
        new PurchaseOrderField<String>("SupplierPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @return Goods Supplier
     */
    @SerializedName( "SupplyingSupplier" )
    @JsonProperty( "SupplyingSupplier" )
    @Nullable
    @ODataField( odataName = "SupplyingSupplier" )
    private String supplyingSupplier;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingSupplier</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> SUPPLYING_SUPPLIER =
        new PurchaseOrderField<String>("SupplyingSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Supplying (issuing) plant in case of stock transport order
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> SUPPLYING_PLANT = new PurchaseOrderField<String>("SupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> INCOTERMS_CLASSIFICATION =
        new PurchaseOrderField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncExternalReference</b>
     * </p>
     *
     * @return Your Reference
     */
    @SerializedName( "CorrespncExternalReference" )
    @JsonProperty( "CorrespncExternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncExternalReference" )
    private String correspncExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncExternalReference</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> CORRESPNC_EXTERNAL_REFERENCE =
        new PurchaseOrderField<String>("CorrespncExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @return Our Reference
     */
    @SerializedName( "CorrespncInternalReference" )
    @JsonProperty( "CorrespncInternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncInternalReference" )
    private String correspncInternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncInternalReference</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> CORRESPNC_INTERNAL_REFERENCE =
        new PurchaseOrderField<String>("CorrespncInternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @return Different Invoicing Party
     */
    @SerializedName( "InvoicingParty" )
    @JsonProperty( "InvoicingParty" )
    @Nullable
    @ODataField( odataName = "InvoicingParty" )
    private String invoicingParty;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingParty</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> INVOICING_PARTY = new PurchaseOrderField<String>("InvoicingParty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseIsNotCompleted</b>
     * </p>
     *
     * @return Release Not Yet Completely Effected
     */
    @SerializedName( "ReleaseIsNotCompleted" )
    @JsonProperty( "ReleaseIsNotCompleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReleaseIsNotCompleted" )
    private Boolean releaseIsNotCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseIsNotCompleted</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<Boolean> RELEASE_IS_NOT_COMPLETED =
        new PurchaseOrderField<Boolean>("ReleaseIsNotCompleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCompletenessStatus</b>
     * </p>
     *
     * @return Purchase order not yet complete
     */
    @SerializedName( "PurchasingCompletenessStatus" )
    @JsonProperty( "PurchasingCompletenessStatus" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurchasingCompletenessStatus" )
    private Boolean purchasingCompletenessStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingCompletenessStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<Boolean> PURCHASING_COMPLETENESS_STATUS =
        new PurchaseOrderField<Boolean>("PurchasingCompletenessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> INCOTERMS_VERSION =
        new PurchaseOrderField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> INCOTERMS_LOCATION1 =
        new PurchaseOrderField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> INCOTERMS_LOCATION2 =
        new PurchaseOrderField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualSupplierAddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @SerializedName( "ManualSupplierAddressID" )
    @JsonProperty( "ManualSupplierAddressID" )
    @Nullable
    @ODataField( odataName = "ManualSupplierAddressID" )
    private String manualSupplierAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ManualSupplierAddressID</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> MANUAL_SUPPLIER_ADDRESS_ID =
        new PurchaseOrderField<String>("ManualSupplierAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> IS_END_OF_PURPOSE_BLOCKED =
        new PurchaseOrderField<String>("IsEndOfPurposeBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AddressCityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "AddressCityName" )
    @JsonProperty( "AddressCityName" )
    @Nullable
    @ODataField( odataName = "AddressCityName" )
    private String addressCityName;
    /**
     * Use with available fluent helpers to apply the <b>AddressCityName</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_CITY_NAME =
        new PurchaseOrderField<String>("AddressCityName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AddressFaxNumber</b>
     * </p>
     *
     * @return First Fax No.: Area Code + Number
     */
    @SerializedName( "AddressFaxNumber" )
    @JsonProperty( "AddressFaxNumber" )
    @Nullable
    @ODataField( odataName = "AddressFaxNumber" )
    private String addressFaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>AddressFaxNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_FAX_NUMBER =
        new PurchaseOrderField<String>("AddressFaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressHouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "AddressHouseNumber" )
    @JsonProperty( "AddressHouseNumber" )
    @Nullable
    @ODataField( odataName = "AddressHouseNumber" )
    private String addressHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>AddressHouseNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_HOUSE_NUMBER =
        new PurchaseOrderField<String>("AddressHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AddressName</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "AddressName" )
    @JsonProperty( "AddressName" )
    @Nullable
    @ODataField( odataName = "AddressName" )
    private String addressName;
    /**
     * Use with available fluent helpers to apply the <b>AddressName</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_NAME = new PurchaseOrderField<String>("AddressName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressPostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "AddressPostalCode" )
    @JsonProperty( "AddressPostalCode" )
    @Nullable
    @ODataField( odataName = "AddressPostalCode" )
    private String addressPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>AddressPostalCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_POSTAL_CODE =
        new PurchaseOrderField<String>("AddressPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AddressStreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "AddressStreetName" )
    @JsonProperty( "AddressStreetName" )
    @Nullable
    @ODataField( odataName = "AddressStreetName" )
    private String addressStreetName;
    /**
     * Use with available fluent helpers to apply the <b>AddressStreetName</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_STREET_NAME =
        new PurchaseOrderField<String>("AddressStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AddressPhoneNumber</b>
     * </p>
     *
     * @return First Telephone No.: Dialing Code + Number
     */
    @SerializedName( "AddressPhoneNumber" )
    @JsonProperty( "AddressPhoneNumber" )
    @Nullable
    @ODataField( odataName = "AddressPhoneNumber" )
    private String addressPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>AddressPhoneNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_PHONE_NUMBER =
        new PurchaseOrderField<String>("AddressPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AddressRegion</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "AddressRegion" )
    @JsonProperty( "AddressRegion" )
    @Nullable
    @ODataField( odataName = "AddressRegion" )
    private String addressRegion;
    /**
     * Use with available fluent helpers to apply the <b>AddressRegion</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_REGION = new PurchaseOrderField<String>("AddressRegion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AddressCountry</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "AddressCountry" )
    @JsonProperty( "AddressCountry" )
    @Nullable
    @ODataField( odataName = "AddressCountry" )
    private String addressCountry;
    /**
     * Use with available fluent helpers to apply the <b>AddressCountry</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_COUNTRY = new PurchaseOrderField<String>("AddressCountry");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AddressCorrespondenceLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "AddressCorrespondenceLanguage" )
    @JsonProperty( "AddressCorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "AddressCorrespondenceLanguage" )
    private String addressCorrespondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>AddressCorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> ADDRESS_CORRESPONDENCE_LANGUAGE =
        new PurchaseOrderField<String>("AddressCorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdProdCmplncSuplrSts</b>
     * </p>
     *
     * @return Product Compliance Supplier Check Status (All Items)
     */
    @SerializedName( "PurgAggrgdProdCmplncSuplrSts" )
    @JsonProperty( "PurgAggrgdProdCmplncSuplrSts" )
    @Nullable
    @ODataField( odataName = "PurgAggrgdProdCmplncSuplrSts" )
    private String purgAggrgdProdCmplncSuplrSts;
    /**
     * Use with available fluent helpers to apply the <b>PurgAggrgdProdCmplncSuplrSts</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURG_AGGRGD_PROD_CMPLNC_SUPLR_STS =
        new PurchaseOrderField<String>("PurgAggrgdProdCmplncSuplrSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdProdMarketabilitySts</b>
     * </p>
     *
     * @return Product Marketability Status (All Items)
     */
    @SerializedName( "PurgAggrgdProdMarketabilitySts" )
    @JsonProperty( "PurgAggrgdProdMarketabilitySts" )
    @Nullable
    @ODataField( odataName = "PurgAggrgdProdMarketabilitySts" )
    private String purgAggrgdProdMarketabilitySts;
    /**
     * Use with available fluent helpers to apply the <b>PurgAggrgdProdMarketabilitySts</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURG_AGGRGD_PROD_MARKETABILITY_STS =
        new PurchaseOrderField<String>("PurgAggrgdProdMarketabilitySts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdSftyDataSheetStatus</b>
     * </p>
     *
     * @return Safety Data Sheet Status (All Items)
     */
    @SerializedName( "PurgAggrgdSftyDataSheetStatus" )
    @JsonProperty( "PurgAggrgdSftyDataSheetStatus" )
    @Nullable
    @ODataField( odataName = "PurgAggrgdSftyDataSheetStatus" )
    private String purgAggrgdSftyDataSheetStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgAggrgdSftyDataSheetStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURG_AGGRGD_SFTY_DATA_SHEET_STATUS =
        new PurchaseOrderField<String>("PurgAggrgdSftyDataSheetStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncTotDngrsGoodsSts</b>
     * </p>
     *
     * @return Dangerous Goods Status (All Items)
     */
    @SerializedName( "PurgProdCmplncTotDngrsGoodsSts" )
    @JsonProperty( "PurgProdCmplncTotDngrsGoodsSts" )
    @Nullable
    @ODataField( odataName = "PurgProdCmplncTotDngrsGoodsSts" )
    private String purgProdCmplncTotDngrsGoodsSts;
    /**
     * Use with available fluent helpers to apply the <b>PurgProdCmplncTotDngrsGoodsSts</b> field to query operations.
     *
     */
    public final static PurchaseOrderField<String> PURG_PROD_CMPLNC_TOT_DNGRS_GOODS_STS =
        new PurchaseOrderField<String>("PurgProdCmplncTotDngrsGoodsSts");
    /**
     * Navigation property <b>to_PurchaseOrderItem</b> for <b>PurchaseOrder</b> to multiple <b>PurchaseOrderItem</b>.
     *
     */
    @SerializedName( "to_PurchaseOrderItem" )
    @JsonProperty( "to_PurchaseOrderItem" )
    @ODataField( odataName = "to_PurchaseOrderItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseOrderItem> toPurchaseOrderItem;
    /**
     * Navigation property <b>to_PurchaseOrderNote</b> for <b>PurchaseOrder</b> to multiple <b>PurchaseOrderNote</b>.
     *
     */
    @SerializedName( "to_PurchaseOrderNote" )
    @JsonProperty( "to_PurchaseOrderNote" )
    @ODataField( odataName = "to_PurchaseOrderNote" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseOrderNote> toPurchaseOrderNote;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseOrderItem</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseOrderLink<PurchaseOrderItem> TO_PURCHASE_ORDER_ITEM =
        new PurchaseOrderLink<PurchaseOrderItem>("to_PurchaseOrderItem");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseOrderNote</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseOrderLink<PurchaseOrderNote> TO_PURCHASE_ORDER_NOTE =
        new PurchaseOrderLink<PurchaseOrderNote>("to_PurchaseOrderNote");

    @Nonnull
    @Override
    public Class<PurchaseOrder> getType()
    {
        return PurchaseOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderType</b>
     * </p>
     *
     * @param purchaseOrderType
     *            Purchasing Document Type
     */
    public void setPurchaseOrderType( @Nullable final String purchaseOrderType )
    {
        rememberChangedField("PurchaseOrderType", this.purchaseOrderType);
        this.purchaseOrderType = purchaseOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @param purchasingDocumentDeletionCode
     *            Purchase Order Deletion Code
     */
    public void setPurchasingDocumentDeletionCode( @Nullable final String purchasingDocumentDeletionCode )
    {
        rememberChangedField("PurchasingDocumentDeletionCode", this.purchasingDocumentDeletionCode);
        this.purchasingDocumentDeletionCode = purchasingDocumentDeletionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingProcessingStatus</b>
     * </p>
     *
     * @param purchasingProcessingStatus
     *            Purchasing Document Processing State
     */
    public void setPurchasingProcessingStatus( @Nullable final String purchasingProcessingStatus )
    {
        rememberChangedField("PurchasingProcessingStatus", this.purchasingProcessingStatus);
        this.purchasingProcessingStatus = purchasingProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User of person who created a purchasing document
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date of Purchasing Document
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Change Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderSubtype</b>
     * </p>
     *
     * @param purchaseOrderSubtype
     *            Control indicator for purchasing document type
     */
    public void setPurchaseOrderSubtype( @Nullable final String purchaseOrderSubtype )
    {
        rememberChangedField("PurchaseOrderSubtype", this.purchaseOrderSubtype);
        this.purchaseOrderSubtype = purchaseOrderSubtype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentOrigin</b>
     * </p>
     *
     * @param purchasingDocumentOrigin
     *            Status of Purchasing Document
     */
    public void setPurchasingDocumentOrigin( @Nullable final String purchasingDocumentOrigin )
    {
        rememberChangedField("PurchasingDocumentOrigin", this.purchasingDocumentOrigin);
        this.purchasingDocumentOrigin = purchasingDocumentOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderDate</b>
     * </p>
     *
     * @param purchaseOrderDate
     *            Purchase Order Date
     */
    public void setPurchaseOrderDate( @Nullable final LocalDateTime purchaseOrderDate )
    {
        rememberChangedField("PurchaseOrderDate", this.purchaseOrderDate);
        this.purchaseOrderDate = purchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            The exchangeRate to set.
     */
    public void setExchangeRate( @Nullable final String exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *            Indicator for Fixed Exchange Rate
     */
    public void setExchangeRateIsFixed( @Nullable final Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start of Validity Period
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End of Validity Period
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationExternalID</b>
     * </p>
     *
     * @param supplierQuotationExternalID
     *            Quotation Number
     */
    public void setSupplierQuotationExternalID( @Nullable final String supplierQuotationExternalID )
    {
        rememberChangedField("SupplierQuotationExternalID", this.supplierQuotationExternalID);
        this.supplierQuotationExternalID = supplierQuotationExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCollectiveNumber</b>
     * </p>
     *
     * @param purchasingCollectiveNumber
     *            Collective Number
     */
    public void setPurchasingCollectiveNumber( @Nullable final String purchasingCollectiveNumber )
    {
        rememberChangedField("PurchasingCollectiveNumber", this.purchasingCollectiveNumber);
        this.purchasingCollectiveNumber = purchasingCollectiveNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @param supplierRespSalesPersonName
     *            Responsible Salesperson at Supplier's Office
     */
    public void setSupplierRespSalesPersonName( @Nullable final String supplierRespSalesPersonName )
    {
        rememberChangedField("SupplierRespSalesPersonName", this.supplierRespSalesPersonName);
        this.supplierRespSalesPersonName = supplierRespSalesPersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @param supplierPhoneNumber
     *            Supplier's Phone Number
     */
    public void setSupplierPhoneNumber( @Nullable final String supplierPhoneNumber )
    {
        rememberChangedField("SupplierPhoneNumber", this.supplierPhoneNumber);
        this.supplierPhoneNumber = supplierPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @param supplyingSupplier
     *            Goods Supplier
     */
    public void setSupplyingSupplier( @Nullable final String supplyingSupplier )
    {
        rememberChangedField("SupplyingSupplier", this.supplyingSupplier);
        this.supplyingSupplier = supplyingSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Supplying (issuing) plant in case of stock transport order
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncExternalReference</b>
     * </p>
     *
     * @param correspncExternalReference
     *            Your Reference
     */
    public void setCorrespncExternalReference( @Nullable final String correspncExternalReference )
    {
        rememberChangedField("CorrespncExternalReference", this.correspncExternalReference);
        this.correspncExternalReference = correspncExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @param correspncInternalReference
     *            Our Reference
     */
    public void setCorrespncInternalReference( @Nullable final String correspncInternalReference )
    {
        rememberChangedField("CorrespncInternalReference", this.correspncInternalReference);
        this.correspncInternalReference = correspncInternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @param invoicingParty
     *            Different Invoicing Party
     */
    public void setInvoicingParty( @Nullable final String invoicingParty )
    {
        rememberChangedField("InvoicingParty", this.invoicingParty);
        this.invoicingParty = invoicingParty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseIsNotCompleted</b>
     * </p>
     *
     * @param releaseIsNotCompleted
     *            Release Not Yet Completely Effected
     */
    public void setReleaseIsNotCompleted( @Nullable final Boolean releaseIsNotCompleted )
    {
        rememberChangedField("ReleaseIsNotCompleted", this.releaseIsNotCompleted);
        this.releaseIsNotCompleted = releaseIsNotCompleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCompletenessStatus</b>
     * </p>
     *
     * @param purchasingCompletenessStatus
     *            Purchase order not yet complete
     */
    public void setPurchasingCompletenessStatus( @Nullable final Boolean purchasingCompletenessStatus )
    {
        rememberChangedField("PurchasingCompletenessStatus", this.purchasingCompletenessStatus);
        this.purchasingCompletenessStatus = purchasingCompletenessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualSupplierAddressID</b>
     * </p>
     *
     * @param manualSupplierAddressID
     *            Address Number
     */
    public void setManualSupplierAddressID( @Nullable final String manualSupplierAddressID )
    {
        rememberChangedField("ManualSupplierAddressID", this.manualSupplierAddressID);
        this.manualSupplierAddressID = manualSupplierAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AddressCityName</b>
     * </p>
     *
     * @param addressCityName
     *            City
     */
    public void setAddressCityName( @Nullable final String addressCityName )
    {
        rememberChangedField("AddressCityName", this.addressCityName);
        this.addressCityName = addressCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AddressFaxNumber</b>
     * </p>
     *
     * @param addressFaxNumber
     *            First Fax No.: Area Code + Number
     */
    public void setAddressFaxNumber( @Nullable final String addressFaxNumber )
    {
        rememberChangedField("AddressFaxNumber", this.addressFaxNumber);
        this.addressFaxNumber = addressFaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressHouseNumber</b>
     * </p>
     *
     * @param addressHouseNumber
     *            House Number
     */
    public void setAddressHouseNumber( @Nullable final String addressHouseNumber )
    {
        rememberChangedField("AddressHouseNumber", this.addressHouseNumber);
        this.addressHouseNumber = addressHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AddressName</b>
     * </p>
     *
     * @param addressName
     *            Name 1
     */
    public void setAddressName( @Nullable final String addressName )
    {
        rememberChangedField("AddressName", this.addressName);
        this.addressName = addressName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressPostalCode</b>
     * </p>
     *
     * @param addressPostalCode
     *            City Postal Code
     */
    public void setAddressPostalCode( @Nullable final String addressPostalCode )
    {
        rememberChangedField("AddressPostalCode", this.addressPostalCode);
        this.addressPostalCode = addressPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AddressStreetName</b>
     * </p>
     *
     * @param addressStreetName
     *            Street
     */
    public void setAddressStreetName( @Nullable final String addressStreetName )
    {
        rememberChangedField("AddressStreetName", this.addressStreetName);
        this.addressStreetName = addressStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AddressPhoneNumber</b>
     * </p>
     *
     * @param addressPhoneNumber
     *            First Telephone No.: Dialing Code + Number
     */
    public void setAddressPhoneNumber( @Nullable final String addressPhoneNumber )
    {
        rememberChangedField("AddressPhoneNumber", this.addressPhoneNumber);
        this.addressPhoneNumber = addressPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AddressRegion</b>
     * </p>
     *
     * @param addressRegion
     *            Region (State, Province, County)
     */
    public void setAddressRegion( @Nullable final String addressRegion )
    {
        rememberChangedField("AddressRegion", this.addressRegion);
        this.addressRegion = addressRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AddressCountry</b>
     * </p>
     *
     * @param addressCountry
     *            Country/Region Key
     */
    public void setAddressCountry( @Nullable final String addressCountry )
    {
        rememberChangedField("AddressCountry", this.addressCountry);
        this.addressCountry = addressCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AddressCorrespondenceLanguage</b>
     * </p>
     *
     * @param addressCorrespondenceLanguage
     *            Language Key
     */
    public void setAddressCorrespondenceLanguage( @Nullable final String addressCorrespondenceLanguage )
    {
        rememberChangedField("AddressCorrespondenceLanguage", this.addressCorrespondenceLanguage);
        this.addressCorrespondenceLanguage = addressCorrespondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdProdCmplncSuplrSts</b>
     * </p>
     *
     * @param purgAggrgdProdCmplncSuplrSts
     *            Product Compliance Supplier Check Status (All Items)
     */
    public void setPurgAggrgdProdCmplncSuplrSts( @Nullable final String purgAggrgdProdCmplncSuplrSts )
    {
        rememberChangedField("PurgAggrgdProdCmplncSuplrSts", this.purgAggrgdProdCmplncSuplrSts);
        this.purgAggrgdProdCmplncSuplrSts = purgAggrgdProdCmplncSuplrSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdProdMarketabilitySts</b>
     * </p>
     *
     * @param purgAggrgdProdMarketabilitySts
     *            Product Marketability Status (All Items)
     */
    public void setPurgAggrgdProdMarketabilitySts( @Nullable final String purgAggrgdProdMarketabilitySts )
    {
        rememberChangedField("PurgAggrgdProdMarketabilitySts", this.purgAggrgdProdMarketabilitySts);
        this.purgAggrgdProdMarketabilitySts = purgAggrgdProdMarketabilitySts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgAggrgdSftyDataSheetStatus</b>
     * </p>
     *
     * @param purgAggrgdSftyDataSheetStatus
     *            Safety Data Sheet Status (All Items)
     */
    public void setPurgAggrgdSftyDataSheetStatus( @Nullable final String purgAggrgdSftyDataSheetStatus )
    {
        rememberChangedField("PurgAggrgdSftyDataSheetStatus", this.purgAggrgdSftyDataSheetStatus);
        this.purgAggrgdSftyDataSheetStatus = purgAggrgdSftyDataSheetStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncTotDngrsGoodsSts</b>
     * </p>
     *
     * @param purgProdCmplncTotDngrsGoodsSts
     *            Dangerous Goods Status (All Items)
     */
    public void setPurgProdCmplncTotDngrsGoodsSts( @Nullable final String purgProdCmplncTotDngrsGoodsSts )
    {
        rememberChangedField("PurgProdCmplncTotDngrsGoodsSts", this.purgProdCmplncTotDngrsGoodsSts);
        this.purgProdCmplncTotDngrsGoodsSts = purgProdCmplncTotDngrsGoodsSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseOrder", getPurchaseOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchaseOrderType", getPurchaseOrderType());
        values.put("PurchasingDocumentDeletionCode", getPurchasingDocumentDeletionCode());
        values.put("PurchasingProcessingStatus", getPurchasingProcessingStatus());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Supplier", getSupplier());
        values.put("PurchaseOrderSubtype", getPurchaseOrderSubtype());
        values.put("Language", getLanguage());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingDocumentOrigin", getPurchasingDocumentOrigin());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchaseOrderDate", getPurchaseOrderDate());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("SupplierQuotationExternalID", getSupplierQuotationExternalID());
        values.put("PurchasingCollectiveNumber", getPurchasingCollectiveNumber());
        values.put("SupplierRespSalesPersonName", getSupplierRespSalesPersonName());
        values.put("SupplierPhoneNumber", getSupplierPhoneNumber());
        values.put("SupplyingSupplier", getSupplyingSupplier());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("CorrespncExternalReference", getCorrespncExternalReference());
        values.put("CorrespncInternalReference", getCorrespncInternalReference());
        values.put("InvoicingParty", getInvoicingParty());
        values.put("ReleaseIsNotCompleted", getReleaseIsNotCompleted());
        values.put("PurchasingCompletenessStatus", getPurchasingCompletenessStatus());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("ManualSupplierAddressID", getManualSupplierAddressID());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        values.put("AddressCityName", getAddressCityName());
        values.put("AddressFaxNumber", getAddressFaxNumber());
        values.put("AddressHouseNumber", getAddressHouseNumber());
        values.put("AddressName", getAddressName());
        values.put("AddressPostalCode", getAddressPostalCode());
        values.put("AddressStreetName", getAddressStreetName());
        values.put("AddressPhoneNumber", getAddressPhoneNumber());
        values.put("AddressRegion", getAddressRegion());
        values.put("AddressCountry", getAddressCountry());
        values.put("AddressCorrespondenceLanguage", getAddressCorrespondenceLanguage());
        values.put("PurgAggrgdProdCmplncSuplrSts", getPurgAggrgdProdCmplncSuplrSts());
        values.put("PurgAggrgdProdMarketabilitySts", getPurgAggrgdProdMarketabilitySts());
        values.put("PurgAggrgdSftyDataSheetStatus", getPurgAggrgdSftyDataSheetStatus());
        values.put("PurgProdCmplncTotDngrsGoodsSts", getPurgProdCmplncTotDngrsGoodsSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderType") ) {
                final Object value = values.remove("PurchaseOrderType");
                if( (value == null) || (!value.equals(getPurchaseOrderType())) ) {
                    setPurchaseOrderType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDeletionCode") ) {
                final Object value = values.remove("PurchasingDocumentDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingDocumentDeletionCode())) ) {
                    setPurchasingDocumentDeletionCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingProcessingStatus") ) {
                final Object value = values.remove("PurchasingProcessingStatus");
                if( (value == null) || (!value.equals(getPurchasingProcessingStatus())) ) {
                    setPurchasingProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderSubtype") ) {
                final Object value = values.remove("PurchaseOrderSubtype");
                if( (value == null) || (!value.equals(getPurchaseOrderSubtype())) ) {
                    setPurchaseOrderSubtype(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentOrigin") ) {
                final Object value = values.remove("PurchasingDocumentOrigin");
                if( (value == null) || (!value.equals(getPurchasingDocumentOrigin())) ) {
                    setPurchasingDocumentOrigin(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderDate") ) {
                final Object value = values.remove("PurchaseOrderDate");
                if( (value == null) || (!value.equals(getPurchaseOrderDate())) ) {
                    setPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SupplierQuotationExternalID") ) {
                final Object value = values.remove("SupplierQuotationExternalID");
                if( (value == null) || (!value.equals(getSupplierQuotationExternalID())) ) {
                    setSupplierQuotationExternalID(((String) value));
                }
            }
            if( values.containsKey("PurchasingCollectiveNumber") ) {
                final Object value = values.remove("PurchasingCollectiveNumber");
                if( (value == null) || (!value.equals(getPurchasingCollectiveNumber())) ) {
                    setPurchasingCollectiveNumber(((String) value));
                }
            }
            if( values.containsKey("SupplierRespSalesPersonName") ) {
                final Object value = values.remove("SupplierRespSalesPersonName");
                if( (value == null) || (!value.equals(getSupplierRespSalesPersonName())) ) {
                    setSupplierRespSalesPersonName(((String) value));
                }
            }
            if( values.containsKey("SupplierPhoneNumber") ) {
                final Object value = values.remove("SupplierPhoneNumber");
                if( (value == null) || (!value.equals(getSupplierPhoneNumber())) ) {
                    setSupplierPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("SupplyingSupplier") ) {
                final Object value = values.remove("SupplyingSupplier");
                if( (value == null) || (!value.equals(getSupplyingSupplier())) ) {
                    setSupplyingSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("CorrespncExternalReference") ) {
                final Object value = values.remove("CorrespncExternalReference");
                if( (value == null) || (!value.equals(getCorrespncExternalReference())) ) {
                    setCorrespncExternalReference(((String) value));
                }
            }
            if( values.containsKey("CorrespncInternalReference") ) {
                final Object value = values.remove("CorrespncInternalReference");
                if( (value == null) || (!value.equals(getCorrespncInternalReference())) ) {
                    setCorrespncInternalReference(((String) value));
                }
            }
            if( values.containsKey("InvoicingParty") ) {
                final Object value = values.remove("InvoicingParty");
                if( (value == null) || (!value.equals(getInvoicingParty())) ) {
                    setInvoicingParty(((String) value));
                }
            }
            if( values.containsKey("ReleaseIsNotCompleted") ) {
                final Object value = values.remove("ReleaseIsNotCompleted");
                if( (value == null) || (!value.equals(getReleaseIsNotCompleted())) ) {
                    setReleaseIsNotCompleted(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingCompletenessStatus") ) {
                final Object value = values.remove("PurchasingCompletenessStatus");
                if( (value == null) || (!value.equals(getPurchasingCompletenessStatus())) ) {
                    setPurchasingCompletenessStatus(((Boolean) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("ManualSupplierAddressID") ) {
                final Object value = values.remove("ManualSupplierAddressID");
                if( (value == null) || (!value.equals(getManualSupplierAddressID())) ) {
                    setManualSupplierAddressID(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
            if( values.containsKey("AddressCityName") ) {
                final Object value = values.remove("AddressCityName");
                if( (value == null) || (!value.equals(getAddressCityName())) ) {
                    setAddressCityName(((String) value));
                }
            }
            if( values.containsKey("AddressFaxNumber") ) {
                final Object value = values.remove("AddressFaxNumber");
                if( (value == null) || (!value.equals(getAddressFaxNumber())) ) {
                    setAddressFaxNumber(((String) value));
                }
            }
            if( values.containsKey("AddressHouseNumber") ) {
                final Object value = values.remove("AddressHouseNumber");
                if( (value == null) || (!value.equals(getAddressHouseNumber())) ) {
                    setAddressHouseNumber(((String) value));
                }
            }
            if( values.containsKey("AddressName") ) {
                final Object value = values.remove("AddressName");
                if( (value == null) || (!value.equals(getAddressName())) ) {
                    setAddressName(((String) value));
                }
            }
            if( values.containsKey("AddressPostalCode") ) {
                final Object value = values.remove("AddressPostalCode");
                if( (value == null) || (!value.equals(getAddressPostalCode())) ) {
                    setAddressPostalCode(((String) value));
                }
            }
            if( values.containsKey("AddressStreetName") ) {
                final Object value = values.remove("AddressStreetName");
                if( (value == null) || (!value.equals(getAddressStreetName())) ) {
                    setAddressStreetName(((String) value));
                }
            }
            if( values.containsKey("AddressPhoneNumber") ) {
                final Object value = values.remove("AddressPhoneNumber");
                if( (value == null) || (!value.equals(getAddressPhoneNumber())) ) {
                    setAddressPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("AddressRegion") ) {
                final Object value = values.remove("AddressRegion");
                if( (value == null) || (!value.equals(getAddressRegion())) ) {
                    setAddressRegion(((String) value));
                }
            }
            if( values.containsKey("AddressCountry") ) {
                final Object value = values.remove("AddressCountry");
                if( (value == null) || (!value.equals(getAddressCountry())) ) {
                    setAddressCountry(((String) value));
                }
            }
            if( values.containsKey("AddressCorrespondenceLanguage") ) {
                final Object value = values.remove("AddressCorrespondenceLanguage");
                if( (value == null) || (!value.equals(getAddressCorrespondenceLanguage())) ) {
                    setAddressCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("PurgAggrgdProdCmplncSuplrSts") ) {
                final Object value = values.remove("PurgAggrgdProdCmplncSuplrSts");
                if( (value == null) || (!value.equals(getPurgAggrgdProdCmplncSuplrSts())) ) {
                    setPurgAggrgdProdCmplncSuplrSts(((String) value));
                }
            }
            if( values.containsKey("PurgAggrgdProdMarketabilitySts") ) {
                final Object value = values.remove("PurgAggrgdProdMarketabilitySts");
                if( (value == null) || (!value.equals(getPurgAggrgdProdMarketabilitySts())) ) {
                    setPurgAggrgdProdMarketabilitySts(((String) value));
                }
            }
            if( values.containsKey("PurgAggrgdSftyDataSheetStatus") ) {
                final Object value = values.remove("PurgAggrgdSftyDataSheetStatus");
                if( (value == null) || (!value.equals(getPurgAggrgdSftyDataSheetStatus())) ) {
                    setPurgAggrgdSftyDataSheetStatus(((String) value));
                }
            }
            if( values.containsKey("PurgProdCmplncTotDngrsGoodsSts") ) {
                final Object value = values.remove("PurgProdCmplncTotDngrsGoodsSts");
                if( (value == null) || (!value.equals(getPurgProdCmplncTotDngrsGoodsSts())) ) {
                    setPurgProdCmplncTotDngrsGoodsSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchaseOrderItem") ) {
                final Object value = (values).remove("to_PurchaseOrderItem");
                if( value instanceof Iterable ) {
                    if( toPurchaseOrderItem == null ) {
                        toPurchaseOrderItem = Lists.newArrayList();
                    } else {
                        toPurchaseOrderItem = Lists.newArrayList(toPurchaseOrderItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseOrderItem entity;
                        if( toPurchaseOrderItem.size() > i ) {
                            entity = toPurchaseOrderItem.get(i);
                        } else {
                            entity = new PurchaseOrderItem();
                            toPurchaseOrderItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurchaseOrderNote") ) {
                final Object value = (values).remove("to_PurchaseOrderNote");
                if( value instanceof Iterable ) {
                    if( toPurchaseOrderNote == null ) {
                        toPurchaseOrderNote = Lists.newArrayList();
                    } else {
                        toPurchaseOrderNote = Lists.newArrayList(toPurchaseOrderNote);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseOrderNote entity;
                        if( toPurchaseOrderNote.size() > i ) {
                            entity = toPurchaseOrderNote.get(i);
                        } else {
                            entity = new PurchaseOrderNote();
                            toPurchaseOrderNote.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PurchaseOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchaseOrderItem != null ) {
            (values).put("to_PurchaseOrderItem", toPurchaseOrderItem);
        }
        if( toPurchaseOrderNote != null ) {
            (values).put("to_PurchaseOrderNote", toPurchaseOrderNote);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchaseOrderItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseOrderItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderItem> fetchPurchaseOrderItem()
    {
        return fetchFieldAsList("to_PurchaseOrderItem", PurchaseOrderItem.class);
    }

    /**
     * Retrieval of associated <b>PurchaseOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurchaseOrderItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderItem</b> of a queried <b>PurchaseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseOrderItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderItem> getPurchaseOrderItemOrFetch()
    {
        if( toPurchaseOrderItem == null ) {
            toPurchaseOrderItem = fetchPurchaseOrderItem();
        }
        return toPurchaseOrderItem;
    }

    /**
     * Retrieval of associated <b>PurchaseOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurchaseOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseOrderItem</b> is already loaded, the result will
     *         contain the <b>PurchaseOrderItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseOrderItem>> getPurchaseOrderItemIfPresent()
    {
        return Option.of(toPurchaseOrderItem);
    }

    /**
     * Overwrites the list of associated <b>PurchaseOrderItem</b> entities for the loaded navigation property
     * <b>to_PurchaseOrderItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderItem</b> of a queried <b>PurchaseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseOrderItem</b> entities.
     */
    public void setPurchaseOrderItem( @Nonnull final List<PurchaseOrderItem> value )
    {
        if( toPurchaseOrderItem == null ) {
            toPurchaseOrderItem = Lists.newArrayList();
        }
        toPurchaseOrderItem.clear();
        toPurchaseOrderItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseOrderItem</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseOrderItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderItem</b> of a queried <b>PurchaseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseOrderItem</b> entities.
     */
    public void addPurchaseOrderItem( PurchaseOrderItem... entity )
    {
        if( toPurchaseOrderItem == null ) {
            toPurchaseOrderItem = Lists.newArrayList();
        }
        toPurchaseOrderItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurchaseOrderNote</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseOrderNote</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseOrderNote</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderNote> fetchPurchaseOrderNote()
    {
        return fetchFieldAsList("to_PurchaseOrderNote", PurchaseOrderNote.class);
    }

    /**
     * Retrieval of associated <b>PurchaseOrderNote</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurchaseOrderNote</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderNote</b> of a queried <b>PurchaseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseOrderNote</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderNote> getPurchaseOrderNoteOrFetch()
    {
        if( toPurchaseOrderNote == null ) {
            toPurchaseOrderNote = fetchPurchaseOrderNote();
        }
        return toPurchaseOrderNote;
    }

    /**
     * Retrieval of associated <b>PurchaseOrderNote</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurchaseOrderNote</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseOrderNote</b> is already loaded, the result will
     *         contain the <b>PurchaseOrderNote</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseOrderNote>> getPurchaseOrderNoteIfPresent()
    {
        return Option.of(toPurchaseOrderNote);
    }

    /**
     * Overwrites the list of associated <b>PurchaseOrderNote</b> entities for the loaded navigation property
     * <b>to_PurchaseOrderNote</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderNote</b> of a queried <b>PurchaseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseOrderNote</b> entities.
     */
    public void setPurchaseOrderNote( @Nonnull final List<PurchaseOrderNote> value )
    {
        if( toPurchaseOrderNote == null ) {
            toPurchaseOrderNote = Lists.newArrayList();
        }
        toPurchaseOrderNote.clear();
        toPurchaseOrderNote.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseOrderNote</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseOrderNote</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderNote</b> of a queried <b>PurchaseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseOrderNote</b> entities.
     */
    public void addPurchaseOrderNote( PurchaseOrderNote... entity )
    {
        if( toPurchaseOrderNote == null ) {
            toPurchaseOrderNote = Lists.newArrayList();
        }
        toPurchaseOrderNote.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchaseOrder instances.
     *
     */
    public final static class PurchaseOrderBuilder
    {

        private List<PurchaseOrderItem> toPurchaseOrderItem = Lists.newArrayList();
        private List<PurchaseOrderNote> toPurchaseOrderNote = Lists.newArrayList();

        private PurchaseOrder.PurchaseOrderBuilder toPurchaseOrderItem( final List<PurchaseOrderItem> value )
        {
            toPurchaseOrderItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseOrderItem</b> for <b>PurchaseOrder</b> to multiple
         * <b>PurchaseOrderItem</b>.
         *
         * @param value
         *            The PurchaseOrderItems to build this PurchaseOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrder.PurchaseOrderBuilder purchaseOrderItem( PurchaseOrderItem... value )
        {
            return toPurchaseOrderItem(Lists.newArrayList(value));
        }

        private PurchaseOrder.PurchaseOrderBuilder toPurchaseOrderNote( final List<PurchaseOrderNote> value )
        {
            toPurchaseOrderNote.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseOrderNote</b> for <b>PurchaseOrder</b> to multiple
         * <b>PurchaseOrderNote</b>.
         *
         * @param value
         *            The PurchaseOrderNotes to build this PurchaseOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrder.PurchaseOrderBuilder purchaseOrderNote( PurchaseOrderNote... value )
        {
            return toPurchaseOrderNote(Lists.newArrayList(value));
        }

    }

}
