/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurchaseOrderItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.PurchaseOrderItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.PurchaseOrderItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.PurchaseOrderItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseOrderItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseOrderItem extends VdmEntity<PurchaseOrderItem>
{

    /**
     * Selector for all available fields of PurchaseOrderItem.
     *
     */
    public final static PurchaseOrderItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchase Order Number
     */
    @Key
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_ORDER =
        new PurchaseOrderItemField<String>("PurchaseOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchase Order
     */
    @Key
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_ORDER_ITEM =
        new PurchaseOrderItemField<String>("PurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingDocumentDeletionCode" )
    @JsonProperty( "PurchasingDocumentDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentDeletionCode" )
    private String purchasingDocumentDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDeletionCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASING_DOCUMENT_DELETION_CODE =
        new PurchaseOrderItemField<String>("PurchasingDocumentDeletionCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "PurchaseOrderItemText" )
    @JsonProperty( "PurchaseOrderItemText" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItemText" )
    private String purchaseOrderItemText;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItemText</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_ORDER_ITEM_TEXT =
        new PurchaseOrderItemField<String>("PurchaseOrderItemText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PLANT = new PurchaseOrderItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> STORAGE_LOCATION =
        new PurchaseOrderItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> MATERIAL_GROUP =
        new PurchaseOrderItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASING_INFO_RECORD =
        new PurchaseOrderItemField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> SUPPLIER_MATERIAL_NUMBER =
        new PurchaseOrderItemField<String>("SupplierMaterialNumber");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantity</b>
     * </p>
     *
     * @return Purchase Order Quantity
     */
    @SerializedName( "OrderQuantity" )
    @JsonProperty( "OrderQuantity" )
    @Nullable
    @ODataField( odataName = "OrderQuantity" )
    private BigDecimal orderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantity</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> ORDER_QUANTITY =
        new PurchaseOrderItemField<BigDecimal>("OrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQuantityUnit" )
    @JsonProperty( "PurchaseOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQuantityUnit" )
    private String purchaseOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_ORDER_QUANTITY_UNIT =
        new PurchaseOrderItemField<String>("PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "OrderPriceUnit" )
    @JsonProperty( "OrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnit" )
    private String orderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnit</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> ORDER_PRICE_UNIT =
        new PurchaseOrderItemField<String>("OrderPriceUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Price Unit into Order Unit
     */
    @SerializedName( "OrderPriceUnitToOrderUnitNmrtr" )
    @JsonProperty( "OrderPriceUnitToOrderUnitNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderPriceUnitToOrderUnitNmrtr" )
    private BigDecimal orderPriceUnitToOrderUnitNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderPriceUnitToOrderUnitNmrtr</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> ORDER_PRICE_UNIT_TO_ORDER_UNIT_NMRTR =
        new PurchaseOrderItemField<BigDecimal>("OrderPriceUnitToOrderUnitNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @return Denominator for Conv. of Order Price Unit into Order Unit
     */
    @SerializedName( "OrdPriceUnitToOrderUnitDnmntr" )
    @JsonProperty( "OrdPriceUnitToOrderUnitDnmntr" )
    @Nullable
    @ODataField( odataName = "OrdPriceUnitToOrderUnitDnmntr" )
    private BigDecimal ordPriceUnitToOrderUnitDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrdPriceUnitToOrderUnitDnmntr</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> ORD_PRICE_UNIT_TO_ORDER_UNIT_DNMNTR =
        new PurchaseOrderItemField<BigDecimal>("OrdPriceUnitToOrderUnitDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DOCUMENT_CURRENCY =
        new PurchaseOrderItemField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Net Price in Purchasing Document (in Document Currency)
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> NET_PRICE_AMOUNT =
        new PurchaseOrderItemField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @return Price Unit
     */
    @SerializedName( "NetPriceQuantity" )
    @JsonProperty( "NetPriceQuantity" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantity" )
    private BigDecimal netPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantity</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> NET_PRICE_QUANTITY =
        new PurchaseOrderItemField<BigDecimal>("NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> TAX_CODE = new PurchaseOrderItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @return Shipping Instructions
     */
    @SerializedName( "ShippingInstruction" )
    @JsonProperty( "ShippingInstruction" )
    @Nullable
    @ODataField( odataName = "ShippingInstruction" )
    private String shippingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>ShippingInstruction</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> SHIPPING_INSTRUCTION =
        new PurchaseOrderItemField<String>("ShippingInstruction");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @return Date for Determining Tax Rates
     */
    @SerializedName( "TaxDeterminationDate" )
    @JsonProperty( "TaxDeterminationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TaxDeterminationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime taxDeterminationDate;
    /**
     * Use with available fluent helpers to apply the <b>TaxDeterminationDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<LocalDateTime> TAX_DETERMINATION_DATE =
        new PurchaseOrderItemField<LocalDateTime>("TaxDeterminationDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> TAX_COUNTRY = new PurchaseOrderItemField<String>("TaxCountry");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @return Price Printout
     */
    @SerializedName( "PriceIsToBePrinted" )
    @JsonProperty( "PriceIsToBePrinted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PriceIsToBePrinted" )
    private Boolean priceIsToBePrinted;
    /**
     * Use with available fluent helpers to apply the <b>PriceIsToBePrinted</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> PRICE_IS_TO_BE_PRINTED =
        new PurchaseOrderItemField<Boolean>("PriceIsToBePrinted");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdelivery Tolerance
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new PurchaseOrderItemField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new PurchaseOrderItemField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdelivery Tolerance
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new PurchaseOrderItemField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @return Valuation Type
     */
    @SerializedName( "ValuationType" )
    @JsonProperty( "ValuationType" )
    @Nullable
    @ODataField( odataName = "ValuationType" )
    private String valuationType;
    /**
     * Use with available fluent helpers to apply the <b>ValuationType</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> VALUATION_TYPE =
        new PurchaseOrderItemField<String>("ValuationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @return "Delivery Completed" Indicator
     */
    @SerializedName( "IsCompletelyDelivered" )
    @JsonProperty( "IsCompletelyDelivered" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCompletelyDelivered" )
    private Boolean isCompletelyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>IsCompletelyDelivered</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> IS_COMPLETELY_DELIVERED =
        new PurchaseOrderItemField<Boolean>("IsCompletelyDelivered");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinallyInvoiced</b>
     * </p>
     *
     * @return Final Invoice Indicator
     */
    @SerializedName( "IsFinallyInvoiced" )
    @JsonProperty( "IsFinallyInvoiced" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFinallyInvoiced" )
    private Boolean isFinallyInvoiced;
    /**
     * Use with available fluent helpers to apply the <b>IsFinallyInvoiced</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> IS_FINALLY_INVOICED =
        new PurchaseOrderItemField<Boolean>("IsFinallyInvoiced");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchaseOrderItemCategory" )
    @JsonProperty( "PurchaseOrderItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItemCategory" )
    private String purchaseOrderItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItemCategory</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_ORDER_ITEM_CATEGORY =
        new PurchaseOrderItemField<String>("PurchaseOrderItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new PurchaseOrderItemField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @return Distribution Indicator for Multiple Account Assignment
     */
    @SerializedName( "MultipleAcctAssgmtDistribution" )
    @JsonProperty( "MultipleAcctAssgmtDistribution" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistribution" )
    private String multipleAcctAssgmtDistribution;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistribution</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> MULTIPLE_ACCT_ASSGMT_DISTRIBUTION =
        new PurchaseOrderItemField<String>("MultipleAcctAssgmtDistribution");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialInvoiceDistribution</b>
     * </p>
     *
     * @return Partial invoice indicator
     */
    @SerializedName( "PartialInvoiceDistribution" )
    @JsonProperty( "PartialInvoiceDistribution" )
    @Nullable
    @ODataField( odataName = "PartialInvoiceDistribution" )
    private String partialInvoiceDistribution;
    /**
     * Use with available fluent helpers to apply the <b>PartialInvoiceDistribution</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PARTIAL_INVOICE_DISTRIBUTION =
        new PurchaseOrderItemField<String>("PartialInvoiceDistribution");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @return Goods Receipt Indicator
     */
    @SerializedName( "GoodsReceiptIsExpected" )
    @JsonProperty( "GoodsReceiptIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsExpected" )
    private Boolean goodsReceiptIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsExpected</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> GOODS_RECEIPT_IS_EXPECTED =
        new PurchaseOrderItemField<Boolean>("GoodsReceiptIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @return Goods Receipt, Non-Valuated
     */
    @SerializedName( "GoodsReceiptIsNonValuated" )
    @JsonProperty( "GoodsReceiptIsNonValuated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsNonValuated" )
    private Boolean goodsReceiptIsNonValuated;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsNonValuated</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> GOODS_RECEIPT_IS_NON_VALUATED =
        new PurchaseOrderItemField<Boolean>("GoodsReceiptIsNonValuated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @return Invoice Receipt Indicator
     */
    @SerializedName( "InvoiceIsExpected" )
    @JsonProperty( "InvoiceIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsExpected" )
    private Boolean invoiceIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsExpected</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> INVOICE_IS_EXPECTED =
        new PurchaseOrderItemField<Boolean>("InvoiceIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @return Indicator: GR-Based Invoice Verification
     */
    @SerializedName( "InvoiceIsGoodsReceiptBased" )
    @JsonProperty( "InvoiceIsGoodsReceiptBased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsGoodsReceiptBased" )
    private Boolean invoiceIsGoodsReceiptBased;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsGoodsReceiptBased</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> INVOICE_IS_GOODS_RECEIPT_BASED =
        new PurchaseOrderItemField<Boolean>("InvoiceIsGoodsReceiptBased");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Number of principal purchase agreement
     */
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_CONTRACT =
        new PurchaseOrderItemField<String>("PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Principal Purchase Agreement
     */
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_CONTRACT_ITEM =
        new PurchaseOrderItemField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> CUSTOMER = new PurchaseOrderItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Subcontractor</b>
     * </p>
     *
     * @return Supplier to be Supplied/Who is to Receive Delivery
     */
    @SerializedName( "Subcontractor" )
    @JsonProperty( "Subcontractor" )
    @Nullable
    @ODataField( odataName = "Subcontractor" )
    private String subcontractor;
    /**
     * Use with available fluent helpers to apply the <b>Subcontractor</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> SUBCONTRACTOR =
        new PurchaseOrderItemField<String>("Subcontractor");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierIsSubcontractor</b>
     * </p>
     *
     * @return Subcontracting Supplier
     */
    @SerializedName( "SupplierIsSubcontractor" )
    @JsonProperty( "SupplierIsSubcontractor" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SupplierIsSubcontractor" )
    private Boolean supplierIsSubcontractor;
    /**
     * Use with available fluent helpers to apply the <b>SupplierIsSubcontractor</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> SUPPLIER_IS_SUBCONTRACTOR =
        new PurchaseOrderItemField<Boolean>("SupplierIsSubcontractor");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> ITEM_NET_WEIGHT =
        new PurchaseOrderItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> ITEM_WEIGHT_UNIT =
        new PurchaseOrderItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> TAX_JURISDICTION =
        new PurchaseOrderItemField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateControl</b>
     * </p>
     *
     * @return Price Determination (Pricing) Date Control
     */
    @SerializedName( "PricingDateControl" )
    @JsonProperty( "PricingDateControl" )
    @Nullable
    @ODataField( odataName = "PricingDateControl" )
    private String pricingDateControl;
    /**
     * Use with available fluent helpers to apply the <b>PricingDateControl</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PRICING_DATE_CONTROL =
        new PurchaseOrderItemField<String>("PricingDateControl");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> ITEM_VOLUME =
        new PurchaseOrderItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> ITEM_VOLUME_UNIT =
        new PurchaseOrderItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierConfirmationControlKey</b>
     * </p>
     *
     * @return Confirmation Control Key
     */
    @SerializedName( "SupplierConfirmationControlKey" )
    @JsonProperty( "SupplierConfirmationControlKey" )
    @Nullable
    @ODataField( odataName = "SupplierConfirmationControlKey" )
    private String supplierConfirmationControlKey;
    /**
     * Use with available fluent helpers to apply the <b>SupplierConfirmationControlKey</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> SUPPLIER_CONFIRMATION_CONTROL_KEY =
        new PurchaseOrderItemField<String>("SupplierConfirmationControlKey");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> INCOTERMS_CLASSIFICATION =
        new PurchaseOrderItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new PurchaseOrderItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @return Evaluated Receipt Settlement (ERS)
     */
    @SerializedName( "EvaldRcptSettlmtIsAllowed" )
    @JsonProperty( "EvaldRcptSettlmtIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EvaldRcptSettlmtIsAllowed" )
    private Boolean evaldRcptSettlmtIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>EvaldRcptSettlmtIsAllowed</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> EVALD_RCPT_SETTLMT_IS_ALLOWED =
        new PurchaseOrderItemField<Boolean>("EvaldRcptSettlmtIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_REQUISITION =
        new PurchaseOrderItemField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASE_REQUISITION_ITEM =
        new PurchaseOrderItemField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReturnsItem</b>
     * </p>
     *
     * @return Returns Item
     */
    @SerializedName( "IsReturnsItem" )
    @JsonProperty( "IsReturnsItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReturnsItem" )
    private Boolean isReturnsItem;
    /**
     * Use with available fluent helpers to apply the <b>IsReturnsItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> IS_RETURNS_ITEM =
        new PurchaseOrderItemField<Boolean>("IsReturnsItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RequisitionerName</b>
     * </p>
     *
     * @return Name of requisitioner/requester
     */
    @SerializedName( "RequisitionerName" )
    @JsonProperty( "RequisitionerName" )
    @Nullable
    @ODataField( odataName = "RequisitionerName" )
    private String requisitionerName;
    /**
     * Use with available fluent helpers to apply the <b>RequisitionerName</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> REQUISITIONER_NAME =
        new PurchaseOrderItemField<String>("RequisitionerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePackage</b>
     * </p>
     *
     * @return Package number
     */
    @SerializedName( "ServicePackage" )
    @JsonProperty( "ServicePackage" )
    @Nullable
    @ODataField( odataName = "ServicePackage" )
    private String servicePackage;
    /**
     * Use with available fluent helpers to apply the <b>ServicePackage</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> SERVICE_PACKAGE =
        new PurchaseOrderItemField<String>("ServicePackage");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFunds</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFunds" )
    @JsonProperty( "EarmarkedFunds" )
    @Nullable
    @ODataField( odataName = "EarmarkedFunds" )
    private String earmarkedFunds;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFunds</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> EARMARKED_FUNDS =
        new PurchaseOrderItemField<String>("EarmarkedFunds");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> EARMARKED_FUNDS_DOCUMENT =
        new PurchaseOrderItemField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsItem</b>
     * </p>
     *
     * @return Earmarked Funds: Document Item
     */
    @SerializedName( "EarmarkedFundsItem" )
    @JsonProperty( "EarmarkedFundsItem" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsItem" )
    private String earmarkedFundsItem;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> EARMARKED_FUNDS_ITEM =
        new PurchaseOrderItemField<String>("EarmarkedFundsItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentItem</b>
     * </p>
     *
     * @return Earmarked Funds: Document Item
     */
    @SerializedName( "EarmarkedFundsDocumentItem" )
    @JsonProperty( "EarmarkedFundsDocumentItem" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocumentItem" )
    private String earmarkedFundsDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocumentItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> EARMARKED_FUNDS_DOCUMENT_ITEM =
        new PurchaseOrderItemField<String>("EarmarkedFundsDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> INCOTERMS_LOCATION1 =
        new PurchaseOrderItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> INCOTERMS_LOCATION2 =
        new PurchaseOrderItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> MATERIAL = new PurchaseOrderItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @return International Article Number (EAN/UPC)
     */
    @SerializedName( "InternationalArticleNumber" )
    @JsonProperty( "InternationalArticleNumber" )
    @Nullable
    @ODataField( odataName = "InternationalArticleNumber" )
    private String internationalArticleNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternationalArticleNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> INTERNATIONAL_ARTICLE_NUMBER =
        new PurchaseOrderItemField<String>("InternationalArticleNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @return Material number
     */
    @SerializedName( "ManufacturerMaterial" )
    @JsonProperty( "ManufacturerMaterial" )
    @Nullable
    @ODataField( odataName = "ManufacturerMaterial" )
    private String manufacturerMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerMaterial</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> MANUFACTURER_MATERIAL =
        new PurchaseOrderItemField<String>("ManufacturerMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Service Performer
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> SERVICE_PERFORMER =
        new PurchaseOrderItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PRODUCT_TYPE = new PurchaseOrderItemField<String>("ProductType");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedOverallLimitAmount</b>
     * </p>
     *
     * @return Expected Value of Overall Limit
     */
    @SerializedName( "ExpectedOverallLimitAmount" )
    @JsonProperty( "ExpectedOverallLimitAmount" )
    @Nullable
    @ODataField( odataName = "ExpectedOverallLimitAmount" )
    private BigDecimal expectedOverallLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>ExpectedOverallLimitAmount</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> EXPECTED_OVERALL_LIMIT_AMOUNT =
        new PurchaseOrderItemField<BigDecimal>("ExpectedOverallLimitAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverallLimitAmount</b>
     * </p>
     *
     * @return Overall Limit
     */
    @SerializedName( "OverallLimitAmount" )
    @JsonProperty( "OverallLimitAmount" )
    @Nullable
    @ODataField( odataName = "OverallLimitAmount" )
    private BigDecimal overallLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>OverallLimitAmount</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> OVERALL_LIMIT_AMOUNT =
        new PurchaseOrderItemField<BigDecimal>("OverallLimitAmount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurContractForOverallLimit</b>
     * </p>
     *
     * @return Purchase Contract for Enhanced Limit
     */
    @SerializedName( "PurContractForOverallLimit" )
    @JsonProperty( "PurContractForOverallLimit" )
    @Nullable
    @ODataField( odataName = "PurContractForOverallLimit" )
    private String purContractForOverallLimit;
    /**
     * Use with available fluent helpers to apply the <b>PurContractForOverallLimit</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PUR_CONTRACT_FOR_OVERALL_LIMIT =
        new PurchaseOrderItemField<String>("PurContractForOverallLimit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentItem</b>
     * </p>
     *
     * @return Higher-Level Item in Purchasing Documents
     */
    @SerializedName( "PurchasingParentItem" )
    @JsonProperty( "PurchasingParentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingParentItem" )
    private String purchasingParentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingParentItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURCHASING_PARENT_ITEM =
        new PurchaseOrderItemField<String>("PurchasingParentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> BATCH = new PurchaseOrderItemField<String>("Batch");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingItemIsFreeOfCharge</b>
     * </p>
     *
     * @return Free Item
     */
    @SerializedName( "PurchasingItemIsFreeOfCharge" )
    @JsonProperty( "PurchasingItemIsFreeOfCharge" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurchasingItemIsFreeOfCharge" )
    private Boolean purchasingItemIsFreeOfCharge;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingItemIsFreeOfCharge</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> PURCHASING_ITEM_IS_FREE_OF_CHARGE =
        new PurchaseOrderItemField<Boolean>("PurchasingItemIsFreeOfCharge");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @return Number of delivery address
     */
    @SerializedName( "ReferenceDeliveryAddressID" )
    @JsonProperty( "ReferenceDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ReferenceDeliveryAddressID" )
    private String referenceDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> REFERENCE_DELIVERY_ADDRESS_ID =
        new PurchaseOrderItemField<String>("ReferenceDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "DeliveryAddressID" )
    @JsonProperty( "DeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressID" )
    private String deliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_ID =
        new PurchaseOrderItemField<String>("DeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressName</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "DeliveryAddressName" )
    @JsonProperty( "DeliveryAddressName" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressName" )
    private String deliveryAddressName;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressName</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_NAME =
        new PurchaseOrderItemField<String>("DeliveryAddressName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "DeliveryAddressName2" )
    @JsonProperty( "DeliveryAddressName2" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressName2" )
    private String deliveryAddressName2;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressName2</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_NAME2 =
        new PurchaseOrderItemField<String>("DeliveryAddressName2");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressFullName</b>
     * </p>
     *
     * @return Full name of a party (Bus. Partner, Org. Unit, Doc. address)
     */
    @SerializedName( "DeliveryAddressFullName" )
    @JsonProperty( "DeliveryAddressFullName" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressFullName" )
    private String deliveryAddressFullName;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressFullName</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_FULL_NAME =
        new PurchaseOrderItemField<String>("DeliveryAddressFullName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressStreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "DeliveryAddressStreetName" )
    @JsonProperty( "DeliveryAddressStreetName" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressStreetName" )
    private String deliveryAddressStreetName;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressStreetName</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_STREET_NAME =
        new PurchaseOrderItemField<String>("DeliveryAddressStreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressHouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "DeliveryAddressHouseNumber" )
    @JsonProperty( "DeliveryAddressHouseNumber" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressHouseNumber" )
    private String deliveryAddressHouseNumber;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressHouseNumber</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_HOUSE_NUMBER =
        new PurchaseOrderItemField<String>("DeliveryAddressHouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressCityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "DeliveryAddressCityName" )
    @JsonProperty( "DeliveryAddressCityName" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressCityName" )
    private String deliveryAddressCityName;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressCityName</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_CITY_NAME =
        new PurchaseOrderItemField<String>("DeliveryAddressCityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressPostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "DeliveryAddressPostalCode" )
    @JsonProperty( "DeliveryAddressPostalCode" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressPostalCode" )
    private String deliveryAddressPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressPostalCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_POSTAL_CODE =
        new PurchaseOrderItemField<String>("DeliveryAddressPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressRegion</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "DeliveryAddressRegion" )
    @JsonProperty( "DeliveryAddressRegion" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressRegion" )
    private String deliveryAddressRegion;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressRegion</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_REGION =
        new PurchaseOrderItemField<String>("DeliveryAddressRegion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressCountry</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "DeliveryAddressCountry" )
    @JsonProperty( "DeliveryAddressCountry" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressCountry" )
    private String deliveryAddressCountry;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressCountry</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_COUNTRY =
        new PurchaseOrderItemField<String>("DeliveryAddressCountry");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressDistrictName</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "DeliveryAddressDistrictName" )
    @JsonProperty( "DeliveryAddressDistrictName" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressDistrictName" )
    private String deliveryAddressDistrictName;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressDistrictName</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DELIVERY_ADDRESS_DISTRICT_NAME =
        new PurchaseOrderItemField<String>("DeliveryAddressDistrictName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentType</b>
     * </p>
     *
     * @return Down Payment Indicator
     */
    @SerializedName( "DownPaymentType" )
    @JsonProperty( "DownPaymentType" )
    @Nullable
    @ODataField( odataName = "DownPaymentType" )
    private String downPaymentType;
    /**
     * Use with available fluent helpers to apply the <b>DownPaymentType</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> DOWN_PAYMENT_TYPE =
        new PurchaseOrderItemField<String>("DownPaymentType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentPercentageOfTotAmt</b>
     * </p>
     *
     * @return Down Payment Percentage
     */
    @SerializedName( "DownPaymentPercentageOfTotAmt" )
    @JsonProperty( "DownPaymentPercentageOfTotAmt" )
    @Nullable
    @ODataField( odataName = "DownPaymentPercentageOfTotAmt" )
    private BigDecimal downPaymentPercentageOfTotAmt;
    /**
     * Use with available fluent helpers to apply the <b>DownPaymentPercentageOfTotAmt</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> DOWN_PAYMENT_PERCENTAGE_OF_TOT_AMT =
        new PurchaseOrderItemField<BigDecimal>("DownPaymentPercentageOfTotAmt");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentAmount</b>
     * </p>
     *
     * @return Down Payment Amount in Document Currency
     */
    @SerializedName( "DownPaymentAmount" )
    @JsonProperty( "DownPaymentAmount" )
    @Nullable
    @ODataField( odataName = "DownPaymentAmount" )
    private BigDecimal downPaymentAmount;
    /**
     * Use with available fluent helpers to apply the <b>DownPaymentAmount</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<BigDecimal> DOWN_PAYMENT_AMOUNT =
        new PurchaseOrderItemField<BigDecimal>("DownPaymentAmount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentDueDate</b>
     * </p>
     *
     * @return Due Date for Down Payment
     */
    @SerializedName( "DownPaymentDueDate" )
    @JsonProperty( "DownPaymentDueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DownPaymentDueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime downPaymentDueDate;
    /**
     * Use with available fluent helpers to apply the <b>DownPaymentDueDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<LocalDateTime> DOWN_PAYMENT_DUE_DATE =
        new PurchaseOrderItemField<LocalDateTime>("DownPaymentDueDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialUsage</b>
     * </p>
     *
     * @return Usage of the material
     */
    @SerializedName( "BR_MaterialUsage" )
    @JsonProperty( "BR_MaterialUsage" )
    @Nullable
    @ODataField( odataName = "BR_MaterialUsage" )
    private String bR_MaterialUsage;
    /**
     * Use with available fluent helpers to apply the <b>BR_MaterialUsage</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> BR_MATERIAL_USAGE =
        new PurchaseOrderItemField<String>("BR_MaterialUsage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialOrigin</b>
     * </p>
     *
     * @return Origin of the material
     */
    @SerializedName( "BR_MaterialOrigin" )
    @JsonProperty( "BR_MaterialOrigin" )
    @Nullable
    @ODataField( odataName = "BR_MaterialOrigin" )
    private String bR_MaterialOrigin;
    /**
     * Use with available fluent helpers to apply the <b>BR_MaterialOrigin</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> BR_MATERIAL_ORIGIN =
        new PurchaseOrderItemField<String>("BR_MaterialOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_CFOPCategory</b>
     * </p>
     *
     * @return Material CFOP category
     */
    @SerializedName( "BR_CFOPCategory" )
    @JsonProperty( "BR_CFOPCategory" )
    @Nullable
    @ODataField( odataName = "BR_CFOPCategory" )
    private String bR_CFOPCategory;
    /**
     * Use with available fluent helpers to apply the <b>BR_CFOPCategory</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> BRCFOP_CATEGORY =
        new PurchaseOrderItemField<String>("BR_CFOPCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_IsProducedInHouse</b>
     * </p>
     *
     * @return Produced in-house
     */
    @SerializedName( "BR_IsProducedInHouse" )
    @JsonProperty( "BR_IsProducedInHouse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BR_IsProducedInHouse" )
    private Boolean bR_IsProducedInHouse;
    /**
     * Use with available fluent helpers to apply the <b>BR_IsProducedInHouse</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<Boolean> BR_IS_PRODUCED_IN_HOUSE =
        new PurchaseOrderItemField<Boolean>("BR_IsProducedInHouse");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @return Brazilian NCM Code
     */
    @SerializedName( "ConsumptionTaxCtrlCode" )
    @JsonProperty( "ConsumptionTaxCtrlCode" )
    @Nullable
    @ODataField( odataName = "ConsumptionTaxCtrlCode" )
    private String consumptionTaxCtrlCode;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionTaxCtrlCode</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> CONSUMPTION_TAX_CTRL_CODE =
        new PurchaseOrderItemField<String>("ConsumptionTaxCtrlCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncSupplierStatus</b>
     * </p>
     *
     * @return Product Compliance Supplier Check Status (Item)
     */
    @SerializedName( "PurgProdCmplncSupplierStatus" )
    @JsonProperty( "PurgProdCmplncSupplierStatus" )
    @Nullable
    @ODataField( odataName = "PurgProdCmplncSupplierStatus" )
    private String purgProdCmplncSupplierStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgProdCmplncSupplierStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURG_PROD_CMPLNC_SUPPLIER_STATUS =
        new PurchaseOrderItemField<String>("PurgProdCmplncSupplierStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProductMarketabilityStatus</b>
     * </p>
     *
     * @return Product Marketability Status (Item)
     */
    @SerializedName( "PurgProductMarketabilityStatus" )
    @JsonProperty( "PurgProductMarketabilityStatus" )
    @Nullable
    @ODataField( odataName = "PurgProductMarketabilityStatus" )
    private String purgProductMarketabilityStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgProductMarketabilityStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURG_PRODUCT_MARKETABILITY_STATUS =
        new PurchaseOrderItemField<String>("PurgProductMarketabilityStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgSafetyDataSheetStatus</b>
     * </p>
     *
     * @return Safety Data Sheet Status (Item)
     */
    @SerializedName( "PurgSafetyDataSheetStatus" )
    @JsonProperty( "PurgSafetyDataSheetStatus" )
    @Nullable
    @ODataField( odataName = "PurgSafetyDataSheetStatus" )
    private String purgSafetyDataSheetStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgSafetyDataSheetStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURG_SAFETY_DATA_SHEET_STATUS =
        new PurchaseOrderItemField<String>("PurgSafetyDataSheetStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncDngrsGoodsStatus</b>
     * </p>
     *
     * @return Dangerous Goods Status (Item)
     */
    @SerializedName( "PurgProdCmplncDngrsGoodsStatus" )
    @JsonProperty( "PurgProdCmplncDngrsGoodsStatus" )
    @Nullable
    @ODataField( odataName = "PurgProdCmplncDngrsGoodsStatus" )
    private String purgProdCmplncDngrsGoodsStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgProdCmplncDngrsGoodsStatus</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemField<String> PURG_PROD_CMPLNC_DNGRS_GOODS_STATUS =
        new PurchaseOrderItemField<String>("PurgProdCmplncDngrsGoodsStatus");
    /**
     * Navigation property <b>to_PurchaseOrder</b> for <b>PurchaseOrderItem</b> to single <b>PurchaseOrder</b>.
     *
     */
    @SerializedName( "to_PurchaseOrder" )
    @JsonProperty( "to_PurchaseOrder" )
    @ODataField( odataName = "to_PurchaseOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchaseOrder toPurchaseOrder;
    /**
     * Navigation property <b>to_AccountAssignment</b> for <b>PurchaseOrderItem</b> to multiple
     * <b>PurOrdAccountAssignment</b>.
     *
     */
    @SerializedName( "to_AccountAssignment" )
    @JsonProperty( "to_AccountAssignment" )
    @ODataField( odataName = "to_AccountAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurOrdAccountAssignment> toAccountAssignment;
    /**
     * Navigation property <b>to_PurchaseOrderItemNote</b> for <b>PurchaseOrderItem</b> to multiple
     * <b>PurchaseOrderItemNote</b>.
     *
     */
    @SerializedName( "to_PurchaseOrderItemNote" )
    @JsonProperty( "to_PurchaseOrderItemNote" )
    @ODataField( odataName = "to_PurchaseOrderItemNote" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseOrderItemNote> toPurchaseOrderItemNote;
    /**
     * Navigation property <b>to_PurchaseOrderPricingElement</b> for <b>PurchaseOrderItem</b> to multiple
     * <b>PurOrdPricingElement</b>.
     *
     */
    @SerializedName( "to_PurchaseOrderPricingElement" )
    @JsonProperty( "to_PurchaseOrderPricingElement" )
    @ODataField( odataName = "to_PurchaseOrderPricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurOrdPricingElement> toPurchaseOrderPricingElement;
    /**
     * Navigation property <b>to_ScheduleLine</b> for <b>PurchaseOrderItem</b> to multiple
     * <b>PurchaseOrderScheduleLine</b>.
     *
     */
    @SerializedName( "to_ScheduleLine" )
    @JsonProperty( "to_ScheduleLine" )
    @ODataField( odataName = "to_ScheduleLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseOrderScheduleLine> toScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseOrder</b> navigation property to query operations.
     *
     */
    public final static PurchaseOrderItemOneToOneLink<PurchaseOrder> TO_PURCHASE_ORDER =
        new PurchaseOrderItemOneToOneLink<PurchaseOrder>("to_PurchaseOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_AccountAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseOrderItemLink<PurOrdAccountAssignment> TO_ACCOUNT_ASSIGNMENT =
        new PurchaseOrderItemLink<PurOrdAccountAssignment>("to_AccountAssignment");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseOrderItemNote</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseOrderItemLink<PurchaseOrderItemNote> TO_PURCHASE_ORDER_ITEM_NOTE =
        new PurchaseOrderItemLink<PurchaseOrderItemNote>("to_PurchaseOrderItemNote");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseOrderPricingElement</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseOrderItemLink<PurOrdPricingElement> TO_PURCHASE_ORDER_PRICING_ELEMENT =
        new PurchaseOrderItemLink<PurOrdPricingElement>("to_PurchaseOrderPricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ScheduleLine</b> navigation property to query operations.
     *
     */
    public final static PurchaseOrderItemLink<PurchaseOrderScheduleLine> TO_SCHEDULE_LINE =
        new PurchaseOrderItemLink<PurchaseOrderScheduleLine>("to_ScheduleLine");

    @Nonnull
    @Override
    public Class<PurchaseOrderItem> getType()
    {
        return PurchaseOrderItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchase Order Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchase Order
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @param purchasingDocumentDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingDocumentDeletionCode( @Nullable final String purchasingDocumentDeletionCode )
    {
        rememberChangedField("PurchasingDocumentDeletionCode", this.purchasingDocumentDeletionCode);
        this.purchasingDocumentDeletionCode = purchasingDocumentDeletionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItemText</b>
     * </p>
     *
     * @param purchaseOrderItemText
     *            Short Text
     */
    public void setPurchaseOrderItemText( @Nullable final String purchaseOrderItemText )
    {
        rememberChangedField("PurchaseOrderItemText", this.purchaseOrderItemText);
        this.purchaseOrderItemText = purchaseOrderItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantity</b>
     * </p>
     *
     * @param orderQuantity
     *            Purchase Order Quantity
     */
    public void setOrderQuantity( @Nullable final BigDecimal orderQuantity )
    {
        rememberChangedField("OrderQuantity", this.orderQuantity);
        this.orderQuantity = orderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @param purchaseOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnit</b>
     * </p>
     *
     * @param orderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setOrderPriceUnit( @Nullable final String orderPriceUnit )
    {
        rememberChangedField("OrderPriceUnit", this.orderPriceUnit);
        this.orderPriceUnit = orderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderPriceUnitToOrderUnitNmrtr</b>
     * </p>
     *
     * @param orderPriceUnitToOrderUnitNmrtr
     *            Numerator for Conversion of Order Price Unit into Order Unit
     */
    public void setOrderPriceUnitToOrderUnitNmrtr( @Nullable final BigDecimal orderPriceUnitToOrderUnitNmrtr )
    {
        rememberChangedField("OrderPriceUnitToOrderUnitNmrtr", this.orderPriceUnitToOrderUnitNmrtr);
        this.orderPriceUnitToOrderUnitNmrtr = orderPriceUnitToOrderUnitNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrdPriceUnitToOrderUnitDnmntr</b>
     * </p>
     *
     * @param ordPriceUnitToOrderUnitDnmntr
     *            Denominator for Conv. of Order Price Unit into Order Unit
     */
    public void setOrdPriceUnitToOrderUnitDnmntr( @Nullable final BigDecimal ordPriceUnitToOrderUnitDnmntr )
    {
        rememberChangedField("OrdPriceUnitToOrderUnitDnmntr", this.ordPriceUnitToOrderUnitDnmntr);
        this.ordPriceUnitToOrderUnitDnmntr = ordPriceUnitToOrderUnitDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Net Price in Purchasing Document (in Document Currency)
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     *
     * @param netPriceQuantity
     *            Price Unit
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @param shippingInstruction
     *            Shipping Instructions
     */
    public void setShippingInstruction( @Nullable final String shippingInstruction )
    {
        rememberChangedField("ShippingInstruction", this.shippingInstruction);
        this.shippingInstruction = shippingInstruction;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TaxDeterminationDate</b>
     * </p>
     *
     * @param taxDeterminationDate
     *            Date for Determining Tax Rates
     */
    public void setTaxDeterminationDate( @Nullable final LocalDateTime taxDeterminationDate )
    {
        rememberChangedField("TaxDeterminationDate", this.taxDeterminationDate);
        this.taxDeterminationDate = taxDeterminationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriceIsToBePrinted</b>
     * </p>
     *
     * @param priceIsToBePrinted
     *            Price Printout
     */
    public void setPriceIsToBePrinted( @Nullable final Boolean priceIsToBePrinted )
    {
        rememberChangedField("PriceIsToBePrinted", this.priceIsToBePrinted);
        this.priceIsToBePrinted = priceIsToBePrinted;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdelivery Tolerance
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdelivery Tolerance
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationType</b>
     * </p>
     *
     * @param valuationType
     *            Valuation Type
     */
    public void setValuationType( @Nullable final String valuationType )
    {
        rememberChangedField("ValuationType", this.valuationType);
        this.valuationType = valuationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCompletelyDelivered</b>
     * </p>
     *
     * @param isCompletelyDelivered
     *            "Delivery Completed" Indicator
     */
    public void setIsCompletelyDelivered( @Nullable final Boolean isCompletelyDelivered )
    {
        rememberChangedField("IsCompletelyDelivered", this.isCompletelyDelivered);
        this.isCompletelyDelivered = isCompletelyDelivered;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinallyInvoiced</b>
     * </p>
     *
     * @param isFinallyInvoiced
     *            Final Invoice Indicator
     */
    public void setIsFinallyInvoiced( @Nullable final Boolean isFinallyInvoiced )
    {
        rememberChangedField("IsFinallyInvoiced", this.isFinallyInvoiced);
        this.isFinallyInvoiced = isFinallyInvoiced;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItemCategory</b>
     * </p>
     *
     * @param purchaseOrderItemCategory
     *            Item category in purchasing document
     */
    public void setPurchaseOrderItemCategory( @Nullable final String purchaseOrderItemCategory )
    {
        rememberChangedField("PurchaseOrderItemCategory", this.purchaseOrderItemCategory);
        this.purchaseOrderItemCategory = purchaseOrderItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistribution
     *            Distribution Indicator for Multiple Account Assignment
     */
    public void setMultipleAcctAssgmtDistribution( @Nullable final String multipleAcctAssgmtDistribution )
    {
        rememberChangedField("MultipleAcctAssgmtDistribution", this.multipleAcctAssgmtDistribution);
        this.multipleAcctAssgmtDistribution = multipleAcctAssgmtDistribution;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialInvoiceDistribution</b>
     * </p>
     *
     * @param partialInvoiceDistribution
     *            Partial invoice indicator
     */
    public void setPartialInvoiceDistribution( @Nullable final String partialInvoiceDistribution )
    {
        rememberChangedField("PartialInvoiceDistribution", this.partialInvoiceDistribution);
        this.partialInvoiceDistribution = partialInvoiceDistribution;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @param goodsReceiptIsExpected
     *            Goods Receipt Indicator
     */
    public void setGoodsReceiptIsExpected( @Nullable final Boolean goodsReceiptIsExpected )
    {
        rememberChangedField("GoodsReceiptIsExpected", this.goodsReceiptIsExpected);
        this.goodsReceiptIsExpected = goodsReceiptIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @param goodsReceiptIsNonValuated
     *            Goods Receipt, Non-Valuated
     */
    public void setGoodsReceiptIsNonValuated( @Nullable final Boolean goodsReceiptIsNonValuated )
    {
        rememberChangedField("GoodsReceiptIsNonValuated", this.goodsReceiptIsNonValuated);
        this.goodsReceiptIsNonValuated = goodsReceiptIsNonValuated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @param invoiceIsExpected
     *            Invoice Receipt Indicator
     */
    public void setInvoiceIsExpected( @Nullable final Boolean invoiceIsExpected )
    {
        rememberChangedField("InvoiceIsExpected", this.invoiceIsExpected);
        this.invoiceIsExpected = invoiceIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @param invoiceIsGoodsReceiptBased
     *            Indicator: GR-Based Invoice Verification
     */
    public void setInvoiceIsGoodsReceiptBased( @Nullable final Boolean invoiceIsGoodsReceiptBased )
    {
        rememberChangedField("InvoiceIsGoodsReceiptBased", this.invoiceIsGoodsReceiptBased);
        this.invoiceIsGoodsReceiptBased = invoiceIsGoodsReceiptBased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Number of principal purchase agreement
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Principal Purchase Agreement
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Subcontractor</b>
     * </p>
     *
     * @param subcontractor
     *            Supplier to be Supplied/Who is to Receive Delivery
     */
    public void setSubcontractor( @Nullable final String subcontractor )
    {
        rememberChangedField("Subcontractor", this.subcontractor);
        this.subcontractor = subcontractor;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierIsSubcontractor</b>
     * </p>
     *
     * @param supplierIsSubcontractor
     *            Subcontracting Supplier
     */
    public void setSupplierIsSubcontractor( @Nullable final Boolean supplierIsSubcontractor )
    {
        rememberChangedField("SupplierIsSubcontractor", this.supplierIsSubcontractor);
        this.supplierIsSubcontractor = supplierIsSubcontractor;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateControl</b>
     * </p>
     *
     * @param pricingDateControl
     *            Price Determination (Pricing) Date Control
     */
    public void setPricingDateControl( @Nullable final String pricingDateControl )
    {
        rememberChangedField("PricingDateControl", this.pricingDateControl);
        this.pricingDateControl = pricingDateControl;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierConfirmationControlKey</b>
     * </p>
     *
     * @param supplierConfirmationControlKey
     *            Confirmation Control Key
     */
    public void setSupplierConfirmationControlKey( @Nullable final String supplierConfirmationControlKey )
    {
        rememberChangedField("SupplierConfirmationControlKey", this.supplierConfirmationControlKey);
        this.supplierConfirmationControlKey = supplierConfirmationControlKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EvaldRcptSettlmtIsAllowed</b>
     * </p>
     *
     * @param evaldRcptSettlmtIsAllowed
     *            Evaluated Receipt Settlement (ERS)
     */
    public void setEvaldRcptSettlmtIsAllowed( @Nullable final Boolean evaldRcptSettlmtIsAllowed )
    {
        rememberChangedField("EvaldRcptSettlmtIsAllowed", this.evaldRcptSettlmtIsAllowed);
        this.evaldRcptSettlmtIsAllowed = evaldRcptSettlmtIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsReturnsItem</b>
     * </p>
     *
     * @param isReturnsItem
     *            Returns Item
     */
    public void setIsReturnsItem( @Nullable final Boolean isReturnsItem )
    {
        rememberChangedField("IsReturnsItem", this.isReturnsItem);
        this.isReturnsItem = isReturnsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RequisitionerName</b>
     * </p>
     *
     * @param requisitionerName
     *            Name of requisitioner/requester
     */
    public void setRequisitionerName( @Nullable final String requisitionerName )
    {
        rememberChangedField("RequisitionerName", this.requisitionerName);
        this.requisitionerName = requisitionerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePackage</b>
     * </p>
     *
     * @param servicePackage
     *            Package number
     */
    public void setServicePackage( @Nullable final String servicePackage )
    {
        rememberChangedField("ServicePackage", this.servicePackage);
        this.servicePackage = servicePackage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFunds</b>
     * </p>
     *
     * @param earmarkedFunds
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFunds( @Nullable final String earmarkedFunds )
    {
        rememberChangedField("EarmarkedFunds", this.earmarkedFunds);
        this.earmarkedFunds = earmarkedFunds;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsItem</b>
     * </p>
     *
     * @param earmarkedFundsItem
     *            Earmarked Funds: Document Item
     */
    public void setEarmarkedFundsItem( @Nullable final String earmarkedFundsItem )
    {
        rememberChangedField("EarmarkedFundsItem", this.earmarkedFundsItem);
        this.earmarkedFundsItem = earmarkedFundsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentItem</b>
     * </p>
     *
     * @param earmarkedFundsDocumentItem
     *            Earmarked Funds: Document Item
     */
    public void setEarmarkedFundsDocumentItem( @Nullable final String earmarkedFundsDocumentItem )
    {
        rememberChangedField("EarmarkedFundsDocumentItem", this.earmarkedFundsDocumentItem);
        this.earmarkedFundsDocumentItem = earmarkedFundsDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InternationalArticleNumber</b>
     * </p>
     *
     * @param internationalArticleNumber
     *            International Article Number (EAN/UPC)
     */
    public void setInternationalArticleNumber( @Nullable final String internationalArticleNumber )
    {
        rememberChangedField("InternationalArticleNumber", this.internationalArticleNumber);
        this.internationalArticleNumber = internationalArticleNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @param manufacturerMaterial
     *            Material number
     */
    public void setManufacturerMaterial( @Nullable final String manufacturerMaterial )
    {
        rememberChangedField("ManufacturerMaterial", this.manufacturerMaterial);
        this.manufacturerMaterial = manufacturerMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Service Performer
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type Group
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedOverallLimitAmount</b>
     * </p>
     *
     * @param expectedOverallLimitAmount
     *            Expected Value of Overall Limit
     */
    public void setExpectedOverallLimitAmount( @Nullable final BigDecimal expectedOverallLimitAmount )
    {
        rememberChangedField("ExpectedOverallLimitAmount", this.expectedOverallLimitAmount);
        this.expectedOverallLimitAmount = expectedOverallLimitAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverallLimitAmount</b>
     * </p>
     *
     * @param overallLimitAmount
     *            Overall Limit
     */
    public void setOverallLimitAmount( @Nullable final BigDecimal overallLimitAmount )
    {
        rememberChangedField("OverallLimitAmount", this.overallLimitAmount);
        this.overallLimitAmount = overallLimitAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurContractForOverallLimit</b>
     * </p>
     *
     * @param purContractForOverallLimit
     *            Purchase Contract for Enhanced Limit
     */
    public void setPurContractForOverallLimit( @Nullable final String purContractForOverallLimit )
    {
        rememberChangedField("PurContractForOverallLimit", this.purContractForOverallLimit);
        this.purContractForOverallLimit = purContractForOverallLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingParentItem</b>
     * </p>
     *
     * @param purchasingParentItem
     *            Higher-Level Item in Purchasing Documents
     */
    public void setPurchasingParentItem( @Nullable final String purchasingParentItem )
    {
        rememberChangedField("PurchasingParentItem", this.purchasingParentItem);
        this.purchasingParentItem = purchasingParentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingItemIsFreeOfCharge</b>
     * </p>
     *
     * @param purchasingItemIsFreeOfCharge
     *            Free Item
     */
    public void setPurchasingItemIsFreeOfCharge( @Nullable final Boolean purchasingItemIsFreeOfCharge )
    {
        rememberChangedField("PurchasingItemIsFreeOfCharge", this.purchasingItemIsFreeOfCharge);
        this.purchasingItemIsFreeOfCharge = purchasingItemIsFreeOfCharge;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDeliveryAddressID</b>
     * </p>
     *
     * @param referenceDeliveryAddressID
     *            Number of delivery address
     */
    public void setReferenceDeliveryAddressID( @Nullable final String referenceDeliveryAddressID )
    {
        rememberChangedField("ReferenceDeliveryAddressID", this.referenceDeliveryAddressID);
        this.referenceDeliveryAddressID = referenceDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressID</b>
     * </p>
     *
     * @param deliveryAddressID
     *            Manual address number in purchasing document item
     */
    public void setDeliveryAddressID( @Nullable final String deliveryAddressID )
    {
        rememberChangedField("DeliveryAddressID", this.deliveryAddressID);
        this.deliveryAddressID = deliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressName</b>
     * </p>
     *
     * @param deliveryAddressName
     *            Name 1
     */
    public void setDeliveryAddressName( @Nullable final String deliveryAddressName )
    {
        rememberChangedField("DeliveryAddressName", this.deliveryAddressName);
        this.deliveryAddressName = deliveryAddressName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressName2</b>
     * </p>
     *
     * @param deliveryAddressName2
     *            Name 2
     */
    public void setDeliveryAddressName2( @Nullable final String deliveryAddressName2 )
    {
        rememberChangedField("DeliveryAddressName2", this.deliveryAddressName2);
        this.deliveryAddressName2 = deliveryAddressName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressFullName</b>
     * </p>
     *
     * @param deliveryAddressFullName
     *            Full name of a party (Bus. Partner, Org. Unit, Doc. address)
     */
    public void setDeliveryAddressFullName( @Nullable final String deliveryAddressFullName )
    {
        rememberChangedField("DeliveryAddressFullName", this.deliveryAddressFullName);
        this.deliveryAddressFullName = deliveryAddressFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressStreetName</b>
     * </p>
     *
     * @param deliveryAddressStreetName
     *            Street
     */
    public void setDeliveryAddressStreetName( @Nullable final String deliveryAddressStreetName )
    {
        rememberChangedField("DeliveryAddressStreetName", this.deliveryAddressStreetName);
        this.deliveryAddressStreetName = deliveryAddressStreetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressHouseNumber</b>
     * </p>
     *
     * @param deliveryAddressHouseNumber
     *            House Number
     */
    public void setDeliveryAddressHouseNumber( @Nullable final String deliveryAddressHouseNumber )
    {
        rememberChangedField("DeliveryAddressHouseNumber", this.deliveryAddressHouseNumber);
        this.deliveryAddressHouseNumber = deliveryAddressHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressCityName</b>
     * </p>
     *
     * @param deliveryAddressCityName
     *            City
     */
    public void setDeliveryAddressCityName( @Nullable final String deliveryAddressCityName )
    {
        rememberChangedField("DeliveryAddressCityName", this.deliveryAddressCityName);
        this.deliveryAddressCityName = deliveryAddressCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressPostalCode</b>
     * </p>
     *
     * @param deliveryAddressPostalCode
     *            City Postal Code
     */
    public void setDeliveryAddressPostalCode( @Nullable final String deliveryAddressPostalCode )
    {
        rememberChangedField("DeliveryAddressPostalCode", this.deliveryAddressPostalCode);
        this.deliveryAddressPostalCode = deliveryAddressPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressRegion</b>
     * </p>
     *
     * @param deliveryAddressRegion
     *            Region (State, Province, County)
     */
    public void setDeliveryAddressRegion( @Nullable final String deliveryAddressRegion )
    {
        rememberChangedField("DeliveryAddressRegion", this.deliveryAddressRegion);
        this.deliveryAddressRegion = deliveryAddressRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressCountry</b>
     * </p>
     *
     * @param deliveryAddressCountry
     *            Country/Region Key
     */
    public void setDeliveryAddressCountry( @Nullable final String deliveryAddressCountry )
    {
        rememberChangedField("DeliveryAddressCountry", this.deliveryAddressCountry);
        this.deliveryAddressCountry = deliveryAddressCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressDistrictName</b>
     * </p>
     *
     * @param deliveryAddressDistrictName
     *            District
     */
    public void setDeliveryAddressDistrictName( @Nullable final String deliveryAddressDistrictName )
    {
        rememberChangedField("DeliveryAddressDistrictName", this.deliveryAddressDistrictName);
        this.deliveryAddressDistrictName = deliveryAddressDistrictName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentType</b>
     * </p>
     *
     * @param downPaymentType
     *            Down Payment Indicator
     */
    public void setDownPaymentType( @Nullable final String downPaymentType )
    {
        rememberChangedField("DownPaymentType", this.downPaymentType);
        this.downPaymentType = downPaymentType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentPercentageOfTotAmt</b>
     * </p>
     *
     * @param downPaymentPercentageOfTotAmt
     *            Down Payment Percentage
     */
    public void setDownPaymentPercentageOfTotAmt( @Nullable final BigDecimal downPaymentPercentageOfTotAmt )
    {
        rememberChangedField("DownPaymentPercentageOfTotAmt", this.downPaymentPercentageOfTotAmt);
        this.downPaymentPercentageOfTotAmt = downPaymentPercentageOfTotAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentAmount</b>
     * </p>
     *
     * @param downPaymentAmount
     *            Down Payment Amount in Document Currency
     */
    public void setDownPaymentAmount( @Nullable final BigDecimal downPaymentAmount )
    {
        rememberChangedField("DownPaymentAmount", this.downPaymentAmount);
        this.downPaymentAmount = downPaymentAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DownPaymentDueDate</b>
     * </p>
     *
     * @param downPaymentDueDate
     *            Due Date for Down Payment
     */
    public void setDownPaymentDueDate( @Nullable final LocalDateTime downPaymentDueDate )
    {
        rememberChangedField("DownPaymentDueDate", this.downPaymentDueDate);
        this.downPaymentDueDate = downPaymentDueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialUsage</b>
     * </p>
     *
     * @param bR_MaterialUsage
     *            Usage of the material
     */
    public void setBR_MaterialUsage( @Nullable final String bR_MaterialUsage )
    {
        rememberChangedField("BR_MaterialUsage", this.bR_MaterialUsage);
        this.bR_MaterialUsage = bR_MaterialUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BR_MaterialOrigin</b>
     * </p>
     *
     * @param bR_MaterialOrigin
     *            Origin of the material
     */
    public void setBR_MaterialOrigin( @Nullable final String bR_MaterialOrigin )
    {
        rememberChangedField("BR_MaterialOrigin", this.bR_MaterialOrigin);
        this.bR_MaterialOrigin = bR_MaterialOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BR_CFOPCategory</b>
     * </p>
     *
     * @param bR_CFOPCategory
     *            Material CFOP category
     */
    public void setBR_CFOPCategory( @Nullable final String bR_CFOPCategory )
    {
        rememberChangedField("BR_CFOPCategory", this.bR_CFOPCategory);
        this.bR_CFOPCategory = bR_CFOPCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BR_IsProducedInHouse</b>
     * </p>
     *
     * @param bR_IsProducedInHouse
     *            Produced in-house
     */
    public void setBR_IsProducedInHouse( @Nullable final Boolean bR_IsProducedInHouse )
    {
        rememberChangedField("BR_IsProducedInHouse", this.bR_IsProducedInHouse);
        this.bR_IsProducedInHouse = bR_IsProducedInHouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionTaxCtrlCode</b>
     * </p>
     *
     * @param consumptionTaxCtrlCode
     *            Brazilian NCM Code
     */
    public void setConsumptionTaxCtrlCode( @Nullable final String consumptionTaxCtrlCode )
    {
        rememberChangedField("ConsumptionTaxCtrlCode", this.consumptionTaxCtrlCode);
        this.consumptionTaxCtrlCode = consumptionTaxCtrlCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncSupplierStatus</b>
     * </p>
     *
     * @param purgProdCmplncSupplierStatus
     *            Product Compliance Supplier Check Status (Item)
     */
    public void setPurgProdCmplncSupplierStatus( @Nullable final String purgProdCmplncSupplierStatus )
    {
        rememberChangedField("PurgProdCmplncSupplierStatus", this.purgProdCmplncSupplierStatus);
        this.purgProdCmplncSupplierStatus = purgProdCmplncSupplierStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProductMarketabilityStatus</b>
     * </p>
     *
     * @param purgProductMarketabilityStatus
     *            Product Marketability Status (Item)
     */
    public void setPurgProductMarketabilityStatus( @Nullable final String purgProductMarketabilityStatus )
    {
        rememberChangedField("PurgProductMarketabilityStatus", this.purgProductMarketabilityStatus);
        this.purgProductMarketabilityStatus = purgProductMarketabilityStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgSafetyDataSheetStatus</b>
     * </p>
     *
     * @param purgSafetyDataSheetStatus
     *            Safety Data Sheet Status (Item)
     */
    public void setPurgSafetyDataSheetStatus( @Nullable final String purgSafetyDataSheetStatus )
    {
        rememberChangedField("PurgSafetyDataSheetStatus", this.purgSafetyDataSheetStatus);
        this.purgSafetyDataSheetStatus = purgSafetyDataSheetStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgProdCmplncDngrsGoodsStatus</b>
     * </p>
     *
     * @param purgProdCmplncDngrsGoodsStatus
     *            Dangerous Goods Status (Item)
     */
    public void setPurgProdCmplncDngrsGoodsStatus( @Nullable final String purgProdCmplncDngrsGoodsStatus )
    {
        rememberChangedField("PurgProdCmplncDngrsGoodsStatus", this.purgProdCmplncDngrsGoodsStatus);
        this.purgProdCmplncDngrsGoodsStatus = purgProdCmplncDngrsGoodsStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseOrderItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseOrder", getPurchaseOrder());
        result.put("PurchaseOrderItem", getPurchaseOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("PurchasingDocumentDeletionCode", getPurchasingDocumentDeletionCode());
        values.put("PurchaseOrderItemText", getPurchaseOrderItemText());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("OrderQuantity", getOrderQuantity());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("OrderPriceUnit", getOrderPriceUnit());
        values.put("OrderPriceUnitToOrderUnitNmrtr", getOrderPriceUnitToOrderUnitNmrtr());
        values.put("OrdPriceUnitToOrderUnitDnmntr", getOrdPriceUnitToOrderUnitDnmntr());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("TaxCode", getTaxCode());
        values.put("ShippingInstruction", getShippingInstruction());
        values.put("TaxDeterminationDate", getTaxDeterminationDate());
        values.put("TaxCountry", getTaxCountry());
        values.put("PriceIsToBePrinted", getPriceIsToBePrinted());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("ValuationType", getValuationType());
        values.put("IsCompletelyDelivered", getIsCompletelyDelivered());
        values.put("IsFinallyInvoiced", getIsFinallyInvoiced());
        values.put("PurchaseOrderItemCategory", getPurchaseOrderItemCategory());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("MultipleAcctAssgmtDistribution", getMultipleAcctAssgmtDistribution());
        values.put("PartialInvoiceDistribution", getPartialInvoiceDistribution());
        values.put("GoodsReceiptIsExpected", getGoodsReceiptIsExpected());
        values.put("GoodsReceiptIsNonValuated", getGoodsReceiptIsNonValuated());
        values.put("InvoiceIsExpected", getInvoiceIsExpected());
        values.put("InvoiceIsGoodsReceiptBased", getInvoiceIsGoodsReceiptBased());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("Customer", getCustomer());
        values.put("Subcontractor", getSubcontractor());
        values.put("SupplierIsSubcontractor", getSupplierIsSubcontractor());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("PricingDateControl", getPricingDateControl());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("SupplierConfirmationControlKey", getSupplierConfirmationControlKey());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("EvaldRcptSettlmtIsAllowed", getEvaldRcptSettlmtIsAllowed());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("IsReturnsItem", getIsReturnsItem());
        values.put("RequisitionerName", getRequisitionerName());
        values.put("ServicePackage", getServicePackage());
        values.put("EarmarkedFunds", getEarmarkedFunds());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("EarmarkedFundsItem", getEarmarkedFundsItem());
        values.put("EarmarkedFundsDocumentItem", getEarmarkedFundsDocumentItem());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("Material", getMaterial());
        values.put("InternationalArticleNumber", getInternationalArticleNumber());
        values.put("ManufacturerMaterial", getManufacturerMaterial());
        values.put("ServicePerformer", getServicePerformer());
        values.put("ProductType", getProductType());
        values.put("ExpectedOverallLimitAmount", getExpectedOverallLimitAmount());
        values.put("OverallLimitAmount", getOverallLimitAmount());
        values.put("PurContractForOverallLimit", getPurContractForOverallLimit());
        values.put("PurchasingParentItem", getPurchasingParentItem());
        values.put("Batch", getBatch());
        values.put("PurchasingItemIsFreeOfCharge", getPurchasingItemIsFreeOfCharge());
        values.put("ReferenceDeliveryAddressID", getReferenceDeliveryAddressID());
        values.put("DeliveryAddressID", getDeliveryAddressID());
        values.put("DeliveryAddressName", getDeliveryAddressName());
        values.put("DeliveryAddressName2", getDeliveryAddressName2());
        values.put("DeliveryAddressFullName", getDeliveryAddressFullName());
        values.put("DeliveryAddressStreetName", getDeliveryAddressStreetName());
        values.put("DeliveryAddressHouseNumber", getDeliveryAddressHouseNumber());
        values.put("DeliveryAddressCityName", getDeliveryAddressCityName());
        values.put("DeliveryAddressPostalCode", getDeliveryAddressPostalCode());
        values.put("DeliveryAddressRegion", getDeliveryAddressRegion());
        values.put("DeliveryAddressCountry", getDeliveryAddressCountry());
        values.put("DeliveryAddressDistrictName", getDeliveryAddressDistrictName());
        values.put("DownPaymentType", getDownPaymentType());
        values.put("DownPaymentPercentageOfTotAmt", getDownPaymentPercentageOfTotAmt());
        values.put("DownPaymentAmount", getDownPaymentAmount());
        values.put("DownPaymentDueDate", getDownPaymentDueDate());
        values.put("BR_MaterialUsage", getBR_MaterialUsage());
        values.put("BR_MaterialOrigin", getBR_MaterialOrigin());
        values.put("BR_CFOPCategory", getBR_CFOPCategory());
        values.put("BR_IsProducedInHouse", getBR_IsProducedInHouse());
        values.put("ConsumptionTaxCtrlCode", getConsumptionTaxCtrlCode());
        values.put("PurgProdCmplncSupplierStatus", getPurgProdCmplncSupplierStatus());
        values.put("PurgProductMarketabilityStatus", getPurgProductMarketabilityStatus());
        values.put("PurgSafetyDataSheetStatus", getPurgSafetyDataSheetStatus());
        values.put("PurgProdCmplncDngrsGoodsStatus", getPurgProdCmplncDngrsGoodsStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDeletionCode") ) {
                final Object value = values.remove("PurchasingDocumentDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingDocumentDeletionCode())) ) {
                    setPurchasingDocumentDeletionCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItemText") ) {
                final Object value = values.remove("PurchaseOrderItemText");
                if( (value == null) || (!value.equals(getPurchaseOrderItemText())) ) {
                    setPurchaseOrderItemText(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("OrderQuantity") ) {
                final Object value = values.remove("OrderQuantity");
                if( (value == null) || (!value.equals(getOrderQuantity())) ) {
                    setOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderPriceUnit") ) {
                final Object value = values.remove("OrderPriceUnit");
                if( (value == null) || (!value.equals(getOrderPriceUnit())) ) {
                    setOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("OrderPriceUnitToOrderUnitNmrtr") ) {
                final Object value = values.remove("OrderPriceUnitToOrderUnitNmrtr");
                if( (value == null) || (!value.equals(getOrderPriceUnitToOrderUnitNmrtr())) ) {
                    setOrderPriceUnitToOrderUnitNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrdPriceUnitToOrderUnitDnmntr") ) {
                final Object value = values.remove("OrdPriceUnitToOrderUnitDnmntr");
                if( (value == null) || (!value.equals(getOrdPriceUnitToOrderUnitDnmntr())) ) {
                    setOrdPriceUnitToOrderUnitDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("ShippingInstruction") ) {
                final Object value = values.remove("ShippingInstruction");
                if( (value == null) || (!value.equals(getShippingInstruction())) ) {
                    setShippingInstruction(((String) value));
                }
            }
            if( values.containsKey("TaxDeterminationDate") ) {
                final Object value = values.remove("TaxDeterminationDate");
                if( (value == null) || (!value.equals(getTaxDeterminationDate())) ) {
                    setTaxDeterminationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
            if( values.containsKey("PriceIsToBePrinted") ) {
                final Object value = values.remove("PriceIsToBePrinted");
                if( (value == null) || (!value.equals(getPriceIsToBePrinted())) ) {
                    setPriceIsToBePrinted(((Boolean) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("ValuationType") ) {
                final Object value = values.remove("ValuationType");
                if( (value == null) || (!value.equals(getValuationType())) ) {
                    setValuationType(((String) value));
                }
            }
            if( values.containsKey("IsCompletelyDelivered") ) {
                final Object value = values.remove("IsCompletelyDelivered");
                if( (value == null) || (!value.equals(getIsCompletelyDelivered())) ) {
                    setIsCompletelyDelivered(((Boolean) value));
                }
            }
            if( values.containsKey("IsFinallyInvoiced") ) {
                final Object value = values.remove("IsFinallyInvoiced");
                if( (value == null) || (!value.equals(getIsFinallyInvoiced())) ) {
                    setIsFinallyInvoiced(((Boolean) value));
                }
            }
            if( values.containsKey("PurchaseOrderItemCategory") ) {
                final Object value = values.remove("PurchaseOrderItemCategory");
                if( (value == null) || (!value.equals(getPurchaseOrderItemCategory())) ) {
                    setPurchaseOrderItemCategory(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistribution") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistribution");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistribution())) ) {
                    setMultipleAcctAssgmtDistribution(((String) value));
                }
            }
            if( values.containsKey("PartialInvoiceDistribution") ) {
                final Object value = values.remove("PartialInvoiceDistribution");
                if( (value == null) || (!value.equals(getPartialInvoiceDistribution())) ) {
                    setPartialInvoiceDistribution(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsExpected") ) {
                final Object value = values.remove("GoodsReceiptIsExpected");
                if( (value == null) || (!value.equals(getGoodsReceiptIsExpected())) ) {
                    setGoodsReceiptIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsNonValuated") ) {
                final Object value = values.remove("GoodsReceiptIsNonValuated");
                if( (value == null) || (!value.equals(getGoodsReceiptIsNonValuated())) ) {
                    setGoodsReceiptIsNonValuated(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsExpected") ) {
                final Object value = values.remove("InvoiceIsExpected");
                if( (value == null) || (!value.equals(getInvoiceIsExpected())) ) {
                    setInvoiceIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsGoodsReceiptBased") ) {
                final Object value = values.remove("InvoiceIsGoodsReceiptBased");
                if( (value == null) || (!value.equals(getInvoiceIsGoodsReceiptBased())) ) {
                    setInvoiceIsGoodsReceiptBased(((Boolean) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Subcontractor") ) {
                final Object value = values.remove("Subcontractor");
                if( (value == null) || (!value.equals(getSubcontractor())) ) {
                    setSubcontractor(((String) value));
                }
            }
            if( values.containsKey("SupplierIsSubcontractor") ) {
                final Object value = values.remove("SupplierIsSubcontractor");
                if( (value == null) || (!value.equals(getSupplierIsSubcontractor())) ) {
                    setSupplierIsSubcontractor(((Boolean) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("PricingDateControl") ) {
                final Object value = values.remove("PricingDateControl");
                if( (value == null) || (!value.equals(getPricingDateControl())) ) {
                    setPricingDateControl(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("SupplierConfirmationControlKey") ) {
                final Object value = values.remove("SupplierConfirmationControlKey");
                if( (value == null) || (!value.equals(getSupplierConfirmationControlKey())) ) {
                    setSupplierConfirmationControlKey(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("EvaldRcptSettlmtIsAllowed") ) {
                final Object value = values.remove("EvaldRcptSettlmtIsAllowed");
                if( (value == null) || (!value.equals(getEvaldRcptSettlmtIsAllowed())) ) {
                    setEvaldRcptSettlmtIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("IsReturnsItem") ) {
                final Object value = values.remove("IsReturnsItem");
                if( (value == null) || (!value.equals(getIsReturnsItem())) ) {
                    setIsReturnsItem(((Boolean) value));
                }
            }
            if( values.containsKey("RequisitionerName") ) {
                final Object value = values.remove("RequisitionerName");
                if( (value == null) || (!value.equals(getRequisitionerName())) ) {
                    setRequisitionerName(((String) value));
                }
            }
            if( values.containsKey("ServicePackage") ) {
                final Object value = values.remove("ServicePackage");
                if( (value == null) || (!value.equals(getServicePackage())) ) {
                    setServicePackage(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFunds") ) {
                final Object value = values.remove("EarmarkedFunds");
                if( (value == null) || (!value.equals(getEarmarkedFunds())) ) {
                    setEarmarkedFunds(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsItem") ) {
                final Object value = values.remove("EarmarkedFundsItem");
                if( (value == null) || (!value.equals(getEarmarkedFundsItem())) ) {
                    setEarmarkedFundsItem(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocumentItem") ) {
                final Object value = values.remove("EarmarkedFundsDocumentItem");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocumentItem())) ) {
                    setEarmarkedFundsDocumentItem(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("InternationalArticleNumber") ) {
                final Object value = values.remove("InternationalArticleNumber");
                if( (value == null) || (!value.equals(getInternationalArticleNumber())) ) {
                    setInternationalArticleNumber(((String) value));
                }
            }
            if( values.containsKey("ManufacturerMaterial") ) {
                final Object value = values.remove("ManufacturerMaterial");
                if( (value == null) || (!value.equals(getManufacturerMaterial())) ) {
                    setManufacturerMaterial(((String) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("ExpectedOverallLimitAmount") ) {
                final Object value = values.remove("ExpectedOverallLimitAmount");
                if( (value == null) || (!value.equals(getExpectedOverallLimitAmount())) ) {
                    setExpectedOverallLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverallLimitAmount") ) {
                final Object value = values.remove("OverallLimitAmount");
                if( (value == null) || (!value.equals(getOverallLimitAmount())) ) {
                    setOverallLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurContractForOverallLimit") ) {
                final Object value = values.remove("PurContractForOverallLimit");
                if( (value == null) || (!value.equals(getPurContractForOverallLimit())) ) {
                    setPurContractForOverallLimit(((String) value));
                }
            }
            if( values.containsKey("PurchasingParentItem") ) {
                final Object value = values.remove("PurchasingParentItem");
                if( (value == null) || (!value.equals(getPurchasingParentItem())) ) {
                    setPurchasingParentItem(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("PurchasingItemIsFreeOfCharge") ) {
                final Object value = values.remove("PurchasingItemIsFreeOfCharge");
                if( (value == null) || (!value.equals(getPurchasingItemIsFreeOfCharge())) ) {
                    setPurchasingItemIsFreeOfCharge(((Boolean) value));
                }
            }
            if( values.containsKey("ReferenceDeliveryAddressID") ) {
                final Object value = values.remove("ReferenceDeliveryAddressID");
                if( (value == null) || (!value.equals(getReferenceDeliveryAddressID())) ) {
                    setReferenceDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressID") ) {
                final Object value = values.remove("DeliveryAddressID");
                if( (value == null) || (!value.equals(getDeliveryAddressID())) ) {
                    setDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressName") ) {
                final Object value = values.remove("DeliveryAddressName");
                if( (value == null) || (!value.equals(getDeliveryAddressName())) ) {
                    setDeliveryAddressName(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressName2") ) {
                final Object value = values.remove("DeliveryAddressName2");
                if( (value == null) || (!value.equals(getDeliveryAddressName2())) ) {
                    setDeliveryAddressName2(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressFullName") ) {
                final Object value = values.remove("DeliveryAddressFullName");
                if( (value == null) || (!value.equals(getDeliveryAddressFullName())) ) {
                    setDeliveryAddressFullName(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressStreetName") ) {
                final Object value = values.remove("DeliveryAddressStreetName");
                if( (value == null) || (!value.equals(getDeliveryAddressStreetName())) ) {
                    setDeliveryAddressStreetName(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressHouseNumber") ) {
                final Object value = values.remove("DeliveryAddressHouseNumber");
                if( (value == null) || (!value.equals(getDeliveryAddressHouseNumber())) ) {
                    setDeliveryAddressHouseNumber(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressCityName") ) {
                final Object value = values.remove("DeliveryAddressCityName");
                if( (value == null) || (!value.equals(getDeliveryAddressCityName())) ) {
                    setDeliveryAddressCityName(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressPostalCode") ) {
                final Object value = values.remove("DeliveryAddressPostalCode");
                if( (value == null) || (!value.equals(getDeliveryAddressPostalCode())) ) {
                    setDeliveryAddressPostalCode(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressRegion") ) {
                final Object value = values.remove("DeliveryAddressRegion");
                if( (value == null) || (!value.equals(getDeliveryAddressRegion())) ) {
                    setDeliveryAddressRegion(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressCountry") ) {
                final Object value = values.remove("DeliveryAddressCountry");
                if( (value == null) || (!value.equals(getDeliveryAddressCountry())) ) {
                    setDeliveryAddressCountry(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressDistrictName") ) {
                final Object value = values.remove("DeliveryAddressDistrictName");
                if( (value == null) || (!value.equals(getDeliveryAddressDistrictName())) ) {
                    setDeliveryAddressDistrictName(((String) value));
                }
            }
            if( values.containsKey("DownPaymentType") ) {
                final Object value = values.remove("DownPaymentType");
                if( (value == null) || (!value.equals(getDownPaymentType())) ) {
                    setDownPaymentType(((String) value));
                }
            }
            if( values.containsKey("DownPaymentPercentageOfTotAmt") ) {
                final Object value = values.remove("DownPaymentPercentageOfTotAmt");
                if( (value == null) || (!value.equals(getDownPaymentPercentageOfTotAmt())) ) {
                    setDownPaymentPercentageOfTotAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("DownPaymentAmount") ) {
                final Object value = values.remove("DownPaymentAmount");
                if( (value == null) || (!value.equals(getDownPaymentAmount())) ) {
                    setDownPaymentAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DownPaymentDueDate") ) {
                final Object value = values.remove("DownPaymentDueDate");
                if( (value == null) || (!value.equals(getDownPaymentDueDate())) ) {
                    setDownPaymentDueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BR_MaterialUsage") ) {
                final Object value = values.remove("BR_MaterialUsage");
                if( (value == null) || (!value.equals(getBR_MaterialUsage())) ) {
                    setBR_MaterialUsage(((String) value));
                }
            }
            if( values.containsKey("BR_MaterialOrigin") ) {
                final Object value = values.remove("BR_MaterialOrigin");
                if( (value == null) || (!value.equals(getBR_MaterialOrigin())) ) {
                    setBR_MaterialOrigin(((String) value));
                }
            }
            if( values.containsKey("BR_CFOPCategory") ) {
                final Object value = values.remove("BR_CFOPCategory");
                if( (value == null) || (!value.equals(getBR_CFOPCategory())) ) {
                    setBR_CFOPCategory(((String) value));
                }
            }
            if( values.containsKey("BR_IsProducedInHouse") ) {
                final Object value = values.remove("BR_IsProducedInHouse");
                if( (value == null) || (!value.equals(getBR_IsProducedInHouse())) ) {
                    setBR_IsProducedInHouse(((Boolean) value));
                }
            }
            if( values.containsKey("ConsumptionTaxCtrlCode") ) {
                final Object value = values.remove("ConsumptionTaxCtrlCode");
                if( (value == null) || (!value.equals(getConsumptionTaxCtrlCode())) ) {
                    setConsumptionTaxCtrlCode(((String) value));
                }
            }
            if( values.containsKey("PurgProdCmplncSupplierStatus") ) {
                final Object value = values.remove("PurgProdCmplncSupplierStatus");
                if( (value == null) || (!value.equals(getPurgProdCmplncSupplierStatus())) ) {
                    setPurgProdCmplncSupplierStatus(((String) value));
                }
            }
            if( values.containsKey("PurgProductMarketabilityStatus") ) {
                final Object value = values.remove("PurgProductMarketabilityStatus");
                if( (value == null) || (!value.equals(getPurgProductMarketabilityStatus())) ) {
                    setPurgProductMarketabilityStatus(((String) value));
                }
            }
            if( values.containsKey("PurgSafetyDataSheetStatus") ) {
                final Object value = values.remove("PurgSafetyDataSheetStatus");
                if( (value == null) || (!value.equals(getPurgSafetyDataSheetStatus())) ) {
                    setPurgSafetyDataSheetStatus(((String) value));
                }
            }
            if( values.containsKey("PurgProdCmplncDngrsGoodsStatus") ) {
                final Object value = values.remove("PurgProdCmplncDngrsGoodsStatus");
                if( (value == null) || (!value.equals(getPurgProdCmplncDngrsGoodsStatus())) ) {
                    setPurgProdCmplncDngrsGoodsStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchaseOrder") ) {
                final Object value = (values).remove("to_PurchaseOrder");
                if( value instanceof Map ) {
                    if( toPurchaseOrder == null ) {
                        toPurchaseOrder = new PurchaseOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_AccountAssignment") ) {
                final Object value = (values).remove("to_AccountAssignment");
                if( value instanceof Iterable ) {
                    if( toAccountAssignment == null ) {
                        toAccountAssignment = Lists.newArrayList();
                    } else {
                        toAccountAssignment = Lists.newArrayList(toAccountAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurOrdAccountAssignment entity;
                        if( toAccountAssignment.size() > i ) {
                            entity = toAccountAssignment.get(i);
                        } else {
                            entity = new PurOrdAccountAssignment();
                            toAccountAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurchaseOrderItemNote") ) {
                final Object value = (values).remove("to_PurchaseOrderItemNote");
                if( value instanceof Iterable ) {
                    if( toPurchaseOrderItemNote == null ) {
                        toPurchaseOrderItemNote = Lists.newArrayList();
                    } else {
                        toPurchaseOrderItemNote = Lists.newArrayList(toPurchaseOrderItemNote);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseOrderItemNote entity;
                        if( toPurchaseOrderItemNote.size() > i ) {
                            entity = toPurchaseOrderItemNote.get(i);
                        } else {
                            entity = new PurchaseOrderItemNote();
                            toPurchaseOrderItemNote.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurchaseOrderPricingElement") ) {
                final Object value = (values).remove("to_PurchaseOrderPricingElement");
                if( value instanceof Iterable ) {
                    if( toPurchaseOrderPricingElement == null ) {
                        toPurchaseOrderPricingElement = Lists.newArrayList();
                    } else {
                        toPurchaseOrderPricingElement = Lists.newArrayList(toPurchaseOrderPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurOrdPricingElement entity;
                        if( toPurchaseOrderPricingElement.size() > i ) {
                            entity = toPurchaseOrderPricingElement.get(i);
                        } else {
                            entity = new PurOrdPricingElement();
                            toPurchaseOrderPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ScheduleLine") ) {
                final Object value = (values).remove("to_ScheduleLine");
                if( value instanceof Iterable ) {
                    if( toScheduleLine == null ) {
                        toScheduleLine = Lists.newArrayList();
                    } else {
                        toScheduleLine = Lists.newArrayList(toScheduleLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseOrderScheduleLine entity;
                        if( toScheduleLine.size() > i ) {
                            entity = toScheduleLine.get(i);
                        } else {
                            entity = new PurchaseOrderScheduleLine();
                            toScheduleLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseOrderItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseOrderItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseOrderItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchaseOrder != null ) {
            (values).put("to_PurchaseOrder", toPurchaseOrder);
        }
        if( toAccountAssignment != null ) {
            (values).put("to_AccountAssignment", toAccountAssignment);
        }
        if( toPurchaseOrderItemNote != null ) {
            (values).put("to_PurchaseOrderItemNote", toPurchaseOrderItemNote);
        }
        if( toPurchaseOrderPricingElement != null ) {
            (values).put("to_PurchaseOrderPricingElement", toPurchaseOrderPricingElement);
        }
        if( toScheduleLine != null ) {
            (values).put("to_ScheduleLine", toScheduleLine);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchaseOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_PurchaseOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchaseOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseOrder fetchPurchaseOrder()
    {
        return fetchFieldAsSingle("to_PurchaseOrder", PurchaseOrder.class);
    }

    /**
     * Retrieval of associated <b>PurchaseOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseOrder</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrder</b> of a queried <b>PurchaseOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseOrder getPurchaseOrderOrFetch()
    {
        if( toPurchaseOrder == null ) {
            toPurchaseOrder = fetchPurchaseOrder();
        }
        return toPurchaseOrder;
    }

    /**
     * Retrieval of associated <b>PurchaseOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseOrder</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseOrder</b> is already loaded, the result will
     *         contain the <b>PurchaseOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchaseOrder> getPurchaseOrderIfPresent()
    {
        return Option.of(toPurchaseOrder);
    }

    /**
     * Overwrites the associated <b>PurchaseOrder</b> entity for the loaded navigation property <b>to_PurchaseOrder</b>.
     *
     * @param value
     *            New <b>PurchaseOrder</b> entity.
     */
    public void setPurchaseOrder( final PurchaseOrder value )
    {
        toPurchaseOrder = value;
    }

    /**
     * Fetches the <b>PurOrdAccountAssignment</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_AccountAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurOrdAccountAssignment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurOrdAccountAssignment> fetchAccountAssignment()
    {
        return fetchFieldAsList("to_AccountAssignment", PurOrdAccountAssignment.class);
    }

    /**
     * Retrieval of associated <b>PurOrdAccountAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property <b>to_AccountAssignment</b> of a queried <b>PurchaseOrderItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurOrdAccountAssignment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurOrdAccountAssignment> getAccountAssignmentOrFetch()
    {
        if( toAccountAssignment == null ) {
            toAccountAssignment = fetchAccountAssignment();
        }
        return toAccountAssignment;
    }

    /**
     * Retrieval of associated <b>PurOrdAccountAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_AccountAssignment</b> is already loaded, the result will
     *         contain the <b>PurOrdAccountAssignment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurOrdAccountAssignment>> getAccountAssignmentIfPresent()
    {
        return Option.of(toAccountAssignment);
    }

    /**
     * Overwrites the list of associated <b>PurOrdAccountAssignment</b> entities for the loaded navigation property
     * <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property <b>to_AccountAssignment</b> of a queried <b>PurchaseOrderItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurOrdAccountAssignment</b> entities.
     */
    public void setAccountAssignment( @Nonnull final List<PurOrdAccountAssignment> value )
    {
        if( toAccountAssignment == null ) {
            toAccountAssignment = Lists.newArrayList();
        }
        toAccountAssignment.clear();
        toAccountAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurOrdAccountAssignment</b> entities. This corresponds to the OData
     * navigation property <b>to_AccountAssignment</b>.
     * <p>
     * If the navigation property <b>to_AccountAssignment</b> of a queried <b>PurchaseOrderItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurOrdAccountAssignment</b> entities.
     */
    public void addAccountAssignment( PurOrdAccountAssignment... entity )
    {
        if( toAccountAssignment == null ) {
            toAccountAssignment = Lists.newArrayList();
        }
        toAccountAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurchaseOrderItemNote</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurchaseOrderItemNote</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseOrderItemNote</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderItemNote> fetchPurchaseOrderItemNote()
    {
        return fetchFieldAsList("to_PurchaseOrderItemNote", PurchaseOrderItemNote.class);
    }

    /**
     * Retrieval of associated <b>PurchaseOrderItemNote</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseOrderItemNote</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderItemNote</b> of a queried <b>PurchaseOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseOrderItemNote</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderItemNote> getPurchaseOrderItemNoteOrFetch()
    {
        if( toPurchaseOrderItemNote == null ) {
            toPurchaseOrderItemNote = fetchPurchaseOrderItemNote();
        }
        return toPurchaseOrderItemNote;
    }

    /**
     * Retrieval of associated <b>PurchaseOrderItemNote</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseOrderItemNote</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseOrderItemNote</b> is already loaded, the result
     *         will contain the <b>PurchaseOrderItemNote</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseOrderItemNote>> getPurchaseOrderItemNoteIfPresent()
    {
        return Option.of(toPurchaseOrderItemNote);
    }

    /**
     * Overwrites the list of associated <b>PurchaseOrderItemNote</b> entities for the loaded navigation property
     * <b>to_PurchaseOrderItemNote</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderItemNote</b> of a queried <b>PurchaseOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseOrderItemNote</b> entities.
     */
    public void setPurchaseOrderItemNote( @Nonnull final List<PurchaseOrderItemNote> value )
    {
        if( toPurchaseOrderItemNote == null ) {
            toPurchaseOrderItemNote = Lists.newArrayList();
        }
        toPurchaseOrderItemNote.clear();
        toPurchaseOrderItemNote.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseOrderItemNote</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseOrderItemNote</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderItemNote</b> of a queried <b>PurchaseOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseOrderItemNote</b> entities.
     */
    public void addPurchaseOrderItemNote( PurchaseOrderItemNote... entity )
    {
        if( toPurchaseOrderItemNote == null ) {
            toPurchaseOrderItemNote = Lists.newArrayList();
        }
        toPurchaseOrderItemNote.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurOrdPricingElement</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurchaseOrderPricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurOrdPricingElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurOrdPricingElement> fetchPurchaseOrderPricingElement()
    {
        return fetchFieldAsList("to_PurchaseOrderPricingElement", PurOrdPricingElement.class);
    }

    /**
     * Retrieval of associated <b>PurOrdPricingElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseOrderPricingElement</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderPricingElement</b> of a queried <b>PurchaseOrderItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurOrdPricingElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurOrdPricingElement> getPurchaseOrderPricingElementOrFetch()
    {
        if( toPurchaseOrderPricingElement == null ) {
            toPurchaseOrderPricingElement = fetchPurchaseOrderPricingElement();
        }
        return toPurchaseOrderPricingElement;
    }

    /**
     * Retrieval of associated <b>PurOrdPricingElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseOrderPricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseOrderPricingElement</b> is already loaded, the
     *         result will contain the <b>PurOrdPricingElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurOrdPricingElement>> getPurchaseOrderPricingElementIfPresent()
    {
        return Option.of(toPurchaseOrderPricingElement);
    }

    /**
     * Overwrites the list of associated <b>PurOrdPricingElement</b> entities for the loaded navigation property
     * <b>to_PurchaseOrderPricingElement</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderPricingElement</b> of a queried <b>PurchaseOrderItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurOrdPricingElement</b> entities.
     */
    public void setPurchaseOrderPricingElement( @Nonnull final List<PurOrdPricingElement> value )
    {
        if( toPurchaseOrderPricingElement == null ) {
            toPurchaseOrderPricingElement = Lists.newArrayList();
        }
        toPurchaseOrderPricingElement.clear();
        toPurchaseOrderPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurOrdPricingElement</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseOrderPricingElement</b>.
     * <p>
     * If the navigation property <b>to_PurchaseOrderPricingElement</b> of a queried <b>PurchaseOrderItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurOrdPricingElement</b> entities.
     */
    public void addPurchaseOrderPricingElement( PurOrdPricingElement... entity )
    {
        if( toPurchaseOrderPricingElement == null ) {
            toPurchaseOrderPricingElement = Lists.newArrayList();
        }
        toPurchaseOrderPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurchaseOrderScheduleLine</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseOrderScheduleLine</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderScheduleLine> fetchScheduleLine()
    {
        return fetchFieldAsList("to_ScheduleLine", PurchaseOrderScheduleLine.class);
    }

    /**
     * Retrieval of associated <b>PurchaseOrderScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>PurchaseOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseOrderScheduleLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseOrderScheduleLine> getScheduleLineOrFetch()
    {
        if( toScheduleLine == null ) {
            toScheduleLine = fetchScheduleLine();
        }
        return toScheduleLine;
    }

    /**
     * Retrieval of associated <b>PurchaseOrderScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrderItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ScheduleLine</b> is already loaded, the result will
     *         contain the <b>PurchaseOrderScheduleLine</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseOrderScheduleLine>> getScheduleLineIfPresent()
    {
        return Option.of(toScheduleLine);
    }

    /**
     * Overwrites the list of associated <b>PurchaseOrderScheduleLine</b> entities for the loaded navigation property
     * <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>PurchaseOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseOrderScheduleLine</b> entities.
     */
    public void setScheduleLine( @Nonnull final List<PurchaseOrderScheduleLine> value )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.clear();
        toScheduleLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseOrderScheduleLine</b> entities. This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>PurchaseOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseOrderScheduleLine</b> entities.
     */
    public void addScheduleLine( PurchaseOrderScheduleLine... entity )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchaseOrderItem instances.
     *
     */
    public final static class PurchaseOrderItemBuilder
    {

        private PurchaseOrder toPurchaseOrder;
        private String purchaseOrder = null;
        private List<PurOrdAccountAssignment> toAccountAssignment = Lists.newArrayList();
        private List<PurchaseOrderItemNote> toPurchaseOrderItemNote = Lists.newArrayList();
        private List<PurOrdPricingElement> toPurchaseOrderPricingElement = Lists.newArrayList();
        private List<PurchaseOrderScheduleLine> toScheduleLine = Lists.newArrayList();

        private PurchaseOrderItem.PurchaseOrderItemBuilder toPurchaseOrder( final PurchaseOrder value )
        {
            toPurchaseOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseOrder</b> for <b>PurchaseOrderItem</b> to single <b>PurchaseOrder</b>.
         *
         * @param value
         *            The PurchaseOrder to build this PurchaseOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderItem.PurchaseOrderItemBuilder purchaseOrder( final PurchaseOrder value )
        {
            return toPurchaseOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>PurchaseOrder</b>
         * </p>
         *
         * @param value
         *            The purchaseOrder to build this PurchaseOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderItem.PurchaseOrderItemBuilder purchaseOrder( final String value )
        {
            purchaseOrder = value;
            return this;
        }

        private PurchaseOrderItem.PurchaseOrderItemBuilder toAccountAssignment(
            final List<PurOrdAccountAssignment> value )
        {
            toAccountAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_AccountAssignment</b> for <b>PurchaseOrderItem</b> to multiple
         * <b>PurOrdAccountAssignment</b>.
         *
         * @param value
         *            The PurOrdAccountAssignments to build this PurchaseOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderItem.PurchaseOrderItemBuilder accountAssignment( PurOrdAccountAssignment... value )
        {
            return toAccountAssignment(Lists.newArrayList(value));
        }

        private PurchaseOrderItem.PurchaseOrderItemBuilder toPurchaseOrderItemNote(
            final List<PurchaseOrderItemNote> value )
        {
            toPurchaseOrderItemNote.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseOrderItemNote</b> for <b>PurchaseOrderItem</b> to multiple
         * <b>PurchaseOrderItemNote</b>.
         *
         * @param value
         *            The PurchaseOrderItemNotes to build this PurchaseOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderItem.PurchaseOrderItemBuilder purchaseOrderItemNote( PurchaseOrderItemNote... value )
        {
            return toPurchaseOrderItemNote(Lists.newArrayList(value));
        }

        private PurchaseOrderItem.PurchaseOrderItemBuilder toPurchaseOrderPricingElement(
            final List<PurOrdPricingElement> value )
        {
            toPurchaseOrderPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseOrderPricingElement</b> for <b>PurchaseOrderItem</b> to multiple
         * <b>PurOrdPricingElement</b>.
         *
         * @param value
         *            The PurOrdPricingElements to build this PurchaseOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderItem.PurchaseOrderItemBuilder purchaseOrderPricingElement( PurOrdPricingElement... value )
        {
            return toPurchaseOrderPricingElement(Lists.newArrayList(value));
        }

        private PurchaseOrderItem.PurchaseOrderItemBuilder toScheduleLine( final List<PurchaseOrderScheduleLine> value )
        {
            toScheduleLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ScheduleLine</b> for <b>PurchaseOrderItem</b> to multiple
         * <b>PurchaseOrderScheduleLine</b>.
         *
         * @param value
         *            The PurchaseOrderScheduleLines to build this PurchaseOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderItem.PurchaseOrderItemBuilder scheduleLine( PurchaseOrderScheduleLine... value )
        {
            return toScheduleLine(Lists.newArrayList(value));
        }

    }

}
