/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurchaseOrderItemNoteField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.PurchaseOrderItemNoteSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Notes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseOrderItemNoteType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseOrderItemNote extends VdmEntity<PurchaseOrderItemNote>
{

    /**
     * Selector for all available fields of PurchaseOrderItemNote.
     *
     */
    public final static PurchaseOrderItemNoteSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchaseOrder" )
    @JsonProperty( "PurchaseOrder" )
    @Nullable
    @ODataField( odataName = "PurchaseOrder" )
    private String purchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrder</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemNoteField<String> PURCHASE_ORDER =
        new PurchaseOrderItemNoteField<String>("PurchaseOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchaseOrderItem" )
    @JsonProperty( "PurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderItem" )
    private String purchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemNoteField<String> PURCHASE_ORDER_ITEM =
        new PurchaseOrderItemNoteField<String>("PurchaseOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "TextObjectType" )
    @JsonProperty( "TextObjectType" )
    @Nullable
    @ODataField( odataName = "TextObjectType" )
    private String textObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TextObjectType</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemNoteField<String> TEXT_OBJECT_TYPE =
        new PurchaseOrderItemNoteField<String>("TextObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemNoteField<String> LANGUAGE =
        new PurchaseOrderItemNoteField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "PlainLongText" )
    @JsonProperty( "PlainLongText" )
    @Nullable
    @ODataField( odataName = "PlainLongText" )
    private String plainLongText;
    /**
     * Use with available fluent helpers to apply the <b>PlainLongText</b> field to query operations.
     *
     */
    public final static PurchaseOrderItemNoteField<String> PLAIN_LONG_TEXT =
        new PurchaseOrderItemNoteField<String>("PlainLongText");

    @Nonnull
    @Override
    public Class<PurchaseOrderItemNote> getType()
    {
        return PurchaseOrderItemNote.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrder</b>
     * </p>
     *
     * @param purchaseOrder
     *            Purchasing Document Number
     */
    public void setPurchaseOrder( @Nullable final String purchaseOrder )
    {
        rememberChangedField("PurchaseOrder", this.purchaseOrder);
        this.purchaseOrder = purchaseOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderItem</b>
     * </p>
     *
     * @param purchaseOrderItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseOrderItem( @Nullable final String purchaseOrderItem )
    {
        rememberChangedField("PurchaseOrderItem", this.purchaseOrderItem);
        this.purchaseOrderItem = purchaseOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectType</b>
     * </p>
     *
     * @param textObjectType
     *            Text ID
     */
    public void setTextObjectType( @Nullable final String textObjectType )
    {
        rememberChangedField("TextObjectType", this.textObjectType);
        this.textObjectType = textObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseOrderItemNote";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseOrder", getPurchaseOrder());
        result.put("PurchaseOrderItem", getPurchaseOrderItem());
        result.put("TextObjectType", getTextObjectType());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseOrder", getPurchaseOrder());
        values.put("PurchaseOrderItem", getPurchaseOrderItem());
        values.put("TextObjectType", getTextObjectType());
        values.put("Language", getLanguage());
        values.put("PlainLongText", getPlainLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseOrder") ) {
                final Object value = values.remove("PurchaseOrder");
                if( (value == null) || (!value.equals(getPurchaseOrder())) ) {
                    setPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderItem") ) {
                final Object value = values.remove("PurchaseOrderItem");
                if( (value == null) || (!value.equals(getPurchaseOrderItem())) ) {
                    setPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("TextObjectType") ) {
                final Object value = values.remove("TextObjectType");
                if( (value == null) || (!value.equals(getTextObjectType())) ) {
                    setTextObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseOrderItemNoteField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseOrderItemNoteField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseOrderItemNoteField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseOrderItemNoteField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

}
