/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurchaseOrderScheduleLineField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.PurchaseOrderScheduleLineLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.PurchaseOrderScheduleLineSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Schedule Lines
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseOrderScheduleLineType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseOrderScheduleLine extends VdmEntity<PurchaseOrderScheduleLine>
{

    /**
     * Selector for all available fields of PurchaseOrderScheduleLine.
     *
     */
    public final static PurchaseOrderScheduleLineSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> PURCHASING_DOCUMENT =
        new PurchaseOrderScheduleLineField<String>("PurchasingDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> PURCHASING_DOCUMENT_ITEM =
        new PurchaseOrderScheduleLineField<String>("PurchasingDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Delivery Schedule Line Counter
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> SCHEDULE_LINE =
        new PurchaseOrderScheduleLineField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DelivDateCategory</b>
     * </p>
     *
     * @return Category of delivery date
     */
    @SerializedName( "DelivDateCategory" )
    @JsonProperty( "DelivDateCategory" )
    @Nullable
    @ODataField( odataName = "DelivDateCategory" )
    private String delivDateCategory;
    /**
     * Use with available fluent helpers to apply the <b>DelivDateCategory</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> DELIV_DATE_CATEGORY =
        new PurchaseOrderScheduleLineField<String>("DelivDateCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @return Item Delivery Date
     */
    @SerializedName( "ScheduleLineDeliveryDate" )
    @JsonProperty( "ScheduleLineDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduleLineDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<LocalDateTime> SCHEDULE_LINE_DELIVERY_DATE =
        new PurchaseOrderScheduleLineField<LocalDateTime>("ScheduleLineDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurchaseOrderQuantityUnit" )
    @JsonProperty( "PurchaseOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderQuantityUnit" )
    private String purchaseOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> PURCHASE_ORDER_QUANTITY_UNIT =
        new PurchaseOrderScheduleLineField<String>("PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Scheduled Quantity
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new PurchaseOrderScheduleLineField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryTime</b>
     * </p>
     *
     * @return Delivery Date Time-Spot
     */
    @SerializedName( "ScheduleLineDeliveryTime" )
    @JsonProperty( "ScheduleLineDeliveryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduleLineDeliveryTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryTime</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<LocalTime> SCHEDULE_LINE_DELIVERY_TIME =
        new PurchaseOrderScheduleLineField<LocalTime>("ScheduleLineDeliveryTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineStscDeliveryDate</b>
     * </p>
     *
     * @return Statistics-Relevant Delivery Date
     */
    @SerializedName( "SchedLineStscDeliveryDate" )
    @JsonProperty( "SchedLineStscDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedLineStscDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedLineStscDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedLineStscDeliveryDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<LocalDateTime> SCHED_LINE_STSC_DELIVERY_DATE =
        new PurchaseOrderScheduleLineField<LocalDateTime>("SchedLineStscDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> PURCHASE_REQUISITION =
        new PurchaseOrderScheduleLineField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<String> PURCHASE_REQUISITION_ITEM =
        new PurchaseOrderScheduleLineField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineCommittedQuantity</b>
     * </p>
     *
     * @return Committed Quantity
     */
    @SerializedName( "ScheduleLineCommittedQuantity" )
    @JsonProperty( "ScheduleLineCommittedQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineCommittedQuantity" )
    private BigDecimal scheduleLineCommittedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineCommittedQuantity</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<BigDecimal> SCHEDULE_LINE_COMMITTED_QUANTITY =
        new PurchaseOrderScheduleLineField<BigDecimal>("ScheduleLineCommittedQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @return Start Date for Period of Performance
     */
    @SerializedName( "PerformancePeriodStartDate" )
    @JsonProperty( "PerformancePeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodStartDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<LocalDateTime> PERFORMANCE_PERIOD_START_DATE =
        new PurchaseOrderScheduleLineField<LocalDateTime>("PerformancePeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @return End Date for Period of Performance
     */
    @SerializedName( "PerformancePeriodEndDate" )
    @JsonProperty( "PerformancePeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodEndDate</b> field to query operations.
     *
     */
    public final static PurchaseOrderScheduleLineField<LocalDateTime> PERFORMANCE_PERIOD_END_DATE =
        new PurchaseOrderScheduleLineField<LocalDateTime>("PerformancePeriodEndDate");
    /**
     * Navigation property <b>to_SubcontractingComponent</b> for <b>PurchaseOrderScheduleLine</b> to multiple
     * <b>POSubcontractingComponent</b>.
     *
     */
    @SerializedName( "to_SubcontractingComponent" )
    @JsonProperty( "to_SubcontractingComponent" )
    @ODataField( odataName = "to_SubcontractingComponent" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<POSubcontractingComponent> toSubcontractingComponent;
    /**
     * Use with available fluent helpers to apply the <b>to_SubcontractingComponent</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseOrderScheduleLineLink<POSubcontractingComponent> TO_SUBCONTRACTING_COMPONENT =
        new PurchaseOrderScheduleLineLink<POSubcontractingComponent>("to_SubcontractingComponent");

    @Nonnull
    @Override
    public Class<PurchaseOrderScheduleLine> getType()
    {
        return PurchaseOrderScheduleLine.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Item Number of Purchasing Document
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DelivDateCategory</b>
     * </p>
     *
     * @param delivDateCategory
     *            Category of delivery date
     */
    public void setDelivDateCategory( @Nullable final String delivDateCategory )
    {
        rememberChangedField("DelivDateCategory", this.delivDateCategory);
        this.delivDateCategory = delivDateCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @param scheduleLineDeliveryDate
     *            Item Delivery Date
     */
    public void setScheduleLineDeliveryDate( @Nullable final LocalDateTime scheduleLineDeliveryDate )
    {
        rememberChangedField("ScheduleLineDeliveryDate", this.scheduleLineDeliveryDate);
        this.scheduleLineDeliveryDate = scheduleLineDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     *
     * @param purchaseOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Scheduled Quantity
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryTime</b>
     * </p>
     *
     * @param scheduleLineDeliveryTime
     *            Delivery Date Time-Spot
     */
    public void setScheduleLineDeliveryTime( @Nullable final LocalTime scheduleLineDeliveryTime )
    {
        rememberChangedField("ScheduleLineDeliveryTime", this.scheduleLineDeliveryTime);
        this.scheduleLineDeliveryTime = scheduleLineDeliveryTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineStscDeliveryDate</b>
     * </p>
     *
     * @param schedLineStscDeliveryDate
     *            Statistics-Relevant Delivery Date
     */
    public void setSchedLineStscDeliveryDate( @Nullable final LocalDateTime schedLineStscDeliveryDate )
    {
        rememberChangedField("SchedLineStscDeliveryDate", this.schedLineStscDeliveryDate);
        this.schedLineStscDeliveryDate = schedLineStscDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineCommittedQuantity</b>
     * </p>
     *
     * @param scheduleLineCommittedQuantity
     *            Committed Quantity
     */
    public void setScheduleLineCommittedQuantity( @Nullable final BigDecimal scheduleLineCommittedQuantity )
    {
        rememberChangedField("ScheduleLineCommittedQuantity", this.scheduleLineCommittedQuantity);
        this.scheduleLineCommittedQuantity = scheduleLineCommittedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @param performancePeriodStartDate
     *            Start Date for Period of Performance
     */
    public void setPerformancePeriodStartDate( @Nullable final LocalDateTime performancePeriodStartDate )
    {
        rememberChangedField("PerformancePeriodStartDate", this.performancePeriodStartDate);
        this.performancePeriodStartDate = performancePeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @param performancePeriodEndDate
     *            End Date for Period of Performance
     */
    public void setPerformancePeriodEndDate( @Nullable final LocalDateTime performancePeriodEndDate )
    {
        rememberChangedField("PerformancePeriodEndDate", this.performancePeriodEndDate);
        this.performancePeriodEndDate = performancePeriodEndDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseOrderScheduleLine";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchasingDocument", getPurchasingDocument());
        result.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("DelivDateCategory", getDelivDateCategory());
        values.put("ScheduleLineDeliveryDate", getScheduleLineDeliveryDate());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("ScheduleLineDeliveryTime", getScheduleLineDeliveryTime());
        values.put("SchedLineStscDeliveryDate", getSchedLineStscDeliveryDate());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("ScheduleLineCommittedQuantity", getScheduleLineCommittedQuantity());
        values.put("PerformancePeriodStartDate", getPerformancePeriodStartDate());
        values.put("PerformancePeriodEndDate", getPerformancePeriodEndDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("DelivDateCategory") ) {
                final Object value = values.remove("DelivDateCategory");
                if( (value == null) || (!value.equals(getDelivDateCategory())) ) {
                    setDelivDateCategory(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryDate") ) {
                final Object value = values.remove("ScheduleLineDeliveryDate");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryDate())) ) {
                    setScheduleLineDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryTime") ) {
                final Object value = values.remove("ScheduleLineDeliveryTime");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryTime())) ) {
                    setScheduleLineDeliveryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SchedLineStscDeliveryDate") ) {
                final Object value = values.remove("SchedLineStscDeliveryDate");
                if( (value == null) || (!value.equals(getSchedLineStscDeliveryDate())) ) {
                    setSchedLineStscDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineCommittedQuantity") ) {
                final Object value = values.remove("ScheduleLineCommittedQuantity");
                if( (value == null) || (!value.equals(getScheduleLineCommittedQuantity())) ) {
                    setScheduleLineCommittedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PerformancePeriodStartDate") ) {
                final Object value = values.remove("PerformancePeriodStartDate");
                if( (value == null) || (!value.equals(getPerformancePeriodStartDate())) ) {
                    setPerformancePeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodEndDate") ) {
                final Object value = values.remove("PerformancePeriodEndDate");
                if( (value == null) || (!value.equals(getPerformancePeriodEndDate())) ) {
                    setPerformancePeriodEndDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SubcontractingComponent") ) {
                final Object value = (values).remove("to_SubcontractingComponent");
                if( value instanceof Iterable ) {
                    if( toSubcontractingComponent == null ) {
                        toSubcontractingComponent = Lists.newArrayList();
                    } else {
                        toSubcontractingComponent = Lists.newArrayList(toSubcontractingComponent);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        POSubcontractingComponent entity;
                        if( toSubcontractingComponent.size() > i ) {
                            entity = toSubcontractingComponent.get(i);
                        } else {
                            entity = new POSubcontractingComponent();
                            toSubcontractingComponent.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseOrderScheduleLineField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseOrderScheduleLineField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseOrderScheduleLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseOrderScheduleLineField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSubcontractingComponent != null ) {
            (values).put("to_SubcontractingComponent", toSubcontractingComponent);
        }
        return values;
    }

    /**
     * Fetches the <b>POSubcontractingComponent</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubcontractingComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>POSubcontractingComponent</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<POSubcontractingComponent> fetchSubcontractingComponent()
    {
        return fetchFieldAsList("to_SubcontractingComponent", POSubcontractingComponent.class);
    }

    /**
     * Retrieval of associated <b>POSubcontractingComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubcontractingComponent</b>.
     * <p>
     * If the navigation property <b>to_SubcontractingComponent</b> of a queried <b>PurchaseOrderScheduleLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>POSubcontractingComponent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<POSubcontractingComponent> getSubcontractingComponentOrFetch()
    {
        if( toSubcontractingComponent == null ) {
            toSubcontractingComponent = fetchSubcontractingComponent();
        }
        return toSubcontractingComponent;
    }

    /**
     * Retrieval of associated <b>POSubcontractingComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubcontractingComponent</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseOrderScheduleLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubcontractingComponent</b> is already loaded, the
     *         result will contain the <b>POSubcontractingComponent</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<POSubcontractingComponent>> getSubcontractingComponentIfPresent()
    {
        return Option.of(toSubcontractingComponent);
    }

    /**
     * Overwrites the list of associated <b>POSubcontractingComponent</b> entities for the loaded navigation property
     * <b>to_SubcontractingComponent</b>.
     * <p>
     * If the navigation property <b>to_SubcontractingComponent</b> of a queried <b>PurchaseOrderScheduleLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>POSubcontractingComponent</b> entities.
     */
    public void setSubcontractingComponent( @Nonnull final List<POSubcontractingComponent> value )
    {
        if( toSubcontractingComponent == null ) {
            toSubcontractingComponent = Lists.newArrayList();
        }
        toSubcontractingComponent.clear();
        toSubcontractingComponent.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>POSubcontractingComponent</b> entities. This corresponds to the OData
     * navigation property <b>to_SubcontractingComponent</b>.
     * <p>
     * If the navigation property <b>to_SubcontractingComponent</b> of a queried <b>PurchaseOrderScheduleLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>POSubcontractingComponent</b> entities.
     */
    public void addSubcontractingComponent( POSubcontractingComponent... entity )
    {
        if( toSubcontractingComponent == null ) {
            toSubcontractingComponent = Lists.newArrayList();
        }
        toSubcontractingComponent.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchaseOrderScheduleLine instances.
     *
     */
    public final static class PurchaseOrderScheduleLineBuilder
    {

        private List<POSubcontractingComponent> toSubcontractingComponent = Lists.newArrayList();

        private PurchaseOrderScheduleLine.PurchaseOrderScheduleLineBuilder toSubcontractingComponent(
            final List<POSubcontractingComponent> value )
        {
            toSubcontractingComponent.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubcontractingComponent</b> for <b>PurchaseOrderScheduleLine</b> to multiple
         * <b>POSubcontractingComponent</b>.
         *
         * @param value
         *            The POSubcontractingComponents to build this PurchaseOrderScheduleLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseOrderScheduleLine.PurchaseOrderScheduleLineBuilder subcontractingComponent(
            POSubcontractingComponent... value )
        {
            return toSubcontractingComponent(Lists.newArrayList(value));
        }

    }

}
