/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable.PurchaseOrderScheduleLineSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
 * PurchaseOrderScheduleLine} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PurchaseOrderScheduleLineByKeyFluentHelper
    extends
    FluentHelperByKey<PurchaseOrderScheduleLineByKeyFluentHelper, PurchaseOrderScheduleLine, PurchaseOrderScheduleLineSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurchaseOrderScheduleLine}
     * @param purchasingDocument
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurchaseOrderScheduleLine}
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingDocumentItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public PurchaseOrderScheduleLineByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchasingDocument,
        final String purchasingDocumentItem,
        final String scheduleLine )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchasingDocument", purchasingDocument);
        this.key.put("PurchasingDocumentItem", purchasingDocumentItem);
        this.key.put("ScheduleLine", scheduleLine);
    }

    @Override
    @Nonnull
    protected Class<PurchaseOrderScheduleLine> getEntityClass()
    {
        return PurchaseOrderScheduleLine.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
