/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchaseOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService PurchaseOrderService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchaseOrderServiceBatch
    extends
    BatchFluentHelperBasic<PurchaseOrderServiceBatch, PurchaseOrderServiceBatchChangeSet>
    implements
    PurchaseOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchaseOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchaseOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchaseOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchaseOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchaseOrderServiceBatchChangeSet(this, service);
    }

}
