/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine;

/**
 * Implementation of the {@link PurchaseOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService PurchaseOrderService}.
 *
 */
public class DefaultPurchaseOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchaseOrderServiceBatch, PurchaseOrderServiceBatchChangeSet>
    implements
    PurchaseOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchaseOrderServiceBatchChangeSet(
        @Nonnull final DefaultPurchaseOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPOSubcontractingComponent(
        @Nonnull final POSubcontractingComponent pOSubcontractingComponent )
    {
        return addRequestCreate(service::createPOSubcontractingComponent, pOSubcontractingComponent);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePOSubcontractingComponent(
        @Nonnull final POSubcontractingComponent pOSubcontractingComponent )
    {
        return addRequestUpdate(service::updatePOSubcontractingComponent, pOSubcontractingComponent);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePOSubcontractingComponent(
        @Nonnull final POSubcontractingComponent pOSubcontractingComponent )
    {
        return addRequestDelete(service::deletePOSubcontractingComponent, pOSubcontractingComponent);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder )
    {
        return addRequestCreate(service::createPurchaseOrder, purchaseOrder);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder )
    {
        return addRequestUpdate(service::updatePurchaseOrder, purchaseOrder);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder )
    {
        return addRequestDelete(service::deletePurchaseOrder, purchaseOrder);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurchaseOrderItem(
        @Nonnull final PurchaseOrderItem purchaseOrderItem )
    {
        return addRequestCreate(service::createPurchaseOrderItem, purchaseOrderItem);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurchaseOrderItem(
        @Nonnull final PurchaseOrderItem purchaseOrderItem )
    {
        return addRequestUpdate(service::updatePurchaseOrderItem, purchaseOrderItem);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurchaseOrderItem(
        @Nonnull final PurchaseOrderItem purchaseOrderItem )
    {
        return addRequestDelete(service::deletePurchaseOrderItem, purchaseOrderItem);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurchaseOrderItemNote(
        @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote )
    {
        return addRequestCreate(service::createPurchaseOrderItemNote, purchaseOrderItemNote);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurchaseOrderItemNote(
        @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote )
    {
        return addRequestUpdate(service::updatePurchaseOrderItemNote, purchaseOrderItemNote);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurchaseOrderItemNote(
        @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote )
    {
        return addRequestDelete(service::deletePurchaseOrderItemNote, purchaseOrderItemNote);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurchaseOrderNote(
        @Nonnull final PurchaseOrderNote purchaseOrderNote )
    {
        return addRequestCreate(service::createPurchaseOrderNote, purchaseOrderNote);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurchaseOrderNote(
        @Nonnull final PurchaseOrderNote purchaseOrderNote )
    {
        return addRequestUpdate(service::updatePurchaseOrderNote, purchaseOrderNote);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurchaseOrderNote(
        @Nonnull final PurchaseOrderNote purchaseOrderNote )
    {
        return addRequestDelete(service::deletePurchaseOrderNote, purchaseOrderNote);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurchaseOrderScheduleLine(
        @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine )
    {
        return addRequestCreate(service::createPurchaseOrderScheduleLine, purchaseOrderScheduleLine);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurchaseOrderScheduleLine(
        @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine )
    {
        return addRequestUpdate(service::updatePurchaseOrderScheduleLine, purchaseOrderScheduleLine);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurchaseOrderScheduleLine(
        @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine )
    {
        return addRequestDelete(service::deletePurchaseOrderScheduleLine, purchaseOrderScheduleLine);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurOrdAccountAssignment(
        @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment )
    {
        return addRequestCreate(service::createPurOrdAccountAssignment, purOrdAccountAssignment);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurOrdAccountAssignment(
        @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment )
    {
        return addRequestUpdate(service::updatePurOrdAccountAssignment, purOrdAccountAssignment);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurOrdAccountAssignment(
        @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment )
    {
        return addRequestDelete(service::deletePurOrdAccountAssignment, purOrdAccountAssignment);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet createPurOrdPricingElement(
        @Nonnull final PurOrdPricingElement purOrdPricingElement )
    {
        return addRequestCreate(service::createPurOrdPricingElement, purOrdPricingElement);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet updatePurOrdPricingElement(
        @Nonnull final PurOrdPricingElement purOrdPricingElement )
    {
        return addRequestUpdate(service::updatePurOrdPricingElement, purOrdPricingElement);
    }

    @Nonnull
    @Override
    public PurchaseOrderServiceBatchChangeSet deletePurOrdPricingElement(
        @Nonnull final PurOrdPricingElement purOrdPricingElement )
    {
        return addRequestDelete(service::deletePurOrdPricingElement, purOrdPricingElement);
    }

}
