/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseOrderService PurchaseOrderService}.
 *
 */
public interface PurchaseOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchaseOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchaseOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity and save it to the S/4HANA system.
     *
     * @param pOSubcontractingComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *            POSubcontractingComponent} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        createPOSubcontractingComponent( @Nonnull final POSubcontractingComponent pOSubcontractingComponent );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity and save it to the S/4HANA system.
     *
     * @param pOSubcontractingComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *            POSubcontractingComponent} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        updatePOSubcontractingComponent( @Nonnull final POSubcontractingComponent pOSubcontractingComponent );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     * POSubcontractingComponent} entity in the S/4HANA system.
     *
     * @param pOSubcontractingComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
     *            POSubcontractingComponent} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        deletePOSubcontractingComponent( @Nonnull final POSubcontractingComponent pOSubcontractingComponent );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet createPurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet updatePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder
     * PurchaseOrder} entity in the S/4HANA system.
     *
     * @param purchaseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrder PurchaseOrder}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet deletePurchaseOrder( @Nonnull final PurchaseOrder purchaseOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *            PurchaseOrderItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet createPurchaseOrderItem( @Nonnull final PurchaseOrderItem purchaseOrderItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *            PurchaseOrderItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet updatePurchaseOrderItem( @Nonnull final PurchaseOrderItem purchaseOrderItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     * PurchaseOrderItem} entity in the S/4HANA system.
     *
     * @param purchaseOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItem
     *            PurchaseOrderItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet deletePurchaseOrderItem( @Nonnull final PurchaseOrderItem purchaseOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItemNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *            PurchaseOrderItemNote} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        createPurchaseOrderItemNote( @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderItemNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *            PurchaseOrderItemNote} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        updatePurchaseOrderItemNote( @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     * PurchaseOrderItemNote} entity in the S/4HANA system.
     *
     * @param purchaseOrderItemNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderItemNote
     *            PurchaseOrderItemNote} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        deletePurchaseOrderItemNote( @Nonnull final PurchaseOrderItemNote purchaseOrderItemNote );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *            PurchaseOrderNote} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet createPurchaseOrderNote( @Nonnull final PurchaseOrderNote purchaseOrderNote );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *            PurchaseOrderNote} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet updatePurchaseOrderNote( @Nonnull final PurchaseOrderNote purchaseOrderNote );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     * PurchaseOrderNote} entity in the S/4HANA system.
     *
     * @param purchaseOrderNote
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote
     *            PurchaseOrderNote} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet deletePurchaseOrderNote( @Nonnull final PurchaseOrderNote purchaseOrderNote );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *            PurchaseOrderScheduleLine} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        createPurchaseOrderScheduleLine( @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param purchaseOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *            PurchaseOrderScheduleLine} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        updatePurchaseOrderScheduleLine( @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     * PurchaseOrderScheduleLine} entity in the S/4HANA system.
     *
     * @param purchaseOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
     *            PurchaseOrderScheduleLine} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        deletePurchaseOrderScheduleLine( @Nonnull final PurchaseOrderScheduleLine purchaseOrderScheduleLine );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity and save it to the S/4HANA system.
     *
     * @param purOrdAccountAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *            PurOrdAccountAssignment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        createPurOrdAccountAssignment( @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity and save it to the S/4HANA system.
     *
     * @param purOrdAccountAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *            PurOrdAccountAssignment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        updatePurOrdAccountAssignment( @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     * PurOrdAccountAssignment} entity in the S/4HANA system.
     *
     * @param purOrdAccountAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdAccountAssignment
     *            PurOrdAccountAssignment} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        deletePurOrdAccountAssignment( @Nonnull final PurOrdAccountAssignment purOrdAccountAssignment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity and save it to the S/4HANA system.
     *
     * @param purOrdPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *            PurOrdPricingElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        createPurOrdPricingElement( @Nonnull final PurOrdPricingElement purOrdPricingElement );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity and save it to the S/4HANA system.
     *
     * @param purOrdPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *            PurOrdPricingElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        updatePurOrdPricingElement( @Nonnull final PurOrdPricingElement purOrdPricingElement );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     * PurOrdPricingElement} entity in the S/4HANA system.
     *
     * @param purOrdPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurOrdPricingElement
     *            PurOrdPricingElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseOrderServiceBatchChangeSet
        deletePurOrdPricingElement( @Nonnull final PurOrdPricingElement purOrdPricingElement );

}
