/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent
 * POSubcontractingComponent}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.POSubcontractingComponentField
 * POSubcontractingComponentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.POSubcontractingComponentLink
 * POSubcontractingComponentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#PURCHASE_ORDER_ITEM
 * PURCHASE_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#RECORD_TYPE
 * RECORD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#BOM_ITEM_DESCRIPTION
 * BOM_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#REQUIRED_QUANTITY
 * REQUIRED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#REQUIREMENT_DATE
 * REQUIREMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#QUANTITY_IN_ENTRY_UNIT
 * QUANTITY_IN_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#ENTRY_UNIT
 * ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#WITHDRAWN_QUANTITY
 * WITHDRAWN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.POSubcontractingComponent#BATCH
 * BATCH}</li>
 * </ul>
 *
 */
public interface POSubcontractingComponentSelectable extends EntitySelectable<POSubcontractingComponent>
{

}
