/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote PurchaseOrderNote}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurchaseOrderNoteField
 * PurchaseOrderNoteField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.PurchaseOrderNoteLink
 * PurchaseOrderNoteLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote#PURCHASE_ORDER
 * PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote#TEXT_OBJECT_TYPE
 * TEXT_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderNote#PLAIN_LONG_TEXT
 * PLAIN_LONG_TEXT}</li>
 * </ul>
 *
 */
public interface PurchaseOrderNoteSelectable extends EntitySelectable<PurchaseOrderNote>
{

}
