/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine
 * PurchaseOrderScheduleLine}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.field.PurchaseOrderScheduleLineField
 * PurchaseOrderScheduleLineField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.link.PurchaseOrderScheduleLineLink
 * PurchaseOrderScheduleLineLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#DELIV_DATE_CATEGORY
 * DELIV_DATE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#SCHEDULE_LINE_DELIVERY_DATE
 * SCHEDULE_LINE_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PURCHASE_ORDER_QUANTITY_UNIT
 * PURCHASE_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#SCHEDULE_LINE_ORDER_QUANTITY
 * SCHEDULE_LINE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#SCHEDULE_LINE_DELIVERY_TIME
 * SCHEDULE_LINE_DELIVERY_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#SCHED_LINE_STSC_DELIVERY_DATE
 * SCHED_LINE_STSC_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#SCHEDULE_LINE_COMMITTED_QUANTITY
 * SCHEDULE_LINE_COMMITTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PERFORMANCE_PERIOD_START_DATE
 * PERFORMANCE_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#PERFORMANCE_PERIOD_END_DATE
 * PERFORMANCE_PERIOD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaseorder.PurchaseOrderScheduleLine#TO_SUBCONTRACTING_COMPONENT
 * TO_SUBCONTRACTING_COMPONENT}</li>
 * </ul>
 *
 */
public interface PurchaseOrderScheduleLineSelectable extends EntitySelectable<PurchaseOrderScheduleLine>
{

}
