/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>Messages</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Messages extends VdmComplex<Messages>
{

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>Type</b>
     * </p>
     *
     * @param type_2
     *
     * @return Message Type
     */
    @SerializedName( "Type" )
    @JsonProperty( "Type" )
    @Nullable
    @ODataField( odataName = "Type" )
    private String type_2;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *
     * @return Message Class
     */
    @SerializedName( "Id" )
    @JsonProperty( "Id" )
    @Nullable
    @ODataField( odataName = "Id" )
    private String id;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>Number</b>
     * </p>
     *
     * @param number
     *
     * @return Message Number
     */
    @SerializedName( "Number" )
    @JsonProperty( "Number" )
    @Nullable
    @ODataField( odataName = "Number" )
    private String number;
    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *
     * @return Message Text
     */
    @SerializedName( "Message" )
    @JsonProperty( "Message" )
    @Nullable
    @ODataField( odataName = "Message" )
    private String message;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>LogNo</b>
     * </p>
     *
     * @param logNo
     *
     * @return Log number
     */
    @SerializedName( "LogNo" )
    @JsonProperty( "LogNo" )
    @Nullable
    @ODataField( odataName = "LogNo" )
    private String logNo;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>LogMsgNo</b>
     * </p>
     *
     * @param logMsgNo
     *
     * @return Message Number
     */
    @SerializedName( "LogMsgNo" )
    @JsonProperty( "LogMsgNo" )
    @Nullable
    @ODataField( odataName = "LogMsgNo" )
    private String logMsgNo;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV1</b>
     * </p>
     *
     * @param messageV1
     *
     * @return Message Variable
     */
    @SerializedName( "MessageV1" )
    @JsonProperty( "MessageV1" )
    @Nullable
    @ODataField( odataName = "MessageV1" )
    private String messageV1;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV2</b>
     * </p>
     *
     * @param messageV2
     *
     * @return Message Variable
     */
    @SerializedName( "MessageV2" )
    @JsonProperty( "MessageV2" )
    @Nullable
    @ODataField( odataName = "MessageV2" )
    private String messageV2;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV3</b>
     * </p>
     *
     * @param messageV3
     *
     * @return Message Variable
     */
    @SerializedName( "MessageV3" )
    @JsonProperty( "MessageV3" )
    @Nullable
    @ODataField( odataName = "MessageV3" )
    private String messageV3;
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV4</b>
     * </p>
     *
     * @param messageV4
     *
     * @return Message Variable
     */
    @SerializedName( "MessageV4" )
    @JsonProperty( "MessageV4" )
    @Nullable
    @ODataField( odataName = "MessageV4" )
    private String messageV4;
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property from the Odata EDM: <b>Parameter</b>
     * </p>
     *
     * @param parameter
     *
     * @return Parameter Name
     */
    @SerializedName( "Parameter" )
    @JsonProperty( "Parameter" )
    @Nullable
    @ODataField( odataName = "Parameter" )
    private String parameter;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Row</b>
     * </p>
     *
     * @param row
     *
     * @return Parameter line
     */
    @SerializedName( "Row" )
    @JsonProperty( "Row" )
    @Nullable
    @ODataField( odataName = "Row" )
    private Integer row;
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>Field</b>
     * </p>
     *
     * @param field
     *
     * @return Field name
     */
    @SerializedName( "Field" )
    @JsonProperty( "Field" )
    @Nullable
    @ODataField( odataName = "Field" )
    private String field;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>System</b>
     * </p>
     *
     * @param system
     *
     * @return Logical system
     */
    @SerializedName( "System" )
    @JsonProperty( "System" )
    @Nullable
    @ODataField( odataName = "System" )
    private String system;

    @Nonnull
    @Override
    public Class<Messages> getType()
    {
        return Messages.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Type", getType_2());
        values.put("Id", getId());
        values.put("Number", getNumber());
        values.put("Message", getMessage());
        values.put("LogNo", getLogNo());
        values.put("LogMsgNo", getLogMsgNo());
        values.put("MessageV1", getMessageV1());
        values.put("MessageV2", getMessageV2());
        values.put("MessageV3", getMessageV3());
        values.put("MessageV4", getMessageV4());
        values.put("Parameter", getParameter());
        values.put("Row", getRow());
        values.put("Field", getField());
        values.put("System", getSystem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Type") ) {
                final Object value = values.remove("Type");
                if( (value == null) || (!value.equals(getType_2())) ) {
                    setType_2(((String) value));
                }
            }
            if( values.containsKey("Id") ) {
                final Object value = values.remove("Id");
                if( (value == null) || (!value.equals(getId())) ) {
                    setId(((String) value));
                }
            }
            if( values.containsKey("Number") ) {
                final Object value = values.remove("Number");
                if( (value == null) || (!value.equals(getNumber())) ) {
                    setNumber(((String) value));
                }
            }
            if( values.containsKey("Message") ) {
                final Object value = values.remove("Message");
                if( (value == null) || (!value.equals(getMessage())) ) {
                    setMessage(((String) value));
                }
            }
            if( values.containsKey("LogNo") ) {
                final Object value = values.remove("LogNo");
                if( (value == null) || (!value.equals(getLogNo())) ) {
                    setLogNo(((String) value));
                }
            }
            if( values.containsKey("LogMsgNo") ) {
                final Object value = values.remove("LogMsgNo");
                if( (value == null) || (!value.equals(getLogMsgNo())) ) {
                    setLogMsgNo(((String) value));
                }
            }
            if( values.containsKey("MessageV1") ) {
                final Object value = values.remove("MessageV1");
                if( (value == null) || (!value.equals(getMessageV1())) ) {
                    setMessageV1(((String) value));
                }
            }
            if( values.containsKey("MessageV2") ) {
                final Object value = values.remove("MessageV2");
                if( (value == null) || (!value.equals(getMessageV2())) ) {
                    setMessageV2(((String) value));
                }
            }
            if( values.containsKey("MessageV3") ) {
                final Object value = values.remove("MessageV3");
                if( (value == null) || (!value.equals(getMessageV3())) ) {
                    setMessageV3(((String) value));
                }
            }
            if( values.containsKey("MessageV4") ) {
                final Object value = values.remove("MessageV4");
                if( (value == null) || (!value.equals(getMessageV4())) ) {
                    setMessageV4(((String) value));
                }
            }
            if( values.containsKey("Parameter") ) {
                final Object value = values.remove("Parameter");
                if( (value == null) || (!value.equals(getParameter())) ) {
                    setParameter(((String) value));
                }
            }
            if( values.containsKey("Row") ) {
                final Object value = values.remove("Row");
                if( (value == null) || (!value.equals(getRow())) ) {
                    setRow(((Integer) value));
                }
            }
            if( values.containsKey("Field") ) {
                final Object value = values.remove("Field");
                if( (value == null) || (!value.equals(getField())) ) {
                    setField(((String) value));
                }
            }
            if( values.containsKey("System") ) {
                final Object value = values.remove("System");
                if( (value == null) || (!value.equals(getSystem())) ) {
                    setSystem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>Type</b>
     * </p>
     *
     * @param type_2
     *            Message Type
     */
    public void setType_2( @Nullable final String type_2 )
    {
        rememberChangedField("Type", this.type_2);
        this.type_2 = type_2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>Id</b>
     * </p>
     *
     * @param id
     *            Message Class
     */
    public void setId( @Nullable final String id )
    {
        rememberChangedField("Id", this.id);
        this.id = id;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>Number</b>
     * </p>
     *
     * @param number
     *            Message Number
     */
    public void setNumber( @Nullable final String number )
    {
        rememberChangedField("Number", this.number);
        this.number = number;
    }

    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *            Message Text
     */
    public void setMessage( @Nullable final String message )
    {
        rememberChangedField("Message", this.message);
        this.message = message;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>LogNo</b>
     * </p>
     *
     * @param logNo
     *            Log number
     */
    public void setLogNo( @Nullable final String logNo )
    {
        rememberChangedField("LogNo", this.logNo);
        this.logNo = logNo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>LogMsgNo</b>
     * </p>
     *
     * @param logMsgNo
     *            Message Number
     */
    public void setLogMsgNo( @Nullable final String logMsgNo )
    {
        rememberChangedField("LogMsgNo", this.logMsgNo);
        this.logMsgNo = logMsgNo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV1</b>
     * </p>
     *
     * @param messageV1
     *            Message Variable
     */
    public void setMessageV1( @Nullable final String messageV1 )
    {
        rememberChangedField("MessageV1", this.messageV1);
        this.messageV1 = messageV1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV2</b>
     * </p>
     *
     * @param messageV2
     *            Message Variable
     */
    public void setMessageV2( @Nullable final String messageV2 )
    {
        rememberChangedField("MessageV2", this.messageV2);
        this.messageV2 = messageV2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV3</b>
     * </p>
     *
     * @param messageV3
     *            Message Variable
     */
    public void setMessageV3( @Nullable final String messageV3 )
    {
        rememberChangedField("MessageV3", this.messageV3);
        this.messageV3 = messageV3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property from the Odata EDM: <b>MessageV4</b>
     * </p>
     *
     * @param messageV4
     *            Message Variable
     */
    public void setMessageV4( @Nullable final String messageV4 )
    {
        rememberChangedField("MessageV4", this.messageV4);
        this.messageV4 = messageV4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property from the Odata EDM: <b>Parameter</b>
     * </p>
     *
     * @param parameter
     *            Parameter Name
     */
    public void setParameter( @Nullable final String parameter )
    {
        rememberChangedField("Parameter", this.parameter);
        this.parameter = parameter;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>Row</b>
     * </p>
     *
     * @param row
     *            Parameter line
     */
    public void setRow( @Nullable final Integer row )
    {
        rememberChangedField("Row", this.row);
        this.row = row;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>Field</b>
     * </p>
     *
     * @param field
     *            Field name
     */
    public void setField( @Nullable final String field )
    {
        rememberChangedField("Field", this.field);
        this.field = field;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>System</b>
     * </p>
     *
     * @param system
     *            Logical system
     */
    public void setSystem( @Nullable final String system )
    {
        rememberChangedField("System", this.system);
        this.system = system;
    }

}
