/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurReqAddDeliveryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurReqAddDeliverySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Delivery Address
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurReqAddDeliveryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurReqAddDelivery extends VdmEntity<PurReqAddDelivery>
{

    /**
     * Selector for all available fields of PurReqAddDelivery.
     *
     */
    public final static PurReqAddDeliverySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @Key
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PURCHASE_REQUISITION =
        new PurReqAddDeliveryField<String>("PurchaseRequisition");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @Key
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PURCHASE_REQUISITION_ITEM =
        new PurReqAddDeliveryField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ADDRESS_ID = new PurReqAddDeliveryField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PLANT = new PurReqAddDeliveryField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AddressType</b>
     * </p>
     *
     * @return Purchase Requisition Address Type
     */
    @SerializedName( "AddressType" )
    @JsonProperty( "AddressType" )
    @Nullable
    @ODataField( odataName = "AddressType" )
    private String addressType;
    /**
     * Use with available fluent helpers to apply the <b>AddressType</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ADDRESS_TYPE = new PurReqAddDeliveryField<String>("AddressType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "ManualDeliveryAddressID" )
    @JsonProperty( "ManualDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ManualDeliveryAddressID" )
    private String manualDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ManualDeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> MANUAL_DELIVERY_ADDRESS_ID =
        new PurReqAddDeliveryField<String>("ManualDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryAddressID</b>
     * </p>
     *
     * @return Number of delivery address
     */
    @SerializedName( "ItemDeliveryAddressID" )
    @JsonProperty( "ItemDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ItemDeliveryAddressID" )
    private String itemDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ItemDeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ITEM_DELIVERY_ADDRESS_ID =
        new PurReqAddDeliveryField<String>("ItemDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CareOfName</b>
     * </p>
     *
     * @return c/o name
     */
    @SerializedName( "CareOfName" )
    @JsonProperty( "CareOfName" )
    @Nullable
    @ODataField( odataName = "CareOfName" )
    private String careOfName;
    /**
     * Use with available fluent helpers to apply the <b>CareOfName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> CARE_OF_NAME = new PurReqAddDeliveryField<String>("CareOfName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @return Street 5
     */
    @SerializedName( "AdditionalStreetSuffixName" )
    @JsonProperty( "AdditionalStreetSuffixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetSuffixName" )
    private String additionalStreetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetSuffixName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ADDITIONAL_STREET_SUFFIX_NAME =
        new PurReqAddDeliveryField<String>("AdditionalStreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "CorrespondenceLanguage" )
    @JsonProperty( "CorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "CorrespondenceLanguage" )
    private String correspondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>CorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> CORRESPONDENCE_LANGUAGE =
        new PurReqAddDeliveryField<String>("CorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrfrdCommMediumType</b>
     * </p>
     *
     * @return Communication Method (Key) (Business Address Services)
     */
    @SerializedName( "PrfrdCommMediumType" )
    @JsonProperty( "PrfrdCommMediumType" )
    @Nullable
    @ODataField( odataName = "PrfrdCommMediumType" )
    private String prfrdCommMediumType;
    /**
     * Use with available fluent helpers to apply the <b>PrfrdCommMediumType</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PRFRD_COMM_MEDIUM_TYPE =
        new PurReqAddDeliveryField<String>("PrfrdCommMediumType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Use with available fluent helpers to apply the <b>POBox</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PO_BOX = new PurReqAddDeliveryField<String>("POBox");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>POBoxIsWithoutNumber</b>
     * </p>
     *
     * @return Flag: PO Box Without Number
     */
    @SerializedName( "POBoxIsWithoutNumber" )
    @JsonProperty( "POBoxIsWithoutNumber" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "POBoxIsWithoutNumber" )
    private Boolean pOBoxIsWithoutNumber;
    /**
     * Use with available fluent helpers to apply the <b>POBoxIsWithoutNumber</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<Boolean> PO_BOX_IS_WITHOUT_NUMBER =
        new PurReqAddDeliveryField<Boolean>("POBoxIsWithoutNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @return PO Box Postal Code
     */
    @SerializedName( "POBoxPostalCode" )
    @JsonProperty( "POBoxPostalCode" )
    @Nullable
    @ODataField( odataName = "POBoxPostalCode" )
    private String pOBoxPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>POBoxPostalCode</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PO_BOX_POSTAL_CODE =
        new PurReqAddDeliveryField<String>("POBoxPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxLobbyName</b>
     * </p>
     *
     * @return PO Box Lobby
     */
    @SerializedName( "POBoxLobbyName" )
    @JsonProperty( "POBoxLobbyName" )
    @Nullable
    @ODataField( odataName = "POBoxLobbyName" )
    private String pOBoxLobbyName;
    /**
     * Use with available fluent helpers to apply the <b>POBoxLobbyName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PO_BOX_LOBBY_NAME =
        new PurReqAddDeliveryField<String>("POBoxLobbyName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCityName</b>
     * </p>
     *
     * @return PO Box city
     */
    @SerializedName( "POBoxDeviatingCityName" )
    @JsonProperty( "POBoxDeviatingCityName" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingCityName" )
    private String pOBoxDeviatingCityName;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingCityName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PO_BOX_DEVIATING_CITY_NAME =
        new PurReqAddDeliveryField<String>("POBoxDeviatingCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingRegion</b>
     * </p>
     *
     * @return Region for PO Box (Country/Region, State, Province, ...)
     */
    @SerializedName( "POBoxDeviatingRegion" )
    @JsonProperty( "POBoxDeviatingRegion" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingRegion" )
    private String pOBoxDeviatingRegion;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingRegion</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PO_BOX_DEVIATING_REGION =
        new PurReqAddDeliveryField<String>("POBoxDeviatingRegion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCountry</b>
     * </p>
     *
     * @return PO Box of Country/Region
     */
    @SerializedName( "POBoxDeviatingCountry" )
    @JsonProperty( "POBoxDeviatingCountry" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingCountry" )
    private String pOBoxDeviatingCountry;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingCountry</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PO_BOX_DEVIATING_COUNTRY =
        new PurReqAddDeliveryField<String>("POBoxDeviatingCountry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceTypeCode</b>
     * </p>
     *
     * @return Type of Delivery Service
     */
    @SerializedName( "DeliveryServiceTypeCode" )
    @JsonProperty( "DeliveryServiceTypeCode" )
    @Nullable
    @ODataField( odataName = "DeliveryServiceTypeCode" )
    private String deliveryServiceTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryServiceTypeCode</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> DELIVERY_SERVICE_TYPE_CODE =
        new PurReqAddDeliveryField<String>("DeliveryServiceTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceNumber</b>
     * </p>
     *
     * @return Number of Delivery Service
     */
    @SerializedName( "DeliveryServiceNumber" )
    @JsonProperty( "DeliveryServiceNumber" )
    @Nullable
    @ODataField( odataName = "DeliveryServiceNumber" )
    private String deliveryServiceNumber;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryServiceNumber</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> DELIVERY_SERVICE_NUMBER =
        new PurReqAddDeliveryField<String>("DeliveryServiceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AddressTimeZone</b>
     * </p>
     *
     * @return Address Time Zone
     */
    @SerializedName( "AddressTimeZone" )
    @JsonProperty( "AddressTimeZone" )
    @Nullable
    @ODataField( odataName = "AddressTimeZone" )
    private String addressTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>AddressTimeZone</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ADDRESS_TIME_ZONE =
        new PurReqAddDeliveryField<String>("AddressTimeZone");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FullName</b>
     * </p>
     *
     * @return Full name of a party (Bus. Partner, Org. Unit, Doc. address)
     */
    @SerializedName( "FullName" )
    @JsonProperty( "FullName" )
    @Nullable
    @ODataField( odataName = "FullName" )
    private String fullName;
    /**
     * Use with available fluent helpers to apply the <b>FullName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> FULL_NAME = new PurReqAddDeliveryField<String>("FullName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> CITY_NAME = new PurReqAddDeliveryField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "District" )
    @JsonProperty( "District" )
    @Nullable
    @ODataField( odataName = "District" )
    private String district;
    /**
     * Use with available fluent helpers to apply the <b>District</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> DISTRICT = new PurReqAddDeliveryField<String>("District");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @return City code for city/street file
     */
    @SerializedName( "CityCode" )
    @JsonProperty( "CityCode" )
    @Nullable
    @ODataField( odataName = "CityCode" )
    private String cityCode;
    /**
     * Use with available fluent helpers to apply the <b>CityCode</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> CITY_CODE = new PurReqAddDeliveryField<String>("CityCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HomeCityName</b>
     * </p>
     *
     * @return City (different from postal city)
     */
    @SerializedName( "HomeCityName" )
    @JsonProperty( "HomeCityName" )
    @Nullable
    @ODataField( odataName = "HomeCityName" )
    private String homeCityName;
    /**
     * Use with available fluent helpers to apply the <b>HomeCityName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> HOME_CITY_NAME =
        new PurReqAddDeliveryField<String>("HomeCityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> POSTAL_CODE = new PurReqAddDeliveryField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompanyPostalCode</b>
     * </p>
     *
     * @return Company Postal Code (for Large Customers)
     */
    @SerializedName( "CompanyPostalCode" )
    @JsonProperty( "CompanyPostalCode" )
    @Nullable
    @ODataField( odataName = "CompanyPostalCode" )
    private String companyPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyPostalCode</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> COMPANY_POSTAL_CODE =
        new PurReqAddDeliveryField<String>("CompanyPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> STREET_NAME = new PurReqAddDeliveryField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @return Street 2
     */
    @SerializedName( "StreetPrefixName" )
    @JsonProperty( "StreetPrefixName" )
    @Nullable
    @ODataField( odataName = "StreetPrefixName" )
    private String streetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetPrefixName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> STREET_PREFIX_NAME =
        new PurReqAddDeliveryField<String>("StreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @return Street 3
     */
    @SerializedName( "AdditionalStreetPrefixName" )
    @JsonProperty( "AdditionalStreetPrefixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetPrefixName" )
    private String additionalStreetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetPrefixName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ADDITIONAL_STREET_PREFIX_NAME =
        new PurReqAddDeliveryField<String>("AdditionalStreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @return Street 4
     */
    @SerializedName( "StreetSuffixName" )
    @JsonProperty( "StreetSuffixName" )
    @Nullable
    @ODataField( odataName = "StreetSuffixName" )
    private String streetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetSuffixName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> STREET_SUFFIX_NAME =
        new PurReqAddDeliveryField<String>("StreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> HOUSE_NUMBER = new PurReqAddDeliveryField<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @return House number supplement
     */
    @SerializedName( "HouseNumberSupplementText" )
    @JsonProperty( "HouseNumberSupplementText" )
    @Nullable
    @ODataField( odataName = "HouseNumberSupplementText" )
    private String houseNumberSupplementText;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumberSupplementText</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> HOUSE_NUMBER_SUPPLEMENT_TEXT =
        new PurReqAddDeliveryField<String>("HouseNumberSupplementText");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @return Building (Number or Code)
     */
    @SerializedName( "Building" )
    @JsonProperty( "Building" )
    @Nullable
    @ODataField( odataName = "Building" )
    private String building;
    /**
     * Use with available fluent helpers to apply the <b>Building</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> BUILDING = new PurReqAddDeliveryField<String>("Building");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @return Floor in building
     */
    @SerializedName( "Floor" )
    @JsonProperty( "Floor" )
    @Nullable
    @ODataField( odataName = "Floor" )
    private String floor;
    /**
     * Use with available fluent helpers to apply the <b>Floor</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> FLOOR = new PurReqAddDeliveryField<String>("Floor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @return Room or Apartment Number
     */
    @SerializedName( "RoomNumber" )
    @JsonProperty( "RoomNumber" )
    @Nullable
    @ODataField( odataName = "RoomNumber" )
    private String roomNumber;
    /**
     * Use with available fluent helpers to apply the <b>RoomNumber</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ROOM_NUMBER = new PurReqAddDeliveryField<String>("RoomNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> COUNTRY = new PurReqAddDeliveryField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> REGION = new PurReqAddDeliveryField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @return County
     */
    @SerializedName( "County" )
    @JsonProperty( "County" )
    @Nullable
    @ODataField( odataName = "County" )
    private String county;
    /**
     * Use with available fluent helpers to apply the <b>County</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> COUNTY = new PurReqAddDeliveryField<String>("County");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Form-of-Address Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> FORM_OF_ADDRESS =
        new PurReqAddDeliveryField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPartnerName1" )
    @JsonProperty( "BusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName1" )
    private String businessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName1</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> BUSINESS_PARTNER_NAME1 =
        new PurReqAddDeliveryField<String>("BusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BusinessPartnerName2" )
    @JsonProperty( "BusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName2" )
    private String businessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName2</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> BUSINESS_PARTNER_NAME2 =
        new PurReqAddDeliveryField<String>("BusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Nation</b>
     * </p>
     *
     * @return Version ID for International Addresses
     */
    @SerializedName( "Nation" )
    @JsonProperty( "Nation" )
    @Nullable
    @ODataField( odataName = "Nation" )
    private String nation;
    /**
     * Use with available fluent helpers to apply the <b>Nation</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> NATION = new PurReqAddDeliveryField<String>("Nation");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return First Telephone No.: Dialing Code + Number
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PHONE_NUMBER = new PurReqAddDeliveryField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return First Fax No.: Area Code + Number
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> FAX_NUMBER = new PurReqAddDeliveryField<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SearchTerm1</b>
     * </p>
     *
     * @return Search Term 1
     */
    @SerializedName( "SearchTerm1" )
    @JsonProperty( "SearchTerm1" )
    @Nullable
    @ODataField( odataName = "SearchTerm1" )
    private String searchTerm1;
    /**
     * Use with available fluent helpers to apply the <b>SearchTerm1</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> SEARCH_TERM1 = new PurReqAddDeliveryField<String>("SearchTerm1");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>StreetSearch</b>
     * </p>
     *
     * @return Street Name in Uppercase for Search Help
     */
    @SerializedName( "StreetSearch" )
    @JsonProperty( "StreetSearch" )
    @Nullable
    @ODataField( odataName = "StreetSearch" )
    private String streetSearch;
    /**
     * Use with available fluent helpers to apply the <b>StreetSearch</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> STREET_SEARCH =
        new PurReqAddDeliveryField<String>("StreetSearch");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CitySearch</b>
     * </p>
     *
     * @return City name in Uppercase for Search Help
     */
    @SerializedName( "CitySearch" )
    @JsonProperty( "CitySearch" )
    @Nullable
    @ODataField( odataName = "CitySearch" )
    private String citySearch;
    /**
     * Use with available fluent helpers to apply the <b>CitySearch</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> CITY_SEARCH = new PurReqAddDeliveryField<String>("CitySearch");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "BusinessPartnerName3" )
    @JsonProperty( "BusinessPartnerName3" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName3" )
    private String businessPartnerName3;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName3</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> BUSINESS_PARTNER_NAME3 =
        new PurReqAddDeliveryField<String>("BusinessPartnerName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "BusinessPartnerName4" )
    @JsonProperty( "BusinessPartnerName4" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName4" )
    private String businessPartnerName4;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName4</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> BUSINESS_PARTNER_NAME4 =
        new PurReqAddDeliveryField<String>("BusinessPartnerName4");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> TAX_JURISDICTION =
        new PurReqAddDeliveryField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @return Transportation zone to or from which the goods are delivered
     */
    @SerializedName( "TransportZone" )
    @JsonProperty( "TransportZone" )
    @Nullable
    @ODataField( odataName = "TransportZone" )
    private String transportZone;
    /**
     * Use with available fluent helpers to apply the <b>TransportZone</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> TRANSPORT_ZONE =
        new PurReqAddDeliveryField<String>("TransportZone");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Person</b>
     * </p>
     *
     * @return Person Number
     */
    @SerializedName( "Person" )
    @JsonProperty( "Person" )
    @Nullable
    @ODataField( odataName = "Person" )
    private String person;
    /**
     * Use with available fluent helpers to apply the <b>Person</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> PERSON = new PurReqAddDeliveryField<String>("Person");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>AddresseeFullName</b>
     * </p>
     *
     * @return Full Name of Person
     */
    @SerializedName( "AddresseeFullName" )
    @JsonProperty( "AddresseeFullName" )
    @Nullable
    @ODataField( odataName = "AddresseeFullName" )
    private String addresseeFullName;
    /**
     * Use with available fluent helpers to apply the <b>AddresseeFullName</b> field to query operations.
     *
     */
    public final static PurReqAddDeliveryField<String> ADDRESSEE_FULL_NAME =
        new PurReqAddDeliveryField<String>("AddresseeFullName");

    @Nonnull
    @Override
    public Class<PurReqAddDelivery> getType()
    {
        return PurReqAddDelivery.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AddressType</b>
     * </p>
     *
     * @param addressType
     *            Purchase Requisition Address Type
     */
    public void setAddressType( @Nullable final String addressType )
    {
        rememberChangedField("AddressType", this.addressType);
        this.addressType = addressType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @param manualDeliveryAddressID
     *            Manual address number in purchasing document item
     */
    public void setManualDeliveryAddressID( @Nullable final String manualDeliveryAddressID )
    {
        rememberChangedField("ManualDeliveryAddressID", this.manualDeliveryAddressID);
        this.manualDeliveryAddressID = manualDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryAddressID</b>
     * </p>
     *
     * @param itemDeliveryAddressID
     *            Number of delivery address
     */
    public void setItemDeliveryAddressID( @Nullable final String itemDeliveryAddressID )
    {
        rememberChangedField("ItemDeliveryAddressID", this.itemDeliveryAddressID);
        this.itemDeliveryAddressID = itemDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CareOfName</b>
     * </p>
     *
     * @param careOfName
     *            c/o name
     */
    public void setCareOfName( @Nullable final String careOfName )
    {
        rememberChangedField("CareOfName", this.careOfName);
        this.careOfName = careOfName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @param additionalStreetSuffixName
     *            Street 5
     */
    public void setAdditionalStreetSuffixName( @Nullable final String additionalStreetSuffixName )
    {
        rememberChangedField("AdditionalStreetSuffixName", this.additionalStreetSuffixName);
        this.additionalStreetSuffixName = additionalStreetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @param correspondenceLanguage
     *            Language Key
     */
    public void setCorrespondenceLanguage( @Nullable final String correspondenceLanguage )
    {
        rememberChangedField("CorrespondenceLanguage", this.correspondenceLanguage);
        this.correspondenceLanguage = correspondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrfrdCommMediumType</b>
     * </p>
     *
     * @param prfrdCommMediumType
     *            Communication Method (Key) (Business Address Services)
     */
    public void setPrfrdCommMediumType( @Nullable final String prfrdCommMediumType )
    {
        rememberChangedField("PrfrdCommMediumType", this.prfrdCommMediumType);
        this.prfrdCommMediumType = prfrdCommMediumType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>POBoxIsWithoutNumber</b>
     * </p>
     *
     * @param pOBoxIsWithoutNumber
     *            Flag: PO Box Without Number
     */
    public void setPOBoxIsWithoutNumber( @Nullable final Boolean pOBoxIsWithoutNumber )
    {
        rememberChangedField("POBoxIsWithoutNumber", this.pOBoxIsWithoutNumber);
        this.pOBoxIsWithoutNumber = pOBoxIsWithoutNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @param pOBoxPostalCode
     *            PO Box Postal Code
     */
    public void setPOBoxPostalCode( @Nullable final String pOBoxPostalCode )
    {
        rememberChangedField("POBoxPostalCode", this.pOBoxPostalCode);
        this.pOBoxPostalCode = pOBoxPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxLobbyName</b>
     * </p>
     *
     * @param pOBoxLobbyName
     *            PO Box Lobby
     */
    public void setPOBoxLobbyName( @Nullable final String pOBoxLobbyName )
    {
        rememberChangedField("POBoxLobbyName", this.pOBoxLobbyName);
        this.pOBoxLobbyName = pOBoxLobbyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCityName</b>
     * </p>
     *
     * @param pOBoxDeviatingCityName
     *            PO Box city
     */
    public void setPOBoxDeviatingCityName( @Nullable final String pOBoxDeviatingCityName )
    {
        rememberChangedField("POBoxDeviatingCityName", this.pOBoxDeviatingCityName);
        this.pOBoxDeviatingCityName = pOBoxDeviatingCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingRegion</b>
     * </p>
     *
     * @param pOBoxDeviatingRegion
     *            Region for PO Box (Country/Region, State, Province, ...)
     */
    public void setPOBoxDeviatingRegion( @Nullable final String pOBoxDeviatingRegion )
    {
        rememberChangedField("POBoxDeviatingRegion", this.pOBoxDeviatingRegion);
        this.pOBoxDeviatingRegion = pOBoxDeviatingRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCountry</b>
     * </p>
     *
     * @param pOBoxDeviatingCountry
     *            PO Box of Country/Region
     */
    public void setPOBoxDeviatingCountry( @Nullable final String pOBoxDeviatingCountry )
    {
        rememberChangedField("POBoxDeviatingCountry", this.pOBoxDeviatingCountry);
        this.pOBoxDeviatingCountry = pOBoxDeviatingCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceTypeCode</b>
     * </p>
     *
     * @param deliveryServiceTypeCode
     *            Type of Delivery Service
     */
    public void setDeliveryServiceTypeCode( @Nullable final String deliveryServiceTypeCode )
    {
        rememberChangedField("DeliveryServiceTypeCode", this.deliveryServiceTypeCode);
        this.deliveryServiceTypeCode = deliveryServiceTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceNumber</b>
     * </p>
     *
     * @param deliveryServiceNumber
     *            Number of Delivery Service
     */
    public void setDeliveryServiceNumber( @Nullable final String deliveryServiceNumber )
    {
        rememberChangedField("DeliveryServiceNumber", this.deliveryServiceNumber);
        this.deliveryServiceNumber = deliveryServiceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AddressTimeZone</b>
     * </p>
     *
     * @param addressTimeZone
     *            Address Time Zone
     */
    public void setAddressTimeZone( @Nullable final String addressTimeZone )
    {
        rememberChangedField("AddressTimeZone", this.addressTimeZone);
        this.addressTimeZone = addressTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FullName</b>
     * </p>
     *
     * @param fullName
     *            Full name of a party (Bus. Partner, Org. Unit, Doc. address)
     */
    public void setFullName( @Nullable final String fullName )
    {
        rememberChangedField("FullName", this.fullName);
        this.fullName = fullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @param district
     *            District
     */
    public void setDistrict( @Nullable final String district )
    {
        rememberChangedField("District", this.district);
        this.district = district;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @param cityCode
     *            City code for city/street file
     */
    public void setCityCode( @Nullable final String cityCode )
    {
        rememberChangedField("CityCode", this.cityCode);
        this.cityCode = cityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HomeCityName</b>
     * </p>
     *
     * @param homeCityName
     *            City (different from postal city)
     */
    public void setHomeCityName( @Nullable final String homeCityName )
    {
        rememberChangedField("HomeCityName", this.homeCityName);
        this.homeCityName = homeCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompanyPostalCode</b>
     * </p>
     *
     * @param companyPostalCode
     *            Company Postal Code (for Large Customers)
     */
    public void setCompanyPostalCode( @Nullable final String companyPostalCode )
    {
        rememberChangedField("CompanyPostalCode", this.companyPostalCode);
        this.companyPostalCode = companyPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @param streetPrefixName
     *            Street 2
     */
    public void setStreetPrefixName( @Nullable final String streetPrefixName )
    {
        rememberChangedField("StreetPrefixName", this.streetPrefixName);
        this.streetPrefixName = streetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @param additionalStreetPrefixName
     *            Street 3
     */
    public void setAdditionalStreetPrefixName( @Nullable final String additionalStreetPrefixName )
    {
        rememberChangedField("AdditionalStreetPrefixName", this.additionalStreetPrefixName);
        this.additionalStreetPrefixName = additionalStreetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @param streetSuffixName
     *            Street 4
     */
    public void setStreetSuffixName( @Nullable final String streetSuffixName )
    {
        rememberChangedField("StreetSuffixName", this.streetSuffixName);
        this.streetSuffixName = streetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @param houseNumberSupplementText
     *            House number supplement
     */
    public void setHouseNumberSupplementText( @Nullable final String houseNumberSupplementText )
    {
        rememberChangedField("HouseNumberSupplementText", this.houseNumberSupplementText);
        this.houseNumberSupplementText = houseNumberSupplementText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @param building
     *            Building (Number or Code)
     */
    public void setBuilding( @Nullable final String building )
    {
        rememberChangedField("Building", this.building);
        this.building = building;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @param floor
     *            Floor in building
     */
    public void setFloor( @Nullable final String floor )
    {
        rememberChangedField("Floor", this.floor);
        this.floor = floor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @param roomNumber
     *            Room or Apartment Number
     */
    public void setRoomNumber( @Nullable final String roomNumber )
    {
        rememberChangedField("RoomNumber", this.roomNumber);
        this.roomNumber = roomNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @param county
     *            County
     */
    public void setCounty( @Nullable final String county )
    {
        rememberChangedField("County", this.county);
        this.county = county;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Form-of-Address Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @param businessPartnerName1
     *            Name 1
     */
    public void setBusinessPartnerName1( @Nullable final String businessPartnerName1 )
    {
        rememberChangedField("BusinessPartnerName1", this.businessPartnerName1);
        this.businessPartnerName1 = businessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @param businessPartnerName2
     *            Name 2
     */
    public void setBusinessPartnerName2( @Nullable final String businessPartnerName2 )
    {
        rememberChangedField("BusinessPartnerName2", this.businessPartnerName2);
        this.businessPartnerName2 = businessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Nation</b>
     * </p>
     *
     * @param nation
     *            Version ID for International Addresses
     */
    public void setNation( @Nullable final String nation )
    {
        rememberChangedField("Nation", this.nation);
        this.nation = nation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            First Telephone No.: Dialing Code + Number
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            First Fax No.: Area Code + Number
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SearchTerm1</b>
     * </p>
     *
     * @param searchTerm1
     *            Search Term 1
     */
    public void setSearchTerm1( @Nullable final String searchTerm1 )
    {
        rememberChangedField("SearchTerm1", this.searchTerm1);
        this.searchTerm1 = searchTerm1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>StreetSearch</b>
     * </p>
     *
     * @param streetSearch
     *            Street Name in Uppercase for Search Help
     */
    public void setStreetSearch( @Nullable final String streetSearch )
    {
        rememberChangedField("StreetSearch", this.streetSearch);
        this.streetSearch = streetSearch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CitySearch</b>
     * </p>
     *
     * @param citySearch
     *            City name in Uppercase for Search Help
     */
    public void setCitySearch( @Nullable final String citySearch )
    {
        rememberChangedField("CitySearch", this.citySearch);
        this.citySearch = citySearch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName3</b>
     * </p>
     *
     * @param businessPartnerName3
     *            Name 3
     */
    public void setBusinessPartnerName3( @Nullable final String businessPartnerName3 )
    {
        rememberChangedField("BusinessPartnerName3", this.businessPartnerName3);
        this.businessPartnerName3 = businessPartnerName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName4</b>
     * </p>
     *
     * @param businessPartnerName4
     *            Name 4
     */
    public void setBusinessPartnerName4( @Nullable final String businessPartnerName4 )
    {
        rememberChangedField("BusinessPartnerName4", this.businessPartnerName4);
        this.businessPartnerName4 = businessPartnerName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @param transportZone
     *            Transportation zone to or from which the goods are delivered
     */
    public void setTransportZone( @Nullable final String transportZone )
    {
        rememberChangedField("TransportZone", this.transportZone);
        this.transportZone = transportZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Person</b>
     * </p>
     *
     * @param person
     *            Person Number
     */
    public void setPerson( @Nullable final String person )
    {
        rememberChangedField("Person", this.person);
        this.person = person;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>AddresseeFullName</b>
     * </p>
     *
     * @param addresseeFullName
     *            Full Name of Person
     */
    public void setAddresseeFullName( @Nullable final String addresseeFullName )
    {
        rememberChangedField("AddresseeFullName", this.addresseeFullName);
        this.addresseeFullName = addresseeFullName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurReqAddDelivery";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseRequisition", getPurchaseRequisition());
        result.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("AddressID", getAddressID());
        values.put("Plant", getPlant());
        values.put("AddressType", getAddressType());
        values.put("ManualDeliveryAddressID", getManualDeliveryAddressID());
        values.put("ItemDeliveryAddressID", getItemDeliveryAddressID());
        values.put("CareOfName", getCareOfName());
        values.put("AdditionalStreetSuffixName", getAdditionalStreetSuffixName());
        values.put("CorrespondenceLanguage", getCorrespondenceLanguage());
        values.put("PrfrdCommMediumType", getPrfrdCommMediumType());
        values.put("POBox", getPOBox());
        values.put("POBoxIsWithoutNumber", getPOBoxIsWithoutNumber());
        values.put("POBoxPostalCode", getPOBoxPostalCode());
        values.put("POBoxLobbyName", getPOBoxLobbyName());
        values.put("POBoxDeviatingCityName", getPOBoxDeviatingCityName());
        values.put("POBoxDeviatingRegion", getPOBoxDeviatingRegion());
        values.put("POBoxDeviatingCountry", getPOBoxDeviatingCountry());
        values.put("DeliveryServiceTypeCode", getDeliveryServiceTypeCode());
        values.put("DeliveryServiceNumber", getDeliveryServiceNumber());
        values.put("AddressTimeZone", getAddressTimeZone());
        values.put("FullName", getFullName());
        values.put("CityName", getCityName());
        values.put("District", getDistrict());
        values.put("CityCode", getCityCode());
        values.put("HomeCityName", getHomeCityName());
        values.put("PostalCode", getPostalCode());
        values.put("CompanyPostalCode", getCompanyPostalCode());
        values.put("StreetName", getStreetName());
        values.put("StreetPrefixName", getStreetPrefixName());
        values.put("AdditionalStreetPrefixName", getAdditionalStreetPrefixName());
        values.put("StreetSuffixName", getStreetSuffixName());
        values.put("HouseNumber", getHouseNumber());
        values.put("HouseNumberSupplementText", getHouseNumberSupplementText());
        values.put("Building", getBuilding());
        values.put("Floor", getFloor());
        values.put("RoomNumber", getRoomNumber());
        values.put("Country", getCountry());
        values.put("Region", getRegion());
        values.put("County", getCounty());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("BusinessPartnerName1", getBusinessPartnerName1());
        values.put("BusinessPartnerName2", getBusinessPartnerName2());
        values.put("Nation", getNation());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("FaxNumber", getFaxNumber());
        values.put("SearchTerm1", getSearchTerm1());
        values.put("StreetSearch", getStreetSearch());
        values.put("CitySearch", getCitySearch());
        values.put("BusinessPartnerName3", getBusinessPartnerName3());
        values.put("BusinessPartnerName4", getBusinessPartnerName4());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("TransportZone", getTransportZone());
        values.put("Person", getPerson());
        values.put("AddresseeFullName", getAddresseeFullName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("AddressType") ) {
                final Object value = values.remove("AddressType");
                if( (value == null) || (!value.equals(getAddressType())) ) {
                    setAddressType(((String) value));
                }
            }
            if( values.containsKey("ManualDeliveryAddressID") ) {
                final Object value = values.remove("ManualDeliveryAddressID");
                if( (value == null) || (!value.equals(getManualDeliveryAddressID())) ) {
                    setManualDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("ItemDeliveryAddressID") ) {
                final Object value = values.remove("ItemDeliveryAddressID");
                if( (value == null) || (!value.equals(getItemDeliveryAddressID())) ) {
                    setItemDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("CareOfName") ) {
                final Object value = values.remove("CareOfName");
                if( (value == null) || (!value.equals(getCareOfName())) ) {
                    setCareOfName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetSuffixName") ) {
                final Object value = values.remove("AdditionalStreetSuffixName");
                if( (value == null) || (!value.equals(getAdditionalStreetSuffixName())) ) {
                    setAdditionalStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("CorrespondenceLanguage") ) {
                final Object value = values.remove("CorrespondenceLanguage");
                if( (value == null) || (!value.equals(getCorrespondenceLanguage())) ) {
                    setCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("PrfrdCommMediumType") ) {
                final Object value = values.remove("PrfrdCommMediumType");
                if( (value == null) || (!value.equals(getPrfrdCommMediumType())) ) {
                    setPrfrdCommMediumType(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("POBoxIsWithoutNumber") ) {
                final Object value = values.remove("POBoxIsWithoutNumber");
                if( (value == null) || (!value.equals(getPOBoxIsWithoutNumber())) ) {
                    setPOBoxIsWithoutNumber(((Boolean) value));
                }
            }
            if( values.containsKey("POBoxPostalCode") ) {
                final Object value = values.remove("POBoxPostalCode");
                if( (value == null) || (!value.equals(getPOBoxPostalCode())) ) {
                    setPOBoxPostalCode(((String) value));
                }
            }
            if( values.containsKey("POBoxLobbyName") ) {
                final Object value = values.remove("POBoxLobbyName");
                if( (value == null) || (!value.equals(getPOBoxLobbyName())) ) {
                    setPOBoxLobbyName(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingCityName") ) {
                final Object value = values.remove("POBoxDeviatingCityName");
                if( (value == null) || (!value.equals(getPOBoxDeviatingCityName())) ) {
                    setPOBoxDeviatingCityName(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingRegion") ) {
                final Object value = values.remove("POBoxDeviatingRegion");
                if( (value == null) || (!value.equals(getPOBoxDeviatingRegion())) ) {
                    setPOBoxDeviatingRegion(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingCountry") ) {
                final Object value = values.remove("POBoxDeviatingCountry");
                if( (value == null) || (!value.equals(getPOBoxDeviatingCountry())) ) {
                    setPOBoxDeviatingCountry(((String) value));
                }
            }
            if( values.containsKey("DeliveryServiceTypeCode") ) {
                final Object value = values.remove("DeliveryServiceTypeCode");
                if( (value == null) || (!value.equals(getDeliveryServiceTypeCode())) ) {
                    setDeliveryServiceTypeCode(((String) value));
                }
            }
            if( values.containsKey("DeliveryServiceNumber") ) {
                final Object value = values.remove("DeliveryServiceNumber");
                if( (value == null) || (!value.equals(getDeliveryServiceNumber())) ) {
                    setDeliveryServiceNumber(((String) value));
                }
            }
            if( values.containsKey("AddressTimeZone") ) {
                final Object value = values.remove("AddressTimeZone");
                if( (value == null) || (!value.equals(getAddressTimeZone())) ) {
                    setAddressTimeZone(((String) value));
                }
            }
            if( values.containsKey("FullName") ) {
                final Object value = values.remove("FullName");
                if( (value == null) || (!value.equals(getFullName())) ) {
                    setFullName(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("District") ) {
                final Object value = values.remove("District");
                if( (value == null) || (!value.equals(getDistrict())) ) {
                    setDistrict(((String) value));
                }
            }
            if( values.containsKey("CityCode") ) {
                final Object value = values.remove("CityCode");
                if( (value == null) || (!value.equals(getCityCode())) ) {
                    setCityCode(((String) value));
                }
            }
            if( values.containsKey("HomeCityName") ) {
                final Object value = values.remove("HomeCityName");
                if( (value == null) || (!value.equals(getHomeCityName())) ) {
                    setHomeCityName(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("CompanyPostalCode") ) {
                final Object value = values.remove("CompanyPostalCode");
                if( (value == null) || (!value.equals(getCompanyPostalCode())) ) {
                    setCompanyPostalCode(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("StreetPrefixName") ) {
                final Object value = values.remove("StreetPrefixName");
                if( (value == null) || (!value.equals(getStreetPrefixName())) ) {
                    setStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetPrefixName") ) {
                final Object value = values.remove("AdditionalStreetPrefixName");
                if( (value == null) || (!value.equals(getAdditionalStreetPrefixName())) ) {
                    setAdditionalStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("StreetSuffixName") ) {
                final Object value = values.remove("StreetSuffixName");
                if( (value == null) || (!value.equals(getStreetSuffixName())) ) {
                    setStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("HouseNumberSupplementText") ) {
                final Object value = values.remove("HouseNumberSupplementText");
                if( (value == null) || (!value.equals(getHouseNumberSupplementText())) ) {
                    setHouseNumberSupplementText(((String) value));
                }
            }
            if( values.containsKey("Building") ) {
                final Object value = values.remove("Building");
                if( (value == null) || (!value.equals(getBuilding())) ) {
                    setBuilding(((String) value));
                }
            }
            if( values.containsKey("Floor") ) {
                final Object value = values.remove("Floor");
                if( (value == null) || (!value.equals(getFloor())) ) {
                    setFloor(((String) value));
                }
            }
            if( values.containsKey("RoomNumber") ) {
                final Object value = values.remove("RoomNumber");
                if( (value == null) || (!value.equals(getRoomNumber())) ) {
                    setRoomNumber(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("County") ) {
                final Object value = values.remove("County");
                if( (value == null) || (!value.equals(getCounty())) ) {
                    setCounty(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName1") ) {
                final Object value = values.remove("BusinessPartnerName1");
                if( (value == null) || (!value.equals(getBusinessPartnerName1())) ) {
                    setBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName2") ) {
                final Object value = values.remove("BusinessPartnerName2");
                if( (value == null) || (!value.equals(getBusinessPartnerName2())) ) {
                    setBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("Nation") ) {
                final Object value = values.remove("Nation");
                if( (value == null) || (!value.equals(getNation())) ) {
                    setNation(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("SearchTerm1") ) {
                final Object value = values.remove("SearchTerm1");
                if( (value == null) || (!value.equals(getSearchTerm1())) ) {
                    setSearchTerm1(((String) value));
                }
            }
            if( values.containsKey("StreetSearch") ) {
                final Object value = values.remove("StreetSearch");
                if( (value == null) || (!value.equals(getStreetSearch())) ) {
                    setStreetSearch(((String) value));
                }
            }
            if( values.containsKey("CitySearch") ) {
                final Object value = values.remove("CitySearch");
                if( (value == null) || (!value.equals(getCitySearch())) ) {
                    setCitySearch(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName3") ) {
                final Object value = values.remove("BusinessPartnerName3");
                if( (value == null) || (!value.equals(getBusinessPartnerName3())) ) {
                    setBusinessPartnerName3(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName4") ) {
                final Object value = values.remove("BusinessPartnerName4");
                if( (value == null) || (!value.equals(getBusinessPartnerName4())) ) {
                    setBusinessPartnerName4(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("TransportZone") ) {
                final Object value = values.remove("TransportZone");
                if( (value == null) || (!value.equals(getTransportZone())) ) {
                    setTransportZone(((String) value));
                }
            }
            if( values.containsKey("Person") ) {
                final Object value = values.remove("Person");
                if( (value == null) || (!value.equals(getPerson())) ) {
                    setPerson(((String) value));
                }
            }
            if( values.containsKey("AddresseeFullName") ) {
                final Object value = values.remove("AddresseeFullName");
                if( (value == null) || (!value.equals(getAddresseeFullName())) ) {
                    setAddresseeFullName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurReqAddDeliveryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurReqAddDeliveryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurReqAddDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurReqAddDeliveryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService.DEFAULT_SERVICE_PATH);
    }

}
