/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurReqAddDeliverySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery PurReqAddDelivery}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class PurReqAddDeliveryByKeyFluentHelper
    extends
    FluentHelperByKey<PurReqAddDeliveryByKeyFluentHelper, PurReqAddDelivery, PurReqAddDeliverySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     * PurReqAddDelivery} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurReqAddDelivery}
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurReqAddDelivery}
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PurReqAddDeliveryByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseRequisition,
        final String purchaseRequisitionItem )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseRequisition", purchaseRequisition);
        this.key.put("PurchaseRequisitionItem", purchaseRequisitionItem);
    }

    @Override
    @Nonnull
    protected Class<PurReqAddDelivery> getEntityClass()
    {
        return PurReqAddDelivery.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
