/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurReqnAcctAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurReqnAcctAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Account Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurReqnAcctAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurReqnAcctAssgmt extends VdmEntity<PurReqnAcctAssgmt>
{

    /**
     * Selector for all available fields of PurReqnAcctAssgmt.
     *
     */
    public final static PurReqnAcctAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @Key
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PURCHASE_REQUISITION =
        new PurReqnAcctAssgmtField<String>("PurchaseRequisition");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @Key
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PURCHASE_REQUISITION_ITEM =
        new PurReqnAcctAssgmtField<String>("PurchaseRequisitionItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseReqnAcctAssgmtNumber</b>
     * </p>
     *
     * @return Serial number for PReq account assignment segment
     */
    @Key
    @SerializedName( "PurchaseReqnAcctAssgmtNumber" )
    @JsonProperty( "PurchaseReqnAcctAssgmtNumber" )
    @Nullable
    @ODataField( odataName = "PurchaseReqnAcctAssgmtNumber" )
    private String purchaseReqnAcctAssgmtNumber;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseReqnAcctAssgmtNumber</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PURCHASE_REQN_ACCT_ASSGMT_NUMBER =
        new PurReqnAcctAssgmtField<String>("PurchaseReqnAcctAssgmtNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> COST_CENTER = new PurReqnAcctAssgmtField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> MASTER_FIXED_ASSET =
        new PurReqnAcctAssgmtField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @return Network Number for Account Assignment
     */
    @SerializedName( "ProjectNetwork" )
    @JsonProperty( "ProjectNetwork" )
    @Nullable
    @ODataField( odataName = "ProjectNetwork" )
    private String projectNetwork;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetwork</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PROJECT_NETWORK =
        new PurReqnAcctAssgmtField<String>("ProjectNetwork");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Purchase requisition unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> BASE_UNIT = new PurReqnAcctAssgmtField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Purchase requisition quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<BigDecimal> QUANTITY =
        new PurReqnAcctAssgmtField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistrPercent</b>
     * </p>
     *
     * @return Distribution percentage in the case of multiple acct assgt
     */
    @SerializedName( "MultipleAcctAssgmtDistrPercent" )
    @JsonProperty( "MultipleAcctAssgmtDistrPercent" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistrPercent" )
    private BigDecimal multipleAcctAssgmtDistrPercent;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistrPercent</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<BigDecimal> MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT =
        new PurReqnAcctAssgmtField<BigDecimal>("MultipleAcctAssgmtDistrPercent");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnItemCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "PurReqnItemCurrency" )
    @JsonProperty( "PurReqnItemCurrency" )
    @Nullable
    @ODataField( odataName = "PurReqnItemCurrency" )
    private String purReqnItemCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnItemCurrency</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PUR_REQN_ITEM_CURRENCY =
        new PurReqnAcctAssgmtField<String>("PurReqnItemCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnNetAmount</b>
     * </p>
     *
     * @return Net Order Value in PO Currency
     */
    @SerializedName( "PurReqnNetAmount" )
    @JsonProperty( "PurReqnNetAmount" )
    @Nullable
    @ODataField( odataName = "PurReqnNetAmount" )
    private BigDecimal purReqnNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnNetAmount</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<BigDecimal> PUR_REQN_NET_AMOUNT =
        new PurReqnAcctAssgmtField<BigDecimal>("PurReqnNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> IS_DELETED = new PurReqnAcctAssgmtField<String>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "CostElement" )
    @JsonProperty( "CostElement" )
    @Nullable
    @ODataField( odataName = "CostElement" )
    private String costElement;
    /**
     * Use with available fluent helpers to apply the <b>CostElement</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> COST_ELEMENT = new PurReqnAcctAssgmtField<String>("CostElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> GL_ACCOUNT = new PurReqnAcctAssgmtField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> BUSINESS_AREA =
        new PurReqnAcctAssgmtField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SDDocument" )
    @JsonProperty( "SDDocument" )
    @Nullable
    @ODataField( odataName = "SDDocument" )
    private String sDDocument;
    /**
     * Use with available fluent helpers to apply the <b>SDDocument</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> SD_DOCUMENT = new PurReqnAcctAssgmtField<String>("SDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> SALES_ORDER = new PurReqnAcctAssgmtField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> SALES_DOCUMENT_ITEM =
        new PurReqnAcctAssgmtField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> SALES_ORDER_ITEM =
        new PurReqnAcctAssgmtField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> SCHEDULE_LINE =
        new PurReqnAcctAssgmtField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @SerializedName( "SalesOrderScheduleLine" )
    @JsonProperty( "SalesOrderScheduleLine" )
    @Nullable
    @ODataField( odataName = "SalesOrderScheduleLine" )
    private String salesOrderScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderScheduleLine</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> SALES_ORDER_SCHEDULE_LINE =
        new PurReqnAcctAssgmtField<String>("SalesOrderScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> FIXED_ASSET = new PurReqnAcctAssgmtField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProcessOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "ProcessOrder" )
    @JsonProperty( "ProcessOrder" )
    @Nullable
    @ODataField( odataName = "ProcessOrder" )
    private String processOrder;
    /**
     * Use with available fluent helpers to apply the <b>ProcessOrder</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PROCESS_ORDER =
        new PurReqnAcctAssgmtField<String>("ProcessOrder");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> ORDER_ID = new PurReqnAcctAssgmtField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> UNLOADING_POINT_NAME =
        new PurReqnAcctAssgmtField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> CONTROLLING_AREA =
        new PurReqnAcctAssgmtField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> COST_OBJECT = new PurReqnAcctAssgmtField<String>("CostObject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @return Profitability Segment Number (CO-PA)
     */
    @SerializedName( "ProfitabilitySegment" )
    @JsonProperty( "ProfitabilitySegment" )
    @Nullable
    @ODataField( odataName = "ProfitabilitySegment" )
    private String profitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>ProfitabilitySegment</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PROFITABILITY_SEGMENT =
        new PurReqnAcctAssgmtField<String>("ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PROFIT_CENTER =
        new PurReqnAcctAssgmtField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkInternalID</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "ProjectNetworkInternalID" )
    @JsonProperty( "ProjectNetworkInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectNetworkInternalID" )
    private String projectNetworkInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectNetworkInternalID</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PROJECT_NETWORK_INTERNAL_ID =
        new PurReqnAcctAssgmtField<String>("ProjectNetworkInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> COMMITMENT_ITEM =
        new PurReqnAcctAssgmtField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> FUNDS_CENTER = new PurReqnAcctAssgmtField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> FUND = new PurReqnAcctAssgmtField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> FUNCTIONAL_AREA =
        new PurReqnAcctAssgmtField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<LocalDateTime> CREATION_DATE =
        new PurReqnAcctAssgmtField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> GOODS_RECIPIENT_NAME =
        new PurReqnAcctAssgmtField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @return Internal Key for Real Estate Object
     */
    @SerializedName( "RealEstateObject" )
    @JsonProperty( "RealEstateObject" )
    @Nullable
    @ODataField( odataName = "RealEstateObject" )
    private String realEstateObject;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateObject</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> REAL_ESTATE_OBJECT =
        new PurReqnAcctAssgmtField<String>("RealEstateObject");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "NetworkActivityInternalID" )
    @JsonProperty( "NetworkActivityInternalID" )
    @Nullable
    @ODataField( odataName = "NetworkActivityInternalID" )
    private String networkActivityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivityInternalID</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> NETWORK_ACTIVITY_INTERNAL_ID =
        new PurReqnAcctAssgmtField<String>("NetworkActivityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountNumber</b>
     * </p>
     *
     * @return Partner account number
     */
    @SerializedName( "PartnerAccountNumber" )
    @JsonProperty( "PartnerAccountNumber" )
    @Nullable
    @ODataField( odataName = "PartnerAccountNumber" )
    private String partnerAccountNumber;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountNumber</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PARTNER_ACCOUNT_NUMBER =
        new PurReqnAcctAssgmtField<String>("PartnerAccountNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureRecoveryCode</b>
     * </p>
     *
     * @return Recovery Indicator
     */
    @SerializedName( "JointVentureRecoveryCode" )
    @JsonProperty( "JointVentureRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureRecoveryCode" )
    private String jointVentureRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureRecoveryCode</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> JOINT_VENTURE_RECOVERY_CODE =
        new PurReqnAcctAssgmtField<String>("JointVentureRecoveryCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @return Reference date for settlement
     */
    @SerializedName( "SettlementReferenceDate" )
    @JsonProperty( "SettlementReferenceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SettlementReferenceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime settlementReferenceDate;
    /**
     * Use with available fluent helpers to apply the <b>SettlementReferenceDate</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<LocalDateTime> SETTLEMENT_REFERENCE_DATE =
        new PurReqnAcctAssgmtField<LocalDateTime>("SettlementReferenceDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @return Routing number of operations in the order
     */
    @SerializedName( "OrderInternalID" )
    @JsonProperty( "OrderInternalID" )
    @Nullable
    @ODataField( odataName = "OrderInternalID" )
    private String orderInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalID</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> ORDER_INTERNAL_ID =
        new PurReqnAcctAssgmtField<String>("OrderInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @return General counter for order
     */
    @SerializedName( "OrderIntBillOfOperationsItem" )
    @JsonProperty( "OrderIntBillOfOperationsItem" )
    @Nullable
    @ODataField( odataName = "OrderIntBillOfOperationsItem" )
    private String orderIntBillOfOperationsItem;
    /**
     * Use with available fluent helpers to apply the <b>OrderIntBillOfOperationsItem</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> ORDER_INT_BILL_OF_OPERATIONS_ITEM =
        new PurReqnAcctAssgmtField<String>("OrderIntBillOfOperationsItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document Number for Earmarked Funds
     */
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> EARMARKED_FUNDS_DOCUMENT =
        new PurReqnAcctAssgmtField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> COST_CTR_ACTIVITY_TYPE =
        new PurReqnAcctAssgmtField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> BUSINESS_PROCESS =
        new PurReqnAcctAssgmtField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> GRANT_ID = new PurReqnAcctAssgmtField<String>("GrantID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityDate</b>
     * </p>
     *
     * @return The validityDate contained in this entity.
     */
    @SerializedName( "ValidityDate" )
    @JsonProperty( "ValidityDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityDate</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<LocalDateTime> VALIDITY_DATE =
        new PurReqnAcctAssgmtField<LocalDateTime>("ValidityDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @return Chart of Accounts
     */
    @SerializedName( "ChartOfAccounts" )
    @JsonProperty( "ChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ChartOfAccounts" )
    private String chartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ChartOfAccounts</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> CHART_OF_ACCOUNTS =
        new PurReqnAcctAssgmtField<String>("ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> WBS_ELEMENT = new PurReqnAcctAssgmtField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivity</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "NetworkActivity" )
    @JsonProperty( "NetworkActivity" )
    @Nullable
    @ODataField( odataName = "NetworkActivity" )
    private String networkActivity;
    /**
     * Use with available fluent helpers to apply the <b>NetworkActivity</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> NETWORK_ACTIVITY =
        new PurReqnAcctAssgmtField<String>("NetworkActivity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionType</b>
     * </p>
     *
     * @return Purchase Requisition Document Type
     */
    @SerializedName( "PurchaseRequisitionType" )
    @JsonProperty( "PurchaseRequisitionType" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionType" )
    private String purchaseRequisitionType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionType</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PURCHASE_REQUISITION_TYPE =
        new PurReqnAcctAssgmtField<String>("PurchaseRequisitionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PLANT = new PurReqnAcctAssgmtField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PURCHASING_ORGANIZATION =
        new PurReqnAcctAssgmtField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static PurReqnAcctAssgmtField<String> PURCHASING_GROUP =
        new PurReqnAcctAssgmtField<String>("PurchasingGroup");

    @Nonnull
    @Override
    public Class<PurReqnAcctAssgmt> getType()
    {
        return PurReqnAcctAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseReqnAcctAssgmtNumber</b>
     * </p>
     *
     * @param purchaseReqnAcctAssgmtNumber
     *            Serial number for PReq account assignment segment
     */
    public void setPurchaseReqnAcctAssgmtNumber( @Nullable final String purchaseReqnAcctAssgmtNumber )
    {
        rememberChangedField("PurchaseReqnAcctAssgmtNumber", this.purchaseReqnAcctAssgmtNumber);
        this.purchaseReqnAcctAssgmtNumber = purchaseReqnAcctAssgmtNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetwork</b>
     * </p>
     *
     * @param projectNetwork
     *            Network Number for Account Assignment
     */
    public void setProjectNetwork( @Nullable final String projectNetwork )
    {
        rememberChangedField("ProjectNetwork", this.projectNetwork);
        this.projectNetwork = projectNetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Purchase requisition unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Purchase requisition quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistrPercent</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistrPercent
     *            Distribution percentage in the case of multiple acct assgt
     */
    public void setMultipleAcctAssgmtDistrPercent( @Nullable final BigDecimal multipleAcctAssgmtDistrPercent )
    {
        rememberChangedField("MultipleAcctAssgmtDistrPercent", this.multipleAcctAssgmtDistrPercent);
        this.multipleAcctAssgmtDistrPercent = multipleAcctAssgmtDistrPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnItemCurrency</b>
     * </p>
     *
     * @param purReqnItemCurrency
     *            Currency Key
     */
    public void setPurReqnItemCurrency( @Nullable final String purReqnItemCurrency )
    {
        rememberChangedField("PurReqnItemCurrency", this.purReqnItemCurrency);
        this.purReqnItemCurrency = purReqnItemCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnNetAmount</b>
     * </p>
     *
     * @param purReqnNetAmount
     *            Net Order Value in PO Currency
     */
    public void setPurReqnNetAmount( @Nullable final BigDecimal purReqnNetAmount )
    {
        rememberChangedField("PurReqnNetAmount", this.purReqnNetAmount);
        this.purReqnNetAmount = purReqnNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator in Purchasing Document
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *            G/L Account Number
     */
    public void setCostElement( @Nullable final String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SDDocument</b>
     * </p>
     *
     * @param sDDocument
     *            Sales and Distribution Document Number
     */
    public void setSDDocument( @Nullable final String sDDocument )
    {
        rememberChangedField("SDDocument", this.sDDocument);
        this.sDDocument = sDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales and Distribution Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Document Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line Number
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderScheduleLine</b>
     * </p>
     *
     * @param salesOrderScheduleLine
     *            Schedule Line Number
     */
    public void setSalesOrderScheduleLine( @Nullable final String salesOrderScheduleLine )
    {
        rememberChangedField("SalesOrderScheduleLine", this.salesOrderScheduleLine);
        this.salesOrderScheduleLine = salesOrderScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProcessOrder</b>
     * </p>
     *
     * @param processOrder
     *            Order Number
     */
    public void setProcessOrder( @Nullable final String processOrder )
    {
        rememberChangedField("ProcessOrder", this.processOrder);
        this.processOrder = processOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order Number
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     *
     * @param profitabilitySegment
     *            Profitability Segment Number (CO-PA)
     */
    public void setProfitabilitySegment( @Nullable final String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProjectNetworkInternalID</b>
     * </p>
     *
     * @param projectNetworkInternalID
     *            Routing number of operations in the order
     */
    public void setProjectNetworkInternalID( @Nullable final String projectNetworkInternalID )
    {
        rememberChangedField("ProjectNetworkInternalID", this.projectNetworkInternalID);
        this.projectNetworkInternalID = projectNetworkInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObject</b>
     * </p>
     *
     * @param realEstateObject
     *            Internal Key for Real Estate Object
     */
    public void setRealEstateObject( @Nullable final String realEstateObject )
    {
        rememberChangedField("RealEstateObject", this.realEstateObject);
        this.realEstateObject = realEstateObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivityInternalID</b>
     * </p>
     *
     * @param networkActivityInternalID
     *            Internal counter
     */
    public void setNetworkActivityInternalID( @Nullable final String networkActivityInternalID )
    {
        rememberChangedField("NetworkActivityInternalID", this.networkActivityInternalID);
        this.networkActivityInternalID = networkActivityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountNumber</b>
     * </p>
     *
     * @param partnerAccountNumber
     *            Partner account number
     */
    public void setPartnerAccountNumber( @Nullable final String partnerAccountNumber )
    {
        rememberChangedField("PartnerAccountNumber", this.partnerAccountNumber);
        this.partnerAccountNumber = partnerAccountNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureRecoveryCode</b>
     * </p>
     *
     * @param jointVentureRecoveryCode
     *            Recovery Indicator
     */
    public void setJointVentureRecoveryCode( @Nullable final String jointVentureRecoveryCode )
    {
        rememberChangedField("JointVentureRecoveryCode", this.jointVentureRecoveryCode);
        this.jointVentureRecoveryCode = jointVentureRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SettlementReferenceDate</b>
     * </p>
     *
     * @param settlementReferenceDate
     *            Reference date for settlement
     */
    public void setSettlementReferenceDate( @Nullable final LocalDateTime settlementReferenceDate )
    {
        rememberChangedField("SettlementReferenceDate", this.settlementReferenceDate);
        this.settlementReferenceDate = settlementReferenceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @param orderInternalID
     *            Routing number of operations in the order
     */
    public void setOrderInternalID( @Nullable final String orderInternalID )
    {
        rememberChangedField("OrderInternalID", this.orderInternalID);
        this.orderInternalID = orderInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            General counter for order
     */
    public void setOrderIntBillOfOperationsItem( @Nullable final String orderIntBillOfOperationsItem )
    {
        rememberChangedField("OrderIntBillOfOperationsItem", this.orderIntBillOfOperationsItem);
        this.orderIntBillOfOperationsItem = orderIntBillOfOperationsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityDate</b>
     * </p>
     *
     * @param validityDate
     *            The validityDate to set.
     */
    public void setValidityDate( @Nullable final LocalDateTime validityDate )
    {
        rememberChangedField("ValidityDate", this.validityDate);
        this.validityDate = validityDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     *
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NetworkActivity</b>
     * </p>
     *
     * @param networkActivity
     *            Operation/Activity Number
     */
    public void setNetworkActivity( @Nullable final String networkActivity )
    {
        rememberChangedField("NetworkActivity", this.networkActivity);
        this.networkActivity = networkActivity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionType</b>
     * </p>
     *
     * @param purchaseRequisitionType
     *            Purchase Requisition Document Type
     */
    public void setPurchaseRequisitionType( @Nullable final String purchaseRequisitionType )
    {
        rememberChangedField("PurchaseRequisitionType", this.purchaseRequisitionType);
        this.purchaseRequisitionType = purchaseRequisitionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurReqnAcctAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseRequisition", getPurchaseRequisition());
        result.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        result.put("PurchaseReqnAcctAssgmtNumber", getPurchaseReqnAcctAssgmtNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("PurchaseReqnAcctAssgmtNumber", getPurchaseReqnAcctAssgmtNumber());
        values.put("CostCenter", getCostCenter());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("ProjectNetwork", getProjectNetwork());
        values.put("BaseUnit", getBaseUnit());
        values.put("Quantity", getQuantity());
        values.put("MultipleAcctAssgmtDistrPercent", getMultipleAcctAssgmtDistrPercent());
        values.put("PurReqnItemCurrency", getPurReqnItemCurrency());
        values.put("PurReqnNetAmount", getPurReqnNetAmount());
        values.put("IsDeleted", getIsDeleted());
        values.put("CostElement", getCostElement());
        values.put("GLAccount", getGLAccount());
        values.put("BusinessArea", getBusinessArea());
        values.put("SDDocument", getSDDocument());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("SalesOrderScheduleLine", getSalesOrderScheduleLine());
        values.put("FixedAsset", getFixedAsset());
        values.put("ProcessOrder", getProcessOrder());
        values.put("OrderID", getOrderID());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("ControllingArea", getControllingArea());
        values.put("CostObject", getCostObject());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProjectNetworkInternalID", getProjectNetworkInternalID());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("FundsCenter", getFundsCenter());
        values.put("Fund", getFund());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("CreationDate", getCreationDate());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("RealEstateObject", getRealEstateObject());
        values.put("NetworkActivityInternalID", getNetworkActivityInternalID());
        values.put("PartnerAccountNumber", getPartnerAccountNumber());
        values.put("JointVentureRecoveryCode", getJointVentureRecoveryCode());
        values.put("SettlementReferenceDate", getSettlementReferenceDate());
        values.put("OrderInternalID", getOrderInternalID());
        values.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("GrantID", getGrantID());
        values.put("ValidityDate", getValidityDate());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("WBSElement", getWBSElement());
        values.put("NetworkActivity", getNetworkActivity());
        values.put("PurchaseRequisitionType", getPurchaseRequisitionType());
        values.put("Plant", getPlant());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("PurchaseReqnAcctAssgmtNumber") ) {
                final Object value = values.remove("PurchaseReqnAcctAssgmtNumber");
                if( (value == null) || (!value.equals(getPurchaseReqnAcctAssgmtNumber())) ) {
                    setPurchaseReqnAcctAssgmtNumber(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("ProjectNetwork") ) {
                final Object value = values.remove("ProjectNetwork");
                if( (value == null) || (!value.equals(getProjectNetwork())) ) {
                    setProjectNetwork(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistrPercent") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistrPercent");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistrPercent())) ) {
                    setMultipleAcctAssgmtDistrPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurReqnItemCurrency") ) {
                final Object value = values.remove("PurReqnItemCurrency");
                if( (value == null) || (!value.equals(getPurReqnItemCurrency())) ) {
                    setPurReqnItemCurrency(((String) value));
                }
            }
            if( values.containsKey("PurReqnNetAmount") ) {
                final Object value = values.remove("PurReqnNetAmount");
                if( (value == null) || (!value.equals(getPurReqnNetAmount())) ) {
                    setPurReqnNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("SDDocument") ) {
                final Object value = values.remove("SDDocument");
                if( (value == null) || (!value.equals(getSDDocument())) ) {
                    setSDDocument(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("SalesOrderScheduleLine") ) {
                final Object value = values.remove("SalesOrderScheduleLine");
                if( (value == null) || (!value.equals(getSalesOrderScheduleLine())) ) {
                    setSalesOrderScheduleLine(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("ProcessOrder") ) {
                final Object value = values.remove("ProcessOrder");
                if( (value == null) || (!value.equals(getProcessOrder())) ) {
                    setProcessOrder(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProjectNetworkInternalID") ) {
                final Object value = values.remove("ProjectNetworkInternalID");
                if( (value == null) || (!value.equals(getProjectNetworkInternalID())) ) {
                    setProjectNetworkInternalID(((String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("RealEstateObject") ) {
                final Object value = values.remove("RealEstateObject");
                if( (value == null) || (!value.equals(getRealEstateObject())) ) {
                    setRealEstateObject(((String) value));
                }
            }
            if( values.containsKey("NetworkActivityInternalID") ) {
                final Object value = values.remove("NetworkActivityInternalID");
                if( (value == null) || (!value.equals(getNetworkActivityInternalID())) ) {
                    setNetworkActivityInternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountNumber") ) {
                final Object value = values.remove("PartnerAccountNumber");
                if( (value == null) || (!value.equals(getPartnerAccountNumber())) ) {
                    setPartnerAccountNumber(((String) value));
                }
            }
            if( values.containsKey("JointVentureRecoveryCode") ) {
                final Object value = values.remove("JointVentureRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureRecoveryCode())) ) {
                    setJointVentureRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("SettlementReferenceDate") ) {
                final Object value = values.remove("SettlementReferenceDate");
                if( (value == null) || (!value.equals(getSettlementReferenceDate())) ) {
                    setSettlementReferenceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OrderInternalID") ) {
                final Object value = values.remove("OrderInternalID");
                if( (value == null) || (!value.equals(getOrderInternalID())) ) {
                    setOrderInternalID(((String) value));
                }
            }
            if( values.containsKey("OrderIntBillOfOperationsItem") ) {
                final Object value = values.remove("OrderIntBillOfOperationsItem");
                if( (value == null) || (!value.equals(getOrderIntBillOfOperationsItem())) ) {
                    setOrderIntBillOfOperationsItem(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("ValidityDate") ) {
                final Object value = values.remove("ValidityDate");
                if( (value == null) || (!value.equals(getValidityDate())) ) {
                    setValidityDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("NetworkActivity") ) {
                final Object value = values.remove("NetworkActivity");
                if( (value == null) || (!value.equals(getNetworkActivity())) ) {
                    setNetworkActivity(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionType") ) {
                final Object value = values.remove("PurchaseRequisitionType");
                if( (value == null) || (!value.equals(getPurchaseRequisitionType())) ) {
                    setPurchaseRequisitionType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurReqnAcctAssgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurReqnAcctAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurReqnAcctAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurReqnAcctAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService.DEFAULT_SERVICE_PATH);
    }

}
