/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurReqnAcctAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt PurReqnAcctAssgmt}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class PurReqnAcctAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<PurReqnAcctAssgmtByKeyFluentHelper, PurReqnAcctAssgmt, PurReqnAcctAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurReqnAcctAssgmt}
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurReqnAcctAssgmt}
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchaseReqnAcctAssgmtNumber
     *            Serial number for PReq account assignment segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public PurReqnAcctAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseRequisition,
        final String purchaseRequisitionItem,
        final String purchaseReqnAcctAssgmtNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseRequisition", purchaseRequisition);
        this.key.put("PurchaseRequisitionItem", purchaseRequisitionItem);
        this.key.put("PurchaseReqnAcctAssgmtNumber", purchaseReqnAcctAssgmtNumber);
    }

    @Override
    @Nonnull
    protected Class<PurReqnAcctAssgmt> getEntityClass()
    {
        return PurReqnAcctAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
