/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurchaseRequisitionHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurchaseRequisitionHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurchaseRequisitionHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchase Requisition
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseRequisitionHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseRequisitionHeader extends VdmEntity<PurchaseRequisitionHeader>
{

    /**
     * Selector for all available fields of PurchaseRequisitionHeader.
     *
     */
    public final static PurchaseRequisitionHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @Key
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionHeaderField<String> PURCHASE_REQUISITION =
        new PurchaseRequisitionHeaderField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionType</b>
     * </p>
     *
     * @return Purchase Requisition Document Type
     */
    @SerializedName( "PurchaseRequisitionType" )
    @JsonProperty( "PurchaseRequisitionType" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionType" )
    private String purchaseRequisitionType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionHeaderField<String> PURCHASE_REQUISITION_TYPE =
        new PurchaseRequisitionHeaderField<String>("PurchaseRequisitionType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnDescription</b>
     * </p>
     *
     * @return Purchase Requisition Description
     */
    @SerializedName( "PurReqnDescription" )
    @JsonProperty( "PurReqnDescription" )
    @Nullable
    @ODataField( odataName = "PurReqnDescription" )
    private String purReqnDescription;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnDescription</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionHeaderField<String> PUR_REQN_DESCRIPTION =
        new PurchaseRequisitionHeaderField<String>("PurReqnDescription");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceDetermination</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "SourceDetermination" )
    @JsonProperty( "SourceDetermination" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceDetermination" )
    private Boolean sourceDetermination;
    /**
     * Use with available fluent helpers to apply the <b>SourceDetermination</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionHeaderField<Boolean> SOURCE_DETERMINATION =
        new PurchaseRequisitionHeaderField<Boolean>("SourceDetermination");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnDoOnlyValidation</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "PurReqnDoOnlyValidation" )
    @JsonProperty( "PurReqnDoOnlyValidation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurReqnDoOnlyValidation" )
    private Boolean purReqnDoOnlyValidation;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnDoOnlyValidation</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionHeaderField<Boolean> PUR_REQN_DO_ONLY_VALIDATION =
        new PurchaseRequisitionHeaderField<Boolean>("PurReqnDoOnlyValidation");
    /**
     * Navigation property <b>to_PurchaseReqnItem</b> for <b>PurchaseRequisitionHeader</b> to multiple
     * <b>PurchaseRequisitionItem</b>.
     *
     */
    @SerializedName( "to_PurchaseReqnItem" )
    @JsonProperty( "to_PurchaseReqnItem" )
    @ODataField( odataName = "to_PurchaseReqnItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseRequisitionItem> toPurchaseReqnItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseReqnItem</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseRequisitionHeaderLink<PurchaseRequisitionItem> TO_PURCHASE_REQN_ITEM =
        new PurchaseRequisitionHeaderLink<PurchaseRequisitionItem>("to_PurchaseReqnItem");

    @Nonnull
    @Override
    public Class<PurchaseRequisitionHeader> getType()
    {
        return PurchaseRequisitionHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionType</b>
     * </p>
     *
     * @param purchaseRequisitionType
     *            Purchase Requisition Document Type
     */
    public void setPurchaseRequisitionType( @Nullable final String purchaseRequisitionType )
    {
        rememberChangedField("PurchaseRequisitionType", this.purchaseRequisitionType);
        this.purchaseRequisitionType = purchaseRequisitionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnDescription</b>
     * </p>
     *
     * @param purReqnDescription
     *            Purchase Requisition Description
     */
    public void setPurReqnDescription( @Nullable final String purReqnDescription )
    {
        rememberChangedField("PurReqnDescription", this.purReqnDescription);
        this.purReqnDescription = purReqnDescription;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceDetermination</b>
     * </p>
     *
     * @param sourceDetermination
     *            Checkbox
     */
    public void setSourceDetermination( @Nullable final Boolean sourceDetermination )
    {
        rememberChangedField("SourceDetermination", this.sourceDetermination);
        this.sourceDetermination = sourceDetermination;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnDoOnlyValidation</b>
     * </p>
     *
     * @param purReqnDoOnlyValidation
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setPurReqnDoOnlyValidation( @Nullable final Boolean purReqnDoOnlyValidation )
    {
        rememberChangedField("PurReqnDoOnlyValidation", this.purReqnDoOnlyValidation);
        this.purReqnDoOnlyValidation = purReqnDoOnlyValidation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseRequisitionHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseRequisition", getPurchaseRequisition());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionType", getPurchaseRequisitionType());
        values.put("PurReqnDescription", getPurReqnDescription());
        values.put("SourceDetermination", getSourceDetermination());
        values.put("PurReqnDoOnlyValidation", getPurReqnDoOnlyValidation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionType") ) {
                final Object value = values.remove("PurchaseRequisitionType");
                if( (value == null) || (!value.equals(getPurchaseRequisitionType())) ) {
                    setPurchaseRequisitionType(((String) value));
                }
            }
            if( values.containsKey("PurReqnDescription") ) {
                final Object value = values.remove("PurReqnDescription");
                if( (value == null) || (!value.equals(getPurReqnDescription())) ) {
                    setPurReqnDescription(((String) value));
                }
            }
            if( values.containsKey("SourceDetermination") ) {
                final Object value = values.remove("SourceDetermination");
                if( (value == null) || (!value.equals(getSourceDetermination())) ) {
                    setSourceDetermination(((Boolean) value));
                }
            }
            if( values.containsKey("PurReqnDoOnlyValidation") ) {
                final Object value = values.remove("PurReqnDoOnlyValidation");
                if( (value == null) || (!value.equals(getPurReqnDoOnlyValidation())) ) {
                    setPurReqnDoOnlyValidation(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchaseReqnItem") ) {
                final Object value = (values).remove("to_PurchaseReqnItem");
                if( value instanceof Iterable ) {
                    if( toPurchaseReqnItem == null ) {
                        toPurchaseReqnItem = Lists.newArrayList();
                    } else {
                        toPurchaseReqnItem = Lists.newArrayList(toPurchaseReqnItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseRequisitionItem entity;
                        if( toPurchaseReqnItem.size() > i ) {
                            entity = toPurchaseReqnItem.get(i);
                        } else {
                            entity = new PurchaseRequisitionItem();
                            toPurchaseReqnItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseRequisitionHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseRequisitionHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseRequisitionHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseRequisitionHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchaseReqnItem != null ) {
            (values).put("to_PurchaseReqnItem", toPurchaseReqnItem);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchaseRequisitionItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurchaseReqnItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseRequisitionItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseRequisitionItem> fetchPurchaseReqnItem()
    {
        return fetchFieldAsList("to_PurchaseReqnItem", PurchaseRequisitionItem.class);
    }

    /**
     * Retrieval of associated <b>PurchaseRequisitionItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseReqnItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnItem</b> of a queried <b>PurchaseRequisitionHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseRequisitionItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseRequisitionItem> getPurchaseReqnItemOrFetch()
    {
        if( toPurchaseReqnItem == null ) {
            toPurchaseReqnItem = fetchPurchaseReqnItem();
        }
        return toPurchaseReqnItem;
    }

    /**
     * Retrieval of associated <b>PurchaseRequisitionItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseReqnItem</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseRequisitionHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseReqnItem</b> is already loaded, the result will
     *         contain the <b>PurchaseRequisitionItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseRequisitionItem>> getPurchaseReqnItemIfPresent()
    {
        return Option.of(toPurchaseReqnItem);
    }

    /**
     * Overwrites the list of associated <b>PurchaseRequisitionItem</b> entities for the loaded navigation property
     * <b>to_PurchaseReqnItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnItem</b> of a queried <b>PurchaseRequisitionHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseRequisitionItem</b> entities.
     */
    public void setPurchaseReqnItem( @Nonnull final List<PurchaseRequisitionItem> value )
    {
        if( toPurchaseReqnItem == null ) {
            toPurchaseReqnItem = Lists.newArrayList();
        }
        toPurchaseReqnItem.clear();
        toPurchaseReqnItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseRequisitionItem</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseReqnItem</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnItem</b> of a queried <b>PurchaseRequisitionHeader</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseRequisitionItem</b> entities.
     */
    public void addPurchaseReqnItem( PurchaseRequisitionItem... entity )
    {
        if( toPurchaseReqnItem == null ) {
            toPurchaseReqnItem = Lists.newArrayList();
        }
        toPurchaseReqnItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchaseRequisitionHeader instances.
     *
     */
    public final static class PurchaseRequisitionHeaderBuilder
    {

        private List<PurchaseRequisitionItem> toPurchaseReqnItem = Lists.newArrayList();

        private PurchaseRequisitionHeader.PurchaseRequisitionHeaderBuilder toPurchaseReqnItem(
            final List<PurchaseRequisitionItem> value )
        {
            toPurchaseReqnItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseReqnItem</b> for <b>PurchaseRequisitionHeader</b> to multiple
         * <b>PurchaseRequisitionItem</b>.
         *
         * @param value
         *            The PurchaseRequisitionItems to build this PurchaseRequisitionHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseRequisitionHeader.PurchaseRequisitionHeaderBuilder purchaseReqnItem(
            PurchaseRequisitionItem... value )
        {
            return toPurchaseReqnItem(Lists.newArrayList(value));
        }

    }

}
